/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.bkd;

import org.apache.lucene.codecs.MutablePointValues;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.FutureArrays;
import org.apache.lucene.util.IntroSelector;
import org.apache.lucene.util.IntroSorter;
import org.apache.lucene.util.RadixSelector;
import org.apache.lucene.util.Selector;
import org.apache.lucene.util.StableMSBRadixSorter;
import org.apache.lucene.util.bkd.BKDConfig;
import org.apache.lucene.util.packed.PackedInts;

public final class MutablePointsReaderUtils {
    MutablePointsReaderUtils() {
    }

    public static void sort(final BKDConfig config, int maxDoc, final MutablePointValues reader, int from, int to) {
        boolean sortedByDocID = true;
        int prevDoc = 0;
        for (int i = from; i < to; ++i) {
            int doc = reader.getDocID(i);
            if (doc < prevDoc) {
                sortedByDocID = false;
                break;
            }
            prevDoc = doc;
        }
        final int bitsPerDocId = sortedByDocID ? 0 : PackedInts.bitsRequired(maxDoc - 1);
        new StableMSBRadixSorter(config.packedBytesLength + (bitsPerDocId + 7) / 8){

            @Override
            protected void swap(int i, int j) {
                reader.swap(i, j);
            }

            @Override
            protected void save(int i, int j) {
                reader.save(i, j);
            }

            @Override
            protected void restore(int i, int j) {
                reader.restore(i, j);
            }

            @Override
            protected int byteAt(int i, int k) {
                if (k < config.packedBytesLength) {
                    return Byte.toUnsignedInt(reader.getByteAt(i, k));
                }
                int shift = bitsPerDocId - (k - config.packedBytesLength + 1 << 3);
                return reader.getDocID(i) >>> Math.max(0, shift) & 0xFF;
            }
        }.sort(from, to);
    }

    public static void sortByDim(final BKDConfig config, int sortedDim, int[] commonPrefixLengths, final MutablePointValues reader, int from, int to, final BytesRef scratch1, final BytesRef scratch2) {
        final int start = sortedDim * config.bytesPerDim + commonPrefixLengths[sortedDim];
        final int dimEnd = sortedDim * config.bytesPerDim + config.bytesPerDim;
        new IntroSorter(){
            final BytesRef pivot;
            int pivotDoc;
            {
                this.pivot = scratch1;
                this.pivotDoc = -1;
            }

            @Override
            protected void swap(int i, int j) {
                reader.swap(i, j);
            }

            @Override
            protected void setPivot(int i) {
                reader.getValue(i, this.pivot);
                this.pivotDoc = reader.getDocID(i);
            }

            @Override
            protected int comparePivot(int j) {
                reader.getValue(j, scratch2);
                int cmp = FutureArrays.compareUnsigned(this.pivot.bytes, this.pivot.offset + start, this.pivot.offset + dimEnd, scratch2.bytes, scratch2.offset + start, scratch2.offset + dimEnd);
                if (cmp == 0 && (cmp = FutureArrays.compareUnsigned(this.pivot.bytes, this.pivot.offset + config.packedIndexBytesLength, this.pivot.offset + config.packedBytesLength, scratch2.bytes, scratch2.offset + config.packedIndexBytesLength, scratch2.offset + config.packedBytesLength)) == 0) {
                    cmp = this.pivotDoc - reader.getDocID(j);
                }
                return cmp;
            }
        }.sort(from, to);
    }

    public static void partition(final BKDConfig config, int maxDoc, int splitDim, int commonPrefixLen, final MutablePointValues reader, int from, int to, int mid, final BytesRef scratch1, final BytesRef scratch2) {
        final int dimOffset = splitDim * config.bytesPerDim + commonPrefixLen;
        final int dimCmpBytes = config.bytesPerDim - commonPrefixLen;
        final int dataCmpBytes = (config.numDims - config.numIndexDims) * config.bytesPerDim + dimCmpBytes;
        final int bitsPerDocId = PackedInts.bitsRequired(maxDoc - 1);
        new RadixSelector(dataCmpBytes + (bitsPerDocId + 7) / 8){

            @Override
            protected Selector getFallbackSelector(final int k) {
                final int dataStart = k < dimCmpBytes ? config.packedIndexBytesLength : config.packedIndexBytesLength + k - dimCmpBytes;
                final int dataEnd = config.numDims * config.bytesPerDim;
                return new IntroSelector(){
                    final BytesRef pivot;
                    int pivotDoc;
                    {
                        this.pivot = scratch1;
                    }

                    @Override
                    protected void swap(int i, int j) {
                        reader.swap(i, j);
                    }

                    @Override
                    protected void setPivot(int i) {
                        reader.getValue(i, this.pivot);
                        this.pivotDoc = reader.getDocID(i);
                    }

                    @Override
                    protected int comparePivot(int j) {
                        int cmp;
                        if (k < dimCmpBytes) {
                            reader.getValue(j, scratch2);
                            cmp = FutureArrays.compareUnsigned(this.pivot.bytes, this.pivot.offset + dimOffset + k, this.pivot.offset + dimOffset + dimCmpBytes, scratch2.bytes, scratch2.offset + dimOffset + k, scratch2.offset + dimOffset + dimCmpBytes);
                            if (cmp != 0) {
                                return cmp;
                            }
                        }
                        if (k < dataCmpBytes) {
                            reader.getValue(j, scratch2);
                            cmp = FutureArrays.compareUnsigned(this.pivot.bytes, this.pivot.offset + dataStart, this.pivot.offset + dataEnd, scratch2.bytes, scratch2.offset + dataStart, scratch2.offset + dataEnd);
                            if (cmp != 0) {
                                return cmp;
                            }
                        }
                        return this.pivotDoc - reader.getDocID(j);
                    }
                };
            }

            @Override
            protected void swap(int i, int j) {
                reader.swap(i, j);
            }

            @Override
            protected int byteAt(int i, int k) {
                if (k < dimCmpBytes) {
                    return Byte.toUnsignedInt(reader.getByteAt(i, dimOffset + k));
                }
                if (k < dataCmpBytes) {
                    return Byte.toUnsignedInt(reader.getByteAt(i, config.packedIndexBytesLength + k - dimCmpBytes));
                }
                int shift = bitsPerDocId - (k - dataCmpBytes + 1 << 3);
                return reader.getDocID(i) >>> Math.max(0, shift) & 0xFF;
            }
        }.select(from, to, mid);
    }
}

