/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.tmpl.master;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.hbase.RSGroupTableAccessor;
import org.apache.hadoop.hbase.RegionMetrics;
import org.apache.hadoop.hbase.ServerMetrics;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.Size;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.procedure2.util.StringUtils;
import org.apache.hadoop.hbase.replication.ReplicationLoadSource;
import org.apache.hadoop.hbase.rsgroup.RSGroupInfo;
import org.apache.hadoop.hbase.tmpl.master.RegionServerListTmpl;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.VersionInfo;
import org.apache.hadoop.util.StringUtils;
import org.jamon.AbstractTemplateImpl;
import org.jamon.AbstractTemplateProxy;
import org.jamon.TemplateManager;
import org.jamon.emit.StandardEmitter;
import org.jamon.escaping.Escaping;

public class RegionServerListTmplImpl
extends AbstractTemplateImpl
implements RegionServerListTmpl.Intf {
    private final HMaster master;
    private final List<ServerName> servers;

    protected static RegionServerListTmpl.ImplData __jamon_setOptionalArguments(RegionServerListTmpl.ImplData p_implData) {
        if (!p_implData.getServers__IsNotDefault()) {
            p_implData.setServers(null);
        }
        return p_implData;
    }

    public RegionServerListTmplImpl(TemplateManager p_templateManager, RegionServerListTmpl.ImplData p_implData) {
        super(p_templateManager, (AbstractTemplateProxy.ImplData)RegionServerListTmplImpl.__jamon_setOptionalArguments(p_implData));
        this.master = p_implData.getMaster();
        this.servers = p_implData.getServers();
    }

    @Override
    public void renderNoFlush(Writer jamonWriter) throws IOException {
        if (this.servers != null && this.servers.size() > 0) {
            jamonWriter.write("\n\n");
            Object[] serverNames = this.servers.toArray(new ServerName[this.servers.size()]);
            Arrays.sort(serverNames);
            jamonWriter.write("<div class=\"tabbable\">\n    <ul class=\"nav nav-pills\">\n        <li class=\"active\"><a href=\"#tab_baseStats\" data-toggle=\"tab\">Base Stats</a></li>\n        <li class=\"\"><a href=\"#tab_memoryStats\" data-toggle=\"tab\">Memory</a></li>\n        <li class=\"\"><a href=\"#tab_requestStats\" data-toggle=\"tab\">Requests</a></li>\n        <li class=\"\"><a href=\"#tab_storeStats\" data-toggle=\"tab\">Storefiles</a></li>\n        <li class=\"\"><a href=\"#tab_compactStats\" data-toggle=\"tab\">Compactions</a></li>\n        <li class=\"\"><a href=\"#tab_replicationStats\" data-toggle=\"tab\">Replications</a></li>\n    </ul>\n    <div class=\"tab-content\" style=\"padding-bottom: 9px; border-bottom: 1px solid #ddd;\">\n        <div class=\"tab-pane active\" id=\"tab_baseStats\">\n            ");
            this.__jamon_innerUnit__baseStats(jamonWriter, (ServerName[])serverNames);
            jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_memoryStats\">\n            ");
            this.__jamon_innerUnit__memoryStats(jamonWriter, (ServerName[])serverNames);
            jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_requestStats\">\n            ");
            this.__jamon_innerUnit__requestStats(jamonWriter, (ServerName[])serverNames);
            jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_storeStats\">\n            ");
            this.__jamon_innerUnit__storeStats(jamonWriter, (ServerName[])serverNames);
            jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_compactStats\">\n            ");
            this.__jamon_innerUnit__compactionStats(jamonWriter, (ServerName[])serverNames);
            jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_replicationStats\">\n            ");
            this.__jamon_innerUnit__replicationStats(jamonWriter, (ServerName[])serverNames);
            jamonWriter.write("\n        </div>\n    </div>\n</div>\n\n");
        }
        jamonWriter.write("\n\n");
    }

    private void __jamon_innerUnit__baseStats(Writer jamonWriter, ServerName[] serverNames) throws IOException {
        jamonWriter.write("<table id=\"baseStatsTable\" class=\"tablesorter table table-striped\">\n<thead>\n<tr>\n    <th>ServerName</th>\n    <th>State</th>\n    <th>Start time</th>\n    <th>Last contact</th>\n    <th>Version</th>\n    <th>Requests Per Second</th>\n    <th>Num. Regions</th>\n    ");
        if (!this.master.isInMaintenanceMode() && this.master.getMasterCoprocessorHost() != null) {
            jamonWriter.write("\n      ");
            if (this.master.getMasterCoprocessorHost().findCoprocessor("RSGroupAdminEndpoint") != null && this.master.getServerManager().getOnlineServersList().size() > 0) {
                jamonWriter.write("\n        <th>RSGroup</th>\n      ");
            }
            jamonWriter.write("\n    ");
        }
        jamonWriter.write("\n</tr>\n</thead>\n<tbody>\n");
        int totalRegions = 0;
        int totalRequestsPerSecond = 0;
        int inconsistentNodeNum = 0;
        String state = "Normal";
        String masterVersion = VersionInfo.getVersion();
        HashSet<ServerName> decommissionedServers = new HashSet<ServerName>(this.master.listDecommissionedRegionServers());
        String rsGroupName = "default";
        HashMap server2GroupMap = new HashMap();
        if (!this.master.isInMaintenanceMode() && this.master.getMasterCoprocessorHost() != null && this.master.getMasterCoprocessorHost().findCoprocessor("RSGroupAdminEndpoint") != null && this.master.getServerManager().getOnlineServersList().size() > 0) {
            List groups = RSGroupTableAccessor.getAllRSGroupInfo((Connection)this.master.getConnection());
            groups.forEach(group -> group.getServers().forEach(address -> server2GroupMap.put(address, group)));
        }
        for (ServerName serverName : serverNames) {
            if (decommissionedServers.contains(serverName)) {
                state = "Decommissioned";
            }
            ServerMetrics sl = this.master.getServerManager().getLoad(serverName);
            String version = this.master.getRegionServerVersion(serverName);
            if (!masterVersion.equals(version)) {
                ++inconsistentNodeNum;
            }
            double requestsPerSecond = 0.0;
            int numRegionsOnline = 0;
            long lastContact = 0L;
            if (sl != null) {
                requestsPerSecond = sl.getRequestCountPerSecond();
                numRegionsOnline = sl.getRegionMetrics().size();
                totalRegions += sl.getRegionMetrics().size();
                totalRequestsPerSecond = (int)((long)totalRequestsPerSecond + sl.getRequestCountPerSecond());
                lastContact = (System.currentTimeMillis() - sl.getReportTimestamp()) / 1000L;
            }
            long startcode = serverName.getStartcode();
            if (!this.master.isInMaintenanceMode() && this.master.getMasterCoprocessorHost() != null && this.master.getMasterCoprocessorHost().findCoprocessor("RSGroupAdminEndpoint") != null && this.master.getServerManager().getOnlineServersList().size() > 0) {
                rsGroupName = ((RSGroupInfo)server2GroupMap.get(serverName.getAddress())).getName();
            }
            jamonWriter.write("<tr>\n    <td>");
            this.__jamon_innerUnit__serverNameLink(jamonWriter, serverName);
            jamonWriter.write("</td>\n    <td>");
            Escaping.HTML.write(StandardEmitter.valueOf((String)state), jamonWriter);
            jamonWriter.write("</td>\n    <td>");
            Escaping.HTML.write(StandardEmitter.valueOf((Object)new Date(startcode)), jamonWriter);
            jamonWriter.write("</td>\n    <td>");
            Escaping.HTML.write(StandardEmitter.valueOf((String)StringUtils.TraditionalBinaryPrefix.long2String((long)lastContact, (String)"s", (int)1)), jamonWriter);
            jamonWriter.write("</td>\n    <td>");
            Escaping.HTML.write(StandardEmitter.valueOf((String)version), jamonWriter);
            jamonWriter.write("</td>\n    <td>");
            Escaping.HTML.write(StandardEmitter.valueOf((String)String.format("%,.0f", requestsPerSecond)), jamonWriter);
            jamonWriter.write("</td>\n    <td>");
            Escaping.HTML.write(StandardEmitter.valueOf((String)String.format("%,d", numRegionsOnline)), jamonWriter);
            jamonWriter.write("</td>\n    ");
            if (!this.master.isInMaintenanceMode() && this.master.getMasterCoprocessorHost() != null) {
                jamonWriter.write("\n      ");
                if (this.master.getMasterCoprocessorHost().findCoprocessor("RSGroupAdminEndpoint") != null && this.master.getServerManager().getOnlineServersList().size() > 0) {
                    jamonWriter.write("\n        <td>");
                    Escaping.HTML.write(StandardEmitter.valueOf((String)rsGroupName), jamonWriter);
                    jamonWriter.write("</td>\n      ");
                }
                jamonWriter.write("\n    ");
            }
            jamonWriter.write("\n</tr>\n");
        }
        jamonWriter.write("</tbody>\n<tr><td>Total:");
        Escaping.HTML.write(StandardEmitter.valueOf((int)this.servers.size()), jamonWriter);
        jamonWriter.write("</td>\n<td></td>\n<td></td>\n<td></td>\n");
        if (inconsistentNodeNum > 0) {
            jamonWriter.write("\n  <td style=\"color:red;\">");
            Escaping.HTML.write(StandardEmitter.valueOf((int)inconsistentNodeNum), jamonWriter);
            jamonWriter.write(" nodes with inconsistent version</td>\n");
        } else {
            jamonWriter.write("\n   <td></td>\n");
        }
        jamonWriter.write("\n<td>");
        Escaping.HTML.write(StandardEmitter.valueOf((int)totalRequestsPerSecond), jamonWriter);
        jamonWriter.write("</td>\n<td>");
        Escaping.HTML.write(StandardEmitter.valueOf((int)totalRegions), jamonWriter);
        jamonWriter.write("</td>\n</tr>\n</table>\n");
    }

    private void __jamon_innerUnit__compactionStats(Writer jamonWriter, ServerName[] serverNames) throws IOException {
        jamonWriter.write("<table id=\"compactionStatsTable\" class=\"tablesorter table table-striped\">\n<thead>\n<tr>\n    <th>ServerName</th>\n    <th>Num. Compacting Cells</th>\n    <th>Num. Compacted Cells</th>\n    <th>Remaining Cells</th>\n    <th>Compaction Progress</th>\n</tr>\n</thead>\n<tbody>\n");
        for (ServerName serverName : serverNames) {
            ServerMetrics sl = this.master.getServerManager().getLoad(serverName);
            if (sl != null) {
                long totalCompactingCells = 0L;
                long totalCompactedCells = 0L;
                for (RegionMetrics rl : sl.getRegionMetrics().values()) {
                    totalCompactingCells += rl.getCompactingCellCount();
                    totalCompactedCells += rl.getCompactedCellCount();
                }
                String percentDone = "";
                if (totalCompactingCells > 0L) {
                    percentDone = String.format("%.2f", Float.valueOf(100.0f * ((float)totalCompactedCells / (float)totalCompactingCells))) + "%";
                }
                jamonWriter.write("<tr>\n<td>");
                this.__jamon_innerUnit__serverNameLink(jamonWriter, serverName);
                jamonWriter.write("</td>\n<td>");
                Escaping.HTML.write(StandardEmitter.valueOf((String)String.format("%,d", totalCompactingCells)), jamonWriter);
                jamonWriter.write("</td>\n<td>");
                Escaping.HTML.write(StandardEmitter.valueOf((String)String.format("%,d", totalCompactedCells)), jamonWriter);
                jamonWriter.write("</td>\n<td>");
                Escaping.HTML.write(StandardEmitter.valueOf((String)String.format("%,d", totalCompactingCells - totalCompactedCells)), jamonWriter);
                jamonWriter.write("</td>\n<td>");
                Escaping.HTML.write(StandardEmitter.valueOf((String)percentDone), jamonWriter);
                jamonWriter.write("</td>\n</tr>\n");
                continue;
            }
            this.__jamon_innerUnit__emptyStat(jamonWriter, serverName);
            jamonWriter.write("\n");
        }
        jamonWriter.write("</tbody>\n</table>\n");
    }

    private void __jamon_innerUnit__emptyStat(Writer jamonWriter, ServerName serverName) throws IOException {
        jamonWriter.write("<tr>\n    <td>");
        this.__jamon_innerUnit__serverNameLink(jamonWriter, serverName);
        jamonWriter.write("</td>\n    <td></td>\n    <td></td>\n    <td></td>\n    <td></td>\n    <td></td>\n    <td></td>\n    </tr>\n");
    }

    private void __jamon_innerUnit__memoryStats(Writer jamonWriter, ServerName[] serverNames) throws IOException {
        jamonWriter.write("<table id=\"memoryStatsTable\" class=\"tablesorter table table-striped\">\n<thead>\n<tr>\n    <th>ServerName</th>\n    <th>Used Heap</th>\n    <th>Max Heap</th>\n    <th>Memstore Size</th>\n\n</tr>\n</thead>\n<tbody>\n");
        String ZEROMB = "0 MB";
        for (ServerName serverName : serverNames) {
            String usedHeapStr = "0 MB";
            String maxHeapStr = "0 MB";
            String memStoreSizeMBStr = "0 MB";
            ServerMetrics sl = this.master.getServerManager().getLoad(serverName);
            if (sl != null) {
                double maxHeapSizeMB;
                double usedHeapSizeMB;
                long memStoreSizeMB = 0L;
                for (RegionMetrics rl : sl.getRegionMetrics().values()) {
                    memStoreSizeMB = (long)((double)memStoreSizeMB + rl.getMemStoreSize().get(Size.Unit.MEGABYTE));
                }
                if (memStoreSizeMB > 0L) {
                    memStoreSizeMBStr = StringUtils.TraditionalBinaryPrefix.long2String((long)(memStoreSizeMB * StringUtils.TraditionalBinaryPrefix.MEGA.value), (String)"B", (int)1);
                }
                if ((usedHeapSizeMB = sl.getUsedHeapSize().get(Size.Unit.MEGABYTE)) > 0.0) {
                    usedHeapStr = StringUtils.TraditionalBinaryPrefix.long2String((long)((long)usedHeapSizeMB * StringUtils.TraditionalBinaryPrefix.MEGA.value), (String)"B", (int)1);
                }
                if ((maxHeapSizeMB = sl.getMaxHeapSize().get(Size.Unit.MEGABYTE)) > 0.0) {
                    maxHeapStr = StringUtils.TraditionalBinaryPrefix.long2String((long)((long)maxHeapSizeMB * StringUtils.TraditionalBinaryPrefix.MEGA.value), (String)"B", (int)1);
                }
                jamonWriter.write("<tr>\n    <td>");
                this.__jamon_innerUnit__serverNameLink(jamonWriter, serverName);
                jamonWriter.write("</td>\n    <td>");
                Escaping.HTML.write(StandardEmitter.valueOf((String)usedHeapStr), jamonWriter);
                jamonWriter.write("</td>\n    <td>");
                Escaping.HTML.write(StandardEmitter.valueOf((String)maxHeapStr), jamonWriter);
                jamonWriter.write("</td>\n    <td>");
                Escaping.HTML.write(StandardEmitter.valueOf((String)memStoreSizeMBStr), jamonWriter);
                jamonWriter.write("</td>\n</tr>\n");
                continue;
            }
            this.__jamon_innerUnit__emptyStat(jamonWriter, serverName);
            jamonWriter.write("\n");
        }
        jamonWriter.write("</tbody>\n</table>\n");
    }

    private void __jamon_innerUnit__replicationStats(Writer jamonWriter, ServerName[] serverNames) throws IOException {
        HashMap<String, List<Pair<ServerName, ReplicationLoadSource>>> replicationLoadSourceMap = this.master.getReplicationLoad(serverNames);
        ArrayList<String> peers = null;
        if (replicationLoadSourceMap != null && replicationLoadSourceMap.size() > 0) {
            peers = new ArrayList<String>(replicationLoadSourceMap.keySet());
            Collections.sort(peers);
        }
        if (replicationLoadSourceMap != null && replicationLoadSourceMap.size() > 0) {
            jamonWriter.write("\n\n<div class=\"tabbable\">\n    <ul class=\"nav nav-tabs\">\n        ");
            String active = "active";
            for (String peer : peers) {
                jamonWriter.write("<li class=");
                Escaping.HTML.write(StandardEmitter.valueOf((String)active), jamonWriter);
                jamonWriter.write("><a href=\"#tab_");
                Escaping.HTML.write(StandardEmitter.valueOf((String)peer), jamonWriter);
                jamonWriter.write("\" data-toggle=\"tab\">Peer ");
                Escaping.HTML.write(StandardEmitter.valueOf((String)peer), jamonWriter);
                jamonWriter.write("</a> </li>\n        ");
                active = "";
            }
            jamonWriter.write("</ul>\n    <div class=\"tab-content\">\n        ");
            active = "active";
            for (String peer : peers) {
                jamonWriter.write("<div class=\"tab-pane ");
                Escaping.HTML.write(StandardEmitter.valueOf((String)active), jamonWriter);
                jamonWriter.write("\" id=\"tab_");
                Escaping.HTML.write(StandardEmitter.valueOf((String)peer), jamonWriter);
                jamonWriter.write("\">\n                <table class=\"table table-striped\">\n                    <tr>\n                        <th>Server</th>\n                        <th>AgeOfLastShippedOp</th>\n                        <th>SizeOfLogQueue</th>\n                        <th>ReplicationLag</th>\n                    </tr>\n\n                    ");
                for (Pair<ServerName, ReplicationLoadSource> pair : replicationLoadSourceMap.get(peer)) {
                    jamonWriter.write("\n                    <tr>\n                        <td>");
                    this.__jamon_innerUnit__serverNameLink(jamonWriter, (ServerName)pair.getFirst());
                    jamonWriter.write("</td>\n                        <td>");
                    Escaping.HTML.write(StandardEmitter.valueOf((String)StringUtils.humanTimeDiff((long)((ReplicationLoadSource)pair.getSecond()).getAgeOfLastShippedOp())), jamonWriter);
                    jamonWriter.write("</td>\n                        <td>");
                    Escaping.HTML.write(StandardEmitter.valueOf((long)((ReplicationLoadSource)pair.getSecond()).getSizeOfLogQueue()), jamonWriter);
                    jamonWriter.write("</td>\n                        <td>");
                    Escaping.HTML.write(StandardEmitter.valueOf((String)(((ReplicationLoadSource)pair.getSecond()).getReplicationLag() == Long.MAX_VALUE ? "UNKNOWN" : StringUtils.humanTimeDiff((long)((ReplicationLoadSource)pair.getSecond()).getReplicationLag()))), jamonWriter);
                    jamonWriter.write("</td>\n                    </tr>\n                    ");
                }
                jamonWriter.write("\n        </table>\n            </div>\n        ");
                active = "";
            }
            jamonWriter.write("</div>\n    <p>If the replication delay is UNKNOWN, that means this walGroup doesn't start replicate yet and it may get disabled.</p>\n</div>\n");
        } else {
            jamonWriter.write("\n    <p>No Peers Metrics</p>\n");
        }
        jamonWriter.write("\n");
    }

    private void __jamon_innerUnit__requestStats(Writer jamonWriter, ServerName[] serverNames) throws IOException {
        jamonWriter.write("<table id=\"requestStatsTable\" class=\"tablesorter table table-striped\">\n<thead>\n<tr>\n    <th>ServerName</th>\n    <th>Request Per Second</th>\n    <th>Read Request Count</th>\n    <th>Filtered Read Request Count</th>\n    <th>Write Request Count</th>\n</tr>\n</thead>\n<tbody>\n");
        for (ServerName serverName : serverNames) {
            ServerMetrics sl = this.master.getServerManager().getLoad(serverName);
            if (sl != null) {
                long readRequestCount = 0L;
                long writeRequestCount = 0L;
                long filteredReadRequestCount = 0L;
                for (RegionMetrics rl : sl.getRegionMetrics().values()) {
                    readRequestCount += rl.getReadRequestCount();
                    writeRequestCount += rl.getWriteRequestCount();
                    filteredReadRequestCount += rl.getFilteredReadRequestCount();
                }
                jamonWriter.write("<tr>\n<td>");
                this.__jamon_innerUnit__serverNameLink(jamonWriter, serverName);
                jamonWriter.write("</td>\n<td>");
                Escaping.HTML.write(StandardEmitter.valueOf((String)String.format("%,d", sl.getRequestCountPerSecond())), jamonWriter);
                jamonWriter.write("</td>\n<td>");
                Escaping.HTML.write(StandardEmitter.valueOf((String)String.format("%,d", readRequestCount)), jamonWriter);
                jamonWriter.write("</td>\n<td>");
                Escaping.HTML.write(StandardEmitter.valueOf((String)String.format("%,d", filteredReadRequestCount)), jamonWriter);
                jamonWriter.write("</td>\n<td>");
                Escaping.HTML.write(StandardEmitter.valueOf((String)String.format("%,d", writeRequestCount)), jamonWriter);
                jamonWriter.write("</td>\n</tr>\n");
                continue;
            }
            this.__jamon_innerUnit__emptyStat(jamonWriter, serverName);
            jamonWriter.write("\n");
        }
        jamonWriter.write("</tbody>\n</table>\n");
    }

    private void __jamon_innerUnit__serverNameLink(Writer jamonWriter, ServerName serverName) throws IOException {
        int infoPort = this.master.getRegionServerInfoPort(serverName);
        String url = "//" + serverName.getHostname() + ":" + infoPort + "/rs-status";
        if (infoPort > 0) {
            jamonWriter.write("\n            <a href=\"");
            Escaping.HTML.write(StandardEmitter.valueOf((String)url), jamonWriter);
            jamonWriter.write("\">");
            Escaping.HTML.write(StandardEmitter.valueOf((String)serverName.getServerName()), jamonWriter);
            jamonWriter.write("</a>\n        ");
        } else {
            jamonWriter.write("\n            ");
            Escaping.HTML.write(StandardEmitter.valueOf((String)serverName.getServerName()), jamonWriter);
            jamonWriter.write("\n        ");
        }
        jamonWriter.write("\n");
    }

    private void __jamon_innerUnit__storeStats(Writer jamonWriter, ServerName[] serverNames) throws IOException {
        jamonWriter.write("<table id=\"storeStatsTable\" class=\"tablesorter table table-striped\">\n<thead>\n<tr>\n    <th>ServerName</th>\n    <th>Num. Stores</th>\n    <th>Num. Storefiles</th>\n    <th>Storefile Size Uncompressed</th>\n    <th>Storefile Size</th>\n    <th>Index Size</th>\n    <th>Bloom Size</th>\n</tr>\n</thead>\n<tbody>\n");
        String ZEROKB = "0 KB";
        String ZEROMB = "0 MB";
        for (ServerName serverName : serverNames) {
            String storeUncompressedSizeMBStr = "0 MB";
            String storeFileSizeMBStr = "0 MB";
            String totalStaticIndexSizeKBStr = "0 KB";
            String totalStaticBloomSizeKBStr = "0 KB";
            ServerMetrics sl = this.master.getServerManager().getLoad(serverName);
            if (sl != null) {
                long storeCount = 0L;
                long storeFileCount = 0L;
                long storeUncompressedSizeMB = 0L;
                long storeFileSizeMB = 0L;
                long totalStaticIndexSizeKB = 0L;
                long totalStaticBloomSizeKB = 0L;
                for (RegionMetrics rl : sl.getRegionMetrics().values()) {
                    storeCount += (long)rl.getStoreCount();
                    storeFileCount += (long)rl.getStoreFileCount();
                    storeUncompressedSizeMB = (long)((double)storeUncompressedSizeMB + rl.getUncompressedStoreFileSize().get(Size.Unit.MEGABYTE));
                    storeFileSizeMB = (long)((double)storeFileSizeMB + rl.getStoreFileSize().get(Size.Unit.MEGABYTE));
                    totalStaticIndexSizeKB = (long)((double)totalStaticIndexSizeKB + rl.getStoreFileUncompressedDataIndexSize().get(Size.Unit.KILOBYTE));
                    totalStaticBloomSizeKB = (long)((double)totalStaticBloomSizeKB + rl.getBloomFilterSize().get(Size.Unit.KILOBYTE));
                }
                if (storeUncompressedSizeMB > 0L) {
                    storeUncompressedSizeMBStr = StringUtils.TraditionalBinaryPrefix.long2String((long)(storeUncompressedSizeMB * StringUtils.TraditionalBinaryPrefix.MEGA.value), (String)"B", (int)1);
                }
                if (storeFileSizeMB > 0L) {
                    storeFileSizeMBStr = StringUtils.TraditionalBinaryPrefix.long2String((long)(storeFileSizeMB * StringUtils.TraditionalBinaryPrefix.MEGA.value), (String)"B", (int)1);
                }
                if (totalStaticIndexSizeKB > 0L) {
                    totalStaticIndexSizeKBStr = StringUtils.TraditionalBinaryPrefix.long2String((long)(totalStaticIndexSizeKB * StringUtils.TraditionalBinaryPrefix.KILO.value), (String)"B", (int)1);
                }
                if (totalStaticBloomSizeKB > 0L) {
                    totalStaticBloomSizeKBStr = StringUtils.TraditionalBinaryPrefix.long2String((long)(totalStaticBloomSizeKB * StringUtils.TraditionalBinaryPrefix.KILO.value), (String)"B", (int)1);
                }
                jamonWriter.write("<tr>\n<td>");
                this.__jamon_innerUnit__serverNameLink(jamonWriter, serverName);
                jamonWriter.write("</td>\n<td>");
                Escaping.HTML.write(StandardEmitter.valueOf((String)String.format("%,d", storeCount)), jamonWriter);
                jamonWriter.write("</td>\n<td>");
                Escaping.HTML.write(StandardEmitter.valueOf((String)String.format("%,d", storeFileCount)), jamonWriter);
                jamonWriter.write("</td>\n<td>");
                Escaping.HTML.write(StandardEmitter.valueOf((String)storeUncompressedSizeMBStr), jamonWriter);
                jamonWriter.write("</td>\n<td>");
                Escaping.HTML.write(StandardEmitter.valueOf((String)storeFileSizeMBStr), jamonWriter);
                jamonWriter.write("</td>\n<td>");
                Escaping.HTML.write(StandardEmitter.valueOf((String)totalStaticIndexSizeKBStr), jamonWriter);
                jamonWriter.write("</td>\n<td>");
                Escaping.HTML.write(StandardEmitter.valueOf((String)totalStaticBloomSizeKBStr), jamonWriter);
                jamonWriter.write("</td>\n</tr>\n");
                continue;
            }
            this.__jamon_innerUnit__emptyStat(jamonWriter, serverName);
            jamonWriter.write("\n");
        }
        jamonWriter.write("</tbody>\n</table>\n");
    }
}

