/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Optional;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CompatibilitySingletonFactory;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServerSourceFactory;
import org.apache.hadoop.hbase.regionserver.MetricsUserAggregate;
import org.apache.hadoop.hbase.regionserver.MetricsUserAggregateSource;
import org.apache.hadoop.hbase.regionserver.MetricsUserSource;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.UserProvider;
import org.apache.hadoop.hbase.util.LossyCounting;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class MetricsUserAggregateImpl
implements MetricsUserAggregate {
    private final UserProvider userProvider;
    private final MetricsUserAggregateSource source = ((MetricsRegionServerSourceFactory)CompatibilitySingletonFactory.getInstance(MetricsRegionServerSourceFactory.class)).getUserAggregate();
    private final LossyCounting<MetricsUserSource> userMetricLossyCounting;

    public MetricsUserAggregateImpl(Configuration conf) {
        this.userMetricLossyCounting = new LossyCounting<MetricsUserSource>("userMetrics", conf, arg_0 -> ((MetricsUserAggregateSource)this.source).deregister(arg_0));
        this.userProvider = UserProvider.instantiate((Configuration)conf);
    }

    private String getActiveUser() {
        Optional<User> user = RpcServer.getRequestUser();
        if (!user.isPresent()) {
            try {
                user = Optional.of(this.userProvider.getCurrent());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return user.map(User::getShortName).orElse(null);
    }

    @Override
    public MetricsUserAggregateSource getSource() {
        return this.source;
    }

    @Override
    public void updatePut(long t) {
        String user = this.getActiveUser();
        if (user != null) {
            MetricsUserSource userSource = this.getOrCreateMetricsUser(user);
            userSource.updatePut(t);
            this.incrementClientWriteMetrics(userSource);
        }
    }

    private String getClient() {
        Optional<InetAddress> ipOptional = RpcServer.getRemoteAddress();
        return ipOptional.map(InetAddress::getHostName).orElse(null);
    }

    private void incrementClientReadMetrics(MetricsUserSource userSource) {
        String client = this.getClient();
        if (client != null && userSource != null) {
            userSource.getOrCreateMetricsClient(client).incrementReadRequest();
        }
    }

    private void incrementFilteredReadRequests(MetricsUserSource userSource) {
        String client = this.getClient();
        if (client != null && userSource != null) {
            userSource.getOrCreateMetricsClient(client).incrementFilteredReadRequests();
        }
    }

    private void incrementClientWriteMetrics(MetricsUserSource userSource) {
        String client = this.getClient();
        if (client != null && userSource != null) {
            userSource.getOrCreateMetricsClient(client).incrementWriteRequest();
        }
    }

    @Override
    public void updateDelete(long t) {
        String user = this.getActiveUser();
        if (user != null) {
            MetricsUserSource userSource = this.getOrCreateMetricsUser(user);
            userSource.updateDelete(t);
            this.incrementClientWriteMetrics(userSource);
        }
    }

    @Override
    public void updateGet(long time, long blockBytesScanned) {
        String user = this.getActiveUser();
        if (user != null) {
            MetricsUserSource userSource = this.getOrCreateMetricsUser(user);
            userSource.updateGet(time, blockBytesScanned);
        }
    }

    @Override
    public void updateIncrement(long time, long blockBytesScanned) {
        String user = this.getActiveUser();
        if (user != null) {
            MetricsUserSource userSource = this.getOrCreateMetricsUser(user);
            userSource.updateIncrement(time, blockBytesScanned);
            this.incrementClientWriteMetrics(userSource);
        }
    }

    @Override
    public void updateAppend(long time, long blockBytesScanned) {
        String user = this.getActiveUser();
        if (user != null) {
            MetricsUserSource userSource = this.getOrCreateMetricsUser(user);
            userSource.updateAppend(time, blockBytesScanned);
            this.incrementClientWriteMetrics(userSource);
        }
    }

    @Override
    public void updateReplay(long t) {
        String user = this.getActiveUser();
        if (user != null) {
            MetricsUserSource userSource = this.getOrCreateMetricsUser(user);
            userSource.updateReplay(t);
            this.incrementClientWriteMetrics(userSource);
        }
    }

    @Override
    public void updateScan(long time, long blockBytesScanned) {
        String user = this.getActiveUser();
        if (user != null) {
            MetricsUserSource userSource = this.getOrCreateMetricsUser(user);
            userSource.updateScan(time, blockBytesScanned);
        }
    }

    @Override
    public void updateCheckAndMutate(long blockBytesScanned) {
        String user = this.getActiveUser();
        if (user != null) {
            MetricsUserSource userSource = this.getOrCreateMetricsUser(user);
            userSource.updateCheckAndMutate(blockBytesScanned);
        }
    }

    @Override
    public void updateFilteredReadRequests() {
        String user = this.getActiveUser();
        if (user != null) {
            MetricsUserSource userSource = this.getOrCreateMetricsUser(user);
            this.incrementFilteredReadRequests(userSource);
        }
    }

    @Override
    public void updateReadRequestCount() {
        String user = this.getActiveUser();
        if (user != null) {
            MetricsUserSource userSource = this.getOrCreateMetricsUser(user);
            this.incrementClientReadMetrics(userSource);
        }
    }

    private MetricsUserSource getOrCreateMetricsUser(String user) {
        MetricsUserSource userSource = this.source.getOrCreateMetricsUser(user);
        this.userMetricLossyCounting.add(userSource);
        return userSource;
    }
}

