/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.region;

import com.google.errorprone.annotations.RestrictedApi;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.master.region.MasterRegionFlusherAndCompactor;
import org.apache.hadoop.hbase.master.region.MasterRegionParams;
import org.apache.hadoop.hbase.master.region.MasterRegionWALRoller;
import org.apache.hadoop.hbase.master.region.RegionScannerAsResultScanner;
import org.apache.hadoop.hbase.master.region.UpdateMasterRegion;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.regionserver.StoreFileInfo;
import org.apache.hadoop.hbase.regionserver.storefiletracker.StoreFileTracker;
import org.apache.hadoop.hbase.regionserver.storefiletracker.StoreFileTrackerFactory;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.FSTableDescriptors;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.HFileArchiveUtil;
import org.apache.hadoop.hbase.util.RecoverLeaseFSUtils;
import org.apache.hadoop.hbase.wal.AbstractFSWALProvider;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.apache.hbase.thirdparty.com.google.common.math.IntMath;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class MasterRegion {
    private static final Logger LOG = LoggerFactory.getLogger(MasterRegion.class);
    private static final String REPLAY_EDITS_DIR = "recovered.wals";
    private static final String DEAD_WAL_DIR_SUFFIX = "-dead";
    static final String INITIALIZING_FLAG = ".initializing";
    static final String INITIALIZED_FLAG = ".initialized";
    private static final int REGION_ID = 1;
    private final WALFactory walFactory;
    final HRegion region;
    final MasterRegionFlusherAndCompactor flusherAndCompactor;
    private MasterRegionWALRoller walRoller;

    private MasterRegion(HRegion region, WALFactory walFactory, MasterRegionFlusherAndCompactor flusherAndCompactor, MasterRegionWALRoller walRoller) {
        this.region = region;
        this.walFactory = walFactory;
        this.flusherAndCompactor = flusherAndCompactor;
        this.walRoller = walRoller;
    }

    private void closeRegion(boolean abort) {
        try {
            this.region.close(abort);
        }
        catch (IOException e) {
            LOG.warn("Failed to close region", (Throwable)e);
        }
    }

    private void shutdownWAL() {
        try {
            this.walFactory.shutdown();
        }
        catch (IOException e) {
            LOG.warn("Failed to shutdown WAL", (Throwable)e);
        }
    }

    public void update(UpdateMasterRegion action) throws IOException {
        action.update(this.region);
        this.flusherAndCompactor.onUpdate();
    }

    public Result get(Get get) throws IOException {
        return this.region.get(get);
    }

    public ResultScanner getScanner(Scan scan) throws IOException {
        return new RegionScannerAsResultScanner(this.region.getScanner(scan));
    }

    public RegionScanner getRegionScanner(Scan scan) throws IOException {
        return this.region.getScanner(scan);
    }

    public HRegion.FlushResult flush(boolean force) throws IOException {
        this.flusherAndCompactor.resetChangesAfterLastFlush();
        HRegion.FlushResult flushResult = this.region.flush(force);
        this.flusherAndCompactor.recordLastFlushTime();
        return flushResult;
    }

    @RestrictedApi(explanation="Should only be called in tests", link="", allowedOnPath=".*/src/test/.*")
    public void requestRollAll() {
        this.walRoller.requestRollAll();
    }

    @RestrictedApi(explanation="Should only be called in tests", link="", allowedOnPath=".*/src/test/.*")
    public void waitUntilWalRollFinished() throws InterruptedException {
        this.walRoller.waitUntilWalRollFinished();
    }

    public void close(boolean abort) {
        LOG.info("Closing local region {}, isAbort={}", (Object)this.region.getRegionInfo(), (Object)abort);
        if (this.flusherAndCompactor != null) {
            this.flusherAndCompactor.close();
        }
        if (abort) {
            this.shutdownWAL();
            this.closeRegion(true);
        } else {
            this.closeRegion(false);
            this.shutdownWAL();
        }
        if (this.walRoller != null) {
            this.walRoller.close();
        }
    }

    private static WAL createWAL(WALFactory walFactory, MasterRegionWALRoller walRoller, String serverName, FileSystem walFs, Path walRootDir, RegionInfo regionInfo) throws IOException {
        String logName = AbstractFSWALProvider.getWALDirectoryName(serverName);
        Path walDir = new Path(walRootDir, logName);
        LOG.debug("WALDir={}", (Object)walDir);
        if (walFs.exists(walDir)) {
            throw new HBaseIOException("Already created wal directory at " + walDir + " for local region " + regionInfo);
        }
        if (!walFs.mkdirs(walDir)) {
            throw new IOException("Can not create wal directory " + walDir + " for local region " + regionInfo);
        }
        WAL wal = walFactory.getWAL(regionInfo);
        walRoller.addWAL(wal);
        return wal;
    }

    private static HRegion bootstrap(Configuration conf, TableDescriptor td, FileSystem fs, Path rootDir, FileSystem walFs, Path walRootDir, WALFactory walFactory, MasterRegionWALRoller walRoller, String serverName, boolean touchInitializingFlag) throws IOException {
        TableName tn = td.getTableName();
        RegionInfo regionInfo = RegionInfoBuilder.newBuilder((TableName)tn).setRegionId(1L).build();
        Path tableDir = CommonFSUtils.getTableDir((Path)rootDir, (TableName)tn);
        FSTableDescriptors.createTableDescriptorForTableDirectory(fs, tableDir, td, true);
        HRegion.createHRegion(conf, regionInfo, fs, tableDir, td).close();
        Path initializedFlag = new Path(tableDir, INITIALIZED_FLAG);
        if (!fs.mkdirs(initializedFlag)) {
            throw new IOException("Can not touch initialized flag: " + initializedFlag);
        }
        Path initializingFlag = new Path(tableDir, INITIALIZING_FLAG);
        if (!fs.delete(initializingFlag, true)) {
            LOG.warn("failed to clean up initializing flag: " + initializingFlag);
        }
        WAL wal = MasterRegion.createWAL(walFactory, walRoller, serverName, walFs, walRootDir, regionInfo);
        return HRegion.openHRegionFromTableDir(conf, fs, tableDir, regionInfo, td, wal, null, null);
    }

    private static RegionInfo loadRegionInfo(FileSystem fs, Path tableDir) throws IOException {
        Path regionDir = fs.listStatus(tableDir, p -> !p.getName().startsWith(".") && RegionInfo.isEncodedRegionName((byte[])Bytes.toBytes((String)p.getName())))[0].getPath();
        return HRegionFileSystem.loadRegionInfoFileContent(fs, regionDir);
    }

    private static HRegion open(Configuration conf, TableDescriptor td, RegionInfo regionInfo, FileSystem fs, Path rootDir, FileSystem walFs, Path walRootDir, WALFactory walFactory, MasterRegionWALRoller walRoller, String serverName) throws IOException {
        Path tableDir = CommonFSUtils.getTableDir((Path)rootDir, (TableName)td.getTableName());
        Path walRegionDir = FSUtils.getRegionDirFromRootDir(walRootDir, regionInfo);
        Path replayEditsDir = new Path(walRegionDir, REPLAY_EDITS_DIR);
        if (!walFs.exists(replayEditsDir) && !walFs.mkdirs(replayEditsDir)) {
            throw new IOException("Failed to create replay directory: " + replayEditsDir);
        }
        Path walsDir = new Path(walRootDir, "WALs");
        if (walFs.exists(walsDir)) {
            MasterRegion.replayWALs(conf, walFs, walRootDir, walsDir, regionInfo, serverName, replayEditsDir);
        } else {
            LOG.error("UNEXPECTED: WAL directory for MasterRegion is missing. {} is unexpectedly missing.", (Object)walsDir);
        }
        WAL wal = MasterRegion.createWAL(walFactory, walRoller, serverName, walFs, walRootDir, regionInfo);
        conf.set("hbase.hregion.special.recovered.edits.dir", replayEditsDir.makeQualified(walFs.getUri(), walFs.getWorkingDirectory()).toString());
        conf.setBoolean("hbase.hregion.recovered.edits.ignore.eof", true);
        return HRegion.openHRegionFromTableDir(conf, fs, tableDir, regionInfo, td, wal, null, null);
    }

    private static void replayWALs(Configuration conf, FileSystem walFs, Path walRootDir, Path walsDir, RegionInfo regionInfo, String serverName, Path replayEditsDir) throws IOException {
        for (FileStatus walDir : walFs.listStatus(walsDir)) {
            Path deadWALDir;
            if (!walDir.isDirectory()) continue;
            if (walDir.getPath().getName().startsWith(serverName)) {
                LOG.warn("This should not happen in real production as we have not created our WAL directory yet, ignore if you are running a local region related UT");
            }
            if (!walDir.getPath().getName().endsWith(DEAD_WAL_DIR_SUFFIX)) {
                deadWALDir = new Path(walDir.getPath().getParent(), walDir.getPath().getName() + DEAD_WAL_DIR_SUFFIX);
                if (!walFs.rename(walDir.getPath(), deadWALDir)) {
                    throw new IOException("Can not rename " + walDir + " to " + deadWALDir + " when recovering lease of proc store");
                }
                LOG.info("Renamed {} to {} as it is dead", (Object)walDir.getPath(), (Object)deadWALDir);
            } else {
                deadWALDir = walDir.getPath();
                LOG.info("{} is already marked as dead", (Object)deadWALDir);
            }
            for (FileStatus walFile : walFs.listStatus(deadWALDir)) {
                Path replayEditsFile = new Path(replayEditsDir, walFile.getPath().getName());
                RecoverLeaseFSUtils.recoverFileLease((FileSystem)walFs, (Path)walFile.getPath(), (Configuration)conf);
                if (!walFs.rename(walFile.getPath(), replayEditsFile)) {
                    throw new IOException("Can not rename " + walFile.getPath() + " to " + replayEditsFile + " when recovering lease for local region");
                }
                LOG.info("Renamed {} to {}", (Object)walFile.getPath(), (Object)replayEditsFile);
            }
            LOG.info("Delete empty local region wal dir {}", (Object)deadWALDir);
            walFs.delete(deadWALDir, true);
        }
    }

    private static void tryMigrate(Configuration conf, FileSystem fs, Path tableDir, RegionInfo regionInfo, TableDescriptor oldTd, TableDescriptor newTd) throws IOException {
        Class<? extends StoreFileTracker> newSft;
        Class<? extends StoreFileTracker> oldSft = StoreFileTrackerFactory.getTrackerClass(oldTd.getValue("hbase.store.file-tracker.impl"));
        if (oldSft.equals(newSft = StoreFileTrackerFactory.getTrackerClass(newTd.getValue("hbase.store.file-tracker.impl")))) {
            LOG.debug("old store file tracker {} is the same with new store file tracker, skip migration", (Object)StoreFileTrackerFactory.getStoreFileTrackerName(oldSft));
            if (!oldTd.equals(newTd)) {
                LOG.info("Update table descriptor from {} to {}", (Object)oldTd, (Object)newTd);
                FSTableDescriptors.createTableDescriptorForTableDirectory(fs, tableDir, newTd, true);
            }
            return;
        }
        LOG.info("Migrate store file tracker from {} to {}", (Object)oldSft.getSimpleName(), (Object)newSft.getSimpleName());
        HRegionFileSystem hfs = HRegionFileSystem.openRegionFromFileSystem(conf, fs, tableDir, regionInfo, false);
        for (ColumnFamilyDescriptor oldCfd : oldTd.getColumnFamilies()) {
            StoreFileTracker oldTracker = StoreFileTrackerFactory.create(conf, oldTd, oldCfd, hfs);
            StoreFileTracker newTracker = StoreFileTrackerFactory.create(conf, oldTd, oldCfd, hfs);
            List<StoreFileInfo> files = oldTracker.load();
            LOG.debug("Store file list for {}: {}", (Object)oldCfd.getNameAsString(), files);
            newTracker.set(oldTracker.load());
        }
        LOG.info("Update table descriptor from {} to {}", (Object)oldTd, (Object)newTd);
        FSTableDescriptors.createTableDescriptorForTableDirectory(fs, tableDir, newTd, true);
    }

    public static MasterRegion create(MasterRegionParams params) throws IOException {
        TableDescriptor oldTd;
        HRegion region;
        TableDescriptor td = params.tableDescriptor();
        LOG.info("Create or load local region for table " + td);
        Server server = params.server();
        Configuration baseConf = server.getConfiguration();
        FileSystem fs = CommonFSUtils.getRootDirFileSystem((Configuration)baseConf);
        FileSystem walFs = CommonFSUtils.getWALFileSystem((Configuration)baseConf);
        Path globalRootDir = CommonFSUtils.getRootDir((Configuration)baseConf);
        Path globalWALRootDir = CommonFSUtils.getWALRootDir((Configuration)baseConf);
        Path rootDir = new Path(globalRootDir, params.regionDirName());
        Path walRootDir = new Path(globalWALRootDir, params.regionDirName());
        Configuration conf = new Configuration(baseConf);
        CommonFSUtils.setRootDir((Configuration)conf, (Path)rootDir);
        CommonFSUtils.setWALRootDir((Configuration)conf, (Path)walRootDir);
        MasterRegionFlusherAndCompactor.setupConf(conf, params.flushSize(), params.flushPerChanges(), params.flushIntervalMs());
        conf.setInt("hbase.regionserver.maxlogs", params.maxWals());
        if (params.useHsync() != null) {
            conf.setBoolean("hbase.wal.hsync", params.useHsync().booleanValue());
        }
        if (params.useMetaCellComparator() != null) {
            conf.setBoolean("hbase.region.use.meta.cell.comparator", params.useMetaCellComparator().booleanValue());
        }
        conf.setInt("hbase.regionserver.wal.disruptor.event.count", IntMath.ceilingPowerOfTwo((int)params.ringBufferSlotCount()));
        MasterRegionWALRoller walRoller = MasterRegionWALRoller.create(td.getTableName() + "-WAL-Roller", conf, server, walFs, walRootDir, globalWALRootDir, params.archivedWalSuffix(), params.rollPeriodMs(), params.flushSize());
        walRoller.start();
        WALFactory walFactory = new WALFactory(conf, server.getServerName().toString());
        Path tableDir = CommonFSUtils.getTableDir((Path)rootDir, (TableName)td.getTableName());
        Path initializingFlag = new Path(tableDir, INITIALIZING_FLAG);
        Path initializedFlag = new Path(tableDir, INITIALIZED_FLAG);
        if (!fs.exists(tableDir)) {
            if (!fs.mkdirs(initializedFlag)) {
                throw new IOException("Can not touch initialized flag");
            }
            region = MasterRegion.bootstrap(conf, td, fs, rootDir, walFs, walRootDir, walFactory, walRoller, server.getServerName().toString(), true);
        } else if (!fs.exists(initializedFlag)) {
            if (!fs.exists(initializingFlag)) {
                LOG.info("No {} or {} file, try upgrading", (Object)INITIALIZING_FLAG, (Object)INITIALIZED_FLAG);
                oldTd = TableDescriptorBuilder.newBuilder((TableDescriptor)td).setValue("hbase.store.file-tracker.impl", StoreFileTrackerFactory.Trackers.DEFAULT.name()).build();
                FSTableDescriptors.createTableDescriptorForTableDirectory(fs, tableDir, oldTd, true);
                if (!fs.mkdirs(initializedFlag)) {
                    throw new IOException("Can not touch initialized flag: " + initializedFlag);
                }
                RegionInfo regionInfo = MasterRegion.loadRegionInfo(fs, tableDir);
                MasterRegion.tryMigrate(conf, fs, tableDir, regionInfo, oldTd, td);
                region = MasterRegion.open(conf, td, regionInfo, fs, rootDir, walFs, walRootDir, walFactory, walRoller, server.getServerName().toString());
            } else {
                for (TableDescriptor status : fs.listStatus(tableDir)) {
                    if (status.getPath().getName().equals(INITIALIZING_FLAG)) continue;
                    fs.delete(status.getPath(), true);
                }
                region = MasterRegion.bootstrap(conf, td, fs, rootDir, walFs, walRootDir, walFactory, walRoller, server.getServerName().toString(), false);
            }
        } else {
            if (fs.exists(initializingFlag) && !fs.delete(initializingFlag, true)) {
                LOG.warn("failed to clean up initializing flag: " + initializingFlag);
            }
            oldTd = FSTableDescriptors.getTableDescriptorFromFs(fs, tableDir);
            RegionInfo regionInfo = MasterRegion.loadRegionInfo(fs, tableDir);
            MasterRegion.tryMigrate(conf, fs, tableDir, regionInfo, oldTd, td);
            region = MasterRegion.open(conf, td, regionInfo, fs, rootDir, walFs, walRootDir, walFactory, walRoller, server.getServerName().toString());
        }
        Path globalArchiveDir = HFileArchiveUtil.getArchivePath(baseConf);
        MasterRegionFlusherAndCompactor flusherAndCompactor = new MasterRegionFlusherAndCompactor(conf, server, region, params.flushSize(), params.flushPerChanges(), params.flushIntervalMs(), params.compactMin(), globalArchiveDir, params.archivedHFileSuffix());
        walRoller.setFlusherAndCompactor(flusherAndCompactor);
        Path archiveDir = HFileArchiveUtil.getArchivePath(conf);
        if (!fs.mkdirs(archiveDir)) {
            LOG.warn("Failed to create archive directory {}. Usually this should not happen but it will be created again when we actually archive the hfiles later, so continue", (Object)archiveDir);
        }
        return new MasterRegion(region, walFactory, flusherAndCompactor, walRoller);
    }
}

