/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.logs.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.logs.model.MetricTransformation;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class PutMetricFilterRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String logGroupName;
    private String filterName;
    private String filterPattern;
    private SdkInternalList<MetricTransformation> metricTransformations;

    public PutMetricFilterRequest() {
    }

    public PutMetricFilterRequest(String logGroupName, String filterName, String filterPattern, List<MetricTransformation> metricTransformations) {
        this.setLogGroupName(logGroupName);
        this.setFilterName(filterName);
        this.setFilterPattern(filterPattern);
        this.setMetricTransformations(metricTransformations);
    }

    public void setLogGroupName(String logGroupName) {
        this.logGroupName = logGroupName;
    }

    public String getLogGroupName() {
        return this.logGroupName;
    }

    public PutMetricFilterRequest withLogGroupName(String logGroupName) {
        this.setLogGroupName(logGroupName);
        return this;
    }

    public void setFilterName(String filterName) {
        this.filterName = filterName;
    }

    public String getFilterName() {
        return this.filterName;
    }

    public PutMetricFilterRequest withFilterName(String filterName) {
        this.setFilterName(filterName);
        return this;
    }

    public void setFilterPattern(String filterPattern) {
        this.filterPattern = filterPattern;
    }

    public String getFilterPattern() {
        return this.filterPattern;
    }

    public PutMetricFilterRequest withFilterPattern(String filterPattern) {
        this.setFilterPattern(filterPattern);
        return this;
    }

    public List<MetricTransformation> getMetricTransformations() {
        if (this.metricTransformations == null) {
            this.metricTransformations = new SdkInternalList();
        }
        return this.metricTransformations;
    }

    public void setMetricTransformations(Collection<MetricTransformation> metricTransformations) {
        if (metricTransformations == null) {
            this.metricTransformations = null;
            return;
        }
        this.metricTransformations = new SdkInternalList(metricTransformations);
    }

    public PutMetricFilterRequest withMetricTransformations(MetricTransformation ... metricTransformations) {
        if (this.metricTransformations == null) {
            this.setMetricTransformations((Collection<MetricTransformation>)new SdkInternalList(metricTransformations.length));
        }
        for (MetricTransformation ele : metricTransformations) {
            this.metricTransformations.add((Object)ele);
        }
        return this;
    }

    public PutMetricFilterRequest withMetricTransformations(Collection<MetricTransformation> metricTransformations) {
        this.setMetricTransformations(metricTransformations);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getLogGroupName() != null) {
            sb.append("LogGroupName: ").append(this.getLogGroupName()).append(",");
        }
        if (this.getFilterName() != null) {
            sb.append("FilterName: ").append(this.getFilterName()).append(",");
        }
        if (this.getFilterPattern() != null) {
            sb.append("FilterPattern: ").append(this.getFilterPattern()).append(",");
        }
        if (this.getMetricTransformations() != null) {
            sb.append("MetricTransformations: ").append(this.getMetricTransformations());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutMetricFilterRequest)) {
            return false;
        }
        PutMetricFilterRequest other = (PutMetricFilterRequest)obj;
        if (other.getLogGroupName() == null ^ this.getLogGroupName() == null) {
            return false;
        }
        if (other.getLogGroupName() != null && !other.getLogGroupName().equals(this.getLogGroupName())) {
            return false;
        }
        if (other.getFilterName() == null ^ this.getFilterName() == null) {
            return false;
        }
        if (other.getFilterName() != null && !other.getFilterName().equals(this.getFilterName())) {
            return false;
        }
        if (other.getFilterPattern() == null ^ this.getFilterPattern() == null) {
            return false;
        }
        if (other.getFilterPattern() != null && !other.getFilterPattern().equals(this.getFilterPattern())) {
            return false;
        }
        if (other.getMetricTransformations() == null ^ this.getMetricTransformations() == null) {
            return false;
        }
        return other.getMetricTransformations() == null || other.getMetricTransformations().equals(this.getMetricTransformations());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getLogGroupName() == null ? 0 : this.getLogGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getFilterName() == null ? 0 : this.getFilterName().hashCode());
        hashCode = 31 * hashCode + (this.getFilterPattern() == null ? 0 : this.getFilterPattern().hashCode());
        hashCode = 31 * hashCode + (this.getMetricTransformations() == null ? 0 : this.getMetricTransformations().hashCode());
        return hashCode;
    }

    public PutMetricFilterRequest clone() {
        return (PutMetricFilterRequest)super.clone();
    }
}

