# Motivation

After configuring the geo-replication on Pulsar clusters, the `clusters list` API will return multiple clusters, including the local Pulsar cluster and remote clusters like

```
bin/pulsar-admin clusters list
us-west
us-east
us-cent
```
But in this return, you can't distinguish the local and the remote cluster. When you need to remove the geo-replication configuration, it will be hard to decide which cluster should be removed on replicated tenants and namespaces unless you record the cluster information.

# High Level Design

Add `--current` option to the cluster list cmd and mark the current cluster with `(*)`
```
bin/pulsar-admin clusters list --current
us-west(*)
us-east
us-cent
```

# Detailed Design

## Implementation Details

Add `--current` option to the cluster list cmd
```
@Parameter(names = { "-c", "--current" }, description = "Print the current cluster with (*)", required = false)
private boolean current = false;
```

```
void run() throws PulsarAdminException {
   java.util.List<String> clusters = getAdmin().clusters().getClusters();
   String clusterName = getAdmin().brokers().getRuntimeConfigurations().get("clusterName");
   List<String> result = clusters.stream().map(c ->c.equals(clusterName) ? (current ? c + "(*)" : c) : c).collect(Collectors.toList());
   print(result);
}
```

# Links

<!--
Updated afterwards
-->
* Mailing List discussion thread: https://lists.apache.org/thread/800r6ld5wg7bttbywmk38m1qx12hs6nl
* Mailing List voting thread: https://lists.apache.org/thread/rqn3rd3c4hj11o3b12ygopmztj2yy7pv
