/*
 * Decompiled with CFR 0.152.
 */
package io.netty.incubator.channel.uring;

import io.netty.incubator.channel.uring.Native;
import io.netty.util.internal.PlatformDependent;

final class Iov {
    private Iov() {
    }

    static void write(long iovAddress, long bufferAddress, int length) {
        if (Native.SIZEOF_SIZE_T == 4) {
            PlatformDependent.putInt((long)(iovAddress + (long)Native.IOVEC_OFFSETOF_IOV_BASE), (int)((int)bufferAddress));
            PlatformDependent.putInt((long)(iovAddress + (long)Native.IOVEC_OFFSETOF_IOV_LEN), (int)length);
        } else {
            assert (Native.SIZEOF_SIZE_T == 8);
            PlatformDependent.putLong((long)(iovAddress + (long)Native.IOVEC_OFFSETOF_IOV_BASE), (long)bufferAddress);
            PlatformDependent.putLong((long)(iovAddress + (long)Native.IOVEC_OFFSETOF_IOV_LEN), (long)length);
        }
    }

    static long readBufferAddress(long iovAddress) {
        if (Native.SIZEOF_SIZE_T == 4) {
            return PlatformDependent.getInt((long)(iovAddress + (long)Native.IOVEC_OFFSETOF_IOV_BASE));
        }
        assert (Native.SIZEOF_SIZE_T == 8);
        return PlatformDependent.getLong((long)(iovAddress + (long)Native.IOVEC_OFFSETOF_IOV_BASE));
    }

    static int readBufferLength(long iovAddress) {
        if (Native.SIZEOF_SIZE_T == 4) {
            return PlatformDependent.getInt((long)(iovAddress + (long)Native.IOVEC_OFFSETOF_IOV_LEN));
        }
        assert (Native.SIZEOF_SIZE_T == 8);
        return (int)PlatformDependent.getLong((long)(iovAddress + (long)Native.IOVEC_OFFSETOF_IOV_LEN));
    }
}

