/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class ConfigurationUpdateTargetType extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public Integer getExtensionId() {
    return (int) 15540;
  }

  // Properties.
  protected final PascalString path;
  protected final ConfigurationUpdateType updateType;

  public ConfigurationUpdateTargetType(PascalString path, ConfigurationUpdateType updateType) {
    super();
    this.path = path;
    this.updateType = updateType;
  }

  public PascalString getPath() {
    return path;
  }

  public ConfigurationUpdateType getUpdateType() {
    return updateType;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("ConfigurationUpdateTargetType");

    // Simple Field (path)
    writeSimpleField("path", path, writeComplex(writeBuffer));

    // Simple Field (updateType)
    writeSimpleEnumField(
        "updateType",
        "ConfigurationUpdateType",
        updateType,
        writeEnum(
            ConfigurationUpdateType::getValue,
            ConfigurationUpdateType::name,
            writeUnsignedLong(writeBuffer, 32)));

    writeBuffer.popContext("ConfigurationUpdateTargetType");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    ConfigurationUpdateTargetType _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (path)
    lengthInBits += path.getLengthInBits();

    // Simple field (updateType)
    lengthInBits += 32;

    return lengthInBits;
  }

  public static ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(
      ReadBuffer readBuffer, Integer extensionId) throws ParseException {
    readBuffer.pullContext("ConfigurationUpdateTargetType");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    PascalString path =
        readSimpleField(
            "path", readComplex(() -> PascalString.staticParse(readBuffer), readBuffer));

    ConfigurationUpdateType updateType =
        readEnumField(
            "updateType",
            "ConfigurationUpdateType",
            readEnum(ConfigurationUpdateType::enumForValue, readUnsignedLong(readBuffer, 32)));

    readBuffer.closeContext("ConfigurationUpdateTargetType");
    // Create the instance
    return new ConfigurationUpdateTargetTypeBuilderImpl(path, updateType);
  }

  public static class ConfigurationUpdateTargetTypeBuilderImpl
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final PascalString path;
    private final ConfigurationUpdateType updateType;

    public ConfigurationUpdateTargetTypeBuilderImpl(
        PascalString path, ConfigurationUpdateType updateType) {
      this.path = path;
      this.updateType = updateType;
    }

    public ConfigurationUpdateTargetType build() {
      ConfigurationUpdateTargetType configurationUpdateTargetType =
          new ConfigurationUpdateTargetType(path, updateType);
      return configurationUpdateTargetType;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof ConfigurationUpdateTargetType)) {
      return false;
    }
    ConfigurationUpdateTargetType that = (ConfigurationUpdateTargetType) o;
    return (getPath() == that.getPath())
        && (getUpdateType() == that.getUpdateType())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getPath(), getUpdateType());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
