/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.cbus.readwrite;

import java.util.HashMap;
import java.util.Map;

// Code generated by code-generation. DO NOT EDIT.

public enum Language {
  NO_LANGUAGE((short) 0x00),
  ENGLISH((short) 0x01),
  ENGLISH_AUSTRALIA((short) 0x02),
  ENGLISH_BELIZE((short) 0x03),
  ENGLISH_CANADA((short) 0x04),
  ENGLISH_CARRIBEAN((short) 0x05),
  ENGLISH_IRELAND((short) 0x06),
  ENGLISH_JAMAICA((short) 0x07),
  ENGLISH_NEW_ZEALAND((short) 0x08),
  ENGLISH_PHILIPPINES((short) 0x09),
  ENGLISH_SOUTH_AFRICA((short) 0x0A),
  ENGLISH_TRINIDAD((short) 0x0B),
  ENGLISH_UK((short) 0x0C),
  ENGLISH_USA((short) 0x0D),
  ENGLISH_ZIMBABWE((short) 0x0E),
  AFRIKAANS((short) 0x40),
  BASQUE((short) 0x41),
  CATALAN((short) 0x42),
  DANISH((short) 0x43),
  DUTCH_BELGIUM((short) 0x44),
  DUTCH_NETHERLANDS((short) 0x45),
  FAEROESE((short) 0x46),
  FINNISH((short) 0x47),
  FRENCH_BELGIUM((short) 0x48),
  FRENCH_CANADA((short) 0x49),
  FRENCH((short) 0x4A),
  FRENCH_LUXEMBOURG((short) 0x4B),
  FRENCH_MONACO((short) 0x4C),
  FRENCH_SWITZERLAND((short) 0x4D),
  GALICIAN((short) 0x4E),
  GERMAN_AUSTRIA((short) 0x4F),
  GERMAN((short) 0x50),
  GERMAN_LIECHTENSTEIN((short) 0x51),
  GERMAN_LUXEMBOURG((short) 0x52),
  GERMAN_SWITZERLAND((short) 0x53),
  ICELANDIC((short) 0x54),
  INDONESIAN((short) 0x55),
  ITALIAN((short) 0x56),
  ITALIAN_SWITZERLAND((short) 0x57),
  MALAY_BRUNEI((short) 0x58),
  MALAY((short) 0x59),
  NORWEGIAN((short) 0x5A),
  NORWEGIAN_NYNORSK((short) 0x5B),
  PORTUGUESE_BRAZIL((short) 0x5C),
  PORTUGUESE((short) 0x5D),
  SPANISH_ARGENTINE((short) 0x5E),
  SPANISH_BOLIVIA((short) 0x5F),
  SPANISH_CHILE((short) 0x60),
  SPANISH_COLOMBIA((short) 0x61),
  SPANISH_COSTA_RICA((short) 0x62),
  SPANISH_DOMINICAN_REPUBLIC((short) 0x63),
  SPANISH_ECUADOR((short) 0x64),
  SPANISH_EL_SALVADOR((short) 0x65),
  SPANISH_GUATEMALA((short) 0x66),
  SPANISH_HONDURAS((short) 0x67),
  SPANISH((short) 0x68),
  SPANISH_MEXICO((short) 0x69),
  SPANISH_NICARAGUA((short) 0x6A),
  SPANISH_PANAMA((short) 0x6B),
  SPANISH_PARAGUAY((short) 0x6C),
  SPANISH_PERU((short) 0x6D),
  SPANISH_PERTO_RICO((short) 0x6E),
  SPANISH_TRADITIONAL((short) 0x6F),
  SPANISH_URUGUAY((short) 0x70),
  SPANISH_VENEZUELA((short) 0x71),
  SWAHILI((short) 0x72),
  SWEDISH((short) 0x73),
  SWEDISH_FINLAND((short) 0x74),
  CHINESE_CP936((short) 0xCA);
  private static final Map<Short, Language> map;

  static {
    map = new HashMap<>();
    for (Language value : Language.values()) {
      map.put((short) value.getValue(), value);
    }
  }

  private final short value;

  Language(short value) {
    this.value = value;
  }

  public short getValue() {
    return value;
  }

  public static Language enumForValue(short value) {
    return map.get(value);
  }

  public static Boolean isDefined(short value) {
    return map.containsKey(value);
  }
}
