/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import java.util.HashMap;
import java.util.Map;

// Code generated by code-generation. DO NOT EDIT.

public enum SecurityResponseCode {
  SUCCESS((short) 0x00),
  ACCESS_DENIED((short) 0x01),
  BAD_DESTINATION_ADDRESS((short) 0x02),
  BAD_DESTINATION_DEVICE_ID((short) 0x03),
  BAD_SIGNATURE((short) 0x04),
  BAD_SOURCE_ADDRESS((short) 0x05),
  BAD_TIMESTAMP((short) 0x06),
  CANNOT_USE_KEY((short) 0x07),
  CANNOT_VERIFY_MESSAGE_ID((short) 0x08),
  CORRECT_KEY_REVISION((short) 0x09),
  DESTINATION_DEVICE_ID_REQUIRED((short) 0x0A),
  DUPLICATE_MESSAGE((short) 0x0B),
  ENCRYPTION_NOT_CONFIGURED((short) 0x0C),
  ENCRYPTION_REQUIRED((short) 0x0D),
  INCORRECT_KEY((short) 0x0E),
  INVALID_KEY_DATA((short) 0x0F),
  KEY_UPDATE_IN_PROGRESS((short) 0x10),
  MALFORMED_MESSAGE((short) 0x11),
  NOT_KEY_SERVER((short) 0x12),
  SECURITY_NOT_CONFIGURED((short) 0x13),
  SOURCE_SECURITY_REQUIRED((short) 0x14),
  TOO_MANY_KEYS((short) 0x15),
  UNKNOWN_AUTHENTICATION_TYPE((short) 0x16),
  UNKNOWN_KEY((short) 0x17),
  UNKNOWN_KEY_REVISION((short) 0x18),
  UNKNOWN_SOURCE_MESSAGE((short) 0x19);
  private static final Map<Short, SecurityResponseCode> map;

  static {
    map = new HashMap<>();
    for (SecurityResponseCode value : SecurityResponseCode.values()) {
      map.put((short) value.getValue(), value);
    }
  }

  private final short value;

  SecurityResponseCode(short value) {
    this.value = value;
  }

  public short getValue() {
    return value;
  }

  public static SecurityResponseCode enumForValue(short value) {
    return map.get(value);
  }

  public static Boolean isDefined(short value) {
    return map.containsKey(value);
  }
}
