/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetServiceAckReadPropertyConditional is the corresponding interface of BACnetServiceAckReadPropertyConditional
type BACnetServiceAckReadPropertyConditional interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetServiceAck
	// GetBytesOfRemovedService returns BytesOfRemovedService (property field)
	GetBytesOfRemovedService() []byte
	// IsBACnetServiceAckReadPropertyConditional is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetServiceAckReadPropertyConditional()
	// CreateBuilder creates a BACnetServiceAckReadPropertyConditionalBuilder
	CreateBACnetServiceAckReadPropertyConditionalBuilder() BACnetServiceAckReadPropertyConditionalBuilder
}

// _BACnetServiceAckReadPropertyConditional is the data-structure of this message
type _BACnetServiceAckReadPropertyConditional struct {
	BACnetServiceAckContract
	BytesOfRemovedService []byte

	// Arguments.
	ServiceAckPayloadLength uint32
}

var _ BACnetServiceAckReadPropertyConditional = (*_BACnetServiceAckReadPropertyConditional)(nil)
var _ BACnetServiceAckRequirements = (*_BACnetServiceAckReadPropertyConditional)(nil)

// NewBACnetServiceAckReadPropertyConditional factory function for _BACnetServiceAckReadPropertyConditional
func NewBACnetServiceAckReadPropertyConditional(bytesOfRemovedService []byte, serviceAckPayloadLength uint32, serviceAckLength uint32) *_BACnetServiceAckReadPropertyConditional {
	_result := &_BACnetServiceAckReadPropertyConditional{
		BACnetServiceAckContract: NewBACnetServiceAck(serviceAckLength),
		BytesOfRemovedService:    bytesOfRemovedService,
	}
	_result.BACnetServiceAckContract.(*_BACnetServiceAck)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetServiceAckReadPropertyConditionalBuilder is a builder for BACnetServiceAckReadPropertyConditional
type BACnetServiceAckReadPropertyConditionalBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(bytesOfRemovedService []byte) BACnetServiceAckReadPropertyConditionalBuilder
	// WithBytesOfRemovedService adds BytesOfRemovedService (property field)
	WithBytesOfRemovedService(...byte) BACnetServiceAckReadPropertyConditionalBuilder
	// WithArgServiceAckPayloadLength sets a parser argument
	WithArgServiceAckPayloadLength(uint32) BACnetServiceAckReadPropertyConditionalBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetServiceAckBuilder
	// Build builds the BACnetServiceAckReadPropertyConditional or returns an error if something is wrong
	Build() (BACnetServiceAckReadPropertyConditional, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetServiceAckReadPropertyConditional
}

// NewBACnetServiceAckReadPropertyConditionalBuilder() creates a BACnetServiceAckReadPropertyConditionalBuilder
func NewBACnetServiceAckReadPropertyConditionalBuilder() BACnetServiceAckReadPropertyConditionalBuilder {
	return &_BACnetServiceAckReadPropertyConditionalBuilder{_BACnetServiceAckReadPropertyConditional: new(_BACnetServiceAckReadPropertyConditional)}
}

type _BACnetServiceAckReadPropertyConditionalBuilder struct {
	*_BACnetServiceAckReadPropertyConditional

	parentBuilder *_BACnetServiceAckBuilder

	collectedErr []error
}

var _ (BACnetServiceAckReadPropertyConditionalBuilder) = (*_BACnetServiceAckReadPropertyConditionalBuilder)(nil)

func (b *_BACnetServiceAckReadPropertyConditionalBuilder) setParent(contract BACnetServiceAckContract) {
	b.BACnetServiceAckContract = contract
	contract.(*_BACnetServiceAck)._SubType = b._BACnetServiceAckReadPropertyConditional
}

func (b *_BACnetServiceAckReadPropertyConditionalBuilder) WithMandatoryFields(bytesOfRemovedService []byte) BACnetServiceAckReadPropertyConditionalBuilder {
	return b.WithBytesOfRemovedService(bytesOfRemovedService...)
}

func (b *_BACnetServiceAckReadPropertyConditionalBuilder) WithBytesOfRemovedService(bytesOfRemovedService ...byte) BACnetServiceAckReadPropertyConditionalBuilder {
	b.BytesOfRemovedService = bytesOfRemovedService
	return b
}

func (b *_BACnetServiceAckReadPropertyConditionalBuilder) WithArgServiceAckPayloadLength(serviceAckPayloadLength uint32) BACnetServiceAckReadPropertyConditionalBuilder {
	b.ServiceAckPayloadLength = serviceAckPayloadLength
	return b
}

func (b *_BACnetServiceAckReadPropertyConditionalBuilder) Build() (BACnetServiceAckReadPropertyConditional, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetServiceAckReadPropertyConditional.deepCopy(), nil
}

func (b *_BACnetServiceAckReadPropertyConditionalBuilder) MustBuild() BACnetServiceAckReadPropertyConditional {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetServiceAckReadPropertyConditionalBuilder) Done() BACnetServiceAckBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetServiceAckBuilder().(*_BACnetServiceAckBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetServiceAckReadPropertyConditionalBuilder) buildForBACnetServiceAck() (BACnetServiceAck, error) {
	return b.Build()
}

func (b *_BACnetServiceAckReadPropertyConditionalBuilder) DeepCopy() any {
	_copy := b.CreateBACnetServiceAckReadPropertyConditionalBuilder().(*_BACnetServiceAckReadPropertyConditionalBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetServiceAckReadPropertyConditionalBuilder creates a BACnetServiceAckReadPropertyConditionalBuilder
func (b *_BACnetServiceAckReadPropertyConditional) CreateBACnetServiceAckReadPropertyConditionalBuilder() BACnetServiceAckReadPropertyConditionalBuilder {
	if b == nil {
		return NewBACnetServiceAckReadPropertyConditionalBuilder()
	}
	return &_BACnetServiceAckReadPropertyConditionalBuilder{_BACnetServiceAckReadPropertyConditional: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetServiceAckReadPropertyConditional) GetServiceChoice() BACnetConfirmedServiceChoice {
	return BACnetConfirmedServiceChoice_READ_PROPERTY_CONDITIONAL
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetServiceAckReadPropertyConditional) GetParent() BACnetServiceAckContract {
	return m.BACnetServiceAckContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetServiceAckReadPropertyConditional) GetBytesOfRemovedService() []byte {
	return m.BytesOfRemovedService
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetServiceAckReadPropertyConditional(structType any) BACnetServiceAckReadPropertyConditional {
	if casted, ok := structType.(BACnetServiceAckReadPropertyConditional); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetServiceAckReadPropertyConditional); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetServiceAckReadPropertyConditional) GetTypeName() string {
	return "BACnetServiceAckReadPropertyConditional"
}

func (m *_BACnetServiceAckReadPropertyConditional) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetServiceAckContract.(*_BACnetServiceAck).getLengthInBits(ctx))

	// Array field
	if len(m.BytesOfRemovedService) > 0 {
		lengthInBits += 8 * uint16(len(m.BytesOfRemovedService))
	}

	return lengthInBits
}

func (m *_BACnetServiceAckReadPropertyConditional) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetServiceAckReadPropertyConditional) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetServiceAck, serviceAckPayloadLength uint32, serviceAckLength uint32) (__bACnetServiceAckReadPropertyConditional BACnetServiceAckReadPropertyConditional, err error) {
	m.BACnetServiceAckContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetServiceAckReadPropertyConditional"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetServiceAckReadPropertyConditional")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	bytesOfRemovedService, err := readBuffer.ReadByteArray("bytesOfRemovedService", int(serviceAckPayloadLength))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'bytesOfRemovedService' field"))
	}
	m.BytesOfRemovedService = bytesOfRemovedService

	if closeErr := readBuffer.CloseContext("BACnetServiceAckReadPropertyConditional"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetServiceAckReadPropertyConditional")
	}

	return m, nil
}

func (m *_BACnetServiceAckReadPropertyConditional) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetServiceAckReadPropertyConditional) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetServiceAckReadPropertyConditional"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetServiceAckReadPropertyConditional")
		}

		if err := WriteByteArrayField(ctx, "bytesOfRemovedService", m.GetBytesOfRemovedService(), WriteByteArray(writeBuffer, 8)); err != nil {
			return errors.Wrap(err, "Error serializing 'bytesOfRemovedService' field")
		}

		if popErr := writeBuffer.PopContext("BACnetServiceAckReadPropertyConditional"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetServiceAckReadPropertyConditional")
		}
		return nil
	}
	return m.BACnetServiceAckContract.(*_BACnetServiceAck).serializeParent(ctx, writeBuffer, m, ser)
}

////
// Arguments Getter

func (m *_BACnetServiceAckReadPropertyConditional) GetServiceAckPayloadLength() uint32 {
	return m.ServiceAckPayloadLength
}

//
////

func (m *_BACnetServiceAckReadPropertyConditional) IsBACnetServiceAckReadPropertyConditional() {}

func (m *_BACnetServiceAckReadPropertyConditional) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetServiceAckReadPropertyConditional) deepCopy() *_BACnetServiceAckReadPropertyConditional {
	if m == nil {
		return nil
	}
	_BACnetServiceAckReadPropertyConditionalCopy := &_BACnetServiceAckReadPropertyConditional{
		m.BACnetServiceAckContract.(*_BACnetServiceAck).deepCopy(),
		utils.DeepCopySlice[byte, byte](m.BytesOfRemovedService),
		m.ServiceAckPayloadLength,
	}
	_BACnetServiceAckReadPropertyConditionalCopy.BACnetServiceAckContract.(*_BACnetServiceAck)._SubType = m
	return _BACnetServiceAckReadPropertyConditionalCopy
}

func (m *_BACnetServiceAckReadPropertyConditional) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
