---
title: Pseudo-cluster
weight: 23

---
<!---
  Licensed to the Apache Software Foundation (ASF) under one or more
  contributor license agreements.  See the NOTICE file distributed with
  this work for additional information regarding copyright ownership.
  The ASF licenses this file to You under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with
  the License.  You may obtain a copy of the License at

      http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
-->

{{< requirements >}}
 * [Docker Engine](https://docs.docker.com/engine/install/) latest stable version
 * [Docker Compose](https://docs.docker.com/compose/install/) at least v2.30
{{< /requirements >}}

* Download the Ozone binary tarball and untar it.

* Go to the directory where the docker compose files exist and tell
`docker-compose` to start Ozone in the background. This will start a small
ozone instance on your machine.

{{< highlight bash >}}
cd compose/ozone/

docker-compose up -d
{{< /highlight >}}

To verify that ozone is working as expected, let us log into a data node and
run _freon_, the load generator for Ozone. The ```exec datanode bash``` command
will open a bash shell on the datanode.

The `ozone freon` command is executed within the datanode container. You can quit freon via CTRL-C any time. The
```rk``` profile instructs freon to generate random keys.

{{< highlight bash >}}
docker-compose exec datanode bash
ozone freon rk
{{< /highlight >}}

You can check out the **OzoneManager UI** at http://localhost:9874/ to see the
activity generated by freon.
While you are there, please don't forget to check out the ozone configuration explorer.

***Congratulations, You have just run your first ozone cluster.***

To shutdown the cluster, please run
{{< highlight bash >}}
docker-compose down
{{< /highlight >}}

**You can refer to the link [README](https://github.com/apache/ozone/blob/master/hadoop-ozone/dist/src/main/compose/ozone/README.md) for configuring `monitoring` and `profiling` add-ons**


