/****************************************************************************
 * arch/arm/src/imx9/hardware/imx95/imx95_memorymap.h
 *
 * SPDX-License-Identifier: Apache-2.0
 * SPDX-FileCopyrightText: 2024 NXP
 *
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.  The
 * ASF licenses this file to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 ****************************************************************************/

/****************************************************************************
 * Pre-processor Definitions
 ****************************************************************************/

#define IMX9_ITCM_BASE            (0x00000000) /* 512 KB ITCM (FlexRAM) */
#define IMX9_FLEXSPI1_ALIAS_BASE  (0x02000000) /* 32 MB FlexSPI1 (alias) */
#define IMX9_DTCM_BASE            (0x20000000) /* 512 KB DTCM (FlexRAM) */
#define IMX9_OCRAM_BASE           (0x20480000) /* 352 KB, OCRAM */
#define IMX9_FLEXSPI1_BASE        (0x28000000) /* 128 MB FlexSPI1 */
#define IMX9_AIPS1_BASE           (0x42000000) /* AIPS 8192KB */
#define IMX9_AIPS2_BASE           (0x42800000) /* AIPS 8192KB */
#define IMX9_AIPS3_BASE           (0x44000000) /* AIPS 8192KB */
#define IMX9_AIPS4_BASE           (0x49000000) /* AIPS 8192KB */
#define IMX9_GPIO_MEM_BASE        (0x43810000) /* GPIO 2-3-4-5 320KB region */
#define IMX9_GPIO1_BASE           (0x47400000) /* GPIO 1 64KB region */
#define IMX9_DRAM_BASE            (0x80000000) /* DRAM */
#define IMX9_DRAM_XIP_BASE        (0x90000800) /* DRAM XIP */
#define IMX9_RPMSG_BASE           (0x88000000) /* DRAM for VRING and RSC */

#define IMX9_ADC_BASE                                                                         (0x44530000)
#define IMX9_ANALOG__AGDET_BASE                                                               (0x44487000)
#define IMX9_ANALOG__AUDIO_FRACT_PLL1_BASE                                                    (0x44481100)
#define IMX9_ANALOG__AUDIO_FRACT_PLL2_BASE                                                    (0x44481200)
#define IMX9_ANALOG__CMU0_BASE                                                                (0x44670000)
#define IMX9_ANALOG__FRO_BASE                                                                 (0x44485000)
#define IMX9_ANALOG__OSC24M_BASE                                                              (0x44480000)
#define IMX9_ANALOG__PMRO_BASE                                                                (0x44484000)
#define IMX9_ANALOG__SFA_BASE                                                                 (0x44483000)
#define IMX9_ANALOG__SYS_FRACT_PLL1_BASE                                                      (0x44481000)
#define IMX9_ANALOG__TCU_BASE                                                                 (0x444C0000)
#define IMX9_ANALOG__TRGMUX_BASE                                                              (0x44531000)
#define IMX9_ANALOG__VDET_BASE                                                                (0x44486000)
#define IMX9_ANALOG__VIDEO_FRACT_PLL1_BASE                                                    (0x44481300)
#define IMX9_AON__AXBS_BASE                                                                   (0x44510000)
#define IMX9_AON__BLK_CTRL_NS_AONMIX1_BASE                                                    (0x44210000)
#define IMX9_AON__BLK_CTRL_S_AONMIX2_BASE                                                     (0x444F0000)
#define IMX9_AON__CMUA1_BASE                                                                  (0x44540000)
#define IMX9_AON__CMUA2_BASE                                                                  (0x44650000)
#define IMX9_AON__CRCA_BASE                                                                   (0x44660000)
#define IMX9_AON__CSTCU_BASE                                                                  (0x44590000)
#define IMX9_AON__EDMA3_TCD1_BASE                                                             (0x44010000)
#define IMX9_AON__EIMA_BASE                                                                   (0x44550000)
#define IMX9_AON__FCCU_BASE                                                                   (0x44570000)
#define IMX9_AON__INTM_BASE                                                                   (0x44580000)
#define IMX9_AON__IOMUXC0__IOMUXC_GPR_BASE                                                    (0x443D0000)
#define IMX9_AON__LSTCUA_BASE                                                                 (0x445A0000)
#define IMX9_AON__M33_CACHE_CTRL_ECC0__CM33_CACHE_ECC_MCM_BASE                                (0x44401000)
#define IMX9_AON__M33_CACHE_CTRL_ECC0__CM33_TCM_MCM_BASE                                      (0x44420000)
#define IMX9_AON__M33_PCF1_BASE                                                               (0x443E0000)
#define IMX9_AON__M33_PSF1_BASE                                                               (0x443F0000)
#define IMX9_AON__MCM_BASE                                                                    (0xE0080000)
#define IMX9_AON__ROMCP1_BASE                                                                 (0x44430000)
#define IMX9_AON__SYS_CTR1__SYS_CTR_COMPARE_BASE                                              (0x442A0000)
#define IMX9_AON__SYS_CTR1__SYS_CTR_CONTROL_BASE                                              (0x44290000)
#define IMX9_AON__SYS_CTR1__SYS_CTR_READ_BASE                                                 (0x442B0000)
#define IMX9_AON__TCU_BASE                                                                    (0x444B0000)
#define IMX9_BBSM__BBNSM_BASE                                                                 (0x44440000)
#define IMX9_BBSM__BLK_CTRL_BBSMMIX_BBSMMIX1_BASE                                             (0x44410000)
#define IMX9_BBSM__TCU_BBSMMIX_BASE                                                           (0x444E0000)
#define IMX9_BLK_CTRL_CAMERAMIX_BASE                                                          (0x4AC10000)
#define IMX9_BLK_CTRL_NETCMIX_BASE                                                            (0x4C810000)
#define IMX9_CAMERA__DSI_CAMID_CSR_BASE                                                       (0x4ADE0000)
#define IMX9_CAMERA__DSI_CSI_COMBO_COMPLEX_CSI1__CSI_BASE                                     (0x4AD40000)
#define IMX9_CAMERA__DSI_MASTER_CSR_BASE                                                      (0x4AD10000)
#define IMX9_CAMERA__DSI_OR_CSI_PHY_CSR_BASE                                                  (0x4AD20000)
#define IMX9_CAMERA__DSI_PIXEL_FORMATTING_BASE                                                (0x4AC00000)
#define IMX9_CAMERA__DSI_STREAM_CSR_BASE                                                      (0x4AD00000)
#define IMX9_CAMERA__EDMA5_TCDC_BASE                                                          (0x4AE20000)
#define IMX9_CAMERA__GPV__ISI_RD_I_MAIN_QOSGENERATOR_BASE                                     (0x4AFF0C00)
#define IMX9_CAMERA__GPV__ISI_RD_I_MAIN_TRANSACTIONSTATFILTER_BASE                            (0x4AFF1000)
#define IMX9_CAMERA__GPV__ISI_WR_U_I_MAIN_QOSGENERATOR_BASE                                   (0x4AFF0C80)
#define IMX9_CAMERA__GPV__ISI_WR_U_I_MAIN_TRANSACTIONSTATFILTER_BASE                          (0x4AFF1080)
#define IMX9_CAMERA__GPV__ISI_WR_V_I_MAIN_QOSGENERATOR_BASE                                   (0x4AFF0D00)
#define IMX9_CAMERA__GPV__ISI_WR_V_I_MAIN_TRANSACTIONSTATFILTER_BASE                          (0x4AFF1100)
#define IMX9_CAMERA__GPV__ISI_WR_Y_I_MAIN_QOSGENERATOR_BASE                                   (0x4AFF0D80)
#define IMX9_CAMERA__GPV__ISI_WR_Y_I_MAIN_TRANSACTIONSTATFILTER_BASE                          (0x4AFF1180)
#define IMX9_CAMERA__GPV__ISP_RD_0_I_MAIN_QOSGENERATOR_BASE                                   (0x4AFF0E00)
#define IMX9_CAMERA__GPV__ISP_RD_0_I_MAIN_TRANSACTIONSTATFILTER_BASE                          (0x4AFF1200)
#define IMX9_CAMERA__GPV__ISP_RD_1_I_MAIN_QOSGENERATOR_BASE                                   (0x4AFF0E80)
#define IMX9_CAMERA__GPV__ISP_RD_1_I_MAIN_TRANSACTIONSTATFILTER_BASE                          (0x4AFF1280)
#define IMX9_CAMERA__GPV__ISP_WR_0_I_MAIN_QOSGENERATOR_BASE                                   (0x4AFF0F00)
#define IMX9_CAMERA__GPV__ISP_WR_0_I_MAIN_TRANSACTIONSTATFILTER_BASE                          (0x4AFF1300)
#define IMX9_CAMERA__GPV__ISP_WR_1_I_MAIN_QOSGENERATOR_BASE                                   (0x4AFF0F80)
#define IMX9_CAMERA__GPV__ISP_WR_1_I_MAIN_TRANSACTIONSTATFILTER_BASE                          (0x4AFF1380)
#define IMX9_CAMERA__GPV__PROBE_ISI_MAIN_PROBE_BASE                                           (0x4AFF0000)
#define IMX9_CAMERA__GPV__PROBE_ISI_MAIN_TRANSACTIONSTATPROFILER_BASE                         (0x4AFF1400)
#define IMX9_CAMERA__GPV__PROBE_ISP_MAIN_PROBE_BASE                                           (0x4AFF0400)
#define IMX9_CAMERA__GPV__PROBE_ISP_MAIN_TRANSACTIONSTATPROFILER_BASE                         (0x4AFF1480)
#define IMX9_CAMERA__GPV__PROBE_SSI_FWD_MAIN_PROBE_BASE                                       (0x4AFF0800)
#define IMX9_CAMERA__ISI_BASE                                                                 (0x4AD50000)
#define IMX9_CAMERA__ISP__ALIAS_BASE                                                          (0x4AE02000)
#define IMX9_CAMERA__ISP__AUTOFOCUS_BASE                                                      (0x4AE01700)
#define IMX9_CAMERA__ISP__BNR_BASE                                                            (0x4AE00800)
#define IMX9_CAMERA__ISP__CAS_BASE                                                            (0x4AE01500)
#define IMX9_CAMERA__ISP__CCONVMED_BASE                                                       (0x4AE014C0)
#define IMX9_CAMERA__ISP__COLOR_TEMP_BASE                                                     (0x4AE00400)
#define IMX9_CAMERA__ISP__DEMOSAIC_BASE                                                       (0x4AE01180)
#define IMX9_CAMERA__ISP__DF_BASE                                                             (0x4AE01440)
#define IMX9_CAMERA__ISP__DRC_BASE                                                            (0x4AE01300)
#define IMX9_CAMERA__ISP__EE_BASE                                                             (0x4AE01480)
#define IMX9_CAMERA__ISP__GCM_BASE                                                            (0x4AE01600)
#define IMX9_CAMERA__ISP__HC_BASE                                                             (0x4AE000C0)
#define IMX9_CAMERA__ISP__HDR_DECOMPRESS0_BASE                                                (0x4AE00100)
#define IMX9_CAMERA__ISP__HDR_DECOMPRESS1_BASE                                                (0x4AE00180)
#define IMX9_CAMERA__ISP__HDR_MERGE_BASE                                                      (0x4AE00300)
#define IMX9_CAMERA__ISP__IDBG1_BASE                                                          (0x4AE00FC0)
#define IMX9_CAMERA__ISP__IDBG2_BASE                                                          (0x4AE01FC0)
#define IMX9_CAMERA__ISP__IR_COMPRESS_BASE                                                    (0x4AE00780)
#define IMX9_CAMERA__ISP__NR_BASE                                                             (0x4AE01400)
#define IMX9_CAMERA__ISP__OB_WB0_BASE                                                         (0x4AE00200)
#define IMX9_CAMERA__ISP__OB_WB1_BASE                                                         (0x4AE00240)
#define IMX9_CAMERA__ISP__OB_WB2_BASE                                                         (0x4AE00280)
#define IMX9_CAMERA__ISP__PACKETIZER_BASE                                                     (0x4AE01580)
#define IMX9_CAMERA__ISP__PIPE_CONF_BASE                                                      (0x4AE00000)
#define IMX9_CAMERA__ISP__RGBIR_BASE                                                          (0x4AE00600)
#define IMX9_CAMERA__ISP__RGB_TO_YUV_BASE                                                     (0x4AE011C0)
#define IMX9_CAMERA__ISP__STAT_BASE                                                           (0x4AE00700)
#define IMX9_CAMERA__ISP__VIGNETTING_BASE                                                     (0x4AE00900)
#define IMX9_CAMERA__MUI_A1__MUA_BASE                                                         (0x4AC60000)
#define IMX9_CAMERA__MUI_A2__MUA_BASE                                                         (0x4AC70000)
#define IMX9_CAMERA__MUI_A3__MUA_BASE                                                         (0x4AC80000)
#define IMX9_CAMERA__MUI_A4__MUA_BASE                                                         (0x4AC90000)
#define IMX9_CAMERA__MUI_A5__MUA_BASE                                                         (0x4ACA0000)
#define IMX9_CAMERA__MUI_A6__MUA_BASE                                                         (0x4ACB0000)
#define IMX9_CAMERA__MUI_A7__MUA_BASE                                                         (0x4ACC0000)
#define IMX9_CAMERA__MUI_A8__MUA_BASE                                                         (0x4ACD0000)
#define IMX9_CAMERA__MUI_A9__MUA_BASE                                                         (0x4ACE0000)
#define IMX9_CAMERA__OCRAM_MECC_BASE                                                          (0x4ADD0000)
#define IMX9_CAMERA__TCU_BASE                                                                 (0x4AC00000)
#define IMX9_CAN1_BASE                                                                        (0x443A0000)
#define IMX9_CAN2_BASE                                                                        (0x425B0000)
#define IMX9_CAN3_BASE                                                                        (0x42600000)
#define IMX9_CAN4_BASE                                                                        (0x427C0000)
#define IMX9_CAN5_BASE                                                                        (0x427D0000)
#define IMX9_CCM_CTRL_BASE                                                                    (0x44450000)
#define IMX9_CCMSRCGPC__GPC__GPC_GLOBAL_BASE                                                  (0x44474800)
#define IMX9_CCMSRCGPC__SRC__SRC_CENTRAL_REG_BASE                                             (0x44460000)
#define IMX9_CCMSRCGPC__SRC__XSPR_ANAMIX_BASE                                                 (0x44460400)
#define IMX9_CCMSRCGPC__SRC__XSPR_AONMIX_BASE                                                 (0x44460800)
#define IMX9_CCMSRCGPC__SRC__XSPR_AONMIX_MEM_BASE                                             (0x44460900)
#define IMX9_CCMSRCGPC__SRC__XSPR_BBSMMIX_BASE                                                (0x44460C00)
#define IMX9_CCMSRCGPC__SRC__XSPR_CAMERAMIX_BASE                                              (0x44461000)
#define IMX9_CCMSRCGPC__SRC__XSPR_CAMERAMIX_MEM_BASE                                          (0x44461100)
#define IMX9_CCMSRCGPC__SRC__XSPR_CCMSRCGPCMIX_BASE                                           (0x44461400)
#define IMX9_CCMSRCGPC__SRC__XSPR_CORTEXMIX_CORE0_BASE                                        (0x44461800)
#define IMX9_CCMSRCGPC__SRC__XSPR_CORTEXMIX_CORE0_MEM_BASE                                    (0x44461900)
#define IMX9_CCMSRCGPC__SRC__XSPR_CORTEXMIX_CORE1_BASE                                        (0x44461C00)
#define IMX9_CCMSRCGPC__SRC__XSPR_CORTEXMIX_CORE1_MEM_BASE                                    (0x44461D00)
#define IMX9_CCMSRCGPC__SRC__XSPR_CORTEXMIX_CORE2_BASE                                        (0x44462000)
#define IMX9_CCMSRCGPC__SRC__XSPR_CORTEXMIX_CORE2_MEM_BASE                                    (0x44462100)
#define IMX9_CCMSRCGPC__SRC__XSPR_CORTEXMIX_CORE3_BASE                                        (0x44462400)
#define IMX9_CCMSRCGPC__SRC__XSPR_CORTEXMIX_CORE3_MEM_BASE                                    (0x44462500)
#define IMX9_CCMSRCGPC__SRC__XSPR_CORTEXMIX_CORE4_BASE                                        (0x44462800)
#define IMX9_CCMSRCGPC__SRC__XSPR_CORTEXMIX_CORE4_MEM_BASE                                    (0x44462900)
#define IMX9_CCMSRCGPC__SRC__XSPR_CORTEXMIX_CORE5_BASE                                        (0x44462C00)
#define IMX9_CCMSRCGPC__SRC__XSPR_CORTEXMIX_CORE5_MEM_BASE                                    (0x44462D00)
#define IMX9_CCMSRCGPC__SRC__XSPR_CORTEXMIX_PLATFORM_BASE                                     (0x44463000)
#define IMX9_CCMSRCGPC__SRC__XSPR_CORTEXMIX_PLATFORM_MEM0_BASE                                (0x44463100)
#define IMX9_CCMSRCGPC__SRC__XSPR_CORTEXMIX_PLATFORM_MEM1_BASE                                (0x44463120)
#define IMX9_CCMSRCGPC__SRC__XSPR_DDRMIX_BASE                                                 (0x44463400)
#define IMX9_CCMSRCGPC__SRC__XSPR_DDRMIX_MEM_BASE                                             (0x44463500)
#define IMX9_CCMSRCGPC__SRC__XSPR_DISPLAYMIX_BASE                                             (0x44463800)
#define IMX9_CCMSRCGPC__SRC__XSPR_DISPLAYMIX_MEM_BASE                                         (0x44463900)
#define IMX9_CCMSRCGPC__SRC__XSPR_GPUMIX_BASE                                                 (0x44463C00)
#define IMX9_CCMSRCGPC__SRC__XSPR_GPUMIX_MEM_BASE                                             (0x44463D00)
#define IMX9_CCMSRCGPC__SRC__XSPR_HSIOMIX_MEM_BASE                                            (0x44464100)
#define IMX9_CCMSRCGPC__SRC__XSPR_HSIOMIX_TOP_BASE                                            (0x44464000)
#define IMX9_CCMSRCGPC__SRC__XSPR_HSIOMIX_WAON_BASE                                           (0x44464400)
#define IMX9_CCMSRCGPC__SRC__XSPR_M7MIX_BASE                                                  (0x44464800)
#define IMX9_CCMSRCGPC__SRC__XSPR_M7MIX_MEM_BASE                                              (0x44464900)
#define IMX9_CCMSRCGPC__SRC__XSPR_NETCMIX_BASE                                                (0x44464C00)
#define IMX9_CCMSRCGPC__SRC__XSPR_NETCMIX_MEM_BASE                                            (0x44464D00)
#define IMX9_CCMSRCGPC__SRC__XSPR_NOCMIX_BASE                                                 (0x44465000)
#define IMX9_CCMSRCGPC__SRC__XSPR_NOCMIX_MEM0_BASE                                            (0x44465100)
#define IMX9_CCMSRCGPC__SRC__XSPR_NOCMIX_MEM1_BASE                                            (0x44465120)
#define IMX9_CCMSRCGPC__SRC__XSPR_NPUMIX_BASE                                                 (0x44465400)
#define IMX9_CCMSRCGPC__SRC__XSPR_NPUMIX_MEM_BASE                                             (0x44465500)
#define IMX9_CCMSRCGPC__SRC__XSPR_VPUMIX_BASE                                                 (0x44465800)
#define IMX9_CCMSRCGPC__SRC__XSPR_VPUMIX_MEM_BASE                                             (0x44465900)
#define IMX9_CCMSRCGPC__SRC__XSPR_WAKEUPMIX_BASE                                              (0x44465C00)
#define IMX9_CCMSRCGPC__SRC__XSPR_WAKEUPMIX_MEM_BASE                                          (0x44465D00)
#define IMX9_CCMSRCGPC__TCU_BASE                                                              (0x444D0000)
#define IMX9_CORTEXA__FRACT_PLL_ARMPLL_BASE                                                   (0x44481600)
#define IMX9_CORTEXA__TCU_BASE                                                                (0x4A400000)
#define IMX9_DDRC_BASE                                                                        (0x4E080000)
#define IMX9_DDRC__BLK_CTRL_DDRMIX_BASE                                                       (0x4E010000)
#define IMX9_DDRC__CMU_1_BASE                                                                 (0x4E060000)
#define IMX9_DDRC__CMU_2_BASE                                                                 (0x4E070000)
#define IMX9_DDRC__FRACT_PLL_BASE                                                             (0x44481700)
#define IMX9_DDRC__LSTCU_BASE                                                                 (0x4E050000)
#define IMX9_DDRC__TCU_BASE                                                                   (0x4E000000)
#define IMX9_DISPLAY__BLK_CTRL_DISPLAYMIX_BASE                                                (0x4B010000)
#define IMX9_DISPLAY__FRACT_PLL_BASE                                                          (0x44481900)
#define IMX9_DISPLAY__GPV__I_SEERIS_2D_BLITTER_FU_RD_0_I_MAIN_QOSGENERATOR_BASE               (0x4B7E0800)
#define IMX9_DISPLAY__GPV__I_SEERIS_2D_BLITTER_FU_RD_0_I_MAIN_TRANSACTIONSTATFILTER_BASE      (0x4B7E0A00)
#define IMX9_DISPLAY__GPV__I_SEERIS_2D_BLITTER_FU_RD_1_I_MAIN_QOSGENERATOR_BASE               (0x4B7E0880)
#define IMX9_DISPLAY__GPV__I_SEERIS_2D_BLITTER_FU_RD_1_I_MAIN_TRANSACTIONSTATFILTER_BASE      (0x4B7E0A80)
#define IMX9_DISPLAY__GPV__I_SEERIS_2D_BLITTER_FU_RD_2_I_MAIN_QOSGENERATOR_BASE               (0x4B7E0900)
#define IMX9_DISPLAY__GPV__I_SEERIS_2D_BLITTER_FU_RD_2_I_MAIN_TRANSACTIONSTATFILTER_BASE      (0x4B7E0B00)
#define IMX9_DISPLAY__GPV__I_SEERIS_2D_BLITTER_STORE_WR_I_MAIN_QOSGENERATOR_BASE              (0x4B7E0980)
#define IMX9_DISPLAY__GPV__I_SEERIS_2D_BLITTER_STORE_WR_I_MAIN_TRANSACTIONSTATFILTER_BASE     (0x4B7E0B80)
#define IMX9_DISPLAY__GPV__I_SEERIS_CMD_SEQ_RD_I_MAIN_TRANSACTIONSTATFILTER_BASE              (0x4B7E0C00)
#define IMX9_DISPLAY__GPV__I_SEERIS_CMD_SEQ_WR_I_MAIN_TRANSACTIONSTATFILTER_BASE              (0x4B7E0C80)
#define IMX9_DISPLAY__GPV__I_SEERIS_DISPLAY_CTRL_FU_RD_0_I_MAIN_TRANSACTIONSTATFILTER_BASE    (0x4B7E0D00)
#define IMX9_DISPLAY__GPV__I_SEERIS_DISPLAY_CTRL_FU_RD_1_I_MAIN_TRANSACTIONSTATFILTER_BASE    (0x4B7E0D80)
#define IMX9_DISPLAY__GPV__I_SEERIS_DISPLAY_CTRL_FU_RD_2_I_MAIN_TRANSACTIONSTATFILTER_BASE    (0x4B7E0E00)
#define IMX9_DISPLAY__GPV__I_SEERIS_DISPLAY_CTRL_FU_RD_3_I_MAIN_TRANSACTIONSTATFILTER_BASE    (0x4B7E0E80)
#define IMX9_DISPLAY__GPV__I_SEERIS_DISPLAY_CTRL_FU_RD_4_I_MAIN_TRANSACTIONSTATFILTER_BASE    (0x4B7E0F00)
#define IMX9_DISPLAY__GPV__I_SEERIS_DISPLAY_CTRL_FU_RD_5_I_MAIN_TRANSACTIONSTATFILTER_BASE    (0x4B7E0F80)
#define IMX9_DISPLAY__GPV__I_SEERIS_DISPLAY_CTRL_FU_RD_6_I_MAIN_TRANSACTIONSTATFILTER_BASE    (0x4B7E1000)
#define IMX9_DISPLAY__GPV__I_SEERIS_DISPLAY_CTRL_FU_RD_7_I_MAIN_TRANSACTIONSTATFILTER_BASE    (0x4B7E1080)
#define IMX9_DISPLAY__GPV__I_SEERIS_DISPLAY_CTRL_FU_RD_8_I_MAIN_TRANSACTIONSTATFILTER_BASE    (0x4B7E1100)
#define IMX9_DISPLAY__GPV__PROBE1_MAIN_PROBE_BASE                                             (0x4B7E0000)
#define IMX9_DISPLAY__GPV__PROBE1_MAIN_TRANSACTIONSTATPROFILER_BASE                           (0x4B7E1180)
#define IMX9_DISPLAY__GPV__PROBE_MAIN_PROBE_BASE                                              (0x4B7E0400)
#define IMX9_DISPLAY__OCRAM_MECC_BASE                                                         (0x4B0F0000)
#define IMX9_DISPLAY__PIXEL_INTERLEAVER1_BASE                                                 (0x4B0D0000)
#define IMX9_DISPLAY__PIXEL_MAPPER_BASE                                                       (0x4B000000)
#define IMX9_DISPLAY_SEERIS_BASE                                                              (0x4B400000)
#define IMX9_DISPLAY__SEERIS__BLITBLEND_BASE                                                  (0x4B470000)
#define IMX9_DISPLAY__SEERIS__CLUT_clut_1_BASE                                                (0x4B450400)
#define IMX9_DISPLAY__SEERIS__CLUT_clut_BASE                                                  (0x4B450000)
#define IMX9_DISPLAY__SEERIS__CMDSEQ_cmdseq_1_BASE                                            (0x4B410100)
#define IMX9_DISPLAY__SEERIS__CMDSEQ_cmdseq_2_BASE                                            (0x4B410180)
#define IMX9_DISPLAY__SEERIS__CMDSEQ_cmdseq_BASE                                              (0x4B410000)
#define IMX9_DISPLAY__SEERIS__CONSTFRAME_1_BASE                                               (0x4B500000)
#define IMX9_DISPLAY__SEERIS__CONSTFRAME_2_BASE                                               (0x4B530000)
#define IMX9_DISPLAY__SEERIS__CONSTFRAME_3_BASE                                               (0x4B540000)
#define IMX9_DISPLAY__SEERIS__CONSTFRAME_BASE                                                 (0x4B4F0000)
#define IMX9_DISPLAY__SEERIS__DITHER_1_BASE                                                   (0x4B770000)
#define IMX9_DISPLAY__SEERIS__DITHER_BASE                                                     (0x4B710000)
#define IMX9_DISPLAY__SEERIS__DOMAINBLEND_1_BASE                                              (0x4B720000)
#define IMX9_DISPLAY__SEERIS__DOMAINBLEND_BASE                                                (0x4B6A0000)
#define IMX9_DISPLAY__SEERIS__EXTDST_1_BASE                                                   (0x4B520000)
#define IMX9_DISPLAY__SEERIS__EXTDST_2_BASE                                                   (0x4B550000)
#define IMX9_DISPLAY__SEERIS__EXTDST_3_BASE                                                   (0x4B560000)
#define IMX9_DISPLAY__SEERIS__EXTDST_BASE                                                     (0x4B510000)
#define IMX9_DISPLAY__SEERIS__FETCHDECODE_1_BASE                                              (0x4B490028)
#define IMX9_DISPLAY__SEERIS__FETCHDECODE_2_BASE                                              (0x4B490060)
#define IMX9_DISPLAY__SEERIS__FETCHDECODE_3_BASE                                              (0x4B490088)
#define IMX9_DISPLAY__SEERIS__FETCHDECODE_4_BASE                                              (0x4B490098)
#define IMX9_DISPLAY__SEERIS__FETCHDECODE_5_BASE                                              (0x4B490400)
#define IMX9_DISPLAY__SEERIS__FETCHDECODE_BASE                                                (0x4B490000)
#define IMX9_DISPLAY__SEERIS__FETCHECO_10_BASE                                                (0x4B630000)
#define IMX9_DISPLAY__SEERIS__FETCHECO_11_BASE                                                (0x4B630010)
#define IMX9_DISPLAY__SEERIS__FETCHECO_12_BASE                                                (0x4B630048)
#define IMX9_DISPLAY__SEERIS__FETCHECO_13_BASE                                                (0x4B630060)
#define IMX9_DISPLAY__SEERIS__FETCHECO_14_BASE                                                (0x4B630068)
#define IMX9_DISPLAY__SEERIS__FETCHECO_15_BASE                                                (0x4B650000)
#define IMX9_DISPLAY__SEERIS__FETCHECO_16_BASE                                                (0x4B650010)
#define IMX9_DISPLAY__SEERIS__FETCHECO_17_BASE                                                (0x4B650048)
#define IMX9_DISPLAY__SEERIS__FETCHECO_18_BASE                                                (0x4B650060)
#define IMX9_DISPLAY__SEERIS__FETCHECO_19_BASE                                                (0x4B650068)
#define IMX9_DISPLAY__SEERIS__FETCHECO_1_BASE                                                 (0x4B4A0010)
#define IMX9_DISPLAY__SEERIS__FETCHECO_2_BASE                                                 (0x4B4A0048)
#define IMX9_DISPLAY__SEERIS__FETCHECO_3_BASE                                                 (0x4B4A0060)
#define IMX9_DISPLAY__SEERIS__FETCHECO_4_BASE                                                 (0x4B4A0068)
#define IMX9_DISPLAY__SEERIS__FETCHECO_5_BASE                                                 (0x4B610000)
#define IMX9_DISPLAY__SEERIS__FETCHECO_6_BASE                                                 (0x4B610010)
#define IMX9_DISPLAY__SEERIS__FETCHECO_7_BASE                                                 (0x4B610048)
#define IMX9_DISPLAY__SEERIS__FETCHECO_8_BASE                                                 (0x4B610060)
#define IMX9_DISPLAY__SEERIS__FETCHECO_9_BASE                                                 (0x4B610068)
#define IMX9_DISPLAY__SEERIS__FETCHECO_BASE                                                   (0x4B4A0000)
#define IMX9_DISPLAY__SEERIS__FETCHLAYER_10_BASE                                              (0x4B5D01F8)
#define IMX9_DISPLAY__SEERIS__FETCHLAYER_11_BASE                                              (0x4B5D0200)
#define IMX9_DISPLAY__SEERIS__FETCHLAYER_12_BASE                                              (0x4B5D0400)
#define IMX9_DISPLAY__SEERIS__FETCHLAYER_13_BASE                                              (0x4B5E0000)
#define IMX9_DISPLAY__SEERIS__FETCHLAYER_14_BASE                                              (0x4B5E0018)
#define IMX9_DISPLAY__SEERIS__FETCHLAYER_15_BASE                                              (0x4B5E0050)
#define IMX9_DISPLAY__SEERIS__FETCHLAYER_16_BASE                                              (0x4B5E0088)
#define IMX9_DISPLAY__SEERIS__FETCHLAYER_17_BASE                                              (0x4B5E00C0)
#define IMX9_DISPLAY__SEERIS__FETCHLAYER_18_BASE                                              (0x4B5E00F8)
#define IMX9_DISPLAY__SEERIS__FETCHLAYER_19_BASE                                              (0x4B5E0130)
#define IMX9_DISPLAY__SEERIS__FETCHLAYER_1_BASE                                               (0x4B5D0018)
#define IMX9_DISPLAY__SEERIS__FETCHLAYER_20_BASE                                              (0x4B5E0168)
#define IMX9_DISPLAY__SEERIS__FETCHLAYER_21_BASE                                              (0x4B5E01A0)
#define IMX9_DISPLAY__SEERIS__FETCHLAYER_22_BASE                                              (0x4B5E01D8)
#define IMX9_DISPLAY__SEERIS__FETCHLAYER_23_BASE                                              (0x4B5E01F8)
#define IMX9_DISPLAY__SEERIS__FETCHLAYER_24_BASE                                              (0x4B5E0200)
#define IMX9_DISPLAY__SEERIS__FETCHLAYER_25_BASE                                              (0x4B5E0400)
#define IMX9_DISPLAY__SEERIS__FETCHLAYER_2_BASE                                               (0x4B5D0050)
#define IMX9_DISPLAY__SEERIS__FETCHLAYER_3_BASE                                               (0x4B5D0088)
#define IMX9_DISPLAY__SEERIS__FETCHLAYER_4_BASE                                               (0x4B5D00C0)
#define IMX9_DISPLAY__SEERIS__FETCHLAYER_5_BASE                                               (0x4B5D00F8)
#define IMX9_DISPLAY__SEERIS__FETCHLAYER_6_BASE                                               (0x4B5D0130)
#define IMX9_DISPLAY__SEERIS__FETCHLAYER_7_BASE                                               (0x4B5D0168)
#define IMX9_DISPLAY__SEERIS__FETCHLAYER_8_BASE                                               (0x4B5D01A0)
#define IMX9_DISPLAY__SEERIS__FETCHLAYER_9_BASE                                               (0x4B5D01D8)
#define IMX9_DISPLAY__SEERIS__FETCHLAYER_BASE                                                 (0x4B5D0000)
#define IMX9_DISPLAY__SEERIS__FETCHROT_fetchrot_10_BASE                                       (0x4B484000)
#define IMX9_DISPLAY__SEERIS__FETCHROT_fetchrot_1_BASE                                        (0x4B480020)
#define IMX9_DISPLAY__SEERIS__FETCHROT_fetchrot_2_BASE                                        (0x4B480058)
#define IMX9_DISPLAY__SEERIS__FETCHROT_fetchrot_3_BASE                                        (0x4B4800A0)
#define IMX9_DISPLAY__SEERIS__FETCHROT_fetchrot_4_BASE                                        (0x4B4800B0)
#define IMX9_DISPLAY__SEERIS__FETCHROT_fetchrot_5_BASE                                        (0x4B480100)
#define IMX9_DISPLAY__SEERIS__FETCHROT_fetchrot_6_BASE                                        (0x4B480200)
#define IMX9_DISPLAY__SEERIS__FETCHROT_fetchrot_7_BASE                                        (0x4B480400)
#define IMX9_DISPLAY__SEERIS__FETCHROT_fetchrot_8_BASE                                        (0x4B480600)
#define IMX9_DISPLAY__SEERIS__FETCHROT_fetchrot_9_BASE                                        (0x4B482000)
#define IMX9_DISPLAY__SEERIS__FETCHROT_fetchrot_BASE                                          (0x4B480000)
#define IMX9_DISPLAY__SEERIS__FETCHYUV_10_BASE                                                (0x4B620000)
#define IMX9_DISPLAY__SEERIS__FETCHYUV_11_BASE                                                (0x4B620028)
#define IMX9_DISPLAY__SEERIS__FETCHYUV_12_BASE                                                (0x4B620060)
#define IMX9_DISPLAY__SEERIS__FETCHYUV_13_BASE                                                (0x4B620078)
#define IMX9_DISPLAY__SEERIS__FETCHYUV_14_BASE                                                (0x4B620088)
#define IMX9_DISPLAY__SEERIS__FETCHYUV_15_BASE                                                (0x4B640000)
#define IMX9_DISPLAY__SEERIS__FETCHYUV_16_BASE                                                (0x4B640028)
#define IMX9_DISPLAY__SEERIS__FETCHYUV_17_BASE                                                (0x4B640060)
#define IMX9_DISPLAY__SEERIS__FETCHYUV_18_BASE                                                (0x4B640078)
#define IMX9_DISPLAY__SEERIS__FETCHYUV_19_BASE                                                (0x4B640088)
#define IMX9_DISPLAY__SEERIS__FETCHYUV_1_BASE                                                 (0x4B5F0028)
#define IMX9_DISPLAY__SEERIS__FETCHYUV_2_BASE                                                 (0x4B5F0060)
#define IMX9_DISPLAY__SEERIS__FETCHYUV_3_BASE                                                 (0x4B5F0078)
#define IMX9_DISPLAY__SEERIS__FETCHYUV_4_BASE                                                 (0x4B5F0088)
#define IMX9_DISPLAY__SEERIS__FETCHYUV_5_BASE                                                 (0x4B600000)
#define IMX9_DISPLAY__SEERIS__FETCHYUV_6_BASE                                                 (0x4B600028)
#define IMX9_DISPLAY__SEERIS__FETCHYUV_7_BASE                                                 (0x4B600060)
#define IMX9_DISPLAY__SEERIS__FETCHYUV_8_BASE                                                 (0x4B600078)
#define IMX9_DISPLAY__SEERIS__FETCHYUV_9_BASE                                                 (0x4B600088)
#define IMX9_DISPLAY__SEERIS__FETCHYUV_BASE                                                   (0x4B5F0000)
#define IMX9_DISPLAY__SEERIS__FILTER_BASE                                                     (0x4B4D0000)
#define IMX9_DISPLAY__SEERIS__FRAMEGEN_1_BASE                                                 (0x4B730000)
#define IMX9_DISPLAY__SEERIS__FRAMEGEN_BASE                                                   (0x4B6B0000)
#define IMX9_DISPLAY__SEERIS__HSCALER_1_BASE                                                  (0x4B670000)
#define IMX9_DISPLAY__SEERIS__HSCALER_BASE                                                    (0x4B4B0000)
#define IMX9_DISPLAY__SEERIS__IDHASH_1_BASE                                                   (0x4B6C1000)
#define IMX9_DISPLAY__SEERIS__IDHASH_BASE                                                     (0x4B6C0000)
#define IMX9_DISPLAY__SEERIS__LAYERBLEND_1_BASE                                               (0x4B580000)
#define IMX9_DISPLAY__SEERIS__LAYERBLEND_2_BASE                                               (0x4B590000)
#define IMX9_DISPLAY__SEERIS__LAYERBLEND_3_BASE                                               (0x4B5A0000)
#define IMX9_DISPLAY__SEERIS__LAYERBLEND_4_BASE                                               (0x4B5B0000)
#define IMX9_DISPLAY__SEERIS__LAYERBLEND_5_BASE                                               (0x4B5C0000)
#define IMX9_DISPLAY__SEERIS__LAYERBLEND_BASE                                                 (0x4B570000)
#define IMX9_DISPLAY__SEERIS__LUT3D_1_BASE                                                    (0x4B702000)
#define IMX9_DISPLAY__SEERIS__LUT3D_2_BASE                                                    (0x4B750000)
#define IMX9_DISPLAY__SEERIS__LUT3D_3_BASE                                                    (0x4B752000)
#define IMX9_DISPLAY__SEERIS__LUT3D_BASE                                                      (0x4B700000)
#define IMX9_DISPLAY__SEERIS__MATRIX_1_BASE                                                   (0x4B660000)
#define IMX9_DISPLAY__SEERIS__MATRIX_BASE                                                     (0x4B460000)
#define IMX9_DISPLAY__SEERIS__MATRIXL_1_BASE                                                  (0x4B6F0030)
#define IMX9_DISPLAY__SEERIS__MATRIXL_2_BASE                                                  (0x4B760000)
#define IMX9_DISPLAY__SEERIS__MATRIXL_3_BASE                                                  (0x4B760030)
#define IMX9_DISPLAY__SEERIS__MATRIXL_BASE                                                    (0x4B6F0000)
#define IMX9_DISPLAY__SEERIS__ROP_BASE                                                        (0x4B440000)
#define IMX9_DISPLAY__SEERIS__SEERIS_MDR5_BLITBLEND9CFG_BASE                                  (0x4B471000)
#define IMX9_DISPLAY__SEERIS__SEERIS_MDR5_CLUT9CFG_BASE                                       (0x4B451000)
#define IMX9_DISPLAY__SEERIS__SEERIS_MDR5_CMDSEQMASK_BASE                                     (0x4B403000)
#define IMX9_DISPLAY__SEERIS__SEERIS_MDR5_CONSTFRAME0CFG_BASE                                 (0x4B4F1000)
#define IMX9_DISPLAY__SEERIS__SEERIS_MDR5_CONSTFRAME1CFG_BASE                                 (0x4B531000)
#define IMX9_DISPLAY__SEERIS__SEERIS_MDR5_CONSTFRAME4CFG_BASE                                 (0x4B501000)
#define IMX9_DISPLAY__SEERIS__SEERIS_MDR5_CONSTFRAME5CFG_BASE                                 (0x4B541000)
#define IMX9_DISPLAY__SEERIS__SEERIS_MDR5_DITHER0CFG_BASE                                     (0x4B711000)
#define IMX9_DISPLAY__SEERIS__SEERIS_MDR5_DITHER1CFG_BASE                                     (0x4B771020)
#define IMX9_DISPLAY__SEERIS__SEERIS_MDR5_DOMAINMASK_BASE                                     (0x4B402000)
#define IMX9_DISPLAY__SEERIS__SEERIS_MDR5_EXTDST0CFG_BASE                                     (0x4B511000)
#define IMX9_DISPLAY__SEERIS__SEERIS_MDR5_EXTDST1CFG_BASE                                     (0x4B551000)
#define IMX9_DISPLAY__SEERIS__SEERIS_MDR5_EXTDST4CFG_BASE                                     (0x4B521000)
#define IMX9_DISPLAY__SEERIS__SEERIS_MDR5_EXTDST5CFG_BASE                                     (0x4B561000)
#define IMX9_DISPLAY__SEERIS__SEERIS_MDR5_FETCHDECODE9CFG_BASE                                (0x4B491000)
#define IMX9_DISPLAY__SEERIS__SEERIS_MDR5_FETCHECO0CFG_BASE                                   (0x4B611000)
#define IMX9_DISPLAY__SEERIS__SEERIS_MDR5_FETCHECO1CFG_BASE                                   (0x4B631000)
#define IMX9_DISPLAY__SEERIS__SEERIS_MDR5_FETCHECO2CFG_BASE                                   (0x4B651000)
#define IMX9_DISPLAY__SEERIS__SEERIS_MDR5_FETCHECO9CFG_BASE                                   (0x4B4A1000)
#define IMX9_DISPLAY__SEERIS__SEERIS_MDR5_FETCHLAYER0CFG_BASE                                 (0x4B5D1000)
#define IMX9_DISPLAY__SEERIS__SEERIS_MDR5_FETCHLAYER1CFG_BASE                                 (0x4B5E1000)
#define IMX9_DISPLAY__SEERIS__SEERIS_MDR5_FETCHROT9CFG_BASE                                   (0x4B486000)
#define IMX9_DISPLAY__SEERIS__SEERIS_MDR5_FETCHYUV0CFG_BASE                                   (0x4B601000)
#define IMX9_DISPLAY__SEERIS__SEERIS_MDR5_FETCHYUV1CFG_BASE                                   (0x4B621000)
#define IMX9_DISPLAY__SEERIS__SEERIS_MDR5_FETCHYUV2CFG_BASE                                   (0x4B641000)
#define IMX9_DISPLAY__SEERIS__SEERIS_MDR5_FETCHYUV3CFG_BASE                                   (0x4B5F1000)
#define IMX9_DISPLAY__SEERIS__SEERIS_MDR5_FILTER9CFG_BASE                                     (0x4B4D1000)
#define IMX9_DISPLAY__SEERIS__SEERIS_MDR5_GENERALPURPOSE_BASE                                 (0x4B412000)
#define IMX9_DISPLAY__SEERIS__SEERIS_MDR5_HSCALER4CFG_BASE                                    (0x4B671000)
#define IMX9_DISPLAY__SEERIS__SEERIS_MDR5_HSCALER9CFG_BASE                                    (0x4B4B1000)
#define IMX9_DISPLAY__SEERIS__SEERIS_MDR5_IDHASH0CFG_BASE                                     (0x4B6C3000)
#define IMX9_DISPLAY__SEERIS__SEERIS_MDR5_IRQ_1_BASE                                          (0x4B411000)
#define IMX9_DISPLAY__SEERIS__SEERIS_MDR5_IRQ_2_BASE                                          (0x4B431000)
#define IMX9_DISPLAY__SEERIS__SEERIS_MDR5_IRQ_3_BASE                                          (0x4B781000)
#define IMX9_DISPLAY__SEERIS__SEERIS_MDR5_IRQ_4_BASE                                          (0x4B791000)
#define IMX9_DISPLAY__SEERIS__SEERIS_MDR5_IRQ_5_BASE                                          (0x4B7A1000)
#define IMX9_DISPLAY__SEERIS__SEERIS_MDR5_IRQ_6_BASE                                          (0x4B7B1000)
#define IMX9_DISPLAY__SEERIS__SEERIS_MDR5_IRQ_BASE                                            (0x4B401000)
#define IMX9_DISPLAY__SEERIS__SEERIS_MDR5_LAYERBLEND1CFG_BASE                                 (0x4B571000)
#define IMX9_DISPLAY__SEERIS__SEERIS_MDR5_LAYERBLEND2CFG_BASE                                 (0x4B581000)
#define IMX9_DISPLAY__SEERIS__SEERIS_MDR5_LAYERBLEND3CFG_BASE                                 (0x4B591000)
#define IMX9_DISPLAY__SEERIS__SEERIS_MDR5_LAYERBLEND4CFG_BASE                                 (0x4B5A1000)
#define IMX9_DISPLAY__SEERIS__SEERIS_MDR5_LAYERBLEND5CFG_BASE                                 (0x4B5B1000)
#define IMX9_DISPLAY__SEERIS__SEERIS_MDR5_LAYERBLEND6CFG_BASE                                 (0x4B5C1000)
#define IMX9_DISPLAY__SEERIS__SEERIS_MDR5_MATRIX4CFG_BASE                                     (0x4B661000)
#define IMX9_DISPLAY__SEERIS__SEERIS_MDR5_MATRIX9CFG_BASE                                     (0x4B461000)
#define IMX9_DISPLAY__SEERIS__SEERIS_MDR5_ROP9CFG_BASE                                        (0x4B441000)
#define IMX9_DISPLAY__SEERIS__SEERIS_MDR5_SIG0CFG_BASE                                        (0x4B6D1000)
#define IMX9_DISPLAY__SEERIS__SEERIS_MDR5_SIG1CFG_BASE                                        (0x4B741020)
#define IMX9_DISPLAY__SEERIS__SEERIS_MDR5_SIG2CFG_BASE                                        (0x4B6E1000)
#define IMX9_DISPLAY__SEERIS__SEERIS_MDR5_STORE9CFG_BASE                                      (0x4B4E1000)
#define IMX9_DISPLAY__SEERIS__SEERIS_MDR5_VSCALER4CFG_BASE                                    (0x4B681000)
#define IMX9_DISPLAY__SEERIS__SEERIS_MDR5_VSCALER9CFG_BASE                                    (0x4B4C1000)
#define IMX9_DISPLAY__SEERIS__SEERIS_MDR5_XPC_BASE                                            (0x4B420000)
#define IMX9_DISPLAY__SEERIS__SIG_1_BASE                                                      (0x4B6D0400)
#define IMX9_DISPLAY__SEERIS__SIG_2_BASE                                                      (0x4B6E0000)
#define IMX9_DISPLAY__SEERIS__SIG_3_BASE                                                      (0x4B6E0400)
#define IMX9_DISPLAY__SEERIS__SIG_4_BASE                                                      (0x4B740000)
#define IMX9_DISPLAY__SEERIS__SIG_5_BASE                                                      (0x4B740400)
#define IMX9_DISPLAY__SEERIS__SIG_BASE                                                        (0x4B6D0000)
#define IMX9_DISPLAY__SEERIS__STORE_PLANAR_1_BASE                                             (0x4B4E0038)
#define IMX9_DISPLAY__SEERIS__STORE_PLANAR_2_BASE                                             (0x4B4E0048)
#define IMX9_DISPLAY__SEERIS__STORE_PLANAR_3_BASE                                             (0x4B4E0070)
#define IMX9_DISPLAY__SEERIS__STORE_PLANAR_BASE                                               (0x4B4E0000)
#define IMX9_DISPLAY__SEERIS__VSCALER_1_BASE                                                  (0x4B680000)
#define IMX9_DISPLAY__SEERIS__VSCALER_BASE                                                    (0x4B4C0000)
#define IMX9_DISPLAY__TCU_BASE                                                                (0x4B000000)
#define IMX9_DMA3_BASE                                                                        (0x44000000)
#define IMX9_DPU_IRQSTEER_BASE                                                                (0x4B0B0000)
#define IMX9_EDMA5_2_BASE                                                                     (0x42000000)
#define IMX9_EDMA5_3_BASE                                                                     (0x42210000)
#define IMX9_EDMA5_4_BASE                                                                     (0x4AE10000)
#define IMX9_EMDIO0_PCI_HDR_TYPE0_BASE                                                        (0x4CB00000)
#define IMX9_EMDIO_BASE_BASE                                                                  (0x4CCE0000)
#define IMX9_EMDIO_GLOBAL_BASE                                                                (0x4CCF0000)
#define IMX9_ENETC0_BASE_BASE                                                                 (0x4CC10000)
#define IMX9_ENETC0_COMMON_BASE                                                               (0x4CC11000)
#define IMX9_ENETC0_ETH_MAC_PORT_BASE                                                         (0x4CC15000)
#define IMX9_ENETC0_GLOBAL_BASE                                                               (0x4CC20000)
#define IMX9_ENETC0_PCI_HDR_TYPE0_BASE                                                        (0x4CA00000)
#define IMX9_ENETC0_PORT_BASE                                                                 (0x4CC14000)
#define IMX9_ENETC0_PSI_BASE                                                                  (0x4CC00000)
#define IMX9_ENETC1_BASE_BASE                                                                 (0x4CC50000)
#define IMX9_ENETC1_COMMON_BASE                                                               (0x4CC51000)
#define IMX9_ENETC1_ETH_MAC_PORT_BASE                                                         (0x4CC55000)
#define IMX9_ENETC1_GLOBAL_BASE                                                               (0x4CC60000)
#define IMX9_ENETC1_PCI_HDR_TYPE0_BASE                                                        (0x4CA40000)
#define IMX9_ENETC1_PORT_BASE                                                                 (0x4CC54000)
#define IMX9_ENETC1_PSI_BASE                                                                  (0x4CC40000)
#define IMX9_ENETC2_BASE_BASE                                                                 (0x4CC90000)
#define IMX9_ENETC2_COMMON_BASE                                                               (0x4CC91000)
#define IMX9_ENETC2_ETH_MAC_PORT_BASE                                                         (0x4CC95000)
#define IMX9_ENETC2_GLOBAL_BASE                                                               (0x4CCA0000)
#define IMX9_ENETC2_PCI_HDR_TYPE0_BASE                                                        (0x4CA80000)
#define IMX9_ENETC2_PORT_BASE                                                                 (0x4CC94000)
#define IMX9_ENETC2_PSI_BASE                                                                  (0x4CC80000)
#define IMX9_ENETC_VSI0_BASE                                                                  (0x4CD20000)
#define IMX9_ENETC_VSI1_BASE                                                                  (0x4CD30000)
#define IMX9_ENETC_VSI2_BASE                                                                  (0x4CD40000)
#define IMX9_ENETC_VSI3_BASE                                                                  (0x4CD50000)
#define IMX9_ENETC_VSI4_BASE                                                                  (0x4CD60000)
#define IMX9_ENETC_VSI5_BASE                                                                  (0x4CD70000)
#define IMX9_ENET_PHY_MAC_ADAPTER_BASE                                                        (0x3E0000)
#define IMX9_ENET_PHY_PMA_MMD_BASE                                                            (0x20000)
#define IMX9_ENET_PHY_VS_MII_MMD_BASE                                                         (0x3E0000)
#define IMX9_ENET_PHY_VS_MMD1_BASE                                                            (0x3C0000)
#define IMX9_ENET_PHY_XS_PCS_MMD_BASE                                                         (0x60000)
#define IMX9_FLEXIO1_BASE                                                                     (0x425C0000)
#define IMX9_FLEXIO2_BASE                                                                     (0x425D0000)
#define IMX9_FLEXSPI_BASE                                                                     (0x425E0000)
#define IMX9_GPC_CTRL_CA55_0_BASE                                                             (0x44471000)
#define IMX9_GPC_CTRL_CA55_1_BASE                                                             (0x44471800)
#define IMX9_GPC_CTRL_CA55_2_BASE                                                             (0x44472000)
#define IMX9_GPC_CTRL_CA55_3_BASE                                                             (0x44472800)
#define IMX9_GPC_CTRL_CA55_4_BASE                                                             (0x44473000)
#define IMX9_GPC_CTRL_CA55_5_BASE                                                             (0x44473800)
#define IMX9_GPC_CTRL_CA55_CLUSTER_BASE                                                       (0x44474000)
#define IMX9_GPC_CTRL_CM33_BASE                                                               (0x44470000)
#define IMX9_GPC_CTRL_CM7_BASE                                                                (0x44470800)
#define IMX9_GPIO1_BASE                                                                       (0x47400000)
#define IMX9_GPIO2_BASE                                                                       (0x43810000)
#define IMX9_GPIO3_BASE                                                                       (0x43820000)
#define IMX9_GPIO4_BASE                                                                       (0x43840000)
#define IMX9_GPIO5_BASE                                                                       (0x43850000)
#define IMX9_GPU__BLK_CTRL_GPUMIX_BASE                                                        (0x4D810000)
#define IMX9_GPU__REG__GPU_MALI_DOORBELLS_BASE                                                (0x4D980000)
#define IMX9_GPU__REG__GPU_MALI_GPU_REGISTERS_BASE                                            (0x4D900000)
#define IMX9_GPU__REG__GPU_MALI_IPA_CONTROL_BASE                                              (0x4D940000)
#define IMX9_GPU__REG__GPU_MALI_USER_BASE                                                     (0x4D910000)
#define IMX9_GPU__TCU_BASE                                                                    (0x4D800000)
#define IMX9_HSIO__BLK_CTRL_HSIOMIX_BASE                                                      (0x4C010000)
#define IMX9_HSIO__GHZ_LN_PLL_BASE                                                            (0x44481800)
#define IMX9_HSIO__GPV__SSI_AXI_SLAVE_RD_OBSERVER_SSI_MASTER_ERROR_MAIN_ERRORLOGGER_0_BASE    (0x980C0000)
#define IMX9_HSIO__GPV__SSI_AXI_SLAVE_RD_PCIE1_AXI_SLAVE_RD_I_MAIN_TRANSACTIONSTATFILTER_BASE (0x980C0480)
#define IMX9_HSIO__GPV__SSI_AXI_SLAVE_RD_PCIE1_AXI_SLAVE_WR_I_MAIN_TRANSACTIONSTATFILTER_BASE (0x980C0400)
#define IMX9_HSIO__GPV__SSI_AXI_SLAVE_RD_PCIE2_AXI_SLAVE_RD_I_MAIN_TRANSACTIONSTATFILTER_BASE (0x980C0380)
#define IMX9_HSIO__GPV__SSI_AXI_SLAVE_RD_PCIE2_AXI_SLAVE_WR_I_MAIN_TRANSACTIONSTATFILTER_BASE (0x980C0300)
#define IMX9_HSIO__GPV__SSI_AXI_SLAVE_RD_PROBE_TRANSACTION_MAIN_PROBE_BASE                    (0x980C0800)
#define IMX9_HSIO__GPV__SSI_AXI_SLAVE_RD_PROBE_TRANSACTION_MAIN_TRANSACTIONSTATPROFILER_BASE  (0x980C0280)
#define IMX9_HSIO__GPV__SSI_AXI_SLAVE_RD_USB1_AXI_SLAVE_RD_I_MAIN_TRANSACTIONSTATFILTER_BASE  (0x980C0200)
#define IMX9_HSIO__GPV__SSI_AXI_SLAVE_RD_USB1_AXI_SLAVE_WR_I_MAIN_TRANSACTIONSTATFILTER_BASE  (0x980C0180)
#define IMX9_HSIO__GPV__SSI_AXI_SLAVE_RD_USB2_AXI_SLAVE_RD_I_MAIN_TRANSACTIONSTATFILTER_BASE  (0x980C0100)
#define IMX9_HSIO__GPV__SSI_AXI_SLAVE_RD_USB2_AXI_SLAVE_WR_I_MAIN_TRANSACTIONSTATFILTER_BASE  (0x980C0080)
#define IMX9_HSIO__PCIE1__PCIE_DMA_IATU_BASE                                                  (0x4C360000)
#define IMX9_HSIO__PCIE1__PCIE_EP_BASE                                                        (0x4C300000)
#define IMX9_HSIO__PCIE1__PCIE_RC_BASE                                                        (0x4C300000)
#define IMX9_HSIO__PCIE1__PCIE_SHADOW_EP_BASE                                                 (0x4C320000)
#define IMX9_HSIO__PCIE1__SERDES_SS_BASE                                                      (0x4C340000)
#define IMX9_HSIO__PCIE2__PCIE_DMA_IATU_BASE                                                  (0x4C3E0000)
#define IMX9_HSIO__PCIE2__PCIE_EP_BASE                                                        (0x4C380000)
#define IMX9_HSIO__PCIE2__PCIE_RC_BASE                                                        (0x4C380000)
#define IMX9_HSIO__PCIE2__PCIE_SHADOW_EP_BASE                                                 (0x4C3A0000)
#define IMX9_HSIO__PCIE2__SERDES_SS_BASE                                                      (0x4C3C0000)
#define IMX9_HSIO__TCU_BASE                                                                   (0x4C000000)
#define IMX9_HSIO__USB_3_01__GLUE_BASE                                                        (0x4C1F0000)
#define IMX9_HSIO__USB_3_01__USB3_BASE                                                        (0x4C100000)
#define IMX9_HSIO__USB_3_0_PHY__TCA_BASE                                                      (0x4C1FC000)
#define IMX9_I3C1_BASE                                                                        (0x44330000)
#define IMX9_I3C2_BASE                                                                        (0x42520000)
#define IMX9_IOMUXC_BASE                                                                      (0x443C0000)
#define IMX9_IRQSTEER_BASE                                                                    (0x44680000)
#define IMX9_LPI2C1_BASE                                                                      (0x44340000)
#define IMX9_LPI2C2_BASE                                                                      (0x44350000)
#define IMX9_LPI2C3_BASE                                                                      (0x42530000)
#define IMX9_LPI2C4_BASE                                                                      (0x42540000)
#define IMX9_LPI2C5_BASE                                                                      (0x426B0000)
#define IMX9_LPI2C6_BASE                                                                      (0x426C0000)
#define IMX9_LPI2C7_BASE                                                                      (0x426D0000)
#define IMX9_LPI2C8_BASE                                                                      (0x426E0000)
#define IMX9_LPIT1_BASE                                                                       (0x442F0000)
#define IMX9_LPIT2_BASE                                                                       (0x424C0000)
#define IMX9_LPSPI1_BASE                                                                      (0x44360000)
#define IMX9_LPSPI2_BASE                                                                      (0x44370000)
#define IMX9_LPSPI3_BASE                                                                      (0x42550000)
#define IMX9_LPSPI4_BASE                                                                      (0x42560000)
#define IMX9_LPSPI5_BASE                                                                      (0x426F0000)
#define IMX9_LPSPI6_BASE                                                                      (0x42700000)
#define IMX9_LPSPI7_BASE                                                                      (0x42710000)
#define IMX9_LPSPI8_BASE                                                                      (0x42720000)
#define IMX9_LPTMR1_BASE                                                                      (0x44300000)
#define IMX9_LPTMR2_BASE                                                                      (0x424D0000)
#define IMX9_LPUART1_BASE                                                                     (0x44380000)
#define IMX9_LPUART2_BASE                                                                     (0x44390000)
#define IMX9_LPUART3_BASE                                                                     (0x42570000)
#define IMX9_LPUART4_BASE                                                                     (0x42580000)
#define IMX9_LPUART5_BASE                                                                     (0x42590000)
#define IMX9_LPUART6_BASE                                                                     (0x425A0000)
#define IMX9_LPUART7_BASE                                                                     (0x42690000)
#define IMX9_LPUART8_BASE                                                                     (0x426A0000)
#define IMX9_LVDS_BASE                                                                        (0x4B0C0000)
#define IMX9_M33_CACHE_CTRLPC_BASE                                                            (0x44400000)
#define IMX9_M33_CACHE_CTRLPS_BASE                                                            (0x44400800)
#define IMX9_M7__A7_APB_MCM1_BASE                                                             (0x4A0A0000)
#define IMX9_M7__CMU_M0_BASE                                                                  (0x4A080000)
#define IMX9_M7__CMU_M1_BASE                                                                  (0x4A090000)
#define IMX9_M7__EIM_BASE                                                                     (0x4A060000)
#define IMX9_M7__ERM_BASE                                                                     (0x4A070000)
#define IMX9_M7__LSTCU_M7MIX_BASE                                                             (0x4A050000)
#define IMX9_M7__TCU_BASE                                                                     (0x4A000000)
#define IMX9_MIPI_CSI2_BASE                                                                   (0x4AD30000)
#define IMX9_MIPI_DSI_BASE                                                                    (0x4ACF0000)
#define IMX9_MSGINTR1_BASE                                                                    (0x44690000)
#define IMX9_MSGINTR2_BASE                                                                    (0x446A0000)
#define IMX9_MU5_MUA_BASE                                                                     (0x44610000)
#define IMX9_MU7_MUB_BASE                                                                     (0x42440000)
#define IMX9_MU8_MUB_BASE                                                                     (0x42740000)
#define IMX9_NETC__IEPRC_1__IEPRC_B0_EC_F0_PCI_HDR_TYPE0_BASE                                 (0x4CA08000)
#define IMX9_NETC__IEPRC_1__IEPRC_B1_EC_F0_PCI_HDR_TYPE0_BASE                                 (0x4CB08000)
#define IMX9_NETC__IEPRC_1__IEPRC_IERB_BASE                                                   (0x4C8A0000)
#define IMX9_NETC__IEPRC_1__IEPRC_PRB_BASE                                                    (0x4C8B0000)
#define IMX9_NETC_IERB_BASE                                                                   (0x4CDE0000)
#define IMX9_NETC_PRIV_BASE                                                                   (0x4CDF0000)
#define IMX9_NETC__TCU_BASE                                                                   (0x4C800000)
#define IMX9_NETC_VF1_PCI_HDR_TYPE0_BASE                                                      (0x4CA10000)
#define IMX9_NETC_VF2_PCI_HDR_TYPE0_BASE                                                      (0x4CA20000)
#define IMX9_NETC_VF3_PCI_HDR_TYPE0_BASE                                                      (0x4CA50000)
#define IMX9_NETC_VF4_PCI_HDR_TYPE0_BASE                                                      (0x4CA60000)
#define IMX9_NETC_VF5_PCI_HDR_TYPE0_BASE                                                      (0x4CA90000)
#define IMX9_NETC_VF6_PCI_HDR_TYPE0_BASE                                                      (0x4CAA0000)
#define IMX9_NOC__BLK_CTRL_NOCMIX_BASE                                                        (0x49000000)
#define IMX9_NOC__CMU_N0_BASE                                                                 (0x49070000)
#define IMX9_NOC__CMU_N1_BASE                                                                 (0x49080000)
#define IMX9_NOC__EIMN_BASE                                                                   (0x49270000)
#define IMX9_NOC__GIC__GICA_BASE                                                              (0x48010000)
#define IMX9_NOC__GIC__GICDA_BASE                                                             (0x48120000)
#define IMX9_NOC__GIC__GICD_BASE                                                              (0x48000000)
#define IMX9_NOC__GIC__GICP_BASE                                                              (0x48030000)
#define IMX9_NOC__GIC__GICRLPI0_BASE                                                          (0x48060000)
#define IMX9_NOC__GIC__GICRLPI1_BASE                                                          (0x48080000)
#define IMX9_NOC__GIC__GICRLPI2_BASE                                                          (0x480A0000)
#define IMX9_NOC__GIC__GICRLPI3_BASE                                                          (0x480C0000)
#define IMX9_NOC__GIC__GICRLPI4_BASE                                                          (0x480E0000)
#define IMX9_NOC__GIC__GICRLPI5_BASE                                                          (0x48100000)
#define IMX9_NOC__GIC__GICRSGI0_BASE                                                          (0x48070000)
#define IMX9_NOC__GIC__GICRSGI1_BASE                                                          (0x48090000)
#define IMX9_NOC__GIC__GICRSGI2_BASE                                                          (0x480B0000)
#define IMX9_NOC__GIC__GICRSGI3_BASE                                                          (0x480D0000)
#define IMX9_NOC__GIC__GICRSGI4_BASE                                                          (0x480F0000)
#define IMX9_NOC__GIC__GICRSGI5_BASE                                                          (0x48110000)
#define IMX9_NOC__GIC__GICT_BASE                                                              (0x48020000)
#define IMX9_NOC__GIC__GITS0_BASE                                                             (0x48040000)
#define IMX9_NOC__GIC__GITS0TRANSLATER_BASE                                                   (0x48050000)
#define IMX9_NOC__GPV__ALWAYS_ON_MAIN_RESILIENCEFAULTCONTROLLER_BASE                          (0x49063080)
#define IMX9_NOC__GPV__M_E_0_RD_I_MAIN_QOSGENERATOR_BASE                                      (0x49062400)
#define IMX9_NOC__GPV__M_E_0_RD_I_MAIN_TRANSACTIONSTATFILTER_BASE                             (0x49063100)
#define IMX9_NOC__GPV__M_E_0_WR_I_MAIN_QOSGENERATOR_BASE                                      (0x49062480)
#define IMX9_NOC__GPV__M_E_0_WR_I_MAIN_TRANSACTIONSTATFILTER_BASE                             (0x49063180)
#define IMX9_NOC__GPV__M_E_10_RD_I_MAIN_QOSGENERATOR_BASE                                     (0x49062E80)
#define IMX9_NOC__GPV__M_E_10_RD_I_MAIN_TRANSACTIONSTATFILTER_BASE                            (0x49063780)
#define IMX9_NOC__GPV__M_E_10_WR_I_MAIN_QOSGENERATOR_BASE                                     (0x49062F00)
#define IMX9_NOC__GPV__M_E_10_WR_I_MAIN_TRANSACTIONSTATFILTER_BASE                            (0x49063800)
#define IMX9_NOC__GPV__M_E_11_RD_I_MAIN_QOSGENERATOR_BASE                                     (0x49062F80)
#define IMX9_NOC__GPV__M_E_11_RD_I_MAIN_TRANSACTIONSTATFILTER_BASE                            (0x49063880)
#define IMX9_NOC__GPV__M_E_11_WR_I_MAIN_QOSGENERATOR_BASE                                     (0x49063000)
#define IMX9_NOC__GPV__M_E_11_WR_I_MAIN_TRANSACTIONSTATFILTER_BASE                            (0x49063900)
#define IMX9_NOC__GPV__M_E_1A_RD_I_MAIN_QOSGENERATOR_BASE                                     (0x49062500)
#define IMX9_NOC__GPV__M_E_1A_WR_I_MAIN_QOSGENERATOR_BASE                                     (0x49062580)
#define IMX9_NOC__GPV__M_E_1B_RD_I_MAIN_QOSGENERATOR_BASE                                     (0x49062600)
#define IMX9_NOC__GPV__M_E_1B_WR_I_MAIN_QOSGENERATOR_BASE                                     (0x49062680)
#define IMX9_NOC__GPV__M_E_3_RD_I_MAIN_QOSGENERATOR_BASE                                      (0x49062800)
#define IMX9_NOC__GPV__M_E_3_RD_I_MAIN_TRANSACTIONSTATFILTER_BASE                             (0x49063200)
#define IMX9_NOC__GPV__M_E_3_WR_I_MAIN_QOSGENERATOR_BASE                                      (0x49062880)
#define IMX9_NOC__GPV__M_E_3_WR_I_MAIN_TRANSACTIONSTATFILTER_BASE                             (0x49063280)
#define IMX9_NOC__GPV__M_E_4_RD_I_MAIN_QOSGENERATOR_BASE                                      (0x49062900)
#define IMX9_NOC__GPV__M_E_4_RD_I_MAIN_TRANSACTIONSTATFILTER_BASE                             (0x49063300)
#define IMX9_NOC__GPV__M_E_4_WR_I_MAIN_QOSGENERATOR_BASE                                      (0x49062980)
#define IMX9_NOC__GPV__M_E_4_WR_I_MAIN_TRANSACTIONSTATFILTER_BASE                             (0x49063380)
#define IMX9_NOC__GPV__M_E_5_RD_I_MAIN_QOSGENERATOR_BASE                                      (0x49062A00)
#define IMX9_NOC__GPV__M_E_5_RD_I_MAIN_TRANSACTIONSTATFILTER_BASE                             (0x49063400)
#define IMX9_NOC__GPV__M_E_5_WR_I_MAIN_QOSGENERATOR_BASE                                      (0x49062A80)
#define IMX9_NOC__GPV__M_E_5_WR_I_MAIN_TRANSACTIONSTATFILTER_BASE                             (0x49063480)
#define IMX9_NOC__GPV__M_E_6_RD_I_MAIN_QOSGENERATOR_BASE                                      (0x49062B00)
#define IMX9_NOC__GPV__M_E_6_RD_I_MAIN_TRANSACTIONSTATFILTER_BASE                             (0x49063500)
#define IMX9_NOC__GPV__M_E_7_RD_I_MAIN_QOSGENERATOR_BASE                                      (0x49062B80)
#define IMX9_NOC__GPV__M_E_7_RD_I_MAIN_TRANSACTIONSTATFILTER_BASE                             (0x49063580)
#define IMX9_NOC__GPV__M_E_7_WR_I_MAIN_QOSGENERATOR_BASE                                      (0x49062C00)
#define IMX9_NOC__GPV__M_E_7_WR_I_MAIN_TRANSACTIONSTATFILTER_BASE                             (0x49063600)
#define IMX9_NOC__GPV__M_E_8_RD_I_MAIN_QOSGENERATOR_BASE                                      (0x49062C80)
#define IMX9_NOC__GPV__M_E_8_WR_I_MAIN_QOSGENERATOR_BASE                                      (0x49062D00)
#define IMX9_NOC__GPV__M_E_9_RD_I_MAIN_QOSGENERATOR_BASE                                      (0x49062D80)
#define IMX9_NOC__GPV__M_E_9_RD_I_MAIN_TRANSACTIONSTATFILTER_BASE                             (0x49063680)
#define IMX9_NOC__GPV__M_E_9_WR_I_MAIN_QOSGENERATOR_BASE                                      (0x49062E00)
#define IMX9_NOC__GPV__M_E_9_WR_I_MAIN_TRANSACTIONSTATFILTER_BASE                             (0x49063700)
#define IMX9_NOC__GPV__PROBE_M_E_0_MAIN_PROBE_BASE                                            (0x49060000)
#define IMX9_NOC__GPV__PROBE_M_E_0_MAIN_TRANSACTIONSTATPROFILER_BASE                          (0x49063980)
#define IMX9_NOC__GPV__PROBE_M_E_10_MAIN_PROBE_BASE                                           (0x49061C00)
#define IMX9_NOC__GPV__PROBE_M_E_10_MAIN_TRANSACTIONSTATPROFILER_BASE                         (0x49063D00)
#define IMX9_NOC__GPV__PROBE_M_E_11_MAIN_PROBE_BASE                                           (0x49062000)
#define IMX9_NOC__GPV__PROBE_M_E_11_MAIN_TRANSACTIONSTATPROFILER_BASE                         (0x49063D80)
#define IMX9_NOC__GPV__PROBE_M_E_3_MAIN_PROBE_BASE                                            (0x49060400)
#define IMX9_NOC__GPV__PROBE_M_E_3_MAIN_TRANSACTIONSTATPROFILER_BASE                          (0x49063A00)
#define IMX9_NOC__GPV__PROBE_M_E_4_MAIN_PROBE_BASE                                            (0x49060800)
#define IMX9_NOC__GPV__PROBE_M_E_4_MAIN_TRANSACTIONSTATPROFILER_BASE                          (0x49063A80)
#define IMX9_NOC__GPV__PROBE_M_E_5_MAIN_PROBE_BASE                                            (0x49060C00)
#define IMX9_NOC__GPV__PROBE_M_E_5_MAIN_TRANSACTIONSTATPROFILER_BASE                          (0x49063B00)
#define IMX9_NOC__GPV__PROBE_M_E_6_MAIN_PROBE_BASE                                            (0x49061000)
#define IMX9_NOC__GPV__PROBE_M_E_6_MAIN_TRANSACTIONSTATPROFILER_BASE                          (0x49063B80)
#define IMX9_NOC__GPV__PROBE_M_E_7_MAIN_PROBE_BASE                                            (0x49061400)
#define IMX9_NOC__GPV__PROBE_M_E_7_MAIN_TRANSACTIONSTATPROFILER_BASE                          (0x49063C00)
#define IMX9_NOC__GPV__PROBE_M_E_9_MAIN_PROBE_BASE                                            (0x49061800)
#define IMX9_NOC__GPV__PROBE_M_E_9_MAIN_TRANSACTIONSTATPROFILER_BASE                          (0x49063C80)
#define IMX9_NOC__LSTCUN_BASE                                                                 (0x490B0000)
#define IMX9_NOC__MMU_TBU_TCU__TBU0_BASE                                                      (0x49110000)
#define IMX9_NOC__MMU_TBU_TCU__TBU10_BASE                                                     (0x49230000)
#define IMX9_NOC__MMU_TBU_TCU__TBU11_BASE                                                     (0x49250000)
#define IMX9_NOC__MMU_TBU_TCU__TBU1_BASE                                                      (0x49130000)
#define IMX9_NOC__MMU_TBU_TCU__TBU2_BASE                                                      (0x49150000)
#define IMX9_NOC__MMU_TBU_TCU__TBU3_BASE                                                      (0x49170000)
#define IMX9_NOC__MMU_TBU_TCU__TBU4_BASE                                                      (0x49190000)
#define IMX9_NOC__MMU_TBU_TCU__TBU5_BASE                                                      (0x491B0000)
#define IMX9_NOC__MMU_TBU_TCU__TBU6_BASE                                                      (0x491D0000)
#define IMX9_NOC__MMU_TBU_TCU__TBU7_BASE                                                      (0x491F0000)
#define IMX9_NOC__MMU_TBU_TCU__TBU9_BASE                                                      (0x49210000)
#define IMX9_NOC__MMU_TBU_TCU__TCU_BASE                                                       (0x490D0000)
#define IMX9_NOC__SRAMCTL_BASE                                                                (0x490A0000)
#define IMX9_NOC__TCU_BASE                                                                    (0x49040000)
#define IMX9_NPU__EIM_NPUMIX_BASE                                                             (0x4A860000)
#define IMX9_NPU__LSTCU_NPUMIX_BASE                                                           (0x4A850000)
#define IMX9_NPU__NEUTRON_NPU__NEUTRON0__NEUTRON_BASE                                         (0x4ABC0000)
#define IMX9_NPU__NEUTRON_NPU__NEUTRON1__NEUTRON_BASE                                         (0x4ABC1000)
#define IMX9_NPU__NEUTRON_NPU__NEUTRON2__NEUTRON_BASE                                         (0x4ABC2000)
#define IMX9_NPU__NEUTRON_NPU__NEUTRON3__NEUTRON_BASE                                         (0x4ABC3000)
#define IMX9_NPU__NEUTRON_NPU__NEUTRON_GANGED__NEUTRON_BASE                                   (0x4ABC4000)
#define IMX9_NPU__NEUTRON_NPU__NEUTRON_S__MMR_SOC_BASE                                        (0x4AB00000)
#define IMX9_NPU__NEUTRON_NPU__NEUTRON_S__MMR_ZV_BASE                                         (0x4AB80000)
#define IMX9_NPU__TCU_BASE                                                                    (0x4A800000)
#define IMX9_PDM_BASE                                                                         (0x44520000)
#define IMX9_SAI1_BASE                                                                        (0x443B0000)
#define IMX9_SAI2_BASE                                                                        (0x4C880000)
#define IMX9_SAI3_BASE                                                                        (0x42650000)
#define IMX9_SAI4_BASE                                                                        (0x42660000)
#define IMX9_SAI5_BASE                                                                        (0x42670000)
#define IMX9_SEMA42_1_BASE                                                                    (0x44260000)
#define IMX9_SEMA42_2_BASE                                                                    (0x42450000)
#define IMX9_TMPSNS1_BASE                                                                     (0x44482000)
#define IMX9_TMPSNS2_BASE                                                                     (0x4A440000)
#define IMX9_TMR0_BASE_BASE                                                                   (0x4CCC0000)
#define IMX9_TMR0_GLOBAL_BASE                                                                 (0x4CCD0000)
#define IMX9_TMR0_PCI_HDR_TYPE0_BASE                                                          (0x4CAC0000)
#define IMX9_TPM1_BASE                                                                        (0x44310000)
#define IMX9_TPM2_BASE                                                                        (0x44320000)
#define IMX9_TPM3_BASE                                                                        (0x424E0000)
#define IMX9_TPM4_BASE                                                                        (0x424F0000)
#define IMX9_TPM5_BASE                                                                        (0x42500000)
#define IMX9_TPM6_BASE                                                                        (0x42510000)
#define IMX9_TRDC1_BASE                                                                       (0x44270000)
#define IMX9_TSTMR1_BASE                                                                      (0x442C0000)
#define IMX9_TSTMR2_BASE                                                                      (0x42480000)
#define IMX9_USBC_BASE                                                                        (0x4C200000)
#define IMX9_USBNC_BASE                                                                       (0x4C200200)
#define IMX9_VPU__BLK_CTRL_VPUMIX_BASE                                                        (0x4C410000)
#define IMX9_VPU__GPV__JPEG_DEC_PROBE_MAIN_PROBE_BASE                                         (0x4C801000)
#define IMX9_VPU__GPV__JPEG_DEC_PROBE_MAIN_TRANSACTIONSTATPROFILER_BASE                       (0x4C801580)
#define IMX9_VPU__GPV__JPEG_DEC_RD_I_MAIN_TRANSACTIONSTATFILTER_BASE                          (0x4C801480)
#define IMX9_VPU__GPV__JPEG_DEC_WR_I_MAIN_QOSGENERATOR_BASE                                   (0x4C801400)
#define IMX9_VPU__GPV__JPEG_DEC_WR_I_MAIN_TRANSACTIONSTATFILTER_BASE                          (0x4C801500)
#define IMX9_VPU__GPV__JPEG_ENC_PROBE_MAIN_PROBE_BASE                                         (0x4C802000)
#define IMX9_VPU__GPV__JPEG_ENC_PROBE_MAIN_TRANSACTIONSTATPROFILER_BASE                       (0x4C802580)
#define IMX9_VPU__GPV__JPEG_ENC_RD_I_MAIN_QOSGENERATOR_BASE                                   (0x4C802400)
#define IMX9_VPU__GPV__JPEG_ENC_RD_I_MAIN_TRANSACTIONSTATFILTER_BASE                          (0x4C802480)
#define IMX9_VPU__GPV__JPEG_ENC_WR_I_MAIN_TRANSACTIONSTATFILTER_BASE                          (0x4C802500)
#define IMX9_VPU__GPV__SSI_PRI_PROBE_MAIN_PROBE_BASE                                          (0x4C800000)
#define IMX9_VPU__GPV__VPU_PRI_PROBE_MAIN_PROBE_BASE                                          (0x4C800400)
#define IMX9_VPU__GPV__VPU_PRI_PROBE_MAIN_TRANSACTIONSTATPROFILER_BASE                        (0x4C800A00)
#define IMX9_VPU__GPV__VPU_PRI_RD_I_MAIN_QOSGENERATOR_BASE                                    (0x4C800800)
#define IMX9_VPU__GPV__VPU_PRI_RD_I_MAIN_TRANSACTIONSTATFILTER_BASE                           (0x4C800900)
#define IMX9_VPU__GPV__VPU_PRI_WR_I_MAIN_QOSGENERATOR_BASE                                    (0x4C800880)
#define IMX9_VPU__GPV__VPU_PRI_WR_I_MAIN_TRANSACTIONSTATFILTER_BASE                           (0x4C800980)
#define IMX9_VPU__JPEG_DEC_BASE                                                               (0x4C500100)
#define IMX9_VPU__JPEG_DEC_WRAP_BASE                                                          (0x4C500000)
#define IMX9_VPU__JPEG_ENC_BASE                                                               (0x4C550100)
#define IMX9_VPU__JPEG_ENC_WRAP_BASE                                                          (0x4C550000)
#define IMX9_VPU__TCU_BASE                                                                    (0x4C400000)
#define IMX9_VPU__VPU__VPU_CODEC_BASE                                                         (0x4C480000)
#define IMX9_WAKEUP__AHBRM1_BASE                                                              (0x425E0000)
#define IMX9_WAKEUP__ATUA_BASE                                                                (0x42760000)
#define IMX9_WAKEUP__ATUM_BASE                                                                (0x42770000)
#define IMX9_WAKEUP__AUDIO_XCVR_BASE                                                          (0x42680000)
#define IMX9_WAKEUP__BLK_CTRL_WAKEUPMIX_BASE                                                  (0x42420000)
#define IMX9_WAKEUP__CMU1_BASE                                                                (0x42750000)
#define IMX9_WAKEUP__CMU2_BASE                                                                (0x427A0000)
#define IMX9_WAKEUP__DMA_CRC2_BASE                                                            (0x427B0000)
#define IMX9_WAKEUP__EDMA5_TCD2_BASE                                                          (0x42010000)
#define IMX9_WAKEUP__EDMA5_TCD3_BASE                                                          (0x42220000)
#define IMX9_WAKEUP__EIMW_BASE                                                                (0x42780000)
#define IMX9_WAKEUP__FLEXSPI_OTFAD_BASE                                                       (0x425E0000)
#define IMX9_WAKEUP__GPV_NOCM__POWER_MEGA_RESILIENCEFAULTCONTROLLER_BASE                      (0x42830000)
#define IMX9_WAKEUP__GPV_NOC__POWER_MAIN_RESILIENCEFAULTCONTROLLER_BASE                       (0x43900000)
#define IMX9_WAKEUP__ROMCP2_BASE                                                              (0x42640000)
#define IMX9_WAKEUP__USDHC1_BASE                                                              (0x42850000)
#define IMX9_WAKEUP__USDHC2_BASE                                                              (0x42860000)
#define IMX9_WAKEUP__USDHC3_BASE                                                              (0x428B0000)
#define IMX9_WAKEUP__XSPI_RESPONDER_BASE                                                      (0x428A0000)
#define IMX9_WDOG1_BASE                                                                       (0x442D0000)
#define IMX9_WDOG2_BASE                                                                       (0x442E0000)
#define IMX9_WDOG3_BASE                                                                       (0x42490000)
#define IMX9_WDOG4_BASE                                                                       (0x424A0000)
#define IMX9_WDOG5_BASE                                                                       (0x424B0000)
