/****************************************************************************
 * libs/libnx/nxfonts/nxfonts_sans39x48.h
 *
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.  The
 * ASF licenses this file to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 ****************************************************************************/

#ifndef __LIBS_LIBNX_NXFONTS_NXFONTS_SANS39X48_H
#define __LIBS_LIBNX_NXFONTS_NXFONTS_SANS39X48_H

/****************************************************************************
 * Included Files
 ****************************************************************************/

/****************************************************************************
 * Pre-Processor Definitions
 ****************************************************************************/

/* Font ID */

#define NXFONT_ID         FONTID_SANS39X48

/* Ranges of 7-bit and 8-bit fonts */

#define NXFONT_MIN7BIT    33
#define NXFONT_MAX7BIT    126

#define NXFONT_MIN8BIT    161
#define NXFONT_MAX8BIT    255

/* Maximum height and width of any glyph in the set */

#define NXFONT_MAXHEIGHT  48
#define NXFONT_MAXWIDTH   39

/* The width of a space */

#define NXFONT_SPACEWIDTH 9

/* exclam (33) */
#define NXFONT_METRICS_33 {1, 3, 25, 4, 12, 0}
#define NXFONT_BITMAP_33 {0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0x40, 0x40, 0x0, 0x0, 0xe0, 0xe0, 0xe0, 0xe0}

/* quotedbl (34) */
#define NXFONT_METRICS_34 {1, 8, 8, 2, 14, 0}
#define NXFONT_BITMAP_34 {0xe7, 0xe7, 0xe7, 0xe7, 0xe7, 0xe7, 0x42, 0x42}

/* numbersign (35) */
#define NXFONT_METRICS_35 {3, 17, 23, 1, 14, 0}
#define NXFONT_BITMAP_35 {0x3, 0x87, 0x0, 0x3, 0x87, 0x0, 0x3, 0x6, 0x0, 0x3, 0x6, 0x0, 0x7, 0xe, 0x0, 0x7, 0xe, 0x0, 0x7f, 0xff, 0x80, 0x7f, 0xff, 0x80, 0x7f, 0xff, 0x80, 0xe, 0x1c, 0x0, 0xe, 0x1c, 0x0, 0xc, 0x18, 0x0, 0x1c, 0x38, 0x0, 0x1c, 0x38, 0x0, 0xff, 0xff, 0x0, 0xff, 0xff, 0x0, 0xff, 0xff, 0x0, 0x38, 0x70, 0x0, 0x38, 0x70, 0x0, 0x30, 0x60, 0x0, 0x30, 0x60, 0x0, 0x70, 0xe0, 0x0, 0x70, 0xe0, 0x0}

/* dollar (36) */
#define NXFONT_METRICS_36 {2, 16, 31, 1, 10, 0}
#define NXFONT_BITMAP_36 {0x1, 0x80, 0x1, 0x80, 0x1, 0x80, 0xf, 0xf0, 0x1f, 0xf8, 0x3d, 0xbc, 0x71, 0x8e, 0x71, 0x8e, 0xe1, 0x8e, 0xe1, 0x80, 0xe1, 0x80, 0x71, 0x80, 0x7d, 0x80, 0x3f, 0xc0, 0x1f, 0xf0, 0x7, 0xfc, 0x1, 0xfe, 0x1, 0x9e, 0x1, 0x8f, 0x1, 0x87, 0xe1, 0x87, 0xe1, 0x87, 0x71, 0x8e, 0x71, 0x8e, 0x3d, 0xbc, 0x3f, 0xf8, 0xf, 0xf0, 0x1, 0x80, 0x1, 0x80, 0x1, 0x80, 0x1, 0x80}

/* percent (37) */
#define NXFONT_METRICS_37 {4, 26, 24, 1, 13, 0}
#define NXFONT_BITMAP_37 {0x0,  0x0,  0x30, 0x0,  0x1f, 0x0,  0x70, 0x0,  0x7f, 0x80, 0x60, 0x0,  0x73, 0xc0, 0xe0, 0x0,  0xe0, 0xc0, 0xc0, 0x0,  0xc0, 0xe1, 0xc0, 0x0,  0xc0, 0xe1, 0x80,\
                          0x0,  0xc0, 0xe3, 0x80, 0x0,  0xe0, 0xc3, 0x0,  0x0,  0x73, 0xc7, 0x0,  0x0,  0x7f, 0x86, 0x0,  0x0,  0x1f, 0xe,  0x0,  0x0,  0x0,  0xc,  0x0,  0x0,  0x0,  0x1c,\
                          0x3e, 0x0,  0x0,  0x18, 0x7f, 0x80, 0x0,  0x38, 0xf3, 0x80, 0x0,  0x30, 0xc1, 0xc0, 0x0,  0x71, 0xc0, 0xc0, 0x0,  0x61, 0xc0, 0xc0, 0x0,  0xe1, 0xc0, 0xc0, 0x0,\
                          0xc0, 0xc1, 0xc0, 0x1, 0xc0, 0xe3, 0x80, 0x1, 0x80, 0x7f, 0x80, 0x3, 0x80, 0x3e, 0x0}

/* ampersand (38) */
#define NXFONT_METRICS_38 {3, 18, 23, 2, 14, 0}
#define NXFONT_BITMAP_38 {0x7, 0xc0, 0x0, 0xf, 0xe0, 0x0, 0x1e, 0x70, 0x0, 0x3c, 0x38, 0x0, 0x38, 0x38, 0x0, 0x38, 0x38, 0x0, 0x3c, 0x70, 0x0, 0x1e, 0xf0, 0x0, 0xf, 0xe0, 0x0, 0x7, 0xc0, 0x0, 0xf, 0x80, 0x0, 0x3f, 0xc0, 0x0, 0x79, 0xc7, 0x0, 0x70, 0xe7, 0x0, 0xe0, 0xf6, 0x0, 0xe0, 0x7e, 0x0, 0xe0, 0x3c, 0x0, 0xe0, 0x1c, 0x0, 0xf0, 0x3e, 0x0, 0x78, 0x7f, 0x0, 0x7f, 0xf7, 0x80, 0x3f, 0xe3, 0xc0, 0xf, 0x0, 0x0}

/* quotesingle (39) */
#define NXFONT_METRICS_39 {1, 3, 8, 2, 14, 0}
#define NXFONT_BITMAP_39 {0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0x40}

/* parenleft (40) */
#define NXFONT_METRICS_40 {1, 7, 31, 2, 13, 0}
#define NXFONT_BITMAP_40 {0x6, 0xc, 0xc, 0x18, 0x18, 0x38, 0x30, 0x70, 0x70, 0x70, 0x60, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0x60, 0x70, 0x70, 0x70, 0x30, 0x38, 0x18, 0x18, 0xc, 0xc, 0x6}

/* parenright (41) */
#define NXFONT_METRICS_41 {1, 7, 31, 1, 13, 0}
#define NXFONT_BITMAP_41 {0xc0, 0x60, 0x60, 0x30, 0x30, 0x38, 0x18, 0x1c, 0x1c, 0x1c, 0xc, 0xe, 0xe, 0xe, 0xe, 0xe, 0xe, 0xe, 0xe, 0xc, 0xc, 0x1c, 0x1c, 0x18, 0x18, 0x38, 0x30, 0x70, 0x60, 0x60, 0xc0}

/* asterisk (42) */
#define NXFONT_METRICS_42 {2, 10, 11, 1, 11, 0}
#define NXFONT_BITMAP_42 {0xc, 0x0, 0xc, 0x0, 0x4c, 0x80, 0xed, 0xc0, 0x7f, 0x80, 0x3f, 0x0, 0x1e, 0x0, 0x3f, 0x0, 0x73, 0x80, 0xe1, 0xc0, 0x40, 0x80}

/* plus (43) */
#define NXFONT_METRICS_43 {3, 17, 16, 1, 20, 0}
#define NXFONT_BITMAP_43 {0x1, 0xc0, 0x0, 0x1, 0xc0, 0x0, 0x1, 0xc0, 0x0, 0x1, 0xc0, 0x0, 0x1, 0xc0, 0x0, 0x1, 0xc0, 0x0, 0x1, 0xc0, 0x0, 0xff, 0xff, 0x80, 0xff, 0xff, 0x80, 0xff, 0xff, 0x80, 0x1, 0xc0, 0x0, 0x1, 0xc0, 0x0, 0x1, 0xc0, 0x0, 0x1, 0xc0, 0x0, 0x1, 0xc0, 0x0, 0x1, 0xc0, 0x0}

/* comma (44) */
#define NXFONT_METRICS_44 {1, 3, 9, 3, 33, 0}
#define NXFONT_BITMAP_44 {0xe0, 0xe0, 0xe0, 0xe0, 0x20, 0x60, 0x60, 0xc0, 0x80}

/* hyphen (45) */
#define NXFONT_METRICS_45 {1, 8, 2, 1, 27, 0}
#define NXFONT_BITMAP_45 {0xff, 0xff}

/* period (46) */
#define NXFONT_METRICS_46 {1, 3, 4, 3, 33, 0}
#define NXFONT_BITMAP_46 {0xe0, 0xe0, 0xe0, 0xe0}

/* slash (47) */
#define NXFONT_METRICS_47 {2, 9, 24, 0, 13, 0}
#define NXFONT_BITMAP_47 {0x1, 0x80, 0x1, 0x80, 0x1, 0x80, 0x3, 0x0, 0x3, 0x0, 0x3, 0x0, 0x6, 0x0, 0x6, 0x0, 0x6, 0x0, 0xc, 0x0, 0xc, 0x0, 0xc, 0x0, 0x8, 0x0, 0x18, 0x0, 0x18, 0x0, 0x18, 0x0, 0x30, 0x0, 0x30, 0x0, 0x30, 0x0, 0x60, 0x0, 0x60, 0x0, 0x60, 0x0, 0xc0, 0x0, 0xc0, 0x0}

/* zero (48) */
#define NXFONT_METRICS_48 {2, 15, 24, 1, 13, 0}
#define NXFONT_BITMAP_48 {0x7, 0xc0, 0x1f, 0xf0, 0x3f, 0xf8, 0x3c, 0x78, 0x78, 0x3c, 0x70, 0x1c, 0x70, 0x1c, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x3c, 0x3c, 0x78, 0x3f, 0xf8, 0x1f, 0xf0, 0x7, 0xc0}

/* one (49) */
#define NXFONT_METRICS_49 {1, 8, 24, 3, 13, 0}
#define NXFONT_BITMAP_49 {0x3, 0x7, 0x7, 0xf, 0x3f, 0xff, 0xff, 0x7, 0x7, 0x7, 0x7, 0x7, 0x7, 0x7, 0x7, 0x7, 0x7, 0x7, 0x7, 0x7, 0x7, 0x7, 0x7, 0x7}

/* two (50) */
#define NXFONT_METRICS_50 {2, 15, 24, 1, 13, 0}
#define NXFONT_BITMAP_50 {0x7, 0xc0, 0x1f, 0xf0, 0x3f, 0xf8, 0x78, 0x3c, 0x70, 0x1c, 0xf0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0x0, 0xe, 0x0, 0x1c, 0x0, 0x3c, 0x0, 0x78, 0x0, 0xf0, 0x3, 0xe0, 0x7, 0xc0, 0x1f, 0x0, 0x3c, 0x0, 0x78, 0x0, 0x70, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xff, 0xfe, 0xff, 0xfe, 0xff, 0xfe}

/* three (51) */
#define NXFONT_METRICS_51 {2, 15, 24, 1, 13, 0}
#define NXFONT_BITMAP_51 {0x7, 0xc0, 0x1f, 0xf0, 0x3f, 0xf8, 0x38, 0x38, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x0, 0x1c, 0x0, 0x38, 0x3, 0xf8, 0x3, 0xf0, 0x3, 0xf8, 0x0, 0x3c, 0x0, 0x1e, 0x0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0x70, 0x1c, 0x78, 0x3c, 0x3f, 0xf8, 0x1f, 0xf0, 0x7, 0xc0}

/* four (52) */
#define NXFONT_METRICS_52 {2, 16, 24, 0, 13, 0}
#define NXFONT_BITMAP_52 {0x0, 0x18, 0x0, 0x38, 0x0, 0x78, 0x0, 0x78, 0x0, 0xf8, 0x1, 0xf8, 0x3, 0xb8, 0x3, 0xb8, 0x7, 0x38, 0xe, 0x38, 0xe, 0x38, 0x1c, 0x38, 0x38, 0x38, 0x38, 0x38, 0x70, 0x38, 0xe0, 0x38, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x38, 0x0, 0x38, 0x0, 0x38, 0x0, 0x38, 0x0, 0x38}

/* five (53) */
#define NXFONT_METRICS_53 {2, 15, 24, 1, 13, 0}
#define NXFONT_BITMAP_53 {0x3f, 0xfc, 0x3f, 0xfc, 0x3f, 0xfc, 0x38, 0x0, 0x38, 0x0, 0x38, 0x0, 0x70, 0x0, 0x70, 0x0, 0x77, 0xc0, 0x7f, 0xf0, 0x7f, 0xf8, 0x78, 0x7c, 0x70, 0x1c, 0x0, 0x1e, 0x0, 0xe, 0x0, 0xe, 0x0, 0xe, 0xe0, 0xe, 0xe0, 0x1e, 0xf0, 0x1c, 0x78, 0x7c, 0x7f, 0xf8, 0x3f, 0xf0, 0xf, 0x80}

/* six (54) */
#define NXFONT_METRICS_54 {2, 15, 24, 1, 13, 0}
#define NXFONT_BITMAP_54 {0x3, 0xc0, 0xf, 0xf0, 0x1f, 0xf8, 0x3c, 0x38, 0x38, 0x1c, 0x70, 0x1c, 0x70, 0x0, 0x70, 0x0, 0x60, 0x0, 0xe3, 0xc0, 0xef, 0xf0, 0xff, 0xf8, 0xf8, 0x3c, 0xf0, 0x1c, 0xf0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0x60, 0xe, 0x70, 0xe, 0x70, 0x1c, 0x38, 0x3c, 0x3f, 0xf8, 0x1f, 0xf0, 0x7, 0xc0}

/* seven (55) */
#define NXFONT_METRICS_55 {2, 15, 24, 1, 13, 0}
#define NXFONT_BITMAP_55 {0xff, 0xfe, 0xff, 0xfe, 0xff, 0xfe, 0x0, 0xe, 0x0, 0x1c, 0x0, 0x18, 0x0, 0x38, 0x0, 0x70, 0x0, 0x70, 0x0, 0xe0, 0x0, 0xe0, 0x1, 0xc0, 0x1, 0xc0, 0x3, 0x80, 0x3, 0x80, 0x7, 0x0, 0x7, 0x0, 0x7, 0x0, 0xe, 0x0, 0xe, 0x0, 0xe, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0}

/* eight (56) */
#define NXFONT_METRICS_56 {2, 15, 24, 1, 13, 0}
#define NXFONT_BITMAP_56 {0x7, 0xc0, 0x1f, 0xf0, 0x3f, 0xf8, 0x38, 0x3c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x78, 0x3c, 0x3c, 0x78, 0x1f, 0xf0, 0xf, 0xe0, 0x3f, 0xf8, 0x78, 0x3c, 0x70, 0x1c, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xf0, 0x1c, 0x78, 0x3c, 0x3f, 0xf8, 0x1f, 0xf0, 0x7, 0xc0}

/* nine (57) */
#define NXFONT_METRICS_57 {2, 15, 24, 1, 13, 0}
#define NXFONT_BITMAP_57 {0x7, 0xc0, 0x1f, 0xf0, 0x3f, 0xf8, 0x78, 0x7c, 0x70, 0x3c, 0xf0, 0x1c, 0xe0, 0x1e, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0x1e, 0xe0, 0x1e, 0x70, 0x3e, 0x7f, 0xfe, 0x3f, 0xee, 0xf, 0xce, 0x0, 0xe, 0x0, 0x1c, 0xe0, 0x1c, 0xf0, 0x3c, 0x78, 0x78, 0x3f, 0xf0, 0x3f, 0xe0, 0xf, 0x80}

/* colon (58) */
#define NXFONT_METRICS_58 {1, 3, 18, 4, 19, 0}
#define NXFONT_BITMAP_58 {0xe0, 0xe0, 0xe0, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xe0, 0xe0, 0xe0, 0xe0}

/* semicolon (59) */
#define NXFONT_METRICS_59 {1, 3, 22, 4, 20, 0}
#define NXFONT_BITMAP_59 {0xe0, 0xe0, 0xe0, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xe0, 0xe0, 0xe0, 0xe0, 0x20, 0x60, 0x60, 0xc0, 0x80}

/* less (60) */
#define NXFONT_METRICS_60 {2, 16, 16, 2, 21, 0}
#define NXFONT_BITMAP_60 {0x0, 0x3, 0x0, 0xf, 0x0, 0x3f, 0x1, 0xfc, 0x7, 0xe0, 0x1f, 0x80, 0xfe, 0x0, 0xf0, 0x0, 0xf0, 0x0, 0xfe, 0x0, 0x1f, 0x80, 0x7, 0xe0, 0x1, 0xfc, 0x0, 0x7f, 0x0, 0xf, 0x0, 0x3}

/* equal (61) */
#define NXFONT_METRICS_61 {2, 15, 9, 2, 24, 0}
#define NXFONT_BITMAP_61 {0xff, 0xfe, 0xff, 0xfe, 0xff, 0xfe, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xfe, 0xff, 0xfe, 0xff, 0xfe}

/* greater (62) */
#define NXFONT_METRICS_62 {2, 16, 16, 1, 21, 0}
#define NXFONT_BITMAP_62 {0xc0, 0x0, 0xf0, 0x0, 0xfe, 0x0, 0x3f, 0x80, 0x7, 0xe0, 0x1, 0xf8, 0x0, 0x7f, 0x0, 0xf, 0x0, 0xf, 0x0, 0x7f, 0x1, 0xf8, 0x7, 0xe0, 0x3f, 0x80, 0xfe, 0x0, 0xf0, 0x0, 0xc0, 0x0}

/* question (63) */
#define NXFONT_METRICS_63 {2, 14, 25, 2, 12, 0}
#define NXFONT_BITMAP_63 {0x7, 0xc0, 0x1f, 0xf0, 0x3f, 0xf8, 0x78, 0x38, 0x70, 0x1c, 0xf0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0x0, 0x1c, 0x0, 0x38, 0x0, 0x38, 0x0, 0x70, 0x0, 0xe0, 0x1, 0xe0, 0x1, 0xc0, 0x3, 0x80, 0x3, 0x80, 0x3, 0x80, 0x3, 0x80, 0x0, 0x0, 0x0, 0x0, 0x3, 0x80, 0x3, 0x80, 0x3, 0x80, 0x3, 0x80}

/* at (64) */
#define NXFONT_METRICS_64 {4, 29, 30, 1, 12, 0}
#define NXFONT_BITMAP_64 {0x0,  0x7,  0xc0, 0x0,  0x0,  0x3f, 0xf8, 0x0,  0x0,  0xff, 0xfe, 0x0,  0x3,  0xf0, 0x3f, 0x80, 0x7,  0xc0, 0x7,  0xc0, 0xf,  0x0,  0x3,  0xe0, 0x1e, 0x0,  0x1,  0xe0, 0x1c, 0x0,  0x0,  0xf0,\
                          0x38, 0xf,  0x8c, 0x70, 0x38, 0x1f, 0xdc, 0x38, 0x70, 0x3c, 0xfc, 0x38, 0x70, 0x70, 0x7c, 0x38, 0x60, 0xe0, 0x38, 0x18, 0xe0, 0xe0, 0x38, 0x18, 0xe1, 0xe0, 0x38, 0x18, 0xe1, 0xc0, 0x70, 0x38,\
                          0xe1, 0xc0, 0x70, 0x38, 0xe1, 0xc0, 0x70, 0x70, 0xe1, 0xc0, 0xe0, 0x70, 0xe1, 0xe0, 0xe0, 0xe0, 0x70, 0xf3, 0xf3, 0xc0, 0x70, 0xff, 0x7f, 0x80, 0x78, 0x3e, 0x7f, 0x0,  0x3c, 0x0,  0x0,  0x0,\
                          0x1e, 0x0,  0x0,  0x0,  0x1f, 0x0,  0x0,   0x0, 0xf,  0x80, 0x0,  0x0,  0x3,  0xe0, 0x78, 0x0,  0x1,  0xff, 0xf8, 0x0,  0x0,  0x7f, 0xe0, 0x0}

/* A (65) */
#define NXFONT_METRICS_65 {3, 20, 25, 1, 12, 0}
#define NXFONT_BITMAP_65 {0x0, 0xf0, 0x0, 0x0, 0xf0, 0x0, 0x0, 0xf8, 0x0, 0x1, 0xf8, 0x0, 0x1, 0xf8, 0x0, 0x3, 0x9c, 0x0, 0x3, 0x9c, 0x0, 0x3, 0x9c, 0x0, 0x7, 0x9e, 0x0, 0x7, 0xe, 0x0, 0x7, 0xe, 0x0, 0xf, 0xf, 0x0, 0xf, 0xf, 0x0, 0xe, 0x7, 0x0, 0x1e, 0x7, 0x80, 0x1f, 0xff, 0x80, 0x1f, 0xff, 0x80, 0x3f, 0xff, 0xc0, 0x3c, 0x3, 0xc0, 0x38, 0x1, 0xc0, 0x78, 0x1, 0xe0, 0x78, 0x1, 0xe0, 0x70, 0x0, 0xe0, 0xf0, 0x0, 0xf0, 0xf0, 0x0, 0xf0}

/* B (66) */
#define NXFONT_METRICS_66 {3, 17, 25, 3, 12, 0}
#define NXFONT_BITMAP_66 {0xff, 0xf0, 0x0, 0xff, 0xfc, 0x0, 0xff, 0xfe, 0x0, 0xe0, 0x3e, 0x0, 0xe0, 0xf, 0x0, 0xe0, 0xf, 0x0, 0xe0, 0x7, 0x0, 0xe0, 0x7, 0x0, 0xe0, 0xf, 0x0, 0xe0, 0xe, 0x0, 0xe0, 0x3e, 0x0, 0xff, 0xfc, 0x0, 0xff, 0xfc, 0x0, 0xff, 0xfe, 0x0, 0xe0, 0x1f, 0x0, 0xe0, 0x7, 0x80, 0xe0, 0x3, 0x80, 0xe0, 0x3, 0x80, 0xe0, 0x3, 0x80, 0xe0, 0x3, 0x80, 0xe0, 0x7, 0x80, 0xe0, 0xf, 0x0, 0xff, 0xfe, 0x0, 0xff, 0xfe, 0x0, 0xff, 0xf8, 0x0}

/* C (67) */
#define NXFONT_METRICS_67 {3, 20, 25, 2, 12, 0}
#define NXFONT_BITMAP_67 {0x1, 0xfc, 0x0, 0x7, 0xff, 0x0, 0xf, 0xff, 0x80, 0x1f, 0x7, 0xc0, 0x3c, 0x1, 0xe0, 0x38, 0x0, 0xe0, 0x70, 0x0, 0xf0, 0x70, 0x0, 0x70, 0xe0, 0x0, 0x0, 0xe0, 0x0, 0x0, 0xe0, 0x0, 0x0, 0xe0, 0x0, 0x0, 0xe0, 0x0, 0x0, 0xe0, 0x0, 0x0, 0xe0, 0x0, 0x0, 0xe0, 0x0, 0x0, 0xe0, 0x0, 0x70, 0xf0, 0x0, 0x70, 0x70, 0x0, 0xf0, 0x78, 0x0, 0xe0, 0x3c, 0x1, 0xe0, 0x3f, 0x7, 0xc0, 0x1f, 0xff, 0x80, 0x7, 0xfe, 0x0, 0x1, 0xf8, 0x0}

/* D (68) */
#define NXFONT_METRICS_68 {3, 18, 25, 3, 12, 0}
#define NXFONT_BITMAP_68 {0xff, 0xf0, 0x0, 0xff, 0xfc, 0x0, 0xff, 0xfe, 0x0, 0xe0, 0x1f, 0x0, 0xe0, 0xf, 0x0, 0xe0, 0x7, 0x80, 0xe0, 0x3, 0x80, 0xe0, 0x3, 0x80, 0xe0, 0x1, 0xc0, 0xe0, 0x1, 0xc0, 0xe0, 0x1, 0xc0, 0xe0, 0x1, 0xc0, 0xe0, 0x1, 0xc0, 0xe0, 0x1, 0xc0, 0xe0, 0x1, 0xc0, 0xe0, 0x1, 0xc0, 0xe0, 0x3, 0xc0, 0xe0, 0x3, 0x80, 0xe0, 0x3, 0x80, 0xe0, 0x7, 0x80, 0xe0, 0xf, 0x0, 0xe0, 0x1e, 0x0, 0xff, 0xfe, 0x0, 0xff, 0xfc, 0x0, 0xff, 0xf0, 0x0}

/* E (69) */
#define NXFONT_METRICS_69 {3, 17, 25, 3, 12, 0}
#define NXFONT_BITMAP_69 {0xff, 0xff, 0x0, 0xff, 0xff, 0x0, 0xff, 0xff, 0x0, 0xe0, 0x0, 0x0, 0xe0, 0x0, 0x0, 0xe0, 0x0, 0x0, 0xe0, 0x0, 0x0, 0xe0, 0x0, 0x0, 0xe0, 0x0, 0x0, 0xe0, 0x0, 0x0, 0xe0, 0x0, 0x0, 0xff, 0xff, 0x0, 0xff, 0xff, 0x0, 0xff, 0xff, 0x0, 0xe0, 0x0, 0x0, 0xe0, 0x0, 0x0, 0xe0, 0x0, 0x0, 0xe0, 0x0, 0x0, 0xe0, 0x0, 0x0, 0xe0, 0x0, 0x0, 0xe0, 0x0, 0x0, 0xe0, 0x0, 0x0, 0xff, 0xff, 0x80, 0xff, 0xff, 0x80, 0xff, 0xff, 0x80}

/* F (70) */
#define NXFONT_METRICS_70 {2, 16, 25, 3, 12, 0}
#define NXFONT_BITMAP_70 {0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xff, 0xfc, 0xff, 0xfc, 0xff, 0xfc, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0}

/* G (71) */
#define NXFONT_METRICS_71 {3, 22, 25, 1, 12, 0}
#define NXFONT_BITMAP_71 {0x0, 0xfe, 0x0, 0x3, 0xff, 0x80, 0xf, 0xff, 0xc0, 0x1f, 0x83, 0xf0, 0x3e, 0x0, 0xf0, 0x3c, 0x0, 0x78, 0x78, 0x0, 0x38, 0x70, 0x0, 0x38, 0xf0, 0x0, 0x0, 0xe0, 0x0, 0x0, 0xe0, 0x0, 0x0, 0xe0, 0x0, 0x0, 0xe0, 0xf, 0xfc, 0xe0, 0xf, 0xfc, 0xe0, 0xf, 0xfc, 0xe0, 0x0, 0x1c, 0xf0, 0x0, 0x1c, 0x70, 0x0, 0x1c, 0x78, 0x0, 0x3c, 0x38, 0x0, 0x3c, 0x3c, 0x0, 0xfc, 0x1f, 0x1, 0xfc, 0xf, 0xff, 0xdc, 0x7, 0xff, 0x1c, 0x1, 0xfc, 0x1c}

/* H (72) */
#define NXFONT_METRICS_72 {3, 18, 25, 3, 12, 0}
#define NXFONT_BITMAP_72 {0xe0, 0x1, 0xc0, 0xe0, 0x1, 0xc0, 0xe0, 0x1, 0xc0, 0xe0, 0x1, 0xc0, 0xe0, 0x1, 0xc0, 0xe0, 0x1, 0xc0, 0xe0, 0x1, 0xc0, 0xe0, 0x1, 0xc0, 0xe0, 0x1, 0xc0, 0xe0, 0x1, 0xc0, 0xe0, 0x1, 0xc0, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xc0, 0xe0, 0x1, 0xc0, 0xe0, 0x1, 0xc0, 0xe0, 0x1, 0xc0, 0xe0, 0x1, 0xc0, 0xe0, 0x1, 0xc0, 0xe0, 0x1, 0xc0, 0xe0, 0x1, 0xc0, 0xe0, 0x1, 0xc0, 0xe0, 0x1, 0xc0, 0xe0, 0x1, 0xc0, 0xe0, 0x1, 0xc0}

/* I (73) */
#define NXFONT_METRICS_73 {1, 3, 25, 3, 12, 0}
#define NXFONT_BITMAP_73 {0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0}

/* J (74) */
#define NXFONT_METRICS_74 {2, 13, 25, 1, 12, 0}
#define NXFONT_BITMAP_74 {0x0, 0x38, 0x0, 0x38, 0x0, 0x38, 0x0, 0x38, 0x0, 0x38, 0x0, 0x38, 0x0, 0x38, 0x0, 0x38, 0x0, 0x38, 0x0, 0x38, 0x0, 0x38, 0x0, 0x38, 0x0, 0x38, 0x0, 0x38, 0x0, 0x38, 0x0, 0x38, 0xe0, 0x38, 0xe0, 0x38, 0xe0, 0x38, 0xe0, 0x38, 0xf0, 0x78, 0x78, 0xf0, 0x7f, 0xf0, 0x3f, 0xe0, 0x1f, 0x80}

/* K (75) */
#define NXFONT_METRICS_75 {3, 20, 25, 3, 12, 0}
#define NXFONT_BITMAP_75 {0xe0, 0x3, 0xc0, 0xe0, 0x7, 0x80, 0xe0, 0xf, 0x0, 0xe0, 0x1e, 0x0, 0xe0, 0x3c, 0x0, 0xe0, 0x78, 0x0, 0xe0, 0xf0, 0x0, 0xe1, 0xe0, 0x0, 0xe3, 0xc0, 0x0, 0xe7, 0xc0, 0x0, 0xef, 0x80, 0x0, 0xff, 0xc0, 0x0, 0xff, 0xc0, 0x0, 0xf9, 0xe0, 0x0, 0xf0, 0xf0, 0x0, 0xe0, 0x70, 0x0, 0xe0, 0x78, 0x0, 0xe0, 0x3c, 0x0, 0xe0, 0x1c, 0x0, 0xe0, 0x1e, 0x0, 0xe0, 0xf, 0x0, 0xe0, 0x7, 0x80, 0xe0, 0x3, 0xc0, 0xe0, 0x3, 0xe0, 0xe0, 0x1, 0xf0}

/* L (76) */
#define NXFONT_METRICS_76 {2, 14, 25, 3, 12, 0}
#define NXFONT_BITMAP_76 {0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xff, 0xfc, 0xff, 0xfc, 0xff, 0xfc}

/* M (77) */
#define NXFONT_METRICS_77 {3, 21, 25, 3, 12, 0}
#define NXFONT_BITMAP_77 {0xf0, 0x0, 0x78, 0xf0, 0x0, 0x78, 0xf8, 0x0, 0xf8, 0xf8, 0x0, 0xf8, 0xfc, 0x1, 0xf8, 0xfc, 0x1, 0xf8, 0xfc, 0x1, 0xf8, 0xec, 0x1, 0xb8, 0xee, 0x3, 0xb8, 0xee, 0x3, 0xb8, 0xe6, 0x3, 0x38, 0xe7, 0x7, 0x38, 0xe7, 0x7, 0x38, 0xe3, 0x6, 0x38, 0xe3, 0x8e, 0x38, 0xe3, 0x8e, 0x38, 0xe3, 0x8e, 0x38, 0xe1, 0x8c, 0x38, 0xe1, 0xdc, 0x38, 0xe1, 0xdc, 0x38, 0xe0, 0xd8, 0x38, 0xe0, 0xf8, 0x38, 0xe0, 0xf8, 0x38, 0xe0, 0x70, 0x38, 0xe0, 0x70, 0x38}

/* N (78) */
#define NXFONT_METRICS_78 {3, 19, 25, 2, 12, 0}
#define NXFONT_BITMAP_78 {0xf0, 0x0, 0xe0, 0xf0, 0x0, 0xe0, 0xf8, 0x0, 0xe0, 0xfc, 0x0, 0xe0, 0xfc, 0x0, 0xe0, 0xfe, 0x0, 0xe0, 0xef, 0x0, 0xe0, 0xe7, 0x0, 0xe0, 0xe7, 0x80, 0xe0, 0xe3, 0xc0, 0xe0, 0xe3, 0xc0, 0xe0, 0xe1, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xf0, 0xe0, 0xe0, 0x78, 0xe0, 0xe0, 0x38, 0xe0, 0xe0, 0x3c, 0xe0, 0xe0, 0x1c, 0xe0, 0xe0, 0x1e, 0xe0, 0xe0, 0xf, 0xe0, 0xe0, 0x7, 0xe0, 0xe0, 0x7, 0xe0, 0xe0, 0x3, 0xe0, 0xe0, 0x1, 0xe0, 0xe0, 0x1, 0xe0}

/* O (79) */
#define NXFONT_METRICS_79 {3, 23, 25, 1, 12, 0}
#define NXFONT_BITMAP_79 {0x0, 0xfe, 0x0, 0x3, 0xff, 0x80, 0xf, 0xef, 0xe0, 0x1f, 0x1, 0xf0, 0x3e, 0x0, 0xf8, 0x3c, 0x0, 0x78, 0x78, 0x0, 0x3c, 0x70, 0x0, 0x1c, 0xf0, 0x0, 0x1e, 0xe0, 0x0, 0xe, 0xe0, 0x0, 0xe, 0xe0, 0x0, 0xe, 0xe0, 0x0, 0xe, 0xe0, 0x0, 0xe, 0xe0, 0x0, 0xe, 0xe0, 0x0, 0xe, 0xf0, 0x0, 0x1e, 0xf0, 0x0, 0x1e, 0x78, 0x0, 0x3c, 0x3c, 0x0, 0x78, 0x3e, 0x0, 0xf8, 0x1f, 0x1, 0xf0, 0xf, 0xef, 0xe0, 0x3, 0xff, 0x80, 0x0, 0xfe, 0x0}

/* P (80) */
#define NXFONT_METRICS_80 {3, 17, 25, 3, 12, 0}
#define NXFONT_BITMAP_80 {0xff, 0xf8, 0x0, 0xff, 0xfe, 0x0, 0xff, 0xff, 0x0, 0xe0, 0xf, 0x0, 0xe0, 0x7, 0x80, 0xe0, 0x3, 0x80, 0xe0, 0x3, 0x80, 0xe0, 0x3, 0x80, 0xe0, 0x3, 0x80, 0xe0, 0x3, 0x80, 0xe0, 0x7, 0x80, 0xe0, 0xf, 0x0, 0xff, 0xff, 0x0, 0xff, 0xfe, 0x0, 0xff, 0xf8, 0x0, 0xe0, 0x0, 0x0, 0xe0, 0x0, 0x0, 0xe0, 0x0, 0x0, 0xe0, 0x0, 0x0, 0xe0, 0x0, 0x0, 0xe0, 0x0, 0x0, 0xe0, 0x0, 0x0, 0xe0, 0x0, 0x0, 0xe0, 0x0, 0x0, 0xe0, 0x0, 0x0}

/* Q (81) */
#define NXFONT_METRICS_81 {3, 23, 26, 1, 12, 0}
#define NXFONT_BITMAP_81 {0x0, 0xfe, 0x0, 0x3, 0xff, 0x80, 0xf, 0xef, 0xe0, 0x1f, 0x1, 0xf0, 0x3e, 0x0, 0xf8, 0x3c, 0x0, 0x78, 0x78, 0x0, 0x3c, 0x70, 0x0, 0x1c, 0xf0, 0x0, 0x1e, 0xe0, 0x0, 0xe, 0xe0, 0x0, 0xe, 0xe0, 0x0, 0xe, 0xe0, 0x0, 0xe, 0xe0, 0x0, 0xe, 0xe0, 0x0, 0xe, 0xe0, 0x0, 0xe, 0xf0, 0x0, 0x1e, 0xf0, 0x2, 0x1e, 0x78, 0x7, 0x3c, 0x3c, 0x7, 0xb8, 0x3e, 0x3, 0xf8, 0x1f, 0x1, 0xf0, 0xf, 0xef, 0xf8, 0x3, 0xff, 0xbc, 0x0, 0xfe, 0x1e, 0x0, 0x0, 0xc}

/* R (82) */
#define NXFONT_METRICS_82 {3, 19, 25, 3, 12, 0}
#define NXFONT_BITMAP_82 {0xff, 0xfc, 0x0, 0xff, 0xff, 0x0, 0xff, 0xff, 0x80, 0xe0, 0x7, 0x80, 0xe0, 0x3, 0xc0, 0xe0, 0x1, 0xc0, 0xe0, 0x1, 0xc0, 0xe0, 0x1, 0xc0, 0xe0, 0x1, 0xc0, 0xe0, 0x3, 0xc0, 0xe0, 0x3, 0x80, 0xe0, 0xf, 0x80, 0xff, 0xff, 0x0, 0xff, 0xfe, 0x0, 0xff, 0xff, 0x0, 0xe0, 0xf, 0x80, 0xe0, 0x7, 0x80, 0xe0, 0x3, 0x80, 0xe0, 0x3, 0xc0, 0xe0, 0x3, 0xc0, 0xe0, 0x3, 0xc0, 0xe0, 0x1, 0xc0, 0xe0, 0x1, 0xc0, 0xe0, 0x1, 0xc0, 0xe0, 0x1, 0xe0}

/* S (83) */
#define NXFONT_METRICS_83 {3, 19, 25, 1, 12, 0}
#define NXFONT_BITMAP_83 {0x3, 0xf8, 0x0, 0xf, 0xfe, 0x0, 0x1f, 0xff, 0x0, 0x3c, 0xf, 0x80, 0x38, 0x3, 0xc0, 0x70, 0x1, 0xc0, 0x70, 0x1, 0xc0, 0x70, 0x0, 0x0, 0x78, 0x0, 0x0, 0x7c, 0x0, 0x0, 0x3f, 0xc0, 0x0, 0x1f, 0xf8, 0x0, 0x7, 0xff, 0x0, 0x0, 0x7f, 0x80, 0x0, 0xf, 0xc0, 0x0, 0x1, 0xe0, 0x0, 0x0, 0xe0, 0xe0, 0x0, 0xe0, 0xf0, 0x0, 0xe0, 0x70, 0x1, 0xe0, 0x78, 0x1, 0xc0, 0x3e, 0x7, 0xc0, 0x3f, 0xff, 0x80, 0xf, 0xfe, 0x0, 0x3, 0xf8, 0x0}

/* T (84) */
#define NXFONT_METRICS_84 {3, 19, 25, 0, 12, 0}
#define NXFONT_BITMAP_84 {0xff, 0xff, 0xe0, 0xff, 0xff, 0xe0, 0xff, 0xff, 0xe0, 0x0, 0xe0, 0x0, 0x0, 0xe0, 0x0, 0x0, 0xe0, 0x0, 0x0, 0xe0, 0x0, 0x0, 0xe0, 0x0, 0x0, 0xe0, 0x0, 0x0, 0xe0, 0x0, 0x0, 0xe0, 0x0, 0x0, 0xe0, 0x0, 0x0, 0xe0, 0x0, 0x0, 0xe0, 0x0, 0x0, 0xe0, 0x0, 0x0, 0xe0, 0x0, 0x0, 0xe0, 0x0, 0x0, 0xe0, 0x0, 0x0, 0xe0, 0x0, 0x0, 0xe0, 0x0, 0x0, 0xe0, 0x0, 0x0, 0xe0, 0x0, 0x0, 0xe0, 0x0, 0x0, 0xe0, 0x0, 0x0, 0xe0, 0x0}

/* U (85) */
#define NXFONT_METRICS_85 {3, 18, 25, 3, 12, 0}
#define NXFONT_BITMAP_85 {0xe0, 0x1, 0xc0, 0xe0, 0x1, 0xc0, 0xe0, 0x1, 0xc0, 0xe0, 0x1, 0xc0, 0xe0, 0x1, 0xc0, 0xe0, 0x1, 0xc0, 0xe0, 0x1, 0xc0, 0xe0, 0x1, 0xc0, 0xe0, 0x1, 0xc0, 0xe0, 0x1, 0xc0, 0xe0, 0x1, 0xc0, 0xe0, 0x1, 0xc0, 0xe0, 0x1, 0xc0, 0xe0, 0x1, 0xc0, 0xe0, 0x1, 0xc0, 0xe0, 0x1, 0xc0, 0xe0, 0x1, 0xc0, 0xe0, 0x1, 0xc0, 0xe0, 0x1, 0xc0, 0xf0, 0x3, 0xc0, 0x78, 0x7, 0x80, 0x7c, 0xf, 0x80, 0x3f, 0xff, 0x0, 0x1f, 0xfe, 0x0, 0x3, 0xf0, 0x0}

/* V (86) */
#define NXFONT_METRICS_86 {3, 19, 25, 1, 12, 0}
#define NXFONT_BITMAP_86 {0xf0, 0x1, 0xe0, 0xf0, 0x1, 0xe0, 0xf0, 0x1, 0xe0, 0x70, 0x1, 0xc0, 0x78, 0x3, 0xc0, 0x78, 0x3, 0xc0, 0x38, 0x3, 0x80, 0x38, 0x3, 0x80, 0x3c, 0x7, 0x80, 0x1c, 0x7, 0x0, 0x1c, 0x7, 0x0, 0x1e, 0xf, 0x0, 0xe, 0xe, 0x0, 0xe, 0xe, 0x0, 0xf, 0xe, 0x0, 0x7, 0x1c, 0x0, 0x7, 0x1c, 0x0, 0x7, 0x9c, 0x0, 0x3, 0xb8, 0x0, 0x3, 0xb8, 0x0, 0x3, 0xb8, 0x0, 0x1, 0xf0, 0x0, 0x1, 0xf0, 0x0, 0x0, 0xe0, 0x0, 0x0, 0xe0, 0x0}

/* W (87) */
#define NXFONT_METRICS_87 {4, 29, 25, 1, 12, 0}
#define NXFONT_BITMAP_87 {0xf0, 0x7,  0x0,  0x78, 0xf0, 0x7,  0x0,  0x78, 0xf0, 0xf,  0x80, 0x78, 0x70, 0xf,  0x80, 0x70, 0x70, 0xf,  0x80, 0x70, 0x78, 0x1d, 0xc0, 0xf0, 0x78, 0x1d, 0xc0, 0xf0, 0x38, 0x1d, 0xc0,\
                          0xe0, 0x38, 0x1d, 0xc0, 0xe0, 0x38, 0x38, 0xe0, 0xe0, 0x3c, 0x38, 0xe1, 0xe0, 0x1c, 0x38, 0xe1, 0xc0, 0x1c, 0x30, 0xe1, 0xc0, 0x1c, 0x70, 0x71, 0xc0, 0x1c, 0x70, 0x71, 0xc0, 0xe,  0x70,\
                          0x73, 0x80, 0xe,  0xe0, 0x3b, 0x80, 0xe,  0xe0, 0x3b, 0x80, 0xe,  0xe0, 0x3b, 0x80, 0x7,  0xe0, 0x3f, 0x80, 0x7,  0xc0, 0x1f, 0x0,  0x7,  0xc0, 0x1f, 0x0,  0x7,  0xc0, 0x1f, 0x0,  0x3,\
                          0x80, 0xe, 0x0, 0x3, 0x80, 0xe, 0x0}

/* X (88) */
#define NXFONT_METRICS_88 {3, 20, 25, 1, 12, 0}
#define NXFONT_BITMAP_88 {0xf8, 0x0, 0xf0, 0x78, 0x1, 0xe0, 0x3c, 0x3, 0xc0, 0x1c, 0x3, 0xc0, 0x1e, 0x7, 0x80, 0xf, 0x7, 0x0, 0xf, 0xf, 0x0, 0x7, 0x9e, 0x0, 0x3, 0x9c, 0x0, 0x3, 0xfc, 0x0, 0x1, 0xf8, 0x0, 0x0, 0xf0, 0x0, 0x0, 0xf0, 0x0, 0x1, 0xf8, 0x0, 0x1, 0xf8, 0x0, 0x3, 0x9c, 0x0, 0x7, 0x9e, 0x0, 0x7, 0xe, 0x0, 0xf, 0xf, 0x0, 0x1e, 0x7, 0x80, 0x1e, 0x7, 0x80, 0x3c, 0x3, 0xc0, 0x78, 0x1, 0xe0, 0x78, 0x1, 0xe0, 0xf0, 0x0, 0xf0}

/* Y (89) */
#define NXFONT_METRICS_89 {3, 21, 25, 0, 12, 0}
#define NXFONT_BITMAP_89 {0xf0, 0x0, 0x78, 0x78, 0x0, 0xf0, 0x78, 0x0, 0xe0, 0x3c, 0x1, 0xe0, 0x1c, 0x1, 0xc0, 0x1e, 0x3, 0xc0, 0xe, 0x7, 0x80, 0xf, 0x7, 0x80, 0x7, 0x8f, 0x0, 0x3, 0x8e, 0x0, 0x3, 0xde, 0x0, 0x1, 0xdc, 0x0, 0x1, 0xfc, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0x70, 0x0, 0x0, 0x70, 0x0, 0x0, 0x70, 0x0, 0x0, 0x70, 0x0, 0x0, 0x70, 0x0, 0x0, 0x70, 0x0, 0x0, 0x70, 0x0, 0x0, 0x70, 0x0, 0x0, 0x70, 0x0, 0x0, 0x70, 0x0}

/* Z (90) */
#define NXFONT_METRICS_90 {3, 18, 25, 1, 12, 0}
#define NXFONT_BITMAP_90 {0x7f, 0xff, 0xc0, 0x7f, 0xff, 0xc0, 0x7f, 0xff, 0xc0, 0x0, 0x7, 0x80, 0x0, 0xf, 0x80, 0x0, 0xf, 0x0, 0x0, 0x1e, 0x0, 0x0, 0x3c, 0x0, 0x0, 0x3c, 0x0, 0x0, 0x78, 0x0, 0x0, 0xf0, 0x0, 0x1, 0xe0, 0x0, 0x1, 0xe0, 0x0, 0x3, 0xc0, 0x0, 0x7, 0x80, 0x0, 0x7, 0x80, 0x0, 0xf, 0x0, 0x0, 0x1e, 0x0, 0x0, 0x3c, 0x0, 0x0, 0x3c, 0x0, 0x0, 0x78, 0x0, 0x0, 0xf0, 0x0, 0x0, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xc0}

/* bracketleft (91) */
#define NXFONT_METRICS_91 {1, 6, 32, 2, 12, 0}
#define NXFONT_BITMAP_91 {0xfc, 0xfc, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xfc, 0xfc}

/* backslash (92) */
#define NXFONT_METRICS_92 {2, 9, 24, 0, 13, 0}
#define NXFONT_BITMAP_92 {0xc0, 0x0, 0xc0, 0x0, 0x60, 0x0, 0x60, 0x0, 0x60, 0x0, 0x30, 0x0, 0x30, 0x0, 0x30, 0x0, 0x10, 0x0, 0x18, 0x0, 0x18, 0x0, 0x18, 0x0, 0xc, 0x0, 0xc, 0x0, 0xc, 0x0, 0x6, 0x0, 0x6, 0x0, 0x6, 0x0, 0x2, 0x0, 0x3, 0x0, 0x3, 0x0, 0x3, 0x0, 0x1, 0x80, 0x1, 0x80}

/* bracketright (93) */
#define NXFONT_METRICS_93 {1, 6, 32, 1, 12, 0}
#define NXFONT_BITMAP_93 {0xfc, 0xfc, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0xfc, 0xfc}

/* asciicircum (94) */
#define NXFONT_METRICS_94 {2, 12, 13, 1, 13, 0}
#define NXFONT_BITMAP_94 {0x6, 0x0, 0xf, 0x0, 0xf, 0x0, 0x1f, 0x80, 0x19, 0x80, 0x19, 0x80, 0x39, 0xc0, 0x30, 0xc0, 0x70, 0xe0, 0x60, 0x60, 0x60, 0x60, 0xe0, 0x70, 0xc0, 0x30}

/* underscore (95) */
#define NXFONT_METRICS_95 {3, 18, 2, 0, 41, 0}
#define NXFONT_BITMAP_95 {0xff, 0xff, 0xc0, 0xff, 0xff, 0xc0}

/* grave (96) */
#define NXFONT_METRICS_96 {1, 6, 5, 1, 12, 0}
#define NXFONT_BITMAP_96 {0xe0, 0xf0, 0x70, 0x38, 0x1c}

/* a (97) */
#define NXFONT_METRICS_97 {2, 16, 18, 1, 19, 0}
#define NXFONT_BITMAP_97 {0xf, 0xe0, 0x3f, 0xf8, 0x3c, 0x78, 0x70, 0x3c, 0x70, 0x1c, 0x0, 0x1c, 0x0, 0x3c, 0x1, 0xfc, 0x1f, 0xfc, 0x7e, 0x1c, 0x78, 0x1c, 0xf0, 0x1c, 0xe0, 0x1c, 0xe0, 0x3c, 0xe0, 0x7c, 0x79, 0xfe, 0x7f, 0xdf, 0x3f, 0x8f}

/* b (98) */
#define NXFONT_METRICS_98 {2, 15, 25, 2, 12, 0}
#define NXFONT_BITMAP_98 {0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe3, 0xe0, 0xef, 0xf0, 0xff, 0xf8, 0xf8, 0x3c, 0xf0, 0x1c, 0xf0, 0x1e, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xf0, 0x1e, 0xf0, 0x1c, 0xfc, 0x3c, 0xff, 0xf8, 0xef, 0xf0, 0xe7, 0xe0}

/* c (99) */
#define NXFONT_METRICS_99 {2, 14, 18, 1, 19, 0}
#define NXFONT_BITMAP_99 {0x7, 0xc0, 0x1f, 0xf0, 0x3f, 0xf8, 0x38, 0x3c, 0x70, 0x1c, 0x70, 0x1c, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x1c, 0xe0, 0x1c, 0x70, 0x1c, 0x78, 0x38, 0x3f, 0xf8, 0x1f, 0xf0, 0x7, 0xc0}

/* d (100) */
#define NXFONT_METRICS_100 {2, 15, 25, 1, 12, 0}
#define NXFONT_BITMAP_100 {0x0, 0xe, 0x0, 0xe, 0x0, 0xe, 0x0, 0xe, 0x0, 0xe, 0x0, 0xe, 0x0, 0xe, 0x7, 0xce, 0x1f, 0xee, 0x3f, 0xfe, 0x7c, 0x3e, 0x70, 0x1e, 0xf0, 0x1e, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xf0, 0x1e, 0xf0, 0x1e, 0x78, 0x3e, 0x7f, 0xfe, 0x3f, 0xee, 0xf, 0xce}

/* e (101) */
#define NXFONT_METRICS_101 {2, 15, 18, 2, 19, 0}
#define NXFONT_BITMAP_101 {0x7, 0xc0, 0x1f, 0xf0, 0x3f, 0xf8, 0x78, 0x3c, 0x70, 0x1c, 0xf0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xff, 0xfe, 0xff, 0xfe, 0xe0, 0x0, 0xe0, 0x0, 0xf0, 0xe, 0x70, 0x1e, 0x78, 0x3c, 0x3f, 0xf8, 0x1f, 0xf0, 0x7, 0xc0}

/* f (102) */
#define NXFONT_METRICS_102 {1, 8, 25, 1, 12, 0}
#define NXFONT_BITMAP_102 {0xf, 0x1f, 0x3c, 0x38, 0x38, 0x38, 0x38, 0xff, 0xff, 0xff, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38}

/* g (103) */
#define NXFONT_METRICS_103 {2, 15, 25, 1, 19, 0}
#define NXFONT_BITMAP_103 {0x7, 0xce, 0x1f, 0xee, 0x3f, 0xfe, 0x7c, 0x3e, 0x70, 0x1e, 0xf0, 0x1e, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xf0, 0x1e, 0x70, 0x3e, 0x78, 0x3e, 0x3f, 0xfe, 0x1f, 0xee, 0x7, 0x8e, 0x0, 0xe, 0xe0, 0xe, 0xe0, 0x1c, 0xf0, 0x1c, 0x7c, 0x78, 0x3f, 0xf8, 0x1f, 0xe0}

/* h (104) */
#define NXFONT_METRICS_104 {2, 14, 25, 2, 12, 0}
#define NXFONT_BITMAP_104 {0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe3, 0xe0, 0xef, 0xf0, 0xff, 0xf8, 0xf8, 0x3c, 0xf0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c}

/* i (105) */
#define NXFONT_METRICS_105 {1, 3, 25, 2, 12, 0}
#define NXFONT_BITMAP_105 {0xe0, 0xe0, 0xe0, 0xe0, 0x0, 0x0, 0x0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0}

/* j (106) -- NOTE: Xoffset should be -1, not 0. */
#define NXFONT_METRICS_106 {1, 6, 32, 0, 12, 0}
#define NXFONT_BITMAP_106 {0x1c, 0x1c, 0x1c, 0x1c, 0x0, 0x0, 0x0, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x3c, 0xfc, 0xf8}

/* k (107) */
#define NXFONT_METRICS_107 {2, 15, 25, 1, 12, 0}
#define NXFONT_BITMAP_107 {0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x78, 0xe0, 0xf0, 0xe1, 0xe0, 0xe3, 0xc0, 0xe7, 0x80, 0xef, 0x0, 0xff, 0x0, 0xff, 0x0, 0xfb, 0x80, 0xf3, 0xc0, 0xe1, 0xc0, 0xe1, 0xe0, 0xe0, 0xe0, 0xe0, 0xf0, 0xe0, 0x78, 0xe0, 0x38, 0xe0, 0x3c, 0xe0, 0x1e}

/* l (108) */
#define NXFONT_METRICS_108 {1, 3, 25, 2, 12, 0}
#define NXFONT_BITMAP_108 {0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0}

/* m (109) */
#define NXFONT_METRICS_109 {3, 23, 18, 2, 19, 0}
#define NXFONT_BITMAP_109 {0xe3, 0xc0, 0xf0, 0xef, 0xf3, 0xfc, 0xff, 0xf7, 0xfc, 0xf8, 0x7e, 0x1e, 0xf0, 0x3c, 0xe, 0xe0, 0x38, 0xe, 0xe0, 0x38, 0xe, 0xe0, 0x38, 0xe, 0xe0, 0x38, 0xe, 0xe0, 0x38, 0xe, 0xe0, 0x38, 0xe, 0xe0, 0x38, 0xe, 0xe0, 0x38, 0xe, 0xe0, 0x38, 0xe, 0xe0, 0x38, 0xe, 0xe0, 0x38, 0xe, 0xe0, 0x38, 0xe, 0xe0, 0x38, 0xe}

/* n (110) */
#define NXFONT_METRICS_110 {2, 14, 18, 2, 19, 0}
#define NXFONT_BITMAP_110 {0xe3, 0xe0, 0xef, 0xf8, 0xff, 0xf8, 0xf8, 0x3c, 0xf0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c}

/* o (111) */
#define NXFONT_METRICS_111 {2, 15, 18, 1, 19, 0}
#define NXFONT_BITMAP_111 {0x7, 0xc0, 0x1f, 0xf0, 0x3f, 0xf8, 0x78, 0x3c, 0x70, 0x1c, 0xf0, 0x1e, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xf0, 0x1e, 0x70, 0x1c, 0x78, 0x3c, 0x3f, 0xf8, 0x1f, 0xf0, 0x7, 0xc0}

/* p (112) */
#define NXFONT_METRICS_112 {2, 15, 25, 2, 19, 0}
#define NXFONT_BITMAP_112 {0x3, 0xc0, 0xef, 0xf0, 0xff, 0xf8, 0xf8, 0x3c, 0xf0, 0x1c, 0xf0, 0x1e, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xf0, 0x1e, 0xf0, 0x1c, 0xf8, 0x3c, 0xff, 0xf8, 0xef, 0xf0, 0xe7, 0xe0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0}

/* q (113) */
#define NXFONT_METRICS_113 {2, 15, 25, 1, 19, 0}
#define NXFONT_BITMAP_113 {0x7, 0xc0, 0x1f, 0xee, 0x3f, 0xfe, 0x7c, 0x3e, 0x70, 0x1e, 0xf0, 0x1e, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xf0, 0x1e, 0x70, 0x1e, 0x78, 0x3e, 0x3f, 0xfe, 0x1f, 0xee, 0xf, 0xce, 0x0, 0xe, 0x0, 0xe, 0x0, 0xe, 0x0, 0xe, 0x0, 0xe, 0x0, 0xe, 0x0, 0xe}

/* r (114) */
#define NXFONT_METRICS_114 {1, 8, 18, 2, 19, 0}
#define NXFONT_BITMAP_114 {0xe7, 0xef, 0xff, 0xfc, 0xf0, 0xf0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0}

/* s (115) */
#define NXFONT_METRICS_115 {2, 13, 18, 2, 19, 0}
#define NXFONT_BITMAP_115 {0xf, 0x80, 0x3f, 0xe0, 0x7f, 0xe0, 0x70, 0xf0, 0xe0, 0x70, 0xe0, 0x0, 0x70, 0x0, 0x7e, 0x0, 0x3f, 0xc0, 0x7, 0xf0, 0x0, 0xf0, 0x0, 0x78, 0xe0, 0x38, 0xe0, 0x38, 0xf0, 0x70, 0x7f, 0xf0, 0x7f, 0xe0, 0x1f, 0x80}

/* t (116) */
#define NXFONT_METRICS_116 {1, 8, 22, 1, 15, 0}
#define NXFONT_BITMAP_116 {0x38, 0x38, 0x38, 0x38, 0xff, 0xff, 0xff, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x3c, 0x3f, 0x1f}

/* u (117) */
#define NXFONT_METRICS_117 {2, 14, 18, 2, 19, 0}
#define NXFONT_BITMAP_117 {0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x3c, 0xf0, 0x7c, 0x7f, 0xfc, 0x7f, 0xdc, 0x1f, 0x1c}

/* v (118) */
#define NXFONT_METRICS_118 {2, 15, 18, 0, 19, 0}
#define NXFONT_BITMAP_118 {0xe0, 0xe, 0xe0, 0xe, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0x7, 0xc0, 0x7, 0xc0, 0x3, 0x80, 0x3, 0x80}

/* w (119) */
#define NXFONT_METRICS_119 {3, 23, 18, 0, 19, 0}
#define NXFONT_BITMAP_119 {0xe0, 0x38, 0xe, 0xe0, 0x38, 0xe, 0x70, 0x7c, 0x1c, 0x70, 0x7c, 0x1c, 0x70, 0x6c, 0x1c, 0x38, 0xee, 0x1c, 0x38, 0xee, 0x38, 0x38, 0xee, 0x38, 0x38, 0xc6, 0x38, 0x18, 0xc6, 0x30, 0x1d, 0xc7, 0x70, 0x1d, 0xc7, 0x70, 0x1d, 0xc7, 0x70, 0xd, 0x83, 0x60, 0xf, 0x83, 0xe0, 0xf, 0x83, 0xe0, 0x7, 0x1, 0xc0, 0x7, 0x1, 0xc0}

/* x (120) */
#define NXFONT_METRICS_120 {2, 15, 18, 0, 19, 0}
#define NXFONT_BITMAP_120 {0xf0, 0x1e, 0x78, 0x1c, 0x38, 0x38, 0x3c, 0x70, 0x1c, 0x70, 0xe, 0xe0, 0xf, 0xe0, 0x7, 0xc0, 0x3, 0x80, 0x7, 0xc0, 0x7, 0xc0, 0xf, 0xe0, 0x1e, 0xe0, 0x1c, 0x70, 0x38, 0x78, 0x38, 0x38, 0x70, 0x1c, 0xf0, 0x1e}

/* y (121) */
#define NXFONT_METRICS_121 {2, 14, 25, 1, 19, 0}
#define NXFONT_BITMAP_121 {0xe0, 0x1c, 0xe0, 0x1c, 0xf0, 0x38, 0x70, 0x38, 0x70, 0x38, 0x70, 0x70, 0x38, 0x70, 0x38, 0x70, 0x38, 0xe0, 0x3c, 0xe0, 0x1c, 0xe0, 0x1d, 0xc0, 0x1d, 0xc0, 0xf, 0xc0, 0xf, 0x80, 0xf, 0x80, 0x7, 0x0, 0x7, 0x0, 0x7, 0x0, 0xe, 0x0, 0xe, 0x0, 0x1c, 0x0, 0x7c, 0x0, 0x78, 0x0, 0x70, 0x0}

/* z (122) */
#define NXFONT_METRICS_122 {2, 14, 18, 1, 19, 0}
#define NXFONT_BITMAP_122 {0x7f, 0xf8, 0x7f, 0xf8, 0x7f, 0xf8, 0x0, 0x78, 0x0, 0xf0, 0x0, 0xe0, 0x1, 0xc0, 0x3, 0xc0, 0x7, 0x80, 0x7, 0x0, 0xe, 0x0, 0x1c, 0x0, 0x3c, 0x0, 0x78, 0x0, 0x70, 0x0, 0xff, 0xfc, 0xff, 0xfc, 0xff, 0xfc}

/* braceleft (123) */
#define NXFONT_METRICS_123 {1, 8, 32, 1, 12, 0}
#define NXFONT_BITMAP_123 {0xf, 0x1f, 0x1c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x38, 0x38, 0x70, 0xe0, 0xe0, 0x70, 0x38, 0x38, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1c, 0x1f, 0xf}

/* bar (124) */
#define NXFONT_METRICS_124 {1, 2, 31, 3, 13, 0}
#define NXFONT_BITMAP_124 {0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0}

/* braceright (125) */
#define NXFONT_METRICS_125 {1, 8, 32, 1, 12, 0}
#define NXFONT_BITMAP_125 {0xf0, 0xf8, 0x38, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1c, 0x1c, 0xe, 0x7, 0x7, 0xe, 0x1c, 0x1c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x38, 0xf8, 0xf0}

/* asciitilde (126) */
#define NXFONT_METRICS_126 {2, 14, 6, 2, 22, 0}
#define NXFONT_BITMAP_126 {0x18, 0x0, 0x7c, 0xc, 0x7f, 0xc, 0xc7, 0xdc, 0xc1, 0xf8, 0x0, 0xf0}

/* exclamdown (161) */
#define NXFONT_METRICS_161 {1, 3, 25, 4, 19, 0}
#define NXFONT_BITMAP_161 {0xe0, 0xe0, 0xe0, 0xe0, 0x0, 0x0, 0x40, 0x40, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0}

/* cent (162) */
#define NXFONT_METRICS_162 {2, 14, 25, 2, 16, 0}
#define NXFONT_BITMAP_162 {0x0, 0x20, 0x0, 0x60, 0x0, 0x40, 0x7, 0xe0, 0x1f, 0xf0, 0x3c, 0xf8, 0x78, 0xbc, 0x70, 0x9c, 0x70, 0x9c, 0xe1, 0x80, 0xe1, 0x0, 0xe1, 0x0, 0xe3, 0x0, 0xe3, 0x0, 0xe2, 0xc, 0xe2, 0x1c, 0x76, 0x1c, 0x7c, 0x3c, 0x3c, 0x78, 0x1f, 0xf0, 0xf, 0xe0, 0x8, 0x0, 0x18, 0x0, 0x10, 0x0, 0x10, 0x0}

/* sterling (163) */
#define NXFONT_METRICS_163 {2, 15, 24, 1, 13, 0}
#define NXFONT_BITMAP_163 {0x3, 0xc0, 0xf, 0xf8, 0x1f, 0xfc, 0x3c, 0x3c, 0x78, 0x1e, 0x70, 0xe, 0x70, 0xe, 0x70, 0x0, 0x70, 0x0, 0x38, 0x0, 0x38, 0x0, 0xff, 0xc0, 0xff, 0xc0, 0xc, 0x0, 0xe, 0x0, 0xe, 0x0, 0xc, 0x0, 0x1c, 0x0, 0x18, 0x0, 0x38, 0x0, 0x73, 0x86, 0xff, 0xfe, 0xff, 0xfe, 0x60, 0x7c}

/* currency (164) */
#define NXFONT_METRICS_164 {2, 12, 13, 3, 19, 0}
#define NXFONT_BITMAP_164 {0xe6, 0x30, 0xff, 0xf0, 0x7f, 0xf0, 0x70, 0xe0, 0x60, 0x60, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0x60, 0x60, 0x70, 0xe0, 0x7f, 0xf0, 0xff, 0xf0, 0xe6, 0x30}

/* yen (165) */
#define NXFONT_METRICS_165 {2, 16, 24, 1, 13, 0}
#define NXFONT_BITMAP_165 {0xe0, 0x7, 0xe0, 0x7, 0x70, 0xe, 0x70, 0xe, 0x38, 0x1c, 0x38, 0x1c, 0x1c, 0x38, 0x1c, 0x38, 0xe, 0x70, 0xe, 0x70, 0x7, 0xe0, 0x7f, 0xfe, 0x7f, 0xfe, 0x7f, 0xfe, 0x1, 0xc0, 0x1, 0xc0, 0x7f, 0xfe, 0x7f, 0xfe, 0x7f, 0xfe, 0x1, 0xc0, 0x1, 0xc0, 0x1, 0xc0, 0x1, 0xc0, 0x1, 0xc0}

/* brokenbar (166) */
#define NXFONT_METRICS_166 {1, 2, 32, 3, 12, 0}
#define NXFONT_BITMAP_166 {0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0}

/* section (167) */
#define NXFONT_METRICS_167 {2, 15, 32, 1, 12, 0}
#define NXFONT_BITMAP_167 {0x3, 0xc0, 0xf, 0xf0, 0x1f, 0xf8, 0x1c, 0x78, 0x38, 0x3c, 0x38, 0x1c, 0x38, 0x1c, 0x3c, 0x0, 0x1e, 0x0, 0x1f, 0x80, 0x3f, 0xe0, 0x71, 0xf0, 0xe0, 0xf8, 0xe0, 0x7c, 0xe0, 0x1c, 0xe0, 0x1e, 0x70, 0xe, 0x7c, 0xe, 0x3e, 0xe, 0x1f, 0x1c, 0xf, 0x9c, 0x3, 0xf8, 0x1, 0xf0, 0x0, 0xf0, 0x0, 0x78, 0x70, 0x38, 0x70, 0x38, 0x78, 0x38, 0x38, 0x70, 0x3f, 0xf0, 0x1f, 0xe0, 0x7, 0x80}

/* dieresis (168) */
#define NXFONT_METRICS_168 {1, 8, 3, 1, 12, 0}
#define NXFONT_BITMAP_168 {0xe7, 0xe7, 0xe7}

/* copyright (169) */
#define NXFONT_METRICS_169 {3, 24, 25, 0, 12, 0}
#define NXFONT_BITMAP_169 {0x0, 0xfe, 0x0, 0x3, 0xff, 0x80, 0x7, 0x1, 0xe0, 0xc, 0x0, 0x70, 0x18, 0x0, 0x18, 0x30, 0x7e, 0xc, 0x60, 0xff, 0x86, 0x61, 0xc1, 0xc6, 0xc3, 0x80, 0xc3, 0xc3, 0x0, 0x3, 0xc7, 0x0, 0x3, 0x86, 0x0, 0x1, 0x86, 0x0, 0x1, 0x86, 0x0, 0x1, 0x86, 0x0, 0x1, 0xc7, 0x0, 0x3, 0xc3, 0x80, 0xc3, 0x61, 0xe1, 0xc6, 0x60, 0xff, 0x86, 0x30, 0x3e, 0xc, 0x18, 0x0, 0x18, 0x1c, 0x0, 0x38, 0x7, 0x1, 0xe0, 0x3, 0xff, 0x80, 0x0, 0xfe, 0x0}

/* ordfeminine (170) */
#define NXFONT_METRICS_170 {2, 10, 15, 1, 12, 0}
#define NXFONT_BITMAP_170 {0x3f, 0x0, 0x77, 0x80, 0x61, 0x80, 0x1, 0x80, 0x7, 0x80, 0x7f, 0x80, 0xe1, 0x80, 0xc1, 0x80, 0xc3, 0x80, 0xe7, 0x80, 0x7d, 0xc0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xc0, 0xff, 0xc0}

/* guillemotleft (171) */
#define NXFONT_METRICS_171 {2, 12, 9, 3, 23, 0}
#define NXFONT_BITMAP_171 {0x1c, 0x70, 0x38, 0xe0, 0x71, 0xc0, 0xe3, 0x80, 0xc3, 0x0, 0xe3, 0x80, 0x71, 0xc0, 0x38, 0xe0, 0x1c, 0x70}

/* logicalnot (172) */
#define NXFONT_METRICS_172 {2, 16, 9, 1, 25, 0}
#define NXFONT_BITMAP_172 {0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x7, 0x0, 0x7, 0x0, 0x7, 0x0, 0x7, 0x0, 0x7, 0x0, 0x7}

/* hyphen (173) */
#define NXFONT_METRICS_173 {1, 8, 2, 1, 27, 0}
#define NXFONT_BITMAP_173 {0xff, 0xff}

/* registered (174) */
#define NXFONT_METRICS_174 {3, 24, 25, 0, 12, 0}
#define NXFONT_BITMAP_174 {0x0, 0x7e, 0x0, 0x3, 0xff, 0x80, 0x7, 0x1, 0xe0, 0xc, 0x0, 0x70, 0x18, 0x0, 0x18, 0x30, 0x0, 0xc, 0x61, 0xff, 0x6, 0x61, 0xff, 0x86, 0xc1, 0x81, 0xc3, 0xc1, 0x80, 0xc3, 0xc1, 0x80, 0xc3, 0x81, 0x81, 0x81, 0x81, 0xff, 0x1, 0x81, 0xfc, 0x1, 0x81, 0x8e, 0x1, 0xc1, 0x86, 0x3, 0xc1, 0x83, 0x3, 0x61, 0x81, 0x86, 0x61, 0x81, 0xc6, 0x30, 0x0, 0xc, 0x18, 0x0, 0x18, 0x1c, 0x0, 0x38, 0x7, 0x1, 0xe0, 0x3, 0xff, 0x80, 0x0, 0x7e, 0x0}

/* macron (175) */
#define NXFONT_METRICS_175 {2, 9, 2, 1, 13, 0}
#define NXFONT_BITMAP_175 {0xff, 0x80, 0xff, 0x80}

/* degree (176) */
#define NXFONT_METRICS_176 {2, 9, 9, 2, 13, 0}
#define NXFONT_BITMAP_176 {0x3e, 0x0, 0x7f, 0x0, 0xe3, 0x80, 0xc1, 0x80, 0xc1, 0x80, 0xc1, 0x80, 0xe3, 0x80, 0x7f, 0x0, 0x3e, 0x0}

/* plusminus (177) */
#define NXFONT_METRICS_177 {3, 17, 21, 1, 16, 0}
#define NXFONT_BITMAP_177 {0x1, 0xc0, 0x0, 0x1, 0xc0, 0x0, 0x1, 0xc0, 0x0, 0x1, 0xc0, 0x0, 0x1, 0xc0, 0x0, 0x1, 0xc0, 0x0, 0x1, 0xc0, 0x0, 0xff, 0xff, 0x80, 0xff, 0xff, 0x80, 0xff, 0xff, 0x80, 0x1, 0xc0, 0x0, 0x1, 0xc0, 0x0, 0x1, 0xc0, 0x0, 0x1, 0xc0, 0x0, 0x1, 0xc0, 0x0, 0x1, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0x80, 0xff, 0xff, 0x80, 0xff, 0xff, 0x80}

/* twosuperior (178) */
#define NXFONT_METRICS_178 {2, 9, 15, 1, 13, 0}
#define NXFONT_BITMAP_178 {0x1e, 0x0, 0x7f, 0x0, 0x63, 0x0, 0xc1, 0x80, 0xc1, 0x80, 0x1, 0x80, 0x3, 0x0, 0x7, 0x0, 0x1e, 0x0, 0x38, 0x0, 0x70, 0x0, 0xe0, 0x0, 0xc0, 0x0, 0xff, 0x80, 0xff, 0x80}

/* threesuperior (179) */
#define NXFONT_METRICS_179 {2, 9, 15, 1, 13, 0}
#define NXFONT_BITMAP_179 {0x3e, 0x0, 0x7f, 0x0, 0xe3, 0x80, 0xc1, 0x80, 0xc1, 0x80, 0x3, 0x80, 0xf, 0x0, 0xf, 0x0, 0x3, 0x80, 0x1, 0x80, 0xc1, 0x80, 0xc1, 0x80, 0xe3, 0x80, 0x7f, 0x0, 0x3e, 0x0}

/* acute (180) */
#define NXFONT_METRICS_180 {1, 7, 5, 3, 10, 0}
#define NXFONT_BITMAP_180 {0x1e, 0x3c, 0x38, 0x70, 0xe0}

/* mu (181) */
#define NXFONT_METRICS_181 {2, 14, 24, 2, 19, 0}
#define NXFONT_BITMAP_181 {0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x3c, 0xf0, 0x7c, 0xff, 0xfc, 0xff, 0xdc, 0xff, 0x1c, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0}

/* paragraph (182) */
#define NXFONT_METRICS_182 {2, 16, 30, 1, 12, 0}
#define NXFONT_BITMAP_182 {0x7, 0xff, 0x1f, 0xff, 0x3f, 0x8c, 0x3f, 0x8c, 0x7f, 0x8c, 0x7f, 0x8c, 0xff, 0x8c, 0xff, 0x8c, 0xff, 0x8c, 0xff, 0x8c, 0x7f, 0x8c, 0x7f, 0x8c, 0x3f, 0x8c, 0x3f, 0x8c, 0x1f, 0x8c, 0x3, 0x8c, 0x1, 0x8c, 0x1, 0x8c, 0x1, 0x8c, 0x1, 0x8c, 0x1, 0x8c, 0x1, 0x8c, 0x1, 0x8c, 0x1, 0x8c, 0x1, 0x8c, 0x1, 0x8c, 0x1, 0x8c, 0x1, 0x8c, 0x1, 0x8c, 0x1, 0x8c}

/* periodcentered (183) */
#define NXFONT_METRICS_183 {1, 4, 4, 3, 22, 0}
#define NXFONT_BITMAP_183 {0x60, 0xf0, 0xf0, 0x60}

/* cedilla (184) */
#define NXFONT_METRICS_184 {1, 7, 7, 2, 37, 0}
#define NXFONT_BITMAP_184 {0x18, 0x18, 0x3c, 0xe, 0x6, 0xce, 0x7c}

/* onesuperior (185) */
#define NXFONT_METRICS_185 {1, 5, 15, 2, 13, 0}
#define NXFONT_BITMAP_185 {0x18, 0x38, 0xf8, 0xf8, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18}

/* ordmasculine (186) */
#define NXFONT_METRICS_186 {2, 10, 15, 1, 12, 0}
#define NXFONT_BITMAP_186 {0x1e, 0x0, 0x7f, 0x80, 0x61, 0x80, 0xe1, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xe1, 0xc0, 0x61, 0x80, 0x7f, 0x80, 0x1e, 0x0, 0x0, 0x0, 0xff, 0xc0, 0xff, 0xc0}

/* guillemotright (187) */
#define NXFONT_METRICS_187 {2, 12, 9, 3, 23, 0}
#define NXFONT_BITMAP_187 {0xe3, 0x80, 0x71, 0xc0, 0x38, 0xe0, 0x1c, 0x70, 0xc, 0x30, 0x1c, 0x70, 0x38, 0xe0, 0x71, 0xc0, 0xe3, 0x80}

/* onequarter (188) */
#define NXFONT_METRICS_188 {4, 25, 25, 1, 12, 0}
#define NXFONT_BITMAP_188 {0x0,  0x0, 0x30, 0x0,  0x18, 0x0, 0x70, 0x0,  0x38, 0x0, 0x60, 0x0,  0xf8, 0x0, 0xe0, 0x0,  0xf8, 0x1,  0xc0, 0x0,  0x18, 0x1,  0x80, 0x0,  0x18, 0x3,  0x80, 0x0,  0x18, 0x3,  0x0, 0x0, 0x18,\
                           0x7,  0x0, 0x0,  0x18, 0xe,  0x0, 0x0,  0x18, 0xc,  0x0, 0x0,  0x18, 0x1c, 0x6, 0x0,  0x18, 0x18, 0xe,  0x0,  0x18, 0x38, 0x1e, 0x0,  0x18, 0x70, 0x3e, 0x0,  0x18, 0x60, 0x76, 0x0, 0x0, 0xe0,\
                           0x66, 0x0, 0x1,  0xc0, 0xc6, 0x0, 0x1,  0x81, 0xc6, 0x0, 0x3, 0x83,  0x86, 0x0, 0x3,  0x3,  0xff, 0x80, 0x7,  0x3,  0xff, 0x80, 0x6,  0x0,  0x6,  0x0,  0xe,  0x0,  0x6,  0x0,  0xc, 0x0, 0x6, 0x0}

/* onehalf (189) */
#define NXFONT_METRICS_189 {4, 25, 25, 1, 12, 0}
#define NXFONT_BITMAP_189 {0x0, 0x0, 0x60, 0x0,  0x18, 0x0,  0xe0, 0x0,  0x38, 0x0,  0xc0, 0x0,  0xf8, 0x1,  0x80, 0x0,  0xf8, 0x3,  0x80, 0x0,  0x18, 0x3,  0x0,  0x0,  0x18, 0x6,  0x0,  0x0,  0x18, 0xe,  0x0,  0x0, 0x18,\
                           0xc, 0x0, 0x0,  0x18, 0x1c, 0x0,  0x0,  0x18, 0x18, 0x0,  0x0,  0x18, 0x38, 0x3c, 0x0,  0x18, 0x30, 0xff, 0x0,  0x18, 0x70, 0xc3, 0x80, 0x18, 0x61, 0x81, 0x80, 0x18, 0xc1, 0x81, 0x80, 0x1, 0xc0,\
                           0x3, 0x80, 0x1, 0x80, 0x7,  0x0,  0x3,  0x80, 0xe,  0x0,  0x3,  0x0,  0x3c, 0x0,  0x6,  0x0,  0x70, 0x0,  0xe,  0x0,  0xe0, 0x0,  0xc,  0x1,  0xc0, 0x0,  0x1c, 0x1,  0xff, 0x80, 0x18, 0x1, 0xff, 0x80}

/* threequarters (190) */
#define NXFONT_METRICS_190 {4, 25, 24, 1, 13, 0}
#define NXFONT_BITMAP_190 {0x3e, 0x0,  0xe, 0x0, 0x7f, 0x0,  0xc, 0x0,  0x63, 0x80, 0x18, 0x0,  0xc1, 0x80, 0x38, 0x0,  0xc1, 0x80, 0x30, 0x0,  0x3,  0x80, 0x60, 0x0,  0xf,  0x0, 0xe0, 0x0,  0xf,  0x80, 0xc0, 0x0,  0x1,\
                           0xc1, 0x80, 0x0, 0x0, 0xc3, 0x80, 0x0, 0xc0, 0xc3, 0x6,  0x0,  0xc0, 0xc7, 0xe,  0x0,  0x61, 0xce, 0x1e, 0x0,  0x7f, 0x8c, 0x3e, 0x0,  0x1e, 0x18, 0x76, 0x0, 0x0,  0x38, 0x66, 0x0,  0x0,  0x30,\
                           0xc6, 0x0, 0x0, 0x61, 0xc6, 0x0, 0x0, 0xe3, 0x86, 0x0, 0x1, 0xc3, 0xff, 0x80, 0x1, 0x83, 0xff, 0x80, 0x3, 0x0, 0x6, 0x0, 0x7, 0x0, 0x6, 0x0, 0x6, 0x0, 0x6, 0x0}

/* questiondown (191) */
#define NXFONT_METRICS_191 {2, 14, 25, 3, 19, 0}
#define NXFONT_BITMAP_191 {0x3, 0x80, 0x3, 0x80, 0x3, 0x80, 0x3, 0x80, 0x0, 0x0, 0x0, 0x0, 0x3, 0x80, 0x3, 0x80, 0x3, 0x80, 0x7, 0x80, 0x7, 0x0, 0xf, 0x0, 0x1e, 0x0, 0x3c, 0x0, 0x78, 0x0, 0x70, 0x0, 0xf0, 0x0, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xf0, 0x3c, 0x78, 0x78, 0x7f, 0xf0, 0x3f, 0xe0, 0x7, 0x80}

/* Agrave (192) */
#define NXFONT_METRICS_192 {3, 20, 31, 1, 6, 0}
#define NXFONT_BITMAP_192 {0x3,  0xc0, 0x0,  0x1, 0xe0, 0x0,  0x0, 0xe0, 0x0,  0x0, 0x70, 0x0,  0x0, 0x38, 0x0,  0x0, 0x0,  0x0,  0x0, 0xf0, 0x0,  0x0, 0xf0, 0x0, 0x0, 0xf0, 0x0, 0x1,  0xf8, 0x0,  0x1,  0xf8, 0x0,  0x3,  0xfc,\
                           0x0,  0x3,  0x9c, 0x0, 0x3,  0x9c, 0x0, 0x7,  0x9e, 0x0, 0x7,  0xe,  0x0, 0x7,  0xe,  0x0, 0xf,  0xf,  0x0, 0xe,  0xf,  0x0, 0xe,  0x7, 0x0, 0x1e, 0x7, 0x80, 0x1f, 0xff, 0x80, 0x1f, 0xff, 0x80, 0x3f,\
                           0xff, 0xc0, 0x3c, 0x3, 0xc0, 0x38, 0x1, 0xc0, 0x78, 0x1, 0xe0, 0x78, 0x1, 0xe0, 0x70, 0x0, 0xe0, 0xf0, 0x0, 0xf0, 0xf0, 0x0, 0xf0}

/* Aacute (193) */
#define NXFONT_METRICS_193 {3, 20, 31, 1, 6, 0}
#define NXFONT_BITMAP_193 {0x0, 0x3c, 0x0, 0x0, 0x78, 0x0, 0x0, 0x70, 0x0, 0x0, 0xe0, 0x0, 0x1, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x0, 0xf0, 0x0, 0x0,  0xf0, 0x0,  0x1,  0xf8, 0x0,  0x1,  0xf8, 0x0,  0x3,  0xfc, 0x0,\
                           0x3, 0x9c, 0x0, 0x3, 0x9c, 0x0, 0x7, 0x9e, 0x0, 0x7, 0xe,  0x0, 0x7, 0xe,  0x0, 0xf, 0xf, 0x0, 0xf, 0xf,  0x0, 0xe, 0x7,  0x0, 0x1e, 0x7,  0x80, 0x1f, 0xff, 0x80, 0x1f, 0xff, 0x80, 0x3f, 0xff, 0xc0,\
                           0x3c, 0x3, 0xc0, 0x78, 0x1, 0xc0, 0x78, 0x1, 0xe0, 0x78, 0x1, 0xe0, 0x70, 0x0, 0xe0, 0xf0, 0x0, 0xf0, 0xf0, 0x0, 0xf0}

/* Acircumflex (194) */
#define NXFONT_METRICS_194 {3, 20, 31, 1, 6, 0}
#define NXFONT_BITMAP_194 {0x0,  0x40, 0x0,  0x0,  0xe0, 0x0,  0x1,  0xf0, 0x0,  0x3,  0xb8, 0x0,  0x7,  0x1c, 0x0,  0x0,  0x0,  0x0, 0x0,  0xf0, 0x0, 0x0,  0xf0, 0x0, 0x0, 0xf0, 0x0, 0x1, 0xf8, 0x0,  0x1,  0xf8, 0x0,  0x3,\
                           0xfc, 0x0,  0x3,  0x9c, 0x0,  0x3,  0x9c, 0x0,  0x7,  0x9e, 0x0,  0x7,  0xe,  0x0,  0x7,  0xe,  0x0,  0xf, 0xf,  0x0,  0xf, 0xf,  0x0,  0xe, 0x7, 0x0, 0x1e, 0x7, 0x80, 0x1f, 0xff, 0x80, 0x1f, 0xff,\
                           0x80, 0x3f, 0xff, 0xc0, 0x3c, 0x3,  0xc0, 0x38, 0x1,  0xc0, 0x78, 0x1,  0xe0, 0x78, 0x1,  0xe0, 0x70, 0x0, 0xe0, 0xf0, 0x0, 0xf0, 0xf0, 0x0, 0xf0}

/* Atilde (195) */
#define NXFONT_METRICS_195 {3, 20, 30, 1, 7, 0}
#define NXFONT_BITMAP_195 {0x1, 0xc6, 0x0,  0x3, 0xfe, 0x0,  0x7, 0xfc, 0x0,  0x6, 0x38, 0x0,  0x0, 0x0,  0x0,  0x0, 0xf0, 0x0,  0x0, 0xf0, 0x0, 0x0, 0xf0, 0x0, 0x1,  0xf8, 0x0,  0x1,  0xf8, 0x0,  0x3,  0xfc, 0x0,  0x3, 0x9c,\
                           0x0, 0x3,  0x9c, 0x0, 0x7,  0x9e, 0x0, 0x7,  0xe,  0x0, 0x7,  0xe,  0x0, 0xf,  0xf,  0x0, 0xf,  0xf,  0x0, 0xe,  0x7, 0x0, 0x1e, 0x7, 0x80, 0x1f, 0xff, 0x80, 0x1f, 0xff, 0x80, 0x3f, 0xff, 0xc0, 0x3c,\
                           0x3, 0xc0, 0x38, 0x1, 0xc0, 0x78, 0x1, 0xe0, 0x78, 0x1, 0xe0, 0x70, 0x0, 0xe0, 0xf0, 0x0, 0xf0, 0xf0, 0x0, 0xf0}

/* Adieresis (196) */
#define NXFONT_METRICS_196 {3, 20, 30, 1, 7, 0}
#define NXFONT_BITMAP_196 {0x3, 0x9c, 0x0,  0x3, 0x9c, 0x0,  0x3, 0x9c, 0x0,  0x0, 0x0,  0x0,  0x0,  0x0,  0x0, 0x0, 0xf0, 0x0, 0x0, 0xf0, 0x0, 0x0, 0xf0, 0x0, 0x1,  0xf8, 0x0,  0x1,  0xf8, 0x0,  0x3,  0xfc, 0x0,  0x3,  0x9c,\
                           0x0, 0x3,  0x9c, 0x0, 0x7,  0x9e, 0x0, 0x7,  0xe,  0x0, 0x7,  0xe,  0x0,  0xf,  0xf, 0x0, 0xf,  0xf, 0x0, 0xe,  0x7, 0x0, 0x1e, 0x7, 0x80, 0x1f, 0xff, 0x80, 0x1f, 0xff, 0x80, 0x3f, 0xff, 0xc0, 0x3c,\
                           0x3, 0xc0, 0x38, 0x1, 0xc0, 0x78, 0x1, 0xe0, 0x78, 0x1, 0xe0, 0x70, 0x0, 0xe0, 0xf0, 0x0, 0xf0, 0xf0, 0x0, 0xf0}

/* Aring (197) */
#define NXFONT_METRICS_197 {3, 20, 31, 1, 6, 0}
#define NXFONT_BITMAP_197 {0x0,  0xf0, 0x0,  0x1,  0x98, 0x0,  0x1,  0x8, 0x0,  0x1,  0x8, 0x0,  0x1,  0x98, 0x0,  0x0,  0xf0, 0x0,  0x0,  0x0, 0x0,  0x0,  0xf0, 0x0, 0x0, 0xf0, 0x0,  0x1, 0xf8, 0x0,  0x1,  0xf8, 0x0,  0x3,\
                           0xfc, 0x0,  0x3,  0x9c, 0x0,  0x3,  0x9c, 0x0,  0x7, 0x9e, 0x0, 0x7,  0xe,  0x0,  0x7,  0xe,  0x0,  0xf,  0xf,  0x0,  0xe, 0xf,  0x0,  0xe, 0x7, 0x0,  0x1e, 0x7, 0x80, 0x1f, 0xff, 0x80, 0x1f, 0xff,\
                           0x80, 0x3f, 0xff, 0xc0, 0x3c, 0x3,  0xc0, 0x38, 0x1, 0xc0, 0x78, 0x1, 0xe0, 0x78, 0x1,  0xe0, 0x70, 0x0,  0xe0, 0xf0, 0x0, 0xf0, 0xf0, 0x0, 0xf0}

/* AE (198) */
#define NXFONT_METRICS_198 {4, 29, 25, 1, 12, 0}
#define NXFONT_BITMAP_198 {0x0,  0x7f, 0xff, 0xf8, 0x0,  0x7f, 0xff, 0xf8, 0x0,  0xff, 0xff, 0xf8, 0x0,  0xe3, 0x80, 0x0, 0x1,  0xc3, 0x80, 0x0, 0x1,  0xc3, 0x80, 0x0,  0x3,  0xc3, 0x80, 0x0,  0x3,  0x83, 0x80, 0x0,  0x3,\
                           0x83, 0x80, 0x0,  0x7,  0x83, 0x80, 0x0,  0x7,  0x3,  0x80, 0x0,  0x7,  0x3,  0xff, 0xf0, 0xf, 0x3,  0xff, 0xf0, 0xe, 0x3,  0xff, 0xf0, 0x1e, 0x3,  0x80, 0x0,  0x1f, 0xff, 0x80, 0x0,  0x1f, 0xff,\
                           0x80, 0x0,  0x3f, 0xff, 0x80, 0x0,  0x38, 0x3,  0x80, 0x0,  0x78, 0x3,  0x80, 0x0,  0x78, 0x3, 0x80, 0x0,  0x70, 0x3, 0x80, 0x0,  0xf0, 0x3,  0xff, 0xf8, 0xe0, 0x3,  0xff, 0xf8, 0xe0, 0x3,  0xff, 0xf8}

/* Ccedilla (199) */
#define NXFONT_METRICS_199 {3, 20, 32, 2, 12, 0}
#define NXFONT_BITMAP_199 {0x1,  0xf8, 0x0,  0x7, 0xfe, 0x0,  0xf, 0xff, 0x80, 0x1f, 0x7, 0x80, 0x3c, 0x3,  0xc0, 0x78, 0x1,  0xe0, 0x70, 0x0,  0xe0, 0x70, 0x0,  0xe0, 0xf0, 0x0,  0x0,  0xf0, 0x0,  0x0,  0xe0, 0x0,  0x0, 0xe0,\
                           0x0,  0x0,  0xe0, 0x0, 0x0,  0xe0, 0x0, 0x0,  0xe0, 0x0,  0x0, 0xf0, 0x0,  0x70, 0xf0, 0x0,  0x70, 0x70, 0x0,  0xf0, 0x70, 0x0,  0xe0, 0x78, 0x1,  0xe0, 0x3c, 0x3,  0xc0, 0x1f, 0x7,  0xc0, 0xf, 0xff,\
                           0x80, 0x7,  0xfe, 0x0, 0x1,  0xf8, 0x0, 0x0,  0x60, 0x0,  0x0, 0x60, 0x0,  0x0,  0xf0, 0x0,  0x0,  0x38, 0x0,  0x0,  0x18, 0x0,  0x3,  0x38, 0x0,  0x1,  0xf0, 0x0}

/* Egrave (200) */
#define NXFONT_METRICS_200 {3, 17, 31, 3, 6, 0}
#define NXFONT_BITMAP_200 {0xf, 0x0,  0x0,  0x7, 0x80, 0x0,  0x3, 0x80, 0x0,  0x1, 0xc0, 0x0,  0x0, 0xe0, 0x0,  0x0,  0x0,  0x0,  0xff, 0xff, 0x0,  0xff, 0xff, 0x0,  0xff, 0xff, 0x0, 0xe0, 0x0,  0x0, 0xe0, 0x0,  0x0, 0xe0, 0x0,\
                           0x0, 0xe0, 0x0,  0x0, 0xe0, 0x0,  0x0, 0xe0, 0x0,  0x0, 0xe0, 0x0,  0x0, 0xe0, 0x0,  0x0,  0xff, 0xff, 0x0,  0xff, 0xff, 0x0,  0xff, 0xff, 0x0,  0xe0, 0x0, 0x0,  0xe0, 0x0, 0x0,  0xe0, 0x0, 0x0,  0xe0,\
                           0x0, 0x0,  0xe0, 0x0, 0x0,  0xe0, 0x0, 0x0,  0xe0, 0x0, 0x0,  0xe0, 0x0, 0x0,  0xff, 0xff, 0x80, 0xff, 0xff, 0x80, 0xff, 0xff, 0x80}

/* Eacute (201) */
#define NXFONT_METRICS_201 {3, 17, 31, 3, 6, 0}
#define NXFONT_BITMAP_201 {0x0, 0x78, 0x0,  0x0, 0xf0, 0x0,  0x0, 0xe0, 0x0,  0x1, 0xc0, 0x0,  0x3, 0x80, 0x0,  0x0,  0x0,  0x0,  0xff, 0xff, 0x0,  0xff, 0xff, 0x0,  0xff, 0xff, 0x0, 0xe0, 0x0,  0x0, 0xe0, 0x0,  0x0, 0xe0, 0x0,\
                           0x0, 0xe0, 0x0,  0x0, 0xe0, 0x0,  0x0, 0xe0, 0x0,  0x0, 0xe0, 0x0,  0x0, 0xe0, 0x0,  0x0,  0xff, 0xff, 0x0,  0xff, 0xff, 0x0,  0xff, 0xff, 0x0,  0xe0, 0x0, 0x0,  0xe0, 0x0, 0x0,  0xe0, 0x0, 0x0,  0xe0,\
                           0x0, 0x0,  0xe0, 0x0, 0x0,  0xe0, 0x0, 0x0,  0xe0, 0x0, 0x0,  0xe0, 0x0, 0x0,  0xff, 0xff, 0x80, 0xff, 0xff, 0x80, 0xff, 0xff, 0x80}

/* Ecircumflex (202) */
#define NXFONT_METRICS_202 {3, 17, 31, 3, 6, 0}
#define NXFONT_BITMAP_202 {0x0, 0x80, 0x0,  0x1, 0xc0, 0x0,  0x3, 0xe0, 0x0,  0x7, 0x70, 0x0,  0xe, 0x38, 0x0,  0x0,  0x0,  0x0,  0xff, 0xff, 0x0,  0xff, 0xff, 0x0, 0xff, 0xff, 0x0, 0xe0, 0x0,  0x0, 0xe0, 0x0,  0x0, 0xe0, 0x0,\
                           0x0, 0xe0, 0x0,  0x0, 0xe0, 0x0,  0x0, 0xe0, 0x0,  0x0, 0xe0, 0x0,  0x0, 0xe0, 0x0,  0x0,  0xff, 0xff, 0x0,  0xff, 0xff, 0x0,  0xff, 0xff, 0x0, 0xe0, 0x0, 0x0,  0xe0, 0x0, 0x0,  0xe0, 0x0, 0x0,  0xe0,\
                           0x0, 0x0,  0xe0, 0x0, 0x0,  0xe0, 0x0, 0x0,  0xe0, 0x0, 0x0,  0xe0, 0x0, 0x0,  0xff, 0xff, 0x80, 0xff, 0xff, 0x80, 0xff, 0xff, 0x80}

/* Edieresis (203) */
#define NXFONT_METRICS_203 {3, 17, 30, 3, 7, 0}
#define NXFONT_BITMAP_203 {0x1c, 0x38, 0x0,  0x1c, 0x38, 0x0,  0x1c, 0x38, 0x0,  0x0, 0x0,  0x0,  0x0, 0x0,  0x0,  0xff, 0xff, 0x0,  0xff, 0xff, 0x0,  0xff, 0xff, 0x0,  0xe0, 0x0, 0x0,  0xe0, 0x0, 0x0,  0xe0, 0x0, 0x0,  0xe0,\
                           0x0,  0x0,  0xe0, 0x0,  0x0,  0xe0, 0x0,  0x0,  0xe0, 0x0, 0x0,  0xe0, 0x0, 0x0,  0xff, 0xff, 0x0,  0xff, 0xff, 0x0,  0xff, 0xff, 0x0,  0xe0, 0x0,  0x0, 0xe0, 0x0,  0x0, 0xe0, 0x0,  0x0, 0xe0, 0x0,\
                           0x0,  0xe0, 0x0,  0x0,  0xe0, 0x0,  0x0,  0xe0, 0x0,  0x0, 0xe0, 0x0,  0x0, 0xff, 0xff, 0x80, 0xff, 0xff, 0x80, 0xff, 0xff, 0x80}

/* Igrave (204) */
#define NXFONT_METRICS_204 {1, 7, 31, 0, 6, 0}
#define NXFONT_BITMAP_204 {0xf0, 0x78, 0x38, 0x1c, 0xe, 0x0, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c}

/* Iacute (205) */
#define NXFONT_METRICS_205 {1, 7, 31, 2, 6, 0}
#define NXFONT_BITMAP_205 {0x1e, 0x3c, 0x38, 0x70, 0xe0, 0x0, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70}

/* Icircumflex (206) */
#define NXFONT_METRICS_206 {2, 9, 31, 0, 6, 0}
#define NXFONT_BITMAP_206 {0x8, 0x0, 0x1c, 0x0, 0x3e, 0x0, 0x77, 0x0, 0xe3, 0x80, 0x0, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0}

/* Idieresis (207) */
#define NXFONT_METRICS_207 {2, 9, 30, 0, 7, 0}
#define NXFONT_BITMAP_207 {0xe3, 0x80, 0xe3, 0x80, 0xe3, 0x80, 0x0, 0x0, 0x0, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0}

/* Eth (208) */
#define NXFONT_METRICS_208 {3, 21, 25, 0, 12, 0}
#define NXFONT_BITMAP_208 {0x1f, 0xfe, 0x0, 0x1f, 0xff, 0x80, 0x1f, 0xff, 0xc0, 0x1c, 0x3, 0xe0, 0x1c, 0x0, 0xe0, 0x1c, 0x0, 0xf0, 0x1c, 0x0, 0x70, 0x1c, 0x0, 0x70, 0x1c, 0x0, 0x38, 0x1c, 0x0, 0x38, 0x1c, 0x0, 0x38, 0xff, 0xc0, 0x38, 0xff, 0xc0, 0x38, 0x1c, 0x0, 0x38, 0x1c, 0x0, 0x38, 0x1c, 0x0, 0x38, 0x1c, 0x0, 0x78, 0x1c, 0x0, 0x70, 0x1c, 0x0, 0x70, 0x1c, 0x0, 0xf0, 0x1c, 0x0, 0xe0, 0x1c, 0x3, 0xc0, 0x1f, 0xff, 0xc0, 0x1f, 0xff, 0x80, 0x1f, 0xfe, 0x0}

/* Ntilde (209) */
#define NXFONT_METRICS_209 {3, 19, 30, 2, 7, 0}
#define NXFONT_BITMAP_209 {0x1,  0xc6, 0x0,  0x3,  0xfe, 0x0,  0x7,  0xfc, 0x0,  0x6,  0x38, 0x0,  0x0, 0x0,   0x0,  0xf0, 0x0,  0xe0, 0xf8, 0x0,  0xe0, 0xf8, 0x0,  0xe0, 0xfc, 0x0,  0xe0, 0xfc, 0x0,  0xe0, 0xfe, 0x0,\
                           0xe0, 0xef, 0x0,  0xe0, 0xe7, 0x0,  0xe0, 0xe7, 0x80, 0xe0, 0xe3, 0xc0, 0xe0, 0xe3, 0xc0, 0xe0, 0xe1, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xf0, 0xe0, 0xe0, 0x78, 0xe0, 0xe0, 0x38, 0xe0, 0xe0,\
                           0x3c, 0xe0, 0xe0, 0x1c, 0xe0, 0xe0, 0x1e, 0xe0, 0xe0, 0xf,  0xe0, 0xe0, 0x7,  0xe0, 0xe0, 0x7,  0xe0, 0xe0, 0x3,  0xe0, 0xe0, 0x1,  0xe0, 0xe0, 0x1,  0xe0}

/* Ograve (210) */
#define NXFONT_METRICS_210 {3, 23, 31, 1, 6, 0}
#define NXFONT_BITMAP_210 {0x0,  0xf0, 0x0,  0x0,  0x78, 0x0,  0x0,  0x38, 0x0,  0x0,  0x1c, 0x0,  0x0,  0xe,  0x0,  0x0,  0x0,  0x0,  0x0,  0xfe, 0x0,  0x3,  0xff, 0x80, 0xf,  0xff, 0xe0, 0x1f, 0x1,  0xf0, 0x3e, 0x0,  0xf8,\
                           0x3c, 0x0,  0x78, 0x78, 0x0,  0x3c, 0x70, 0x0,  0x1c, 0x70, 0x0,  0x1c, 0xf0, 0x0,  0x1e, 0xe0, 0x0,  0xe,  0xe0, 0x0,  0xe,  0xe0, 0x0,  0xe,  0xe0, 0x0,  0xe,  0xe0, 0x0,  0xe,  0xf0, 0x0,  0x1e,\
                           0xf0, 0x0,  0x1e, 0x70, 0x0,  0x1c, 0x78, 0x0,  0x3c, 0x3c, 0x0,  0x78, 0x3e, 0x0,  0xf8, 0x1f, 0x1,  0xf0, 0xf,  0xff, 0xe0, 0x3,  0xff, 0x80, 0x0,  0xfe, 0x0}

/* Oacute (211) */
#define NXFONT_METRICS_211 {3, 23, 31, 1, 6, 0}
#define NXFONT_BITMAP_211 {0x0,  0xf,  0x0,  0x0,  0x1e, 0x0,  0x0,  0x1c, 0x0,  0x0,  0x38, 0x0,  0x0,  0x70, 0x0,  0x0,  0x0,  0x0,  0x0, 0xfe, 0x0, 0x3,  0xff, 0x80, 0xf,  0xff, 0xe0, 0x1f, 0x1,  0xf0, 0x3e, 0x0, \
                           0xf8, 0x3c, 0x0,  0x78, 0x78, 0x0,  0x3c, 0x70, 0x0,  0x1c, 0x70, 0x0,  0x1c, 0xf0, 0x0,  0x1e, 0xe0, 0x0,  0xe, 0xe0, 0x0, 0xe,  0xe0, 0x0,  0xe,  0xe0, 0x0,  0xe,  0xe0, 0x0,  0xe,  0xf0,\
                           0x0,  0x1e, 0xf0, 0x0,  0x1e, 0x70, 0x0,  0x1c, 0x78, 0x0,  0x3c, 0x3c, 0x0,  0x78, 0x3e, 0x0,  0xf8, 0x1f, 0x1, 0xf0, 0xf, 0xff, 0xe0, 0x3,  0xff, 0x80, 0x0,  0xfe, 0x0}

/* Ocircumflex (212) */
#define NXFONT_METRICS_212 {3, 23, 31, 1, 6, 0}
#define NXFONT_BITMAP_212 {0x0,  0x10, 0x0,  0x0,  0x38, 0x0,  0x0,  0x7c, 0x0,  0x0,  0xee, 0x0,  0x1,  0xc7, 0x0,  0x0,  0x0,  0x0, 0x0,  0xfe, 0x0,  0x3,  0xff, 0x80, 0xf,  0xff, 0xe0, 0x1f, 0x1, 0xf0, 0x3e, 0x0,\
                           0xf8, 0x3c, 0x0,  0x78, 0x78, 0x0,  0x3c, 0x70, 0x0,  0x1c, 0x70, 0x0,  0x1c, 0xf0, 0x0,  0x1e, 0xe0, 0x0,  0xe, 0xe0, 0x0,  0xe,  0xe0, 0x0,  0xe,  0xe0, 0x0,  0xe,  0xe0, 0x0, 0xe,  0xf0,\
                           0x0,  0x1e, 0xf0, 0x0,  0x1e, 0x70, 0x0,  0x1c, 0x78, 0x0,  0x3c, 0x3c, 0x0,  0x78, 0x3e, 0x0,  0xf8, 0x1f, 0x1, 0xf0, 0xf,  0xff, 0xe0, 0x3,  0xff, 0x80, 0x0,  0xfe, 0x0}

/* Otilde (213) */
#define NXFONT_METRICS_213 {3, 23, 30, 1, 7, 0}
#define NXFONT_BITMAP_213 {0x0,  0x71, 0x80, 0x0,  0xff, 0x80, 0x1,  0xff, 0x0,  0x1,  0x8e, 0x0,  0x0,  0x0,  0x0,  0x0, 0xfe, 0x0, 0x3,  0xff, 0x80, 0xf,  0xff, 0xe0, 0x1f, 0x1,  0xf0, 0x3e, 0x0,  0xf8, 0x3c, 0x0,\
                           0x78, 0x78, 0x0,  0x3c, 0x70, 0x0,  0x1c, 0x70, 0x0,  0x1c, 0xf0, 0x0,  0x1e, 0xe0, 0x0,  0xe, 0xe0, 0x0, 0xe,  0xe0, 0x0,  0xe,  0xe0, 0x0,  0xe,  0xe0, 0x0,  0xe,  0xf0, 0x0,  0x1e, 0xf0,\
                           0x0,  0x1e, 0x70, 0x0,  0x1c, 0x78, 0x0,  0x3c, 0x3c, 0x0,  0x78, 0x3e, 0x0,  0xf8, 0x1f, 0x1, 0xf0, 0xf, 0xff, 0xe0, 0x3,  0xff, 0x80, 0x0,  0xfe, 0x0}

/* Odieresis (214) */
#define NXFONT_METRICS_214 {3, 23, 29, 1, 8, 0}
#define NXFONT_BITMAP_214 {0x1, 0xc3, 0x80, 0x1, 0xc3, 0x80, 0x1, 0xc3, 0x80, 0x0, 0x0, 0x0, 0x0, 0xfe, 0x0, 0x3, 0xff, 0x80, 0xf, 0xff, 0xe0, 0x1f, 0x1, 0xf0, 0x3e, 0x0, 0xf8, 0x3c, 0x0, 0x78, 0x78, 0x0, 0x3c, 0x70, 0x0, 0x1c, 0x70, 0x0, 0x1c, 0xf0, 0x0, 0x1e, 0xe0, 0x0, 0xe, 0xe0, 0x0, 0xe, 0xe0, 0x0, 0xe, 0xe0, 0x0, 0xe, 0xe0, 0x0, 0xe, 0xf0, 0x0, 0x1e, 0xf0, 0x0, 0x1e, 0x70, 0x0, 0x1c, 0x78, 0x0, 0x3c, 0x3c, 0x0, 0x78, 0x3e, 0x0, 0xf8, 0x1f, 0x1, 0xf0, 0xf, 0xff, 0xe0, 0x3, 0xff, 0x80, 0x0, 0xfe, 0x0}

/* multiply (215) */
#define NXFONT_METRICS_215 {2, 15, 15, 2, 21, 0}
#define NXFONT_BITMAP_215 {0x40, 0x4, 0xe0, 0xe, 0xf0, 0x1e, 0x78, 0x3c, 0x3c, 0x78, 0x1f, 0xf0, 0xf, 0xe0, 0x7, 0xc0, 0x7, 0xc0, 0xf, 0xe0, 0x1e, 0xf0, 0x3c, 0x78, 0x78, 0x3c, 0xf0, 0x1e, 0x60, 0xc}

/* Oslash (216) */
#define NXFONT_METRICS_216 {3, 23, 25, 1, 12, 0}
#define NXFONT_BITMAP_216 {0x0, 0xfe, 0x6, 0x3, 0xff, 0x8c, 0xf, 0xff, 0xf8, 0x1f, 0x1, 0xf0, 0x3e, 0x0, 0xf8, 0x3c, 0x0, 0xf8, 0x78, 0x1, 0xbc, 0x70, 0x3, 0x1c, 0x70, 0x6, 0x1c, 0xf0, 0x6, 0x1e, 0xe0, 0xc, 0xe, 0xe0, 0x18, 0xe, 0xe0, 0x30, 0xe, 0xe0, 0x60, 0xe, 0xe0, 0xc0, 0xe, 0xe1, 0x80, 0x1e, 0xf3, 0x0, 0x1e, 0x76, 0x0, 0x1c, 0x7c, 0x0, 0x3c, 0x3c, 0x0, 0x78, 0x3e, 0x0, 0xf8, 0x3f, 0x1, 0xf0, 0x6f, 0xff, 0xe0, 0xc3, 0xff, 0x80, 0x0, 0xfe, 0x0}

/* Ugrave (217) */
#define NXFONT_METRICS_217 {3, 18, 31, 3, 6, 0}
#define NXFONT_BITMAP_217 {0x7,  0x80, 0x0,  0x3,  0xc0, 0x0,  0x1,  0xc0, 0x0,  0x0,  0xe0, 0x0,  0x0,  0x70, 0x0,  0x0,  0x0,  0x0,  0xe0, 0x1,  0xc0, 0xe0, 0x1,  0xc0, 0xe0, 0x1,  0xc0, 0xe0, 0x1,  0xc0, 0xe0,\
                           0x1,  0xc0, 0xe0, 0x1,  0xc0, 0xe0, 0x1,  0xc0, 0xe0, 0x1,  0xc0, 0xe0, 0x1,  0xc0, 0xe0, 0x1,  0xc0, 0xe0, 0x1,  0xc0, 0xe0, 0x1,  0xc0, 0xe0, 0x1,  0xc0, 0xe0, 0x1,  0xc0, 0xe0, 0x1,\
                           0xc0, 0xe0, 0x1,  0xc0, 0xe0, 0x1,  0xc0, 0xe0, 0x1,  0xc0, 0xe0, 0x1,  0xc0, 0xf0, 0x3,  0xc0, 0x78, 0x7,  0x80, 0x7c, 0xf,  0x80, 0x3f, 0xff, 0x0,  0x1f, 0xfe, 0x0,  0x3,  0xf0, 0x0}

/* Uacute (218) */
#define NXFONT_METRICS_218 {3, 18, 31, 3, 6, 0}
#define NXFONT_BITMAP_218 {0x0, 0x78, 0x0,  0x0, 0xf0, 0x0,  0x0, 0xe0, 0x0,  0x1, 0xc0, 0x0,  0x3, 0x80, 0x0,  0x0, 0x0,  0x0,  0xe0, 0x1,  0xc0, 0xe0, 0x1,  0xc0, 0xe0, 0x1,  0xc0, 0xe0, 0x1,  0xc0, 0xe0,\
                           0x1, 0xc0, 0xe0, 0x1, 0xc0, 0xe0, 0x1, 0xc0, 0xe0, 0x1, 0xc0, 0xe0, 0x1, 0xc0, 0xe0, 0x1, 0xc0, 0xe0, 0x1,  0xc0, 0xe0, 0x1,  0xc0, 0xe0, 0x1,  0xc0, 0xe0, 0x1,  0xc0, 0xe0, 0x1,\
                           0xc0, 0xe0, 0x1, 0xc0, 0xe0, 0x1, 0xc0, 0xe0, 0x1, 0xc0, 0xe0, 0x1, 0xc0, 0xf0, 0x3, 0xc0, 0x78, 0x7,  0x80, 0x7c, 0xf,  0x80, 0x3f, 0xff, 0x0,  0x1f, 0xfe, 0x0,  0x3, 0xf0, 0x0}

/* Ucircumflex (219) */
#define NXFONT_METRICS_219 {3, 18, 31, 3, 6, 0}
#define NXFONT_BITMAP_219 {0x0,  0x40, 0x0,  0x0,  0xe0, 0x0,  0x1,  0xf0, 0x0,  0x3,  0xb8, 0x0,  0x7,  0x1c, 0x0,  0x0,  0x0,  0x0,  0xe0, 0x1,  0xc0, 0xe0, 0x1,  0xc0, 0xe0, 0x1,  0xc0, 0xe0, 0x1,  0xc0, 0xe0,\
                           0x1,  0xc0, 0xe0, 0x1,  0xc0, 0xe0, 0x1,  0xc0, 0xe0, 0x1,  0xc0, 0xe0, 0x1,  0xc0, 0xe0, 0x1,  0xc0, 0xe0, 0x1,  0xc0, 0xe0, 0x1,  0xc0, 0xe0, 0x1,  0xc0, 0xe0, 0x1,  0xc0, 0xe0, 0x1,\
                           0xc0, 0xe0, 0x1,  0xc0, 0xe0, 0x1,  0xc0, 0xe0, 0x1,  0xc0, 0xe0, 0x1,  0xc0, 0xf0, 0x3,  0xc0, 0x78, 0x7,  0x80, 0x7c, 0xf,  0x80, 0x3f, 0xff, 0x0,  0x1f, 0xfe, 0x0,  0x3,  0xf0, 0x0}

/* Udieresis (220) */
#define NXFONT_METRICS_220 {3, 18, 30, 3, 7, 0}
#define NXFONT_BITMAP_220 {0xe,  0x1c, 0x0,  0xe,  0x1c, 0x0,  0xe,  0x1c, 0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0xe0, 0x1,  0xc0, 0xe0, 0x1,  0xc0, 0xe0, 0x1, 0xc0, 0xe0, 0x1, 0xc0, 0xe0, 0x1, 0xc0, 0xe0, 0x1,\
                           0xc0, 0xe0, 0x1,  0xc0, 0xe0, 0x1,  0xc0, 0xe0, 0x1,  0xc0, 0xe0, 0x1,  0xc0, 0xe0, 0x1,  0xc0, 0xe0, 0x1,  0xc0, 0xe0, 0x1,  0xc0, 0xe0, 0x1, 0xc0, 0xe0, 0x1, 0xc0, 0xe0, 0x1, 0xc0, 0xe0,\
                           0x1,  0xc0, 0xe0, 0x1,  0xc0, 0xe0, 0x1,  0xc0, 0xf0, 0x3,  0xc0, 0x78, 0x7,  0x80, 0x7c, 0xf,  0x80, 0x3f, 0xff, 0x0,  0x1f, 0xfe, 0x0,  0x3, 0xf0, 0x0}

/* Yacute (221) */
#define NXFONT_METRICS_221 {3, 19, 31, 1, 6, 0}
#define NXFONT_BITMAP_221 {0x0,  0x3c, 0x0, 0x0,  0x78, 0x0, 0x0,  0x70, 0x0, 0x0,  0xe0, 0x0,  0x1,  0xc0, 0x0,  0x0,  0x0, 0x0,  0xe0, 0x0, 0xe0, 0xf0, 0x1, 0xe0, 0x70, 0x1, 0xc0, 0x78, 0x3, 0xc0, 0x38, 0x3,\
                           0x80, 0x3c, 0x7, 0x80, 0x1c, 0xf, 0x0,  0x1e, 0xf, 0x0,  0xf,  0x1e, 0x0,  0x7,  0x1c, 0x0,  0x7, 0xbc, 0x0,  0x3, 0xb8, 0x0,  0x3, 0xf8, 0x0,  0x1, 0xf0, 0x0,  0x1, 0xf0, 0x0,  0x0,\
                           0xe0, 0x0,  0x0, 0xe0, 0x0,  0x0, 0xe0, 0x0,  0x0, 0xe0, 0x0,  0x0,  0xe0, 0x0,  0x0,  0xe0, 0x0, 0x0,  0xe0, 0x0, 0x0,  0xe0, 0x0, 0x0,  0xe0, 0x0, 0x0,  0xe0, 0x0}

/* Thorn (222) */
#define NXFONT_METRICS_222 {3, 17, 25, 3, 12, 0}
#define NXFONT_BITMAP_222 {0xe0, 0x0, 0x0, 0xe0, 0x0, 0x0, 0xe0, 0x0, 0x0, 0xe0, 0x0, 0x0, 0xe0, 0x0, 0x0, 0xff, 0xf8, 0x0, 0xff, 0xfe, 0x0, 0xff, 0xff, 0x0, 0xe0, 0xf, 0x0, 0xe0, 0x7, 0x0, 0xe0, 0x7, 0x80, 0xe0, 0x3, 0x80, 0xe0, 0x3, 0x80, 0xe0, 0x7, 0x80, 0xe0, 0x7, 0x0, 0xe0, 0xf, 0x0, 0xff, 0xfe, 0x0, 0xff, 0xfc, 0x0, 0xff, 0xf8, 0x0, 0xe0, 0x0, 0x0, 0xe0, 0x0, 0x0, 0xe0, 0x0, 0x0, 0xe0, 0x0, 0x0, 0xe0, 0x0, 0x0, 0xe0, 0x0, 0x0}

/* germandbls (223) */
#define NXFONT_METRICS_223 {2, 14, 25, 4, 12, 0}
#define NXFONT_BITMAP_223 {0xf, 0x80, 0x3f, 0xe0, 0x7f, 0xf0, 0x78, 0xf0, 0xf0, 0x78, 0xe0, 0x38, 0xe0, 0x38, 0xe0, 0x38, 0xe0, 0x78, 0xe0, 0xf0, 0xe3, 0xe0, 0xe3, 0xe0, 0xe3, 0xf0, 0xe0, 0x78, 0xe0, 0x3c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x38, 0xe0, 0x78, 0xe7, 0xf0, 0xe7, 0xe0, 0xe7, 0x80}

/* agrave (224) */
#define NXFONT_METRICS_224 {2, 16, 25, 1, 12, 0}
#define NXFONT_BITMAP_224 {0xf, 0x0, 0x7, 0x80, 0x3, 0x80, 0x1, 0xc0, 0x0, 0xe0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xe0, 0x3f, 0xf8, 0x3c, 0x7c, 0x70, 0x1c, 0x70, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0xfc, 0x1f, 0xfc, 0x7f, 0x9c, 0x78, 0x1c, 0xf0, 0x1c, 0xe0, 0x1c, 0xe0, 0x3c, 0xe0, 0x7c, 0x79, 0xfc, 0x7f, 0xdf, 0x3f, 0x8f}

/* aacute (225) */
#define NXFONT_METRICS_225 {2, 16, 25, 1, 12, 0}
#define NXFONT_BITMAP_225 {0x0, 0xf0, 0x1, 0xe0, 0x1, 0xc0, 0x3, 0x80, 0x7, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xe0, 0x3f, 0xf8, 0x3c, 0x7c, 0x70, 0x1c, 0x70, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0xfc, 0x1f, 0xfc, 0x7f, 0x9c, 0x78, 0x1c, 0xf0, 0x1c, 0xe0, 0x1c, 0xe0, 0x3c, 0xe0, 0x7c, 0x78, 0xfc, 0x7f, 0xdf, 0x3f, 0x8f}

/* acircumflex (226) */
#define NXFONT_METRICS_226 {2, 16, 25, 1, 12, 0}
#define NXFONT_BITMAP_226 {0x1, 0x0, 0x3, 0x80, 0x7, 0xc0, 0xe, 0xe0, 0x1c, 0x70, 0x0, 0x0, 0x0, 0x0, 0xf, 0xe0, 0x3f, 0xf8, 0x3c, 0x7c, 0x70, 0x1c, 0x70, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0xfc, 0x1f, 0xfc, 0x7f, 0x9c, 0x78, 0x1c, 0xf0, 0x1c, 0xe0, 0x1c, 0xe0, 0x3c, 0xe0, 0x7c, 0x78, 0xfc, 0x7f, 0xdf, 0x3f, 0x8f}

/* atilde (227) */
#define NXFONT_METRICS_227 {2, 16, 24, 1, 13, 0}
#define NXFONT_BITMAP_227 {0x7, 0x18, 0xf, 0xf8, 0x1f, 0xf0, 0x18, 0xe0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xe0, 0x3f, 0xf8, 0x3c, 0x7c, 0x70, 0x1c, 0x70, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0xfc, 0x1f, 0xfc, 0x7f, 0x9c, 0x78, 0x1c, 0xf0, 0x1c, 0xe0, 0x1c, 0xe0, 0x3c, 0xe0, 0x7c, 0x78, 0xfc, 0x7f, 0xdf, 0x3f, 0x8f}

/* adieresis (228) */
#define NXFONT_METRICS_228 {2, 16, 23, 1, 14, 0}
#define NXFONT_BITMAP_228 {0xe, 0x70, 0xe, 0x70, 0xe, 0x70, 0x0, 0x0, 0x0, 0x0, 0xf, 0xe0, 0x3f, 0xf8, 0x3c, 0xfc, 0x70, 0x1c, 0x70, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0xfc, 0x1f, 0xfc, 0x7f, 0x9c, 0x78, 0x1c, 0xf0, 0x1c, 0xe0, 0x1c, 0xe0, 0x3c, 0xe0, 0x7c, 0x79, 0xfc, 0x7f, 0xdf, 0x3f, 0x8f}

/* aring (229) */
#define NXFONT_METRICS_229 {2, 16, 25, 1, 12, 0}
#define NXFONT_BITMAP_229 {0x3, 0x80, 0x6, 0xc0, 0x4, 0x40, 0x4, 0x40, 0x6, 0xc0, 0x3, 0x80, 0x0, 0x0, 0xf, 0xe0, 0x3f, 0xf8, 0x3c, 0x7c, 0x70, 0x1c, 0x70, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0xfc, 0x1f, 0xfc, 0x7f, 0x9c, 0x78, 0x1c, 0xf0, 0x1c, 0xe0, 0x1c, 0xe0, 0x3c, 0xe0, 0x7c, 0x78, 0xfc, 0x7f, 0xdf, 0x3f, 0x8f}

/* ae (230) */
#define NXFONT_METRICS_230 {4, 26, 18, 1, 19, 0}
#define NXFONT_BITMAP_230 {0x7, 0xc0, 0xf8, 0x0, 0x1f, 0xf1, 0xfe, 0x0, 0x3c, 0x7f, 0x8f, 0x0, 0x70, 0x3e, 0x3, 0x80, 0x70, 0x1e, 0x3, 0x80, 0x0, 0x1c, 0x1, 0xc0, 0x0, 0x1c, 0x1, 0xc0, 0x0, 0xfc, 0x1, 0xc0, 0xf, 0xff, 0xff, 0xc0, 0x3f, 0xff, 0xff, 0xc0, 0x7e, 0x1f, 0xff, 0xc0, 0xf0, 0x1c, 0x0, 0x0, 0xe0, 0x1c, 0x1, 0xc0, 0xe0, 0x1e, 0x1, 0xc0, 0xe0, 0x7e, 0x3, 0x80, 0xf8, 0xf7, 0x8f, 0x0, 0x7f, 0xe7, 0xff, 0x0, 0x3f, 0x81, 0xfc, 0x0}

/* ccedilla (231) */
#define NXFONT_METRICS_231 {2, 14, 25, 1, 19, 0}
#define NXFONT_BITMAP_231 {0x7, 0xc0, 0x1f, 0xf0, 0x3f, 0xf8, 0x38, 0x38, 0x70, 0x1c, 0x70, 0x1c, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x1c, 0xe0, 0x1c, 0x70, 0x38, 0x78, 0x78, 0x3f, 0xf0, 0x1f, 0xe0, 0x7, 0x80, 0x3, 0x0, 0x3, 0x0, 0x7, 0x80, 0x1, 0xc0, 0x0, 0xc0, 0x19, 0xc0, 0xf, 0x80}

/* egrave (232) */
#define NXFONT_METRICS_232 {2, 15, 25, 1, 12, 0}
#define NXFONT_BITMAP_232 {0x1e, 0x0, 0xf, 0x0, 0x7, 0x0, 0x3, 0x80, 0x1, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x7, 0xc0, 0x1f, 0xf0, 0x3e, 0x78, 0x78, 0x1c, 0x70, 0x1c, 0xf0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xff, 0xfe, 0xff, 0xfe, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0xe, 0x70, 0xe, 0x78, 0x1c, 0x3c, 0x7c, 0x1f, 0xf0, 0xf, 0xe0}

/* eacute (233) */
#define NXFONT_METRICS_233 {2, 15, 25, 1, 12, 0}
#define NXFONT_BITMAP_233 {0x1, 0xe0, 0x3, 0xc0, 0x3, 0x80, 0x7, 0x0, 0xe, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7, 0xc0, 0x1f, 0xf0, 0x3c, 0x78, 0x78, 0x1c, 0x70, 0x1c, 0xf0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xff, 0xfe, 0xff, 0xfe, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0xe, 0x70, 0xe, 0x78, 0x1c, 0x3c, 0x7c, 0x1f, 0xf0, 0xf, 0xe0}

/* ecircumflex (234) */
#define NXFONT_METRICS_234 {2, 15, 25, 1, 12, 0}
#define NXFONT_BITMAP_234 {0x1, 0x0, 0x3, 0x80, 0x7, 0xc0, 0xe, 0xe0, 0x1c, 0x70, 0x0, 0x0, 0x0, 0x0, 0x7, 0xc0, 0x1f, 0xf0, 0x3c, 0x78, 0x78, 0x1c, 0x70, 0x1c, 0xf0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xff, 0xfe, 0xff, 0xfe, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0xe, 0x70, 0xe, 0x78, 0x1c, 0x3c, 0x7c, 0x1f, 0xf0, 0x7, 0xc0}

/* edieresis (235) */
#define NXFONT_METRICS_235 {2, 15, 23, 1, 14, 0}
#define NXFONT_BITMAP_235 {0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x0, 0x0, 0x0, 0x0, 0x7, 0xc0, 0x1f, 0xf0, 0x3c, 0x78, 0x78, 0x1c, 0x70, 0x1c, 0xf0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xff, 0xfe, 0xff, 0xfe, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0xe, 0x70, 0xe, 0x78, 0x1c, 0x3c, 0x7c, 0x1f, 0xf0, 0x7, 0xc0}

/* igrave (236) */
#define NXFONT_METRICS_236 {1, 7, 25, 0, 12, 0}
#define NXFONT_BITMAP_236 {0xf0, 0x78, 0x38, 0x1c, 0xe, 0x0, 0x0, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c}

/* iacute (237) */
#define NXFONT_METRICS_237 {1, 7, 25, 2, 12, 0}
#define NXFONT_BITMAP_237 {0x1e, 0x3c, 0x38, 0x70, 0xe0, 0x0, 0x0, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70}

/* icircumflex (238) */
#define NXFONT_METRICS_238 {2, 9, 25, 0, 12, 0}
#define NXFONT_BITMAP_238 {0x8, 0x0, 0x1c, 0x0, 0x3e, 0x0, 0x77, 0x0, 0xe3, 0x80, 0x0, 0x0, 0x0, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0}

/* idieresis (239) */
#define NXFONT_METRICS_239 {1, 8, 23, 1, 14, 0}
#define NXFONT_BITMAP_239 {0xe7, 0xe7, 0xe7, 0x0, 0x0, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38}

/* eth (240) */
#define NXFONT_METRICS_240 {2, 15, 25, 1, 12, 0}
#define NXFONT_BITMAP_240 {0x78, 0x40, 0x3c, 0xe0, 0x1f, 0xc0, 0xf, 0x80, 0x1f, 0x80, 0x3b, 0xc0, 0x11, 0xe0, 0x7, 0xf0, 0x1f, 0xf8, 0x3f, 0xf8, 0x78, 0x3c, 0x70, 0x1c, 0x70, 0x1c, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0x70, 0x1c, 0x70, 0x1c, 0x78, 0x3c, 0x3f, 0xf8, 0x1f, 0xf0, 0x7, 0xc0}

/* ntilde (241) */
#define NXFONT_METRICS_241 {2, 14, 24, 2, 13, 0}
#define NXFONT_BITMAP_241 {0xe, 0x30, 0x1f, 0xf0, 0x3f, 0xe0, 0x31, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x3, 0xc0, 0xef, 0xf0, 0xff, 0xf8, 0xf8, 0x3c, 0xf0, 0x1c, 0xf0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c}

/* ograve (242) */
#define NXFONT_METRICS_242 {2, 15, 25, 1, 12, 0}
#define NXFONT_BITMAP_242 {0x1e, 0x0, 0xf, 0x0, 0x7, 0x0, 0x3, 0x80, 0x1, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x7, 0xc0, 0x1f, 0xf0, 0x3f, 0xf8, 0x78, 0x3c, 0x70, 0x1c, 0x70, 0x1c, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0x70, 0x1c, 0x70, 0x1c, 0x78, 0x3c, 0x3f, 0xf8, 0x1f, 0xf0, 0x7, 0xc0}

/* oacute (243) */
#define NXFONT_METRICS_243 {2, 15, 25, 1, 12, 0}
#define NXFONT_BITMAP_243 {0x1, 0xe0, 0x3, 0xc0, 0x3, 0x80, 0x7, 0x0, 0xe, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7, 0xc0, 0x1f, 0xf0, 0x3f, 0xf8, 0x78, 0x3c, 0x70, 0x1c, 0x70, 0x1c, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0x70, 0x1c, 0x70, 0x1c, 0x78, 0x3c, 0x3f, 0xf8, 0x1f, 0xf0, 0x7, 0xc0}

/* ocircumflex (244) */
#define NXFONT_METRICS_244 {2, 15, 25, 1, 12, 0}
#define NXFONT_BITMAP_244 {0x1, 0x0, 0x3, 0x80, 0x7, 0xc0, 0xe, 0xe0, 0x1c, 0x70, 0x0, 0x0, 0x0, 0x0, 0x7, 0xc0, 0x1f, 0xf0, 0x3f, 0xf8, 0x78, 0x3c, 0x70, 0x1c, 0x70, 0x1c, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0x70, 0x1c, 0x70, 0x1c, 0x78, 0x3c, 0x3f, 0xf8, 0x1f, 0xf0, 0x7, 0xc0}

/* otilde (245) */
#define NXFONT_METRICS_245 {2, 15, 24, 1, 13, 0}
#define NXFONT_BITMAP_245 {0xe, 0x30, 0x1f, 0xf0, 0x3f, 0xe0, 0x31, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x7, 0xc0, 0x1f, 0xf0, 0x3f, 0xf8, 0x78, 0x3c, 0x70, 0x1c, 0x70, 0x1c, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0x70, 0x1c, 0x70, 0x1c, 0x78, 0x3c, 0x3f, 0xf8, 0x1f, 0xf0, 0x7, 0xc0}

/* odieresis (246) */
#define NXFONT_METRICS_246 {2, 15, 23, 1, 14, 0}
#define NXFONT_BITMAP_246 {0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x0, 0x0, 0x0, 0x0, 0x7, 0xc0, 0x1f, 0xf0, 0x3f, 0xf8, 0x78, 0x3c, 0x70, 0x1c, 0x70, 0x1c, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0x70, 0x1c, 0x70, 0x1c, 0x78, 0x3c, 0x3f, 0xf8, 0x1f, 0xf0, 0x7, 0xc0}

/* divide (247) */
#define NXFONT_METRICS_247 {2, 15, 15, 2, 21, 0}
#define NXFONT_BITMAP_247 {0x3, 0x80, 0x3, 0x80, 0x3, 0x80, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xfe, 0xff, 0xfe, 0xff, 0xfe, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0x80, 0x3, 0x80, 0x3, 0x80}

/* oslash (248) */
#define NXFONT_METRICS_248 {2, 16, 18, 2, 19, 0}
#define NXFONT_BITMAP_248 {0x7, 0xc3, 0x1f, 0xf6, 0x3f, 0xfc, 0x78, 0x78, 0x70, 0x1c, 0x70, 0x3c, 0xe0, 0x6e, 0xe0, 0xce, 0xe1, 0x8e, 0xe3, 0xe, 0xe6, 0xe, 0xec, 0xe, 0x78, 0x1c, 0x70, 0x1c, 0x38, 0x3c, 0x7f, 0xf8, 0xdf, 0xf0, 0x87, 0xc0}

/* ugrave (249) */
#define NXFONT_METRICS_249 {2, 14, 25, 2, 12, 0}
#define NXFONT_BITMAP_249 {0x1e, 0x0, 0xf, 0x0, 0x7, 0x0, 0x3, 0x80, 0x1, 0xc0, 0x0, 0x0, 0x0, 0x0, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x3c, 0xe0, 0x3c, 0xf0, 0xfc, 0x7f, 0xfc, 0x3f, 0xdc, 0xf, 0x0}

/* uacute (250) */
#define NXFONT_METRICS_250 {2, 14, 25, 2, 12, 0}
#define NXFONT_BITMAP_250 {0x1, 0xe0, 0x3, 0xc0, 0x3, 0x80, 0x7, 0x0, 0xe, 0x0, 0x0, 0x0, 0x0, 0x0, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x3c, 0xe0, 0x3c, 0xf0, 0xfc, 0x7f, 0xfc, 0x3f, 0xdc, 0xf, 0x0}

/* ucircumflex (251) */
#define NXFONT_METRICS_251 {2, 14, 25, 2, 12, 0}
#define NXFONT_BITMAP_251 {0x1, 0x0, 0x3, 0x80, 0x7, 0xc0, 0xe, 0xe0, 0x1c, 0x70, 0x0, 0x0, 0x0, 0x0, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x3c, 0xe0, 0x3c, 0xf0, 0xfc, 0x7f, 0xfc, 0x3f, 0xdc, 0xf, 0x0}

/* udieresis (252) */
#define NXFONT_METRICS_252 {2, 14, 23, 2, 14, 0}
#define NXFONT_BITMAP_252 {0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x0, 0x0, 0x0, 0x0, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x3c, 0xe0, 0x3c, 0xf0, 0xfc, 0x7f, 0xfc, 0x3f, 0xdc, 0xf, 0x0}

/* yacute (253) */
#define NXFONT_METRICS_253 {2, 14, 32, 1, 12, 0}
#define NXFONT_BITMAP_253 {0x0, 0xf0, 0x1, 0xe0, 0x1, 0xc0, 0x3, 0x80, 0x7, 0x0, 0x0, 0x0, 0x0, 0x0, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x3c, 0x70, 0x38, 0x70, 0x38, 0x70, 0x38, 0x78, 0x70, 0x38, 0x70, 0x38, 0xf0, 0x3c, 0xe0, 0x1c, 0xe0, 0x1d, 0xc0, 0x1d, 0xc0, 0xf, 0xc0, 0xf, 0x80, 0xf, 0x80, 0x7, 0x0, 0x7, 0x0, 0x7, 0x0, 0xe, 0x0, 0xe, 0x0, 0x1e, 0x0, 0x7c, 0x0, 0x7c, 0x0, 0x70, 0x0}

/* thorn (254) */
#define NXFONT_METRICS_254 {2, 15, 31, 2, 12, 0}
#define NXFONT_BITMAP_254 {0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe7, 0xe0, 0xef, 0xf0, 0xff, 0xf8, 0xf8, 0x3c, 0xf0, 0x1c, 0xf0, 0x1e, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xf0, 0x1c, 0xf0, 0x1c, 0xf8, 0x3c, 0xff, 0xf8, 0xef, 0xf0, 0xe3, 0xc0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0}

/* ydieresis (255) */
#define NXFONT_METRICS_255 {2, 14, 30, 1, 14, 0}
#define NXFONT_BITMAP_255 {0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x0, 0x0, 0x0, 0x0, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x3c, 0x70, 0x38, 0x70, 0x38, 0x70, 0x78, 0x78, 0x70, 0x38, 0x70, 0x38, 0xf0, 0x3c, 0xe0, 0x1c, 0xe0, 0x1d, 0xc0, 0x1d, 0xc0, 0xf, 0xc0, 0xf, 0x80, 0xf, 0x80, 0x7, 0x0, 0x7, 0x0, 0x7, 0x0, 0xe, 0x0, 0xe, 0x0, 0x1e, 0x0, 0x7c, 0x0, 0x7c, 0x0, 0x70, 0x0}

/****************************************************************************
 * Public Types
 ****************************************************************************/

/****************************************************************************
 * Public Data
 ****************************************************************************/

#undef EXTERN
#if defined(__cplusplus)
#define EXTERN extern "C"
extern "C"
{
#else
#define EXTERN extern
#endif

/****************************************************************************
 * Public Functions Definitions
 ****************************************************************************/

#undef EXTERN
#if defined(__cplusplus)
}
#endif

#endif /* __LIBS_LIBNX_NXFONTS_NXFONTS_SANS39X48_H */
