/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.authorization.user;

import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.nifi.authorization.user.NiFiUser;

public class StandardNiFiUser
implements NiFiUser {
    public static final String ANONYMOUS_IDENTITY = "anonymous";
    public static final StandardNiFiUser ANONYMOUS = new Builder().identity("anonymous").anonymous(true).build();
    private final String identity;
    private final Set<String> groups;
    private final Set<String> identityProviderGroups;
    private final Set<String> allGroups;
    private final NiFiUser chain;
    private final String clientAddress;
    private final boolean isAnonymous;

    private StandardNiFiUser(Builder builder) {
        this.identity = builder.identity;
        this.groups = builder.groups == null ? null : Collections.unmodifiableSet(builder.groups);
        this.identityProviderGroups = builder.identityProviderGroups == null ? null : Collections.unmodifiableSet(builder.identityProviderGroups);
        this.chain = builder.chain;
        this.clientAddress = builder.clientAddress;
        this.isAnonymous = builder.isAnonymous;
        HashSet<String> combineGroups = new HashSet<String>();
        if (this.groups != null) {
            combineGroups.addAll(this.groups);
        }
        if (this.identityProviderGroups != null) {
            combineGroups.addAll(this.identityProviderGroups);
        }
        this.allGroups = Collections.unmodifiableSet(combineGroups);
    }

    public static StandardNiFiUser populateAnonymousUser(NiFiUser chain, String clientAddress) {
        return new Builder().identity(ANONYMOUS_IDENTITY).chain(chain).clientAddress(clientAddress).anonymous(true).build();
    }

    public String getIdentity() {
        return this.identity;
    }

    public Set<String> getGroups() {
        return this.groups;
    }

    public Set<String> getIdentityProviderGroups() {
        return this.identityProviderGroups;
    }

    public Set<String> getAllGroups() {
        return this.allGroups;
    }

    public NiFiUser getChain() {
        return this.chain;
    }

    public boolean isAnonymous() {
        return this.isAnonymous;
    }

    public String getClientAddress() {
        return this.clientAddress;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NiFiUser)) {
            return false;
        }
        NiFiUser other = (NiFiUser)obj;
        return Objects.equals(this.identity, other.getIdentity());
    }

    public int hashCode() {
        int hash = 7;
        hash = 53 * hash + Objects.hashCode(this.identity);
        return hash;
    }

    public String toString() {
        String formattedGroups = this.groups == null ? "none" : String.join((CharSequence)", ", this.groups);
        return String.format("identity[%s], groups[%s]", this.getIdentity(), formattedGroups);
    }

    public static class Builder {
        private String identity;
        private Set<String> groups;
        private Set<String> identityProviderGroups;
        private NiFiUser chain;
        private String clientAddress;
        private boolean isAnonymous = false;

        public Builder identity(String identity) {
            this.identity = identity;
            return this;
        }

        public Builder groups(Set<String> groups) {
            this.groups = groups;
            return this;
        }

        public Builder identityProviderGroups(Set<String> identityProviderGroups) {
            this.identityProviderGroups = identityProviderGroups;
            return this;
        }

        public Builder chain(NiFiUser chain) {
            this.chain = chain;
            return this;
        }

        public Builder clientAddress(String clientAddress) {
            this.clientAddress = clientAddress;
            return this;
        }

        private Builder anonymous(boolean isAnonymous) {
            this.isAnonymous = isAnonymous;
            return this;
        }

        public StandardNiFiUser build() {
            return new StandardNiFiUser(this);
        }
    }
}

