/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.nifi.web.api.dto.BundleDTO;
import org.apache.nifi.web.api.dto.ComponentDTO;
import org.apache.nifi.web.api.dto.PropertyDescriptorDTO;

@XmlType(name="flowAnalysisRule")
public class FlowAnalysisRuleDTO
extends ComponentDTO {
    public static final String VALID = "VALID";
    public static final String INVALID = "INVALID";
    public static final String VALIDATING = "VALIDATING";
    private String name;
    private String type;
    private BundleDTO bundle;
    private String state;
    private String comments;
    private Boolean persistsState;
    private Boolean restricted;
    private Boolean deprecated;
    private Boolean isExtensionMissing;
    private Boolean multipleVersionsAvailable;
    private Boolean supportsSensitiveDynamicProperties;
    private String enforcementPolicy;
    private Map<String, String> properties;
    private Map<String, PropertyDescriptorDTO> descriptors;
    private Set<String> sensitiveDynamicPropertyNames;
    private Collection<String> validationErrors;
    private String validationStatus;

    @Schema(description="The name of the flow analysis rule.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Schema(description="The comments of the flow analysis rule.")
    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    @Schema(description="The fully qualified type of the flow analysis rule.")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Schema(description="The details of the artifact that bundled this flow analysis rule type.")
    public BundleDTO getBundle() {
        return this.bundle;
    }

    public void setBundle(BundleDTO bundle) {
        this.bundle = bundle;
    }

    @Schema(description="Whether the flow analysis rule persists state.")
    public Boolean getPersistsState() {
        return this.persistsState;
    }

    public void setPersistsState(Boolean persistsState) {
        this.persistsState = persistsState;
    }

    @Schema(description="Whether the flow analysis rule requires elevated privileges.")
    public Boolean getRestricted() {
        return this.restricted;
    }

    public void setRestricted(Boolean restricted) {
        this.restricted = restricted;
    }

    @Schema(description="Whether the flow analysis rule has been deprecated.")
    public Boolean getDeprecated() {
        return this.deprecated;
    }

    public void setDeprecated(Boolean deprecated) {
        this.deprecated = deprecated;
    }

    @Schema(description="Whether the underlying extension is missing.")
    public Boolean getExtensionMissing() {
        return this.isExtensionMissing;
    }

    public void setExtensionMissing(Boolean extensionMissing) {
        this.isExtensionMissing = extensionMissing;
    }

    @Schema(description="Whether the flow analysis rule has multiple versions available.")
    public Boolean getMultipleVersionsAvailable() {
        return this.multipleVersionsAvailable;
    }

    public void setMultipleVersionsAvailable(Boolean multipleVersionsAvailable) {
        this.multipleVersionsAvailable = multipleVersionsAvailable;
    }

    @Schema(description="Whether the flow analysis rule supports sensitive dynamic properties.")
    public Boolean getSupportsSensitiveDynamicProperties() {
        return this.supportsSensitiveDynamicProperties;
    }

    public void setSupportsSensitiveDynamicProperties(Boolean supportsSensitiveDynamicProperties) {
        this.supportsSensitiveDynamicProperties = supportsSensitiveDynamicProperties;
    }

    @Schema(description="The state of the flow analysis rule.", allowableValues={"ENABLED, DISABLED"})
    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    @Schema(description="Enforcement Policy.")
    public String getEnforcementPolicy() {
        return this.enforcementPolicy;
    }

    public void setEnforcementPolicy(String enforcementPolicy) {
        this.enforcementPolicy = enforcementPolicy;
    }

    @Schema(description="The properties of the flow analysis rule.")
    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    @Schema(description="The descriptors for the flow analysis rules properties.")
    public Map<String, PropertyDescriptorDTO> getDescriptors() {
        return this.descriptors;
    }

    public void setDescriptors(Map<String, PropertyDescriptorDTO> descriptors) {
        this.descriptors = descriptors;
    }

    @Schema(description="Set of sensitive dynamic property names")
    public Set<String> getSensitiveDynamicPropertyNames() {
        return this.sensitiveDynamicPropertyNames;
    }

    public void setSensitiveDynamicPropertyNames(Set<String> sensitiveDynamicPropertyNames) {
        this.sensitiveDynamicPropertyNames = sensitiveDynamicPropertyNames;
    }

    @Schema(description="Gets the validation errors from the flow analysis rule. These validation errors represent the problems with the flow analysis rule that must be resolved before it can be scheduled to run.")
    public Collection<String> getValidationErrors() {
        return this.validationErrors;
    }

    public void setValidationErrors(Collection<String> validationErrors) {
        this.validationErrors = validationErrors;
    }

    @Schema(description="Indicates whether the Flow Analysis Rule is valid, invalid, or still in the process of validating (i.e., it is unknown whether or not the Flow Analysis Rule is valid)", accessMode=Schema.AccessMode.READ_ONLY, allowableValues={"VALID, INVALID, VALIDATING"})
    public String getValidationStatus() {
        return this.validationStatus;
    }

    public void setValidationStatus(String validationStatus) {
        this.validationStatus = validationStatus;
    }
}

