/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.projectapi.nb;

import java.awt.EventQueue;
import java.io.IOException;
import java.lang.ref.Reference;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.projectapi.nb.TimedWeakReference;
import org.netbeans.spi.project.ProjectFactory;
import org.netbeans.spi.project.ProjectFactory2;
import org.netbeans.spi.project.ProjectManagerImplementation;
import org.netbeans.spi.project.ProjectState;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.Parameters;
import org.openide.util.Union2;
import org.openide.util.WeakSet;
import org.openide.util.spi.MutexImplementation;

public final class NbProjectManager
implements ProjectManagerImplementation {
    private static final Logger LOG = Logger.getLogger(NbProjectManager.class.getName());
    private static final Logger TIMERS = Logger.getLogger("TIMER.projects");
    private static final Lookup.Result<ProjectFactory> factories = Lookup.getDefault().lookupResult(ProjectFactory.class);
    private final Mutex MUTEX = new Mutex();
    private final Map<FileObject, Union2<Reference<Project>, LoadStatus>> dir2Proj = new WeakHashMap<FileObject, Union2<Reference<Project>, LoadStatus>>();
    private final Set<Project> modifiedProjects = new HashSet<Project>();
    private final Set<Project> removedProjects = Collections.synchronizedSet(new WeakSet());
    private final Map<Project, ProjectFactory> proj2Factory = Collections.synchronizedMap(new WeakHashMap());
    private final FileChangeListener projectDeletionListener = new ProjectDeletionListener();
    private ThreadLocal<Set<FileObject>> loadingThread = new ThreadLocal();
    private volatile ProjectManagerImplementation.ProjectManagerCallBack callBack;

    public NbProjectManager() {
        factories.addLookupListener(new LookupListener(){

            @Override
            public void resultChanged(LookupEvent e) {
                NbProjectManager.this.clearNonProjectCache();
            }
        });
    }

    @Override
    public void init(@NonNull ProjectManagerImplementation.ProjectManagerCallBack callBack) {
        Parameters.notNull("callBack", callBack);
        this.callBack = callBack;
    }

    @Override
    @NonNull
    public Mutex getMutex() {
        return this.MUTEX;
    }

    @Override
    @NonNull
    public Mutex getMutex(boolean autoSave, @NonNull Project project, Project ... otherProjects) {
        return new Mutex(new MutexImpl(this, autoSave, project, otherProjects));
    }

    void reset() {
        this.dir2Proj.clear();
        this.modifiedProjects.clear();
        this.proj2Factory.clear();
        this.removedProjects.clear();
    }

    @Override
    public Project findProject(final FileObject projectDirectory) throws IOException, IllegalArgumentException {
        Parameters.notNull("projectDirectory", projectDirectory);
        try {
            return this.getMutex().readAccess(new Mutex.ExceptionAction<Project>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Loose catch block
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 * Converted monitor instructions to comments
                 * Lifted jumps to return sites
                 */
                @Override
                public Project run() throws IOException {
                    try {
                        boolean resetLP;
                        boolean wasSomeSuchProject;
                        block45: {
                            HashSet<FileObject> ldng;
                            Union2 o;
                            Map map = NbProjectManager.this.dir2Proj;
                            // MONITORENTER : map
                            do {
                                if (!LoadStatus.LOADING_PROJECT.is(o = (Union2)NbProjectManager.this.dir2Proj.get(projectDirectory))) continue;
                                try {
                                    ldng = (HashSet<FileObject>)NbProjectManager.this.loadingThread.get();
                                    if (ldng != null && ldng.contains(projectDirectory)) {
                                        throw new IllegalStateException("Attempt to call ProjectManager.findProject within the body of ProjectFactory.loadProject (hint: try using ProjectManager.mutex().postWriteRequest(...) within the body of your Project's constructor to prevent this)");
                                    }
                                    if (LOG.isLoggable(Level.FINE)) {
                                        LOG.log(Level.FINE, "findProject({0}) in {1}: waiting for LOADING_PROJECT...", new Object[]{projectDirectory, Thread.currentThread().getName()});
                                    }
                                    if (LOG.isLoggable(Level.FINE) && EventQueue.isDispatchThread()) {
                                        LOG.log(Level.WARNING, "loading " + projectDirectory, new IllegalStateException("trying to load a prpject from EQ"));
                                    }
                                    NbProjectManager.this.dir2Proj.wait();
                                    if (!LOG.isLoggable(Level.FINE)) continue;
                                    LOG.log(Level.FINE, "findProject({0}) in {1}: ...done waiting for LOADING_PROJECT", new Object[]{projectDirectory, Thread.currentThread().getName()});
                                }
                                catch (InterruptedException e) {
                                    LOG.log(Level.INFO, null, e);
                                    // MONITOREXIT : map
                                    return null;
                                }
                            } while (LoadStatus.LOADING_PROJECT.is(o));
                            assert (!LoadStatus.LOADING_PROJECT.is(o));
                            wasSomeSuchProject = LoadStatus.SOME_SUCH_PROJECT.is(o);
                            if (LoadStatus.NO_SUCH_PROJECT.is(o)) {
                                if (LOG.isLoggable(Level.FINE)) {
                                    LOG.log(Level.FINE, "findProject({0}) in {1}: NO_SUCH_PROJECT", new Object[]{projectDirectory, Thread.currentThread().getName()});
                                }
                                // MONITOREXIT : map
                                return null;
                            }
                            if (o != null && !LoadStatus.SOME_SUCH_PROJECT.is(o)) {
                                Project p = (Project)((Reference)o.first()).get();
                                if (p != null) {
                                    if (LOG.isLoggable(Level.FINE)) {
                                        LOG.log(Level.FINE, "findProject({0}) in {1}: cached project @{2}", new Object[]{projectDirectory, Thread.currentThread().getName(), p.hashCode()});
                                    }
                                    // MONITOREXIT : map
                                    return p;
                                }
                                if (LOG.isLoggable(Level.FINE)) {
                                    LOG.log(Level.FINE, "findProject({0}) in {1}: null project reference", new Object[]{projectDirectory, Thread.currentThread().getName()});
                                }
                            } else if (LOG.isLoggable(Level.FINE)) {
                                LOG.log(Level.FINE, "findProject({0} in {1}: no entries among {2}", new Object[]{projectDirectory, Thread.currentThread().getName(), NbProjectManager.this.dir2Proj});
                            }
                            NbProjectManager.this.dir2Proj.put(projectDirectory, LoadStatus.LOADING_PROJECT.wrap());
                            ldng = (Set)NbProjectManager.this.loadingThread.get();
                            if (ldng == null) {
                                ldng = new HashSet<FileObject>();
                                NbProjectManager.this.loadingThread.set(ldng);
                            }
                            ldng.add(projectDirectory);
                            if (LOG.isLoggable(Level.FINE)) {
                                LOG.log(Level.FINE, "findProject({0}) in {1}: may load new project...", new Object[]{projectDirectory, Thread.currentThread().getName()});
                            }
                            // MONITOREXIT : map
                            resetLP = false;
                            Project p = NbProjectManager.this.createProject(projectDirectory);
                            Map map2 = NbProjectManager.this.dir2Proj;
                            // MONITORENTER : map2
                            NbProjectManager.this.dir2Proj.notifyAll();
                            if (p == null) break block45;
                            if (LOG.isLoggable(Level.FINE)) {
                                LOG.log(Level.FINE, "findProject({0}) in {1}: created new project @{2}", new Object[]{projectDirectory, Thread.currentThread().getName(), p.hashCode()});
                            }
                            projectDirectory.addFileChangeListener(NbProjectManager.this.projectDeletionListener);
                            NbProjectManager.this.dir2Proj.put(projectDirectory, Union2.createFirst(new TimedWeakReference<Project>(p)));
                            resetLP = true;
                            Project project = p;
                            // MONITOREXIT : map2
                            ((Set)NbProjectManager.this.loadingThread.get()).remove(projectDirectory);
                            if (resetLP) return project;
                            if (LOG.isLoggable(Level.FINE)) {
                                LOG.log(Level.FINE, "findProject({0}) in {1}: cleaning up after error", new Object[]{projectDirectory, Thread.currentThread().getName()});
                            }
                            Map map3 = NbProjectManager.this.dir2Proj;
                            // MONITORENTER : map3
                            assert (LoadStatus.LOADING_PROJECT.is((Union2)NbProjectManager.this.dir2Proj.get(projectDirectory))) : (Union2)NbProjectManager.access$000(NbProjectManager.this).get(projectDirectory);
                            NbProjectManager.this.dir2Proj.remove(projectDirectory);
                            NbProjectManager.this.dir2Proj.notifyAll();
                            // MONITOREXIT : map3
                            return project;
                        }
                        NbProjectManager.this.dir2Proj.put(projectDirectory, LoadStatus.NO_SUCH_PROJECT.wrap());
                        resetLP = true;
                        if (wasSomeSuchProject && LOG.isLoggable(Level.FINE)) {
                            LOG.log(Level.FINE, "Directory {0} was initially claimed to be a project folder but really was not", FileUtil.getFileDisplayName(projectDirectory));
                        }
                        Project project = null;
                        // MONITOREXIT : map2
                        ((Set)NbProjectManager.this.loadingThread.get()).remove(projectDirectory);
                        {
                            catch (IOException e) {
                                if (!LOG.isLoggable(Level.FINE)) throw e;
                                LOG.log(Level.FINE, "findProject({0}) in {1}: error loading project: {2}", new Object[]{projectDirectory, Thread.currentThread().getName(), e});
                                throw e;
                            }
                        }
                        if (resetLP) return project;
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.log(Level.FINE, "findProject({0}) in {1}: cleaning up after error", new Object[]{projectDirectory, Thread.currentThread().getName()});
                        }
                        Map map = NbProjectManager.this.dir2Proj;
                        // MONITORENTER : map
                        assert (LoadStatus.LOADING_PROJECT.is((Union2)NbProjectManager.this.dir2Proj.get(projectDirectory))) : (Union2)NbProjectManager.access$000(NbProjectManager.this).get(projectDirectory);
                        NbProjectManager.this.dir2Proj.remove(projectDirectory);
                        NbProjectManager.this.dir2Proj.notifyAll();
                        // MONITOREXIT : map
                        return project;
                        catch (Throwable throwable) {
                            ((Set)NbProjectManager.this.loadingThread.get()).remove(projectDirectory);
                            if (resetLP) throw throwable;
                            if (LOG.isLoggable(Level.FINE)) {
                                LOG.log(Level.FINE, "findProject({0}) in {1}: cleaning up after error", new Object[]{projectDirectory, Thread.currentThread().getName()});
                            }
                            Map map4 = NbProjectManager.this.dir2Proj;
                            // MONITORENTER : map4
                            assert (LoadStatus.LOADING_PROJECT.is((Union2)NbProjectManager.this.dir2Proj.get(projectDirectory))) : (Union2)NbProjectManager.access$000(NbProjectManager.this).get(projectDirectory);
                            NbProjectManager.this.dir2Proj.remove(projectDirectory);
                            NbProjectManager.this.dir2Proj.notifyAll();
                            // MONITOREXIT : map4
                            throw throwable;
                        }
                    }
                    catch (Error e) {
                        LOG.log(Level.FINE, null, e);
                        throw e;
                    }
                    catch (RuntimeException e) {
                        LOG.log(Level.FINE, null, e);
                        throw e;
                    }
                    catch (IOException e) {
                        LOG.log(Level.FINE, null, e);
                        throw e;
                    }
                }
            });
        }
        catch (MutexException e) {
            throw (IOException)e.getException();
        }
    }

    private Project createProject(FileObject dir) throws IOException {
        assert (dir != null);
        assert (dir.isFolder());
        assert (this.getMutex().isReadAccess());
        ProjectStateImpl state = new ProjectStateImpl();
        for (ProjectFactory factory : factories.allInstances()) {
            Project p = factory.loadProject(dir, state);
            if (p == null) continue;
            if (TIMERS.isLoggable(Level.FINE)) {
                LogRecord rec = new LogRecord(Level.FINE, "Project");
                rec.setParameters(new Object[]{p});
                TIMERS.log(rec);
            }
            this.proj2Factory.put(p, factory);
            state.attach(p);
            return p;
        }
        return null;
    }

    @Override
    public ProjectManager.Result isProject(final FileObject projectDirectory) throws IllegalArgumentException {
        Parameters.notNull("projectDirectory", projectDirectory);
        return this.getMutex().readAccess(new Mutex.Action<ProjectManager.Result>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             * Converted monitor instructions to comments
             * Lifted jumps to return sites
             */
            @Override
            public ProjectManager.Result run() {
                boolean resetLP;
                block24: {
                    ProjectManager.Result result;
                    Union2 o;
                    Map map = NbProjectManager.this.dir2Proj;
                    // MONITORENTER : map
                    do {
                        if (!LoadStatus.LOADING_PROJECT.is(o = (Union2)NbProjectManager.this.dir2Proj.get(projectDirectory))) continue;
                        if (EventQueue.isDispatchThread()) {
                            // MONITOREXIT : map
                            return new ProjectManager.Result(null);
                        }
                        try {
                            NbProjectManager.this.dir2Proj.wait();
                        }
                        catch (InterruptedException e) {
                            LOG.log(Level.INFO, null, e);
                            // MONITOREXIT : map
                            return null;
                        }
                    } while (LoadStatus.LOADING_PROJECT.is(o));
                    assert (!LoadStatus.LOADING_PROJECT.is(o));
                    if (LoadStatus.NO_SUCH_PROJECT.is(o)) {
                        // MONITOREXIT : map
                        return null;
                    }
                    if (o != null) {
                        // MONITOREXIT : map
                        return NbProjectManager.this.checkForProject(projectDirectory);
                    }
                    NbProjectManager.this.dir2Proj.put(projectDirectory, LoadStatus.LOADING_PROJECT.wrap());
                    // MONITOREXIT : map
                    resetLP = false;
                    try {
                        ProjectManager.Result p = NbProjectManager.this.checkForProject(projectDirectory);
                        Map map2 = NbProjectManager.this.dir2Proj;
                        // MONITORENTER : map2
                        resetLP = true;
                        NbProjectManager.this.dir2Proj.notifyAll();
                        if (p == null) break block24;
                        NbProjectManager.this.dir2Proj.put(projectDirectory, LoadStatus.SOME_SUCH_PROJECT.wrap());
                        result = p;
                        // MONITOREXIT : map2
                        if (resetLP) return result;
                    }
                    catch (Throwable throwable) {
                        if (resetLP) throw throwable;
                        Map map3 = NbProjectManager.this.dir2Proj;
                        // MONITORENTER : map3
                        assert (LoadStatus.LOADING_PROJECT.is((Union2)NbProjectManager.this.dir2Proj.get(projectDirectory)));
                        NbProjectManager.this.dir2Proj.remove(projectDirectory);
                        // MONITOREXIT : map3
                        throw throwable;
                    }
                    Map map4 = NbProjectManager.this.dir2Proj;
                    // MONITORENTER : map4
                    assert (LoadStatus.LOADING_PROJECT.is((Union2)NbProjectManager.this.dir2Proj.get(projectDirectory)));
                    NbProjectManager.this.dir2Proj.remove(projectDirectory);
                    // MONITOREXIT : map4
                    return result;
                }
                NbProjectManager.this.dir2Proj.put(projectDirectory, LoadStatus.NO_SUCH_PROJECT.wrap());
                ProjectManager.Result result = null;
                // MONITOREXIT : map2
                if (resetLP) return result;
                Map map = NbProjectManager.this.dir2Proj;
                // MONITORENTER : map
                assert (LoadStatus.LOADING_PROJECT.is((Union2)NbProjectManager.this.dir2Proj.get(projectDirectory)));
                NbProjectManager.this.dir2Proj.remove(projectDirectory);
                // MONITOREXIT : map
                return result;
            }
        });
    }

    private ProjectManager.Result checkForProject(FileObject dir) {
        assert (dir != null);
        assert (dir.isFolder()) : dir;
        assert (this.getMutex().isReadAccess());
        for (ProjectFactory factory : factories.allInstances()) {
            if (factory instanceof ProjectFactory2) {
                ProjectManager.Result res = ((ProjectFactory2)factory).isProject2(dir);
                if (res == null) continue;
                return res;
            }
            if (!factory.isProject(dir)) continue;
            return new ProjectManager.Result(null);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearNonProjectCache() {
        Map<FileObject, Union2<Reference<Project>, LoadStatus>> map = this.dir2Proj;
        synchronized (map) {
            this.dir2Proj.values().removeAll(Arrays.asList(LoadStatus.NO_SUCH_PROJECT.wrap(), LoadStatus.SOME_SUCH_PROJECT.wrap()));
        }
    }

    @Override
    public Set<Project> getModifiedProjects() {
        return this.getMutex().readAccess(new Mutex.Action<Set<Project>>(){

            @Override
            public Set<Project> run() {
                return new HashSet<Project>(NbProjectManager.this.modifiedProjects);
            }
        });
    }

    @Override
    public boolean isModified(final Project p) {
        return this.getMutex().readAccess(new Mutex.Action<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean run() {
                Map map = NbProjectManager.this.dir2Proj;
                synchronized (map) {
                    if (!NbProjectManager.this.proj2Factory.containsKey(p)) {
                        LOG.log(Level.WARNING, "Project {0} was already deleted", p);
                    }
                }
                return NbProjectManager.this.modifiedProjects.contains(p);
            }
        });
    }

    @Override
    public void saveProject(final Project p) throws IOException {
        try {
            this.getMutex().writeAccess(new Mutex.ExceptionAction<Void>(){

                @Override
                public Void run() throws IOException {
                    if (NbProjectManager.this.removedProjects.contains(p)) {
                        return null;
                    }
                    if (NbProjectManager.this.modifiedProjects.contains(p)) {
                        ProjectFactory f = (ProjectFactory)NbProjectManager.this.proj2Factory.get(p);
                        if (f != null) {
                            f.saveProject(p);
                            LOG.log(Level.FINE, "saveProject({0})", p.getProjectDirectory());
                        } else {
                            LOG.log(Level.WARNING, "Project {0} was already deleted", p);
                        }
                        NbProjectManager.this.modifiedProjects.remove(p);
                    }
                    return null;
                }
            });
        }
        catch (MutexException e) {
            if (!p.getProjectDirectory().canWrite()) {
                throw new IOException("Project folder is not writeable.");
            }
            throw (IOException)e.getException();
        }
    }

    @Override
    public void saveAllProjects() throws IOException {
        try {
            this.getMutex().writeAccess(new Mutex.ExceptionAction<Void>(){

                @Override
                public Void run() throws IOException {
                    Iterator it = NbProjectManager.this.modifiedProjects.iterator();
                    while (it.hasNext()) {
                        Project p = (Project)it.next();
                        ProjectFactory f = (ProjectFactory)NbProjectManager.this.proj2Factory.get(p);
                        if (f != null) {
                            f.saveProject(p);
                            LOG.log(Level.FINE, "saveProject({0})", p.getProjectDirectory());
                        } else {
                            LOG.log(Level.WARNING, "Project {0} was already deleted", p);
                        }
                        it.remove();
                    }
                    return null;
                }
            });
        }
        catch (MutexException e) {
            throw (IOException)e.getException();
        }
    }

    @Override
    public boolean isValid(final Project p) {
        return this.getMutex().readAccess(new Mutex.Action<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean run() {
                Map map = NbProjectManager.this.dir2Proj;
                synchronized (map) {
                    return NbProjectManager.this.proj2Factory.containsKey(p);
                }
            }
        });
    }

    private static final class MutexImpl
    implements MutexImplementation {
        private final NbProjectManager owner;
        private final boolean autoSave;
        private final Project[] projects;
        private final AtomicInteger writeDepth = new AtomicInteger();

        MutexImpl(@NonNull NbProjectManager owner, boolean autoSave, @NonNull Project project, Project ... otherProjects) {
            Parameters.notNull("owner", owner);
            Parameters.notNull("project", project);
            Parameters.notNull("otherProjects", otherProjects);
            this.owner = owner;
            this.autoSave = autoSave;
            this.projects = new Project[1 + otherProjects.length];
            this.projects[0] = project;
            System.arraycopy(otherProjects, 0, this.projects, 1, otherProjects.length);
        }

        @Override
        public boolean isReadAccess() {
            return this.owner.MUTEX.isReadAccess();
        }

        @Override
        public boolean isWriteAccess() {
            return this.owner.MUTEX.isWriteAccess();
        }

        @Override
        public void writeAccess(Runnable runnable) {
            this.owner.MUTEX.writeAccess(this.wrap(runnable));
        }

        @Override
        public <T> T writeAccess(Mutex.ExceptionAction<T> action) throws MutexException {
            return this.owner.MUTEX.writeAccess(this.wrap(action));
        }

        @Override
        public void readAccess(Runnable runnable) {
            this.owner.MUTEX.readAccess(this.wrap(runnable));
        }

        @Override
        public <T> T readAccess(Mutex.ExceptionAction<T> action) throws MutexException {
            return this.owner.MUTEX.readAccess(action);
        }

        @Override
        public void postReadRequest(Runnable run) {
            this.owner.MUTEX.postReadRequest(run);
        }

        @Override
        public void postWriteRequest(Runnable run) {
            this.owner.MUTEX.postWriteRequest(this.wrap(run));
        }

        @NonNull
        private Runnable wrap(final @NonNull Runnable r) {
            return this.autoSave ? new Runnable(){

                @Override
                public void run() {
                    writeDepth.incrementAndGet();
                    try {
                        r.run();
                    }
                    finally {
                        if (writeDepth.decrementAndGet() == 0) {
                            this.saveProjects(RuntimeException.class);
                        }
                    }
                }
            } : r;
        }

        private <T> Mutex.ExceptionAction<T> wrap(final @NonNull Mutex.ExceptionAction<T> a) {
            return this.autoSave ? new Mutex.ExceptionAction<T>(){

                @Override
                public T run() throws Exception {
                    writeDepth.incrementAndGet();
                    try {
                        Object t = a.run();
                        return t;
                    }
                    finally {
                        if (writeDepth.decrementAndGet() == 0) {
                            this.saveProjects(IOException.class);
                        }
                    }
                }
            } : a;
        }

        /*
         * WARNING - void declaration
         */
        private <E extends Exception> void saveProjects(@NonNull Class<E> clz) throws E {
            void var5_8;
            ArrayDeque<IOException> causes = new ArrayDeque<IOException>();
            Project[] projectArray = this.projects;
            int n = projectArray.length;
            boolean bl = false;
            while (var5_8 < n) {
                Project prj = projectArray[var5_8];
                try {
                    this.owner.saveProject(prj);
                }
                catch (IOException ioe) {
                    causes.add(ioe);
                }
                ++var5_8;
            }
            if (!causes.isEmpty()) {
                try {
                    Exception exc = (Exception)clz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    for (Exception exception : causes) {
                        exc.addSuppressed(exception);
                    }
                    throw exc;
                }
                catch (ReflectiveOperationException e) {
                    throw new IllegalStateException(e);
                }
            }
        }
    }

    private final class ProjectDeletionListener
    extends FileChangeAdapter {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void fileDeleted(FileEvent fe) {
            Map map = NbProjectManager.this.dir2Proj;
            synchronized (map) {
                LOG.log(Level.FINE, "deleted: {0}", fe.getFile());
                Union2 prjOrLs = (Union2)NbProjectManager.this.dir2Proj.remove(fe.getFile());
                NbProjectManager.this.callBack.notifyDeleted(prjOrLs != null && prjOrLs.hasFirst() ? (Project)((Reference)prjOrLs.first()).get() : null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void fileRenamed(FileRenameEvent fe) {
            Map map = NbProjectManager.this.dir2Proj;
            synchronized (map) {
                LOG.log(Level.FINE, "renamed: {0}", fe.getFile());
                Union2 prjOrLs = (Union2)NbProjectManager.this.dir2Proj.remove(fe.getFile());
                NbProjectManager.this.callBack.notifyDeleted(prjOrLs != null && prjOrLs.hasFirst() ? (Project)((Reference)prjOrLs.first()).get() : null);
            }
        }
    }

    private final class ProjectStateImpl
    implements ProjectState {
        private Project p;

        private ProjectStateImpl() {
        }

        void attach(Project p) {
            assert (p != null);
            assert (this.p == null);
            this.p = p;
        }

        @Override
        public void markModified() {
            assert (this.p != null);
            LOG.log(Level.FINE, "markModified({0})", this.p.getProjectDirectory());
            NbProjectManager.this.getMutex().writeAccess(new Mutex.Action<Void>(){

                @Override
                public Void run() {
                    if (NbProjectManager.this.proj2Factory.containsKey(ProjectStateImpl.this.p)) {
                        NbProjectManager.this.modifiedProjects.add(ProjectStateImpl.this.p);
                    } else {
                        LOG.log(Level.WARNING, "An attempt to call ProjectState.markModified on an unknown project: {0}", ProjectStateImpl.this.p.getProjectDirectory());
                    }
                    return null;
                }
            });
        }

        @Override
        public void notifyDeleted() throws IllegalStateException {
            assert (this.p != null);
            final FileObject dir = this.p.getProjectDirectory();
            LOG.log(Level.FINE, "notifyDeleted: {0}", dir);
            NbProjectManager.this.getMutex().writeAccess(new Mutex.Action<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void run() {
                    Map map = NbProjectManager.this.dir2Proj;
                    synchronized (map) {
                        Union2 o = (Union2)NbProjectManager.this.dir2Proj.get(dir);
                        if (o != null && o.hasFirst() && ((Reference)o.first()).get() == ProjectStateImpl.this.p) {
                            NbProjectManager.this.dir2Proj.remove(dir);
                        } else {
                            LOG.log(Level.FINE, "notifyDeleted skipping dir2Proj update since {0} @{1} != {2}", new Object[]{ProjectStateImpl.this.p, ProjectStateImpl.this.p.hashCode(), o});
                        }
                    }
                    NbProjectManager.this.proj2Factory.remove(ProjectStateImpl.this.p);
                    NbProjectManager.this.modifiedProjects.remove(ProjectStateImpl.this.p);
                    if (!NbProjectManager.this.removedProjects.add(ProjectStateImpl.this.p)) {
                        LOG.log(Level.WARNING, "An attempt to call notifyDeleted more than once. Project: {0}", dir);
                    }
                    NbProjectManager.this.callBack.notifyDeleted(ProjectStateImpl.this.p);
                    return null;
                }
            });
        }
    }

    private static enum LoadStatus {
        NO_SUCH_PROJECT,
        SOME_SUCH_PROJECT,
        LOADING_PROJECT;


        public boolean is(Union2<Reference<Project>, LoadStatus> o) {
            return o != null && o.hasSecond() && o.second() == this;
        }

        public Union2<Reference<Project>, LoadStatus> wrap() {
            return Union2.createSecond(this);
        }
    }
}

