/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.suggestions;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.prefs.Preferences;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.JComponent;
import jpt.sun.source.tree.ExpressionTree;
import jpt.sun.source.tree.NewArrayTree;
import jpt.sun.source.tree.Tree;
import jpt.sun.source.tree.VariableTree;
import jpt.sun.source.util.TreePath;
import jpt30.lang.model.element.Element;
import jpt30.lang.model.element.ElementKind;
import jpt30.lang.model.element.Modifier;
import jpt30.lang.model.element.TypeElement;
import jpt30.lang.model.type.DeclaredType;
import jpt30.lang.model.type.TypeKind;
import jpt30.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.hints.ArithmeticUtilities;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.modules.java.hints.suggestions.Bundle;
import org.netbeans.modules.java.hints.suggestions.ConstantNameOptions;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.CustomizerProvider;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;

public class ConstantNameHint {
    static final String PREF_MIN_LENGTH = "minLength";
    static final String PREF_MAX_LENGTH = "maxLength";
    static final String PREF_CHECK_ONLY_IMMUTABLES = "onlyCheckImmutables";
    static final String PREF_IMMUTABLE_CLASSES = "immutableClasses";
    static final String PREF_CONSTANT_NAME_PATTERN = "namePattern";
    private static final String ID = "org.netbeans.modules.java.hints.suggestions.ConstantNameHint";
    static final String DEFAULT_CONSTANT_NAME_PATTERN = "[A-Z]([A-Z\\d_]*[A-Z\\d])?";
    static final int DEFAULT_MIN_LENGTH = 0;
    static final int DEFAULT_MAX_LENGTH = 35;
    static final boolean DEFAULT_CHECK_ONLY_IMMUTABLES = true;
    static final Set<String> IGNORE_CONSTANT_NAMES = new HashSet<String>();
    private static final Set<String> IMMUTABLE_JDK_CLASSES;

    public static ErrorDescription checkConstantName(HintContext ctx) {
        TreePath p = ctx.getPath();
        if (p.getParentPath() == null) {
            return null;
        }
        Tree parent = p.getParentPath().getLeaf();
        if (parent.getKind() != Tree.Kind.CLASS && parent.getKind() != Tree.Kind.INTERFACE && parent.getKind() != Tree.Kind.ENUM) {
            return null;
        }
        VariableTree vt = (VariableTree)p.getLeaf();
        Set<Modifier> mods = vt.getModifiers().getFlags();
        if (parent.getKind() != Tree.Kind.INTERFACE) {
            if (parent.getKind() == Tree.Kind.ENUM) {
                return null;
            }
            if (!mods.contains((Object)Modifier.FINAL) || !mods.contains((Object)Modifier.STATIC)) {
                return null;
            }
        }
        if (IGNORE_CONSTANT_NAMES.contains(vt.getName().toString())) {
            return null;
        }
        Preferences prefs = ctx.getPreferences();
        boolean onlyImmClasses = prefs.getBoolean(PREF_CHECK_ONLY_IMMUTABLES, true);
        if (onlyImmClasses && !ConstantNameHint.isImmutableValue(ctx.getInfo(), p, ctx.getPreferences())) {
            return null;
        }
        String constantName = vt.getName().toString();
        String patString = prefs.get(PREF_CONSTANT_NAME_PATTERN, DEFAULT_CONSTANT_NAME_PATTERN);
        if ("".equals(patString)) {
            return null;
        }
        try {
            Pattern namePattern = Pattern.compile(patString);
            if (!namePattern.matcher(constantName).matches()) {
                return ErrorDescriptionFactory.forName(ctx, vt, Bundle.ERR_BadConstantName(constantName), new Fix[0]);
            }
        }
        catch (PatternSyntaxException namePattern) {
            // empty catch block
        }
        int min = prefs.getInt(PREF_MIN_LENGTH, 0);
        if (min > 0 && constantName.length() < min) {
            return ErrorDescriptionFactory.forName(ctx, vt, Bundle.ERR_ConstantNameMinLength(min), new Fix[0]);
        }
        int max = prefs.getInt(PREF_MAX_LENGTH, 0);
        if (max > 0 && constantName.length() > max) {
            return ErrorDescriptionFactory.forName(ctx, vt, Bundle.ERR_ConstantNameMaxLength(max), new Fix[0]);
        }
        return null;
    }

    private static boolean isImmutableType(CompilationInfo info, TypeMirror m, Preferences p) {
        if (m == null) {
            return false;
        }
        if (m.getKind().isPrimitive() || !Utilities.isValidType(m)) {
            return true;
        }
        if (Utilities.isPrimitiveWrapperType(m)) {
            return true;
        }
        if (m.getKind() != TypeKind.DECLARED) {
            return false;
        }
        Element e = ((DeclaredType)m).asElement();
        if (e == null) {
            return false;
        }
        if (e.getKind() == ElementKind.ENUM) {
            return true;
        }
        if (e.getKind() != ElementKind.CLASS) {
            return false;
        }
        String qn = ((TypeElement)e).getQualifiedName().toString();
        if (IMMUTABLE_JDK_CLASSES.contains(qn)) {
            return true;
        }
        List<String> classes = ConstantNameHint.getImmutableTypes(p);
        return classes.contains(qn);
    }

    private static boolean isImmutableValue(CompilationInfo info, TreePath val, Preferences p) {
        TypeMirror m = info.getTrees().getTypeMirror(val);
        if (Utilities.isValidType(m) && m.getKind() == TypeKind.ARRAY) {
            return ConstantNameHint.checkZeroSizeArray(info, val);
        }
        return ConstantNameHint.isImmutableType(info, m, p);
    }

    private static boolean checkZeroSizeArray(CompilationInfo info, TreePath val) {
        if (val.getLeaf().getKind() != Tree.Kind.VARIABLE) {
            return false;
        }
        VariableTree vt = (VariableTree)val.getLeaf();
        ExpressionTree xpr = vt.getInitializer();
        if (xpr == null) {
            return false;
        }
        if (xpr.getKind() == Tree.Kind.NEW_ARRAY) {
            NewArrayTree nat = (NewArrayTree)xpr;
            List<? extends ExpressionTree> dims = nat.getDimensions();
            if (dims != null && !dims.isEmpty()) {
                Number size = ArithmeticUtilities.compute(info, new TreePath(new TreePath(val, xpr), dims.get(dims.size() - 1)), true);
                return ArithmeticUtilities.isRealValue(size) && Integer.valueOf(0).equals(size);
            }
            return nat.getInitializers() != null && nat.getInitializers().isEmpty();
        }
        return false;
    }

    public static List<String> getImmutableTypes(Preferences p) {
        String val = p.get(PREF_IMMUTABLE_CLASSES, "");
        StringTokenizer tukac = new StringTokenizer(", ", val);
        ArrayList<String> res = new ArrayList<String>(3);
        while (tukac.hasMoreTokens()) {
            String token = tukac.nextToken();
            if (token.isEmpty()) continue;
            res.add(token);
        }
        return res;
    }

    public static void setImmutableTypes(Preferences p, List<String> types) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String s : types) {
            if (first) {
                sb.append(", ");
            }
            first = false;
            sb.append(s);
        }
        p.put(PREF_IMMUTABLE_CLASSES, sb.toString());
    }

    static {
        IGNORE_CONSTANT_NAMES.add("serialVersionUID");
        IGNORE_CONSTANT_NAMES.add("serialPersistentFields");
        IMMUTABLE_JDK_CLASSES = new HashSet<String>();
        IMMUTABLE_JDK_CLASSES.add("java.lang.String");
        IMMUTABLE_JDK_CLASSES.add("java.awt.Color");
        IMMUTABLE_JDK_CLASSES.add("java.awt.Font");
        IMMUTABLE_JDK_CLASSES.add("java.math.BigDecimal");
        IMMUTABLE_JDK_CLASSES.add("java.math.BigInteger");
        IMMUTABLE_JDK_CLASSES.add("java.io.File");
        IMMUTABLE_JDK_CLASSES.add("java.nio.Path");
        IMMUTABLE_JDK_CLASSES.add("java.io.URI");
        IMMUTABLE_JDK_CLASSES.add("java.util.regex.Pattern");
    }

    public static class CPImpl
    implements CustomizerProvider {
        @Override
        public JComponent getCustomizer(Preferences prefs) {
            return new ConstantNameOptions(prefs);
        }
    }
}

