/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import jpt.sun.source.tree.AnnotationTree;
import jpt.sun.source.tree.MethodTree;
import jpt.sun.source.tree.ModifiersTree;
import jpt.sun.source.tree.Tree;
import jpt.sun.source.util.TreePath;
import jpt30.lang.model.SourceVersion;
import jpt30.lang.model.element.AnnotationMirror;
import jpt30.lang.model.element.Element;
import jpt30.lang.model.element.ElementKind;
import jpt30.lang.model.element.ExecutableElement;
import jpt30.lang.model.element.TypeElement;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.editor.codegen.GeneratorUtils;
import org.netbeans.modules.java.editor.overridden.AnnotationType;
import org.netbeans.modules.java.editor.overridden.ComputeOverriding;
import org.netbeans.modules.java.editor.overridden.ElementDescription;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFix;
import org.openide.util.NbBundle;

public class AddOverrideAnnotation {
    public Set<Tree.Kind> getTreeKinds() {
        return EnumSet.of(Tree.Kind.METHOD);
    }

    public static ErrorDescription run(HintContext ctx) {
        CompilationInfo compilationInfo = ctx.getInfo();
        TreePath treePath = ctx.getPath();
        TypeElement el = compilationInfo.getElements().getTypeElement("java.lang.Override");
        if (el == null || !GeneratorUtils.supportsOverride(compilationInfo)) {
            return null;
        }
        Element e = compilationInfo.getTrees().getElement(treePath);
        if (e != null && e.getKind() == ElementKind.METHOD) {
            ExecutableElement ee = (ExecutableElement)e;
            ArrayList<ElementDescription> result = new ArrayList<ElementDescription>();
            Element enclEl = ee.getEnclosingElement();
            if (!enclEl.getKind().isClass() && !enclEl.getKind().isInterface()) {
                return null;
            }
            AnnotationType type = ComputeOverriding.detectOverrides(compilationInfo, (TypeElement)enclEl, ee, result);
            boolean hasOverriddenAnnotation = false;
            for (AnnotationMirror annotationMirror : ee.getAnnotationMirrors()) {
                if (!compilationInfo.getTypes().isSameType(annotationMirror.getAnnotationType(), el.asType())) continue;
                hasOverriddenAnnotation = true;
                break;
            }
            if (hasOverriddenAnnotation) {
                return null;
            }
            boolean addHint = false;
            if (type == AnnotationType.OVERRIDES) {
                addHint = true;
            } else if (type == AnnotationType.IMPLEMENTS) {
                boolean bl = addHint = compilationInfo.getSourceVersion() != SourceVersion.RELEASE_5;
            }
            if (addHint) {
                String string = NbBundle.getMessage(AddOverrideAnnotation.class, "HINT_AddOverrideAnnotation");
                return ErrorDescriptionFactory.forName(ctx, treePath, string, new FixImpl(compilationInfo, treePath).toEditorFix());
            }
        }
        return null;
    }

    private static final class FixImpl
    extends JavaFix {
        private static final Set<Tree.Kind> DECLARATION = EnumSet.of(Tree.Kind.ANNOTATION_TYPE, new Tree.Kind[]{Tree.Kind.CLASS, Tree.Kind.ENUM, Tree.Kind.INTERFACE, Tree.Kind.METHOD, Tree.Kind.VARIABLE});

        public FixImpl(CompilationInfo info, TreePath treePath) {
            super(info, treePath);
        }

        @Override
        public String getText() {
            return NbBundle.getMessage(AddOverrideAnnotation.class, "FIX_AddOverrideAnnotation");
        }

        @Override
        protected void performRewrite(JavaFix.TransformationContext ctx) {
            WorkingCopy copy = ctx.getWorkingCopy();
            TreePath path = ctx.getPath();
            while (path.getLeaf().getKind() != Tree.Kind.COMPILATION_UNIT && !DECLARATION.contains((Object)path.getLeaf().getKind())) {
                path = path.getParentPath();
            }
            if (path.getLeaf().getKind() == Tree.Kind.COMPILATION_UNIT) {
                return;
            }
            Tree top = path.getLeaf();
            ModifiersTree modifiers = null;
            switch (top.getKind()) {
                case METHOD: {
                    modifiers = ((MethodTree)top).getModifiers();
                    break;
                }
                default: {
                    assert (false) : "Unhandled Tree.Kind";
                    break;
                }
            }
            if (modifiers == null) {
                return;
            }
            TypeElement el = copy.getElements().getTypeElement("java.lang.Override");
            if (el == null) {
                return;
            }
            for (AnnotationTree annotationTree : modifiers.getAnnotations()) {
                TreePath tp = new TreePath(new TreePath(path, annotationTree), annotationTree.getAnnotationType());
                Element e = copy.getTrees().getElement(tp);
                if (!el.equals(e)) continue;
                return;
            }
            ArrayList<? extends AnnotationTree> annotations = new ArrayList<AnnotationTree>(modifiers.getAnnotations());
            annotations.add(copy.getTreeMaker().Annotation(copy.getTreeMaker().QualIdent(el), Collections.emptyList()));
            ModifiersTree modifiersTree = copy.getTreeMaker().Modifiers(modifiers, annotations);
            copy.rewrite(modifiers, modifiersTree);
        }
    }
}

