/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.overridden;

import java.awt.Image;
import java.awt.Toolkit;
import java.util.Collection;
import javax.swing.Icon;
import jpt30.lang.model.element.Element;
import jpt30.lang.model.element.ElementKind;
import jpt30.lang.model.element.Modifier;
import jpt30.lang.model.element.PackageElement;
import jpt30.lang.model.element.TypeElement;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.ui.ElementIcons;
import org.netbeans.api.java.source.ui.ElementOpen;
import org.netbeans.modules.editor.java.Utilities;
import org.openide.filesystems.FileObject;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class ElementDescription {
    private static final String PKG_COLOR = Utilities.getHTMLColor(192, 192, 192);
    private final ElementKind imageKind;
    private ClasspathInfo originalCPInfo;
    private ElementHandle<Element> handle;
    private ElementHandle<TypeElement> outtermostElement;
    private Collection<Modifier> modifiers;
    private String displayName;
    private final boolean overriddenFlag;

    public ElementDescription(CompilationInfo info, Element element, boolean overriddenFlag) {
        this.originalCPInfo = info.getClasspathInfo();
        this.handle = ElementHandle.create(element);
        this.imageKind = ElementKind.METHOD.equals((Object)element.getKind()) && null != element.getEnclosingElement() ? element.getEnclosingElement().getKind() : this.handle.getKind();
        this.outtermostElement = ElementHandle.create(SourceUtils.getOutermostEnclosingTypeElement(element));
        this.modifiers = element.getModifiers();
        this.displayName = overriddenFlag ? ElementDescription.computeDisplayNameIsOverridden(element) : ElementDescription.computeDisplayNameOverrides(element);
        this.overriddenFlag = overriddenFlag;
    }

    private static String computeDisplayNameIsOverridden(Element element) throws IllegalStateException {
        TypeElement clazz;
        if (element.getKind().isClass() || element.getKind().isInterface()) {
            clazz = (TypeElement)element;
        } else {
            assert (element.getKind() == ElementKind.METHOD) : element.getKind();
            clazz = (TypeElement)element.getEnclosingElement();
        }
        StringBuilder displayName = new StringBuilder();
        Element parent = clazz.getEnclosingElement();
        displayName.append("<html>");
        displayName.append(ElementDescription.computeSimpleName(clazz));
        while (ElementDescription.isAnonymous(parent) || parent.getKind() == ElementKind.CONSTRUCTOR || parent.getKind() == ElementKind.INSTANCE_INIT || parent.getKind() == ElementKind.METHOD || parent.getKind() == ElementKind.STATIC_INIT) {
            displayName.append(' ');
            displayName.append(NbBundle.getMessage(ElementDescription.class, "NAME_In"));
            displayName.append(' ');
            displayName.append(ElementDescription.computeSimpleName(parent));
            parent = parent.getEnclosingElement();
        }
        displayName.append(' ');
        displayName.append(PKG_COLOR);
        displayName.append('(');
        displayName.append(ElementDescription.getQualifiedName(parent));
        displayName.append(')');
        return displayName.toString();
    }

    private static boolean isAnonymous(Element el) {
        if (!el.getKind().isClass()) {
            return false;
        }
        TypeElement clazz = (TypeElement)el;
        return clazz.getQualifiedName() == null || clazz.getQualifiedName().length() == 0 || clazz.getSimpleName() == null || clazz.getSimpleName().length() == 0;
    }

    private static String computeSimpleName(Element clazz) {
        if (ElementDescription.isAnonymous(clazz)) {
            return NbBundle.getMessage(ElementDescription.class, "NAME_AnonynmousInner");
        }
        String simpleName = clazz.getSimpleName().toString();
        return simpleName;
    }

    private static CharSequence getQualifiedName(Element el) {
        if (el.getKind() == ElementKind.PACKAGE) {
            return ((PackageElement)el).getQualifiedName();
        }
        if (el.getKind().isClass() || el.getKind().isInterface()) {
            return ((TypeElement)el).getQualifiedName();
        }
        throw new IllegalStateException();
    }

    private static String computeDisplayNameOverrides(Element element) {
        return ((TypeElement)element.getEnclosingElement()).getQualifiedName().toString();
    }

    public FileObject getSourceFile() {
        FileObject file = SourceUtils.getFile(this.outtermostElement, this.originalCPInfo);
        if (file != null) {
            return SourceUtils.getFile(this.outtermostElement, ClasspathInfo.create(file));
        }
        return null;
    }

    public void open() {
        if (!ElementOpen.open(this.originalCPInfo, this.getHandle())) {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public ClasspathInfo getOriginalCPInfo() {
        return this.originalCPInfo;
    }

    public ElementHandle<Element> getHandle() {
        return this.handle;
    }

    public Icon getIcon() {
        Image badge = this.overriddenFlag ? ImageUtilities.loadImage("org/netbeans/modules/java/editor/resources/is-overridden-badge.png") : ImageUtilities.loadImage("org/netbeans/modules/java/editor/resources/overrides-badge.png");
        Image icon = ImageUtilities.icon2Image(ElementIcons.getElementIcon(this.imageKind, this.modifiers));
        return ImageUtilities.image2Icon(ImageUtilities.mergeImages(icon, badge, 16, 0));
    }

    public boolean isOverridden() {
        return this.overriddenFlag;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Collection<Modifier> getModifiers() {
        return this.modifiers;
    }
}

