/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.editor.mimelookup;

import org.netbeans.api.editor.mimelookup.MimePath;
import org.openide.util.Lookup;

public final class MimeLookup
extends Lookup {
    private Lookup mimePathLookup;
    private final MimePath mimePath;

    public static Lookup getLookup(MimePath mimePath) {
        if (mimePath == null) {
            throw new NullPointerException("The mimePath parameter must not be null.");
        }
        return mimePath.getLookup();
    }

    public static Lookup getLookup(String mimePath) {
        return MimeLookup.getLookup(MimePath.parse(mimePath));
    }

    @Deprecated
    public static MimeLookup getMimeLookup(String mimeType) {
        if (mimeType == null) {
            throw new NullPointerException("The mimeType parameter must not be null.");
        }
        MimePath path = MimePath.get(mimeType);
        return new MimeLookup(path, MimePath.get(mimeType).getLookup());
    }

    private MimeLookup(MimePath path, Lookup lookup) {
        this.mimePathLookup = lookup;
        this.mimePath = path;
    }

    @Deprecated
    public MimeLookup childLookup(String mimeType) {
        if (mimeType == null) {
            throw new NullPointerException("The mimeType parameter must not be null.");
        }
        MimePath newPath = MimePath.get(this.mimePath, mimeType);
        return new MimeLookup(newPath, newPath.getLookup());
    }

    @Override
    @Deprecated
    public <T> T lookup(Class<T> clazz) {
        return this.mimePathLookup.lookup(clazz);
    }

    @Override
    @Deprecated
    public <T> Lookup.Result<T> lookup(Lookup.Template<T> template) {
        return this.mimePathLookup.lookup(template);
    }
}

