/*
 * Decompiled with CFR 0.152.
 */
package jpt.sun.tools.javac.code;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import jpt.sun.tools.javac.code.Lint;
import jpt.sun.tools.javac.code.Source;
import jpt.sun.tools.javac.code.Symbol;
import jpt.sun.tools.javac.code.Symtab;
import jpt.sun.tools.javac.jvm.Target;
import jpt.sun.tools.javac.main.Option;
import jpt.sun.tools.javac.resources.CompilerProperties;
import jpt.sun.tools.javac.util.Assert;
import jpt.sun.tools.javac.util.Context;
import jpt.sun.tools.javac.util.JCDiagnostic;
import jpt.sun.tools.javac.util.Log;
import jpt.sun.tools.javac.util.MandatoryWarningHandler;
import jpt.sun.tools.javac.util.Names;
import jpt.sun.tools.javac.util.Options;
import jpt30.tools.JavaFileObject;

public class Preview {
    private final boolean enabled;
    private final boolean verbose;
    private final MandatoryWarningHandler previewHandler;
    private final boolean forcePreview;
    private final Map<Integer, Source> majorVersionToSource;
    private final Set<JavaFileObject> sourcesWithPreviewFeatures = new HashSet<JavaFileObject>();
    private final Names names;
    private final Log log;
    private final Source source;
    protected static final Context.Key<Preview> previewKey = new Context.Key();

    public static Preview instance(Context context) {
        Preview instance = context.get(previewKey);
        if (instance == null) {
            instance = new Preview(context);
        }
        return instance;
    }

    protected Preview(Context context) {
        context.put(previewKey, this);
        Options options = Options.instance(context);
        this.names = Names.instance(context);
        this.enabled = options.isSet(Option.PREVIEW);
        this.log = Log.instance(context);
        this.source = Source.instance(context);
        this.verbose = Lint.instance(context).isEnabled(Lint.LintCategory.PREVIEW);
        this.previewHandler = new MandatoryWarningHandler(this.log, this.source, this.verbose, true, Lint.LintCategory.PREVIEW);
        this.forcePreview = options.isSet("forcePreview");
        this.majorVersionToSource = this.initMajorVersionToSourceMap();
    }

    private Map<Integer, Source> initMajorVersionToSourceMap() {
        HashMap<Integer, Source> majorVersionToSource = new HashMap<Integer, Source>();
        for (Target t : Target.values()) {
            int major = t.majorVersion;
            Source source = Source.lookup(t.name);
            if (source == null) continue;
            majorVersionToSource.put(major, source);
        }
        return majorVersionToSource;
    }

    public boolean participatesInPreview(Symtab syms, Symbol s, Symbol previewSymbol) {
        if (previewSymbol.packge().modle == s.packge().modle) {
            return true;
        }
        return this.participatesInPreview(syms, s.packge().modle);
    }

    public boolean participatesInPreview(Symtab syms, Symbol.ModuleSymbol m) {
        return syms.java_base.exports.stream().filter(ed -> ed.packge.fullname == this.names.jdk_internal_javac).anyMatch(ed -> ed.modules.contains(m));
    }

    public void warnPreview(int pos, Source.Feature feature) {
        this.warnPreview(new JCDiagnostic.SimpleDiagnosticPosition(pos), feature);
    }

    public void warnPreview(JCDiagnostic.DiagnosticPosition pos, Source.Feature feature) {
        Assert.check(this.isEnabled());
        Assert.check(this.isPreview(feature));
        this.markUsesPreview(pos);
        this.previewHandler.report(pos, feature.isPlural() ? CompilerProperties.LintWarnings.PreviewFeatureUsePlural(feature.nameFragment()) : CompilerProperties.LintWarnings.PreviewFeatureUse(feature.nameFragment()));
    }

    public void warnPreview(JavaFileObject classfile, int majorVersion) {
        Assert.check(this.isEnabled());
        if (this.verbose) {
            this.log.mandatoryWarning(null, CompilerProperties.LintWarnings.PreviewFeatureUseClassfile(classfile, this.majorVersionToSource.get((Object)Integer.valueOf((int)majorVersion)).name));
        }
    }

    public void markUsesPreview(JCDiagnostic.DiagnosticPosition pos) {
        this.sourcesWithPreviewFeatures.add(this.log.currentSourceFile());
    }

    public void reportPreviewWarning(JCDiagnostic.DiagnosticPosition pos, JCDiagnostic.LintWarning warnKey) {
        this.previewHandler.report(pos, warnKey);
    }

    public boolean usesPreview(JavaFileObject file) {
        return this.sourcesWithPreviewFeatures.contains(file);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isPreview(Source.Feature feature) {
        boolean bl;
        switch (feature) {
            case PRIMITIVE_PATTERNS: {
                bl = true;
                break;
            }
            default: {
                bl = this.forcePreview;
            }
        }
        return bl;
    }

    public JCDiagnostic.Error disabledError(Source.Feature feature) {
        Assert.check(!this.isEnabled());
        return feature.isPlural() ? CompilerProperties.Errors.PreviewFeatureDisabledPlural(feature.nameFragment()) : CompilerProperties.Errors.PreviewFeatureDisabled(feature.nameFragment());
    }

    public JCDiagnostic.Error disabledError(JavaFileObject classfile, int majorVersion) {
        Assert.check(!this.isEnabled());
        return CompilerProperties.Errors.PreviewFeatureDisabledClassfile(classfile, this.majorVersionToSource.get((Object)Integer.valueOf((int)majorVersion)).name);
    }

    public boolean declaredUsingPreviewFeature(Symbol sym) {
        return false;
    }

    public void reportDeferredDiagnostics() {
        this.previewHandler.reportDeferredDiagnostic();
    }

    public void clear() {
        this.previewHandler.clear();
    }

    public void checkSourceLevel(JCDiagnostic.DiagnosticPosition pos, Source.Feature feature) {
        if (this.isPreview(feature) && !this.isEnabled()) {
            this.log.error(JCDiagnostic.DiagnosticFlag.SOURCE_LEVEL, pos, this.disabledError(feature));
        } else {
            if (!feature.allowedInSource(this.source)) {
                this.log.error(JCDiagnostic.DiagnosticFlag.SOURCE_LEVEL, pos, feature.error(this.source.name));
            }
            if (this.isEnabled() && this.isPreview(feature)) {
                this.warnPreview(pos, feature);
            }
        }
    }
}

