/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.myfaces.tobago.internal.lifecycle;

import org.apache.myfaces.tobago.internal.util.Deprecation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;
import java.util.Iterator;

/**
 * Not longer needed.
 *
 * @deprecated since Tobago 2.0.0
 */
@Deprecated
public class TobagoLifecycleFactory extends LifecycleFactory {

  private static final Logger LOG = LoggerFactory.getLogger(TobagoLifecycleFactory.class);

  private LifecycleFactory factory;
  private TobagoLifecycle defaultLifecycle;

  public TobagoLifecycleFactory(final LifecycleFactory factory) {
    this.factory = factory;
    defaultLifecycle = new TobagoLifecycle();
    Deprecation.LOG.warn("new TobagoLifecycleFactory");
  }

  public void addLifecycle(final String lifecycleId, final Lifecycle lifecycle) {
    factory.addLifecycle(lifecycleId, lifecycle);
    Deprecation.LOG.warn("Lifecycle added : " + lifecycleId + " = " + lifecycle.getClass().getName() + "");
  }

  public Lifecycle getLifecycle(final String lifecycleId) {
    if (LifecycleFactory.DEFAULT_LIFECYCLE.equals(lifecycleId)) {
      Deprecation.LOG.warn("getLifecycle(\"" + lifecycleId + "\")  -> TobagoLifecycle");
      return defaultLifecycle;
    } else {
      Deprecation.LOG.warn("getLifecycle(\"" + lifecycleId + "\")  -> other Lifecycle");
      return factory.getLifecycle(lifecycleId);
    }
  }

  public Iterator<String> getLifecycleIds() {
    Deprecation.LOG.warn("getLifecycleIds()");
    return factory.getLifecycleIds();
  }
}
