/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.myfaces.orchestra.filter;

import java.io.IOException;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

import org.apache.myfaces.orchestra.CoreConfig;

/**
 * Perform a number of useful per-request tasks.
 * <p>
 * This filter has been deprecated. The configuration settings it supports are
 * still implemented; however web.xml files defining this filter should instead
 * simply define context params using the corresponding constants from class 
 * org.apache.myfaces.orchestra.CoreConfig instead.
 * <p>
 * <h2>Request Serialization</h2>
 * Request serialization functionality can be enabled or disabled via a filter init
 * parameter; setting "serializeRequests" to "false" disables this feature. Default
 * value: true (enabled).
 * <p>
 * See {@link org.apache.myfaces.orchestra.CoreConfig#SERIALIZE_REQUESTS} for further details.
 * <p>
 * <h2>JDBC Connection Management</h2>
 * This servlet always enables connection management; see
 * {@link org.apache.myfaces.orchestra.CoreConfig#CLEANUP_CONNECTIONS}
 * for further details.
 */

public class OrchestraServletFilter implements Filter
{
    /**
     * This filter init property can be set to "true" or "false". Default: "true".
     */
    public final static String SERIALIZE_REQUESTS = "serializeRequests"; // NON-NLS

    private boolean serializeRequests = true;

    public void init(FilterConfig filterConfig) throws ServletException
    {
        String value = filterConfig.getInitParameter(SERIALIZE_REQUESTS);
        if ("false".equals(value)) // NON-NLS
        {
            serializeRequests = false;
        }
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse,
      final FilterChain filterChain) throws IOException, ServletException
    {
        // Copy the setting over to where the ContextLockRequestHandler class can see it.
        servletRequest.setAttribute(CoreConfig.SERIALIZE_REQUESTS, Boolean.valueOf(serializeRequests));
        filterChain.doFilter(servletRequest, servletResponse);
    }

    public void destroy()
    {
    }
}
