/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared_orchestra.renderkit.html;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIGraphic;
import javax.faces.component.html.HtmlGraphicImage;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.shared_orchestra.renderkit.RendererUtils;
import org.apache.myfaces.shared_orchestra.renderkit.html.HTML;
import org.apache.myfaces.shared_orchestra.renderkit.html.HtmlRenderer;
import org.apache.myfaces.shared_orchestra.renderkit.html.HtmlRendererUtils;

public class HtmlImageRendererBase
extends HtmlRenderer {
    private static final Log log = LogFactory.getLog(HtmlImageRendererBase.class);

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        RendererUtils.checkParamValidity(facesContext, uiComponent, UIGraphic.class);
        ResponseWriter writer = facesContext.getResponseWriter();
        String url = uiComponent instanceof HtmlGraphicImage ? ((HtmlGraphicImage)uiComponent).getUrl() : (String)uiComponent.getAttributes().get("url");
        if (url != null && url.length() > 0) {
            writer.startElement("img", uiComponent);
            HtmlRendererUtils.writeIdIfNecessary(writer, uiComponent, facesContext);
            String src = facesContext.getApplication().getViewHandler().getResourceURL(facesContext, url);
            writer.writeURIAttribute("src", (Object)facesContext.getExternalContext().encodeResourceURL(src), null);
            HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.IMG_PASSTHROUGH_ATTRIBUTES);
            writer.endElement("img");
        } else if (log.isWarnEnabled()) {
            log.warn((Object)("Graphic with id " + uiComponent.getClientId(facesContext) + " has no value (url)."));
        }
    }
}

