/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared_orchestra.renderkit;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.faces.FacesException;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.component.UIInput;
import javax.faces.component.UIOutput;
import javax.faces.component.UISelectMany;
import javax.faces.component.UISelectOne;
import javax.faces.component.UIViewRoot;
import javax.faces.component.ValueHolder;
import javax.faces.component.html.HtmlInputText;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.el.PropertyNotFoundException;
import javax.faces.el.ValueBinding;
import javax.faces.event.PhaseId;
import javax.faces.model.SelectItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.shared_orchestra.renderkit._SharedRendererUtils;
import org.apache.myfaces.shared_orchestra.renderkit.html.util.FormInfo;
import org.apache.myfaces.shared_orchestra.util.HashMapUtils;
import org.apache.myfaces.shared_orchestra.util.SelectItemsIterator;

public final class RendererUtils {
    private static final Log log = LogFactory.getLog(RendererUtils.class);
    public static final String SELECT_ITEM_LIST_ATTR = RendererUtils.class.getName() + ".LIST";
    public static final String EMPTY_STRING = "";
    public static final Object NOTHING = new Serializable(){};
    public static final String ACTION_FOR_LIST = "org.apache.myfaces.ActionForList";
    public static final String ACTION_FOR_PHASE_LIST = "org.apache.myfaces.ActionForPhaseList";
    private static final String TRINIDAD_FORM_COMPONENT_FAMILY = "org.apache.myfaces.trinidad.Form";
    private static final String ADF_FORM_COMPONENT_FAMILY = "oracle.adf.Form";

    private RendererUtils() {
    }

    public static String getPathToComponent(UIComponent component) {
        StringBuffer buf = new StringBuffer();
        if (component == null) {
            buf.append("{Component-Path : ");
            buf.append("[null]}");
            return buf.toString();
        }
        RendererUtils.getPathToComponent(component, buf);
        buf.insert(0, "{Component-Path : ");
        buf.append("}");
        return buf.toString();
    }

    private static void getPathToComponent(UIComponent component, StringBuffer buf) {
        if (component == null) {
            return;
        }
        StringBuffer intBuf = new StringBuffer();
        intBuf.append("[Class: ");
        intBuf.append(component.getClass().getName());
        if (component instanceof UIViewRoot) {
            intBuf.append(",ViewId: ");
            intBuf.append(((UIViewRoot)component).getViewId());
        } else {
            intBuf.append(",Id: ");
            intBuf.append(component.getId());
        }
        intBuf.append("]");
        buf.insert(0, intBuf.toString());
        RendererUtils.getPathToComponent(component.getParent(), buf);
    }

    public static String getConcatenatedId(FacesContext context, UIComponent container, String clientId) {
        UIComponent child = container.findComponent(clientId);
        if (child == null) {
            return clientId;
        }
        return RendererUtils.getConcatenatedId(context, child);
    }

    public static String getConcatenatedId(FacesContext context, UIComponent component) {
        UIComponent parent;
        if (context == null) {
            throw new NullPointerException("context");
        }
        StringBuffer idBuf = new StringBuffer();
        idBuf.append(component.getId());
        while ((parent = component.getParent()) != null) {
            if (!(parent instanceof NamingContainer)) continue;
            idBuf.insert(0, ':');
            idBuf.insert(0, parent.getId());
        }
        return idBuf.toString();
    }

    public static Boolean getBooleanValue(UIComponent component) {
        Object value = RendererUtils.getObjectValue(component);
        if (value == null || value instanceof Boolean) {
            return (Boolean)value;
        }
        throw new IllegalArgumentException("Expected submitted value of type Boolean for Component : " + RendererUtils.getPathToComponent(component));
    }

    public static Date getDateValue(UIComponent component) {
        Object value = RendererUtils.getObjectValue(component);
        if (value == null || value instanceof Date) {
            return (Date)value;
        }
        throw new IllegalArgumentException("Expected submitted value of type Date for component : " + RendererUtils.getPathToComponent(component));
    }

    public static Object getObjectValue(UIComponent component) {
        Object value;
        if (!(component instanceof ValueHolder)) {
            throw new IllegalArgumentException("Component : " + RendererUtils.getPathToComponent(component) + "is not a ValueHolder");
        }
        if (component instanceof EditableValueHolder && (value = ((EditableValueHolder)component).getSubmittedValue()) != null && !NOTHING.equals(value)) {
            return value;
        }
        return ((ValueHolder)component).getValue();
    }

    public static String getStringValue(FacesContext context, ValueBinding vb) {
        Object value = vb.getValue(context);
        if (value != null) {
            return value.toString();
        }
        return null;
    }

    public static String getStringValue(FacesContext facesContext, UIComponent component) {
        try {
            Object value;
            Object holder;
            Object submittedValue;
            if (!(component instanceof ValueHolder)) {
                throw new IllegalArgumentException("Component : " + RendererUtils.getPathToComponent(component) + "is not a ValueHolder");
            }
            if (component instanceof EditableValueHolder && (submittedValue = (holder = (EditableValueHolder)component).getSubmittedValue()) != null) {
                if (submittedValue instanceof String) {
                    return (String)submittedValue;
                }
                throw new IllegalArgumentException("Expected submitted value of type String for component : " + RendererUtils.getPathToComponent(component));
            }
            if (component instanceof EditableValueHolder) {
                EditableValueHolder holder2 = (EditableValueHolder)component;
                if (holder2.isLocalValueSet()) {
                    holder = holder2.getLocalValue();
                }
                value = RendererUtils.getValue(component);
            } else {
                value = RendererUtils.getValue(component);
            }
            Converter converter = ((ValueHolder)component).getConverter();
            if (converter == null && value != null) {
                if (value instanceof String) {
                    return (String)value;
                }
                try {
                    converter = facesContext.getApplication().createConverter(value.getClass());
                }
                catch (FacesException e) {
                    log.error((Object)("No converter for class " + value.getClass().getName() + " found (component id=" + component.getId() + ")."));
                }
            }
            if (converter == null) {
                if (value == null) {
                    return EMPTY_STRING;
                }
                return value.toString();
            }
            return converter.getAsString(facesContext, component, value);
        }
        catch (PropertyNotFoundException ex) {
            log.error((Object)("Property not found - called by component : " + RendererUtils.getPathToComponent(component)), (Throwable)ex);
            throw ex;
        }
    }

    private static Object getValue(UIComponent component) {
        Object value;
        try {
            value = ((ValueHolder)component).getValue();
        }
        catch (Exception ex) {
            throw new FacesException("Could not retrieve value of component with path : " + RendererUtils.getPathToComponent(component), (Throwable)ex);
        }
        return value;
    }

    public static boolean isDefaultAttributeValue(Object value) {
        if (value == null) {
            return true;
        }
        if (value instanceof Boolean) {
            return (Boolean)value == false;
        }
        if (value instanceof Number) {
            if (value instanceof Integer) {
                return ((Number)value).intValue() == Integer.MIN_VALUE;
            }
            if (value instanceof Double) {
                return ((Number)value).doubleValue() == Double.MIN_VALUE;
            }
            if (value instanceof Long) {
                return ((Number)value).longValue() == Long.MIN_VALUE;
            }
            if (value instanceof Byte) {
                return ((Number)value).byteValue() == -128;
            }
            if (value instanceof Float) {
                return ((Number)value).floatValue() == Float.MIN_VALUE;
            }
            if (value instanceof Short) {
                return ((Number)value).shortValue() == Short.MIN_VALUE;
            }
        }
        return false;
    }

    public static Converter findUIOutputConverter(FacesContext facesContext, UIOutput component) throws FacesException {
        return _SharedRendererUtils.findUIOutputConverter(facesContext, component);
    }

    public static Converter findUISelectManyConverter(FacesContext facesContext, UISelectMany component) {
        Converter converter = component.getConverter();
        if (converter != null) {
            return converter;
        }
        ValueBinding vb = component.getValueBinding("value");
        if (vb == null) {
            return null;
        }
        Class valueType = vb.getType(facesContext);
        if (valueType == null) {
            return null;
        }
        if (List.class.isAssignableFrom(valueType)) {
            SelectItem selectItem;
            Class<?> listComponentType;
            List selectItems = RendererUtils.internalGetSelectItemList((UIComponent)component);
            if (selectItems != null && selectItems.size() > 0 && !String.class.equals(listComponentType = (selectItem = (SelectItem)selectItems.get(0)).getValue().getClass())) {
                try {
                    return facesContext.getApplication().createConverter(listComponentType);
                }
                catch (FacesException e) {
                    log.error((Object)("No Converter for type " + listComponentType.getName() + " found"), (Throwable)e);
                    return null;
                }
            }
            return null;
        }
        if (!valueType.isArray()) {
            throw new IllegalArgumentException("ValueBinding for UISelectMany : " + RendererUtils.getPathToComponent((UIComponent)component) + " must be of type List or Array");
        }
        Class<?> arrayComponentType = valueType.getComponentType();
        if (String.class.equals(arrayComponentType)) {
            return null;
        }
        if (Object.class.equals(arrayComponentType)) {
            return null;
        }
        try {
            return facesContext.getApplication().createConverter(arrayComponentType);
        }
        catch (FacesException e) {
            log.error((Object)("No Converter for type " + arrayComponentType.getName() + " found"), (Throwable)e);
            return null;
        }
    }

    public static void checkParamValidity(FacesContext facesContext, UIComponent uiComponent, Class compClass) {
        if (facesContext == null) {
            throw new NullPointerException("facesContext may not be null");
        }
        if (uiComponent == null) {
            throw new NullPointerException("uiComponent may not be null");
        }
        if (compClass != null && !compClass.isInstance(uiComponent)) {
            throw new IllegalArgumentException("uiComponent : " + RendererUtils.getPathToComponent(uiComponent) + " is not instance of " + compClass.getName() + " as it should be");
        }
    }

    public static void renderChildren(FacesContext facesContext, UIComponent component) throws IOException {
        if (component.getChildCount() > 0) {
            for (UIComponent child : component.getChildren()) {
                RendererUtils.renderChild(facesContext, child);
            }
        }
    }

    public static void renderChild(FacesContext facesContext, UIComponent child) throws IOException {
        if (!child.isRendered()) {
            return;
        }
        child.encodeBegin(facesContext);
        if (child.getRendersChildren()) {
            child.encodeChildren(facesContext);
        } else {
            RendererUtils.renderChildren(facesContext, child);
        }
        child.encodeEnd(facesContext);
    }

    public static List getSelectItemList(UISelectOne uiSelectOne) {
        return RendererUtils.internalGetSelectItemList((UIComponent)uiSelectOne);
    }

    public static List getSelectItemList(UISelectMany uiSelectMany) {
        return RendererUtils.internalGetSelectItemList((UIComponent)uiSelectMany);
    }

    private static List internalGetSelectItemList(UIComponent uiComponent) {
        ArrayList list = new ArrayList();
        SelectItemsIterator iter = new SelectItemsIterator(uiComponent);
        while (iter.hasNext()) {
            list.add(iter.next());
        }
        return list;
    }

    public static Set getSubmittedValuesAsSet(FacesContext context, UIComponent component, Converter converter, UISelectMany uiSelectMany) {
        Object submittedValues = uiSelectMany.getSubmittedValue();
        if (submittedValues == null) {
            return null;
        }
        if (converter != null) {
            converter = new PassThroughAsStringConverter(converter);
        }
        return RendererUtils.internalSubmittedOrSelectedValuesAsSet(context, component, converter, uiSelectMany, submittedValues);
    }

    public static Set getSelectedValuesAsSet(FacesContext context, UIComponent component, Converter converter, UISelectMany uiSelectMany) {
        Object selectedValues = uiSelectMany.getValue();
        return RendererUtils.internalSubmittedOrSelectedValuesAsSet(context, component, converter, uiSelectMany, selectedValues);
    }

    public static String getConvertedStringValue(FacesContext context, UIComponent component, Converter converter, Object value) {
        if (converter == null) {
            if (value == null) {
                return EMPTY_STRING;
            }
            if (value instanceof String) {
                return (String)value;
            }
            throw new IllegalArgumentException("Value is no String (class=" + value.getClass().getName() + ", value=" + value + ") and component " + component.getClientId(context) + "with path: " + RendererUtils.getPathToComponent(component) + " does not have a Converter");
        }
        return converter.getAsString(context, component, value);
    }

    public static String getConvertedStringValue(FacesContext context, UIComponent component, Converter converter, SelectItem selectItem) {
        return RendererUtils.getConvertedStringValue(context, component, converter, selectItem.getValue());
    }

    private static Set internalSubmittedOrSelectedValuesAsSet(FacesContext context, UIComponent component, Converter converter, UISelectMany uiSelectMany, Object values) {
        if (values == null || EMPTY_STRING.equals(values)) {
            return Collections.EMPTY_SET;
        }
        if (values instanceof Object[]) {
            Object[] ar = (Object[])values;
            if (ar.length == 0) {
                return Collections.EMPTY_SET;
            }
            HashSet<String> set = new HashSet<String>(HashMapUtils.calcCapacity(ar.length));
            for (int i = 0; i < ar.length; ++i) {
                set.add(RendererUtils.getConvertedStringValue(context, component, converter, ar[i]));
            }
            return set;
        }
        if (values.getClass().isArray()) {
            int len = Array.getLength(values);
            HashSet<String> set = new HashSet<String>(HashMapUtils.calcCapacity(len));
            for (int i = 0; i < len; ++i) {
                set.add(RendererUtils.getConvertedStringValue(context, component, converter, Array.get(values, i)));
            }
            return set;
        }
        if (values instanceof List) {
            List lst = (List)values;
            if (lst.size() == 0) {
                return Collections.EMPTY_SET;
            }
            HashSet<String> set = new HashSet<String>(HashMapUtils.calcCapacity(lst.size()));
            Iterator i = lst.iterator();
            while (i.hasNext()) {
                set.add(RendererUtils.getConvertedStringValue(context, component, converter, i.next()));
            }
            return set;
        }
        throw new IllegalArgumentException("Value of UISelectMany component with path : " + RendererUtils.getPathToComponent((UIComponent)uiSelectMany) + " is not of type Array or List");
    }

    public static Object getConvertedUIOutputValue(FacesContext facesContext, UIOutput output, Object submittedValue) throws ConverterException {
        if (submittedValue != null && !(submittedValue instanceof String)) {
            if (NOTHING.equals(submittedValue)) {
                return null;
            }
            throw new IllegalArgumentException("Submitted value of type String for component : " + RendererUtils.getPathToComponent((UIComponent)output) + "expected");
        }
        Converter converter = RendererUtils.findUIOutputConverter(facesContext, output);
        if (converter == null) {
            return submittedValue;
        }
        return converter.getAsObject(facesContext, (UIComponent)output, (String)submittedValue);
    }

    public static Object getConvertedUISelectManyValue(FacesContext facesContext, UISelectMany selectMany, Object submittedValue) throws ConverterException {
        if (submittedValue == null) {
            return null;
        }
        if (!(submittedValue instanceof String[])) {
            throw new ConverterException("Submitted value of type String[] for component : " + RendererUtils.getPathToComponent((UIComponent)selectMany) + "expected");
        }
        return _SharedRendererUtils.getConvertedUISelectManyValue(facesContext, selectMany, (String[])submittedValue);
    }

    public static boolean getBooleanAttribute(UIComponent component, String attrName, boolean defaultValue) {
        Boolean b = (Boolean)component.getAttributes().get(attrName);
        return b != null ? b : defaultValue;
    }

    public static int getIntegerAttribute(UIComponent component, String attrName, int defaultValue) {
        Integer i = (Integer)component.getAttributes().get(attrName);
        return i != null ? i : defaultValue;
    }

    public static FormInfo findNestingForm(UIComponent uiComponent, FacesContext facesContext) {
        UIComponent parent;
        for (parent = uiComponent.getParent(); !(parent == null || ADF_FORM_COMPONENT_FAMILY.equals(parent.getFamily()) || TRINIDAD_FORM_COMPONENT_FAMILY.equals(parent.getFamily()) || parent instanceof UIForm); parent = parent.getParent()) {
        }
        if (parent != null) {
            String formName = parent.getClientId(facesContext);
            return new FormInfo(parent, formName);
        }
        return null;
    }

    public static boolean getBooleanValue(String attribute, Object value, boolean defaultValue) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return Boolean.valueOf((String)value);
        }
        if (value != null) {
            log.error((Object)("value for attribute " + attribute + " must be instanceof 'Boolean' or 'String', is of type : " + value.getClass()));
            return defaultValue;
        }
        return defaultValue;
    }

    public static void copyHtmlInputTextAttributes(HtmlInputText src, HtmlInputText dest) {
        dest.setId(src.getId());
        boolean forceId = RendererUtils.getBooleanValue("forceId", src.getAttributes().get("forceId"), false);
        if (forceId) {
            dest.getAttributes().put("forceId", Boolean.TRUE);
        }
        dest.setImmediate(src.isImmediate());
        dest.setTransient(src.isTransient());
        dest.setAccesskey(src.getAccesskey());
        dest.setAlt(src.getAlt());
        dest.setConverter(src.getConverter());
        dest.setDir(src.getDir());
        dest.setDisabled(src.isDisabled());
        dest.setLang(src.getLang());
        dest.setLocalValueSet(src.isLocalValueSet());
        dest.setMaxlength(src.getMaxlength());
        dest.setOnblur(src.getOnblur());
        dest.setOnchange(src.getOnchange());
        dest.setOnclick(src.getOnclick());
        dest.setOndblclick(src.getOndblclick());
        dest.setOnfocus(src.getOnfocus());
        dest.setOnkeydown(src.getOnkeydown());
        dest.setOnkeypress(src.getOnkeypress());
        dest.setOnkeyup(src.getOnkeyup());
        dest.setOnmousedown(src.getOnmousedown());
        dest.setOnmousemove(src.getOnmousemove());
        dest.setOnmouseout(src.getOnmouseout());
        dest.setOnmouseover(src.getOnmouseover());
        dest.setOnmouseup(src.getOnmouseup());
        dest.setOnselect(src.getOnselect());
        dest.setReadonly(src.isReadonly());
        dest.setRendered(src.isRendered());
        dest.setRequired(src.isRequired());
        dest.setSize(src.getSize());
        dest.setStyle(src.getStyle());
        dest.setStyleClass(src.getStyleClass());
        dest.setTabindex(src.getTabindex());
        dest.setTitle(src.getTitle());
        dest.setValidator(src.getValidator());
    }

    public static UIComponent findComponent(UIComponent headerComp, Class clazz) {
        if (clazz.isAssignableFrom(headerComp.getClass())) {
            return headerComp;
        }
        List li = headerComp.getChildren();
        for (int i = 0; i < li.size(); ++i) {
            UIComponent comp = (UIComponent)li.get(i);
            UIComponent lookupComp = RendererUtils.findComponent(comp, clazz);
            if (lookupComp == null) continue;
            return lookupComp;
        }
        return null;
    }

    public static void addOrReplaceChild(UIInput component, UIComponent child) {
        List li = component.getChildren();
        for (int i = 0; i < li.size(); ++i) {
            UIComponent oldChild = (UIComponent)li.get(i);
            if (oldChild.getId() == null || !oldChild.getId().equals(child.getId())) continue;
            li.set(i, child);
            return;
        }
        component.getChildren().add(child);
    }

    public static String getClientId(FacesContext facesContext, UIComponent uiComponent, String forAttr) {
        UIComponent forComponent = uiComponent.findComponent(forAttr);
        if (forComponent == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Unable to find component '" + forAttr + "' (calling findComponent on component '" + uiComponent.getClientId(facesContext) + "')." + " We'll try to return a guessed client-id anyways -" + " this will be a problem if you put the referenced component" + " into a different naming-container. If this is the case, you can always use the full client-id."));
            }
            if (forAttr.length() > 0 && forAttr.charAt(0) == ':') {
                return forAttr.substring(1);
            }
            String labelClientId = uiComponent.getClientId(facesContext);
            int colon = labelClientId.lastIndexOf(58);
            if (colon == -1) {
                return forAttr;
            }
            return labelClientId.substring(0, colon + 1) + forAttr;
        }
        return forComponent.getClientId(facesContext);
    }

    public static List convertIdsToClientIds(String actionFor, FacesContext facesContext, UIComponent component) {
        ArrayList<String> li = new ArrayList<String>();
        String[] ids = actionFor.split(",");
        for (int i = 0; i < ids.length; ++i) {
            if (ids[i].equals("none")) {
                li.add(ids[i]);
                continue;
            }
            li.add(RendererUtils.getClientId(facesContext, component, ids[i]));
        }
        return li;
    }

    public static List convertPhasesToPhasesIds(String actionForPhase) {
        ArrayList<PhaseId> li = new ArrayList<PhaseId>();
        if (actionForPhase == null) {
            return li;
        }
        String[] ids = actionForPhase.split(",");
        for (int i = 0; i < ids.length; ++i) {
            if (ids[i].equals("PROCESS_VALIDATIONS")) {
                li.add(PhaseId.PROCESS_VALIDATIONS);
                continue;
            }
            if (!ids[i].equals("UPDATE_MODEL_VALUES")) continue;
            li.add(PhaseId.UPDATE_MODEL_VALUES);
        }
        return li;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadResourceFile(FacesContext ctx, String file) {
        ByteArrayOutputStream content = new ByteArrayOutputStream(10240);
        InputStream in = null;
        try {
            int read;
            in = ctx.getExternalContext().getResourceAsStream(file);
            if (in == null) {
                String string = null;
                return string;
            }
            byte[] fileBuffer = new byte[10240];
            while ((read = in.read(fileBuffer)) > -1) {
                content.write(fileBuffer, 0, read);
            }
        }
        catch (FileNotFoundException e) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("no such file " + file), (Throwable)e);
            }
            content = null;
        }
        catch (IOException e) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("problems during processing resource " + file), (Throwable)e);
            }
            content = null;
        }
        finally {
            try {
                content.close();
            }
            catch (IOException e) {
                log.warn((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    log.warn((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
        return content.toString();
    }

    public static void initPartialValidationAndModelUpdate(UIComponent component, FacesContext facesContext) {
        String actionFor = (String)component.getAttributes().get("actionFor");
        if (actionFor != null) {
            List li = RendererUtils.convertIdsToClientIds(actionFor, facesContext, component);
            facesContext.getExternalContext().getRequestMap().put(ACTION_FOR_LIST, li);
            String actionForPhase = (String)component.getAttributes().get("actionForPhase");
            if (actionForPhase != null) {
                List phaseList = RendererUtils.convertPhasesToPhasesIds(actionForPhase);
                facesContext.getExternalContext().getRequestMap().put(ACTION_FOR_PHASE_LIST, phaseList);
            }
        }
    }

    public static boolean isAdfOrTrinidadForm(UIComponent component) {
        if (component == null) {
            return false;
        }
        return ADF_FORM_COMPONENT_FAMILY.equals(component.getFamily()) || TRINIDAD_FORM_COMPONENT_FAMILY.equals(component.getFamily());
    }

    private static class PassThroughAsStringConverter
    implements Converter {
        private final Converter converter;

        public PassThroughAsStringConverter(Converter converter) {
            this.converter = converter;
        }

        public Object getAsObject(FacesContext context, UIComponent component, String value) throws ConverterException {
            return this.converter.getAsObject(context, component, value);
        }

        public String getAsString(FacesContext context, UIComponent component, Object value) throws ConverterException {
            return (String)value;
        }
    }
}

