/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.orchestra.frameworkAdapter.jsf;

import java.io.IOException;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.orchestra.conversation.ConversationMessager;
import org.apache.myfaces.orchestra.conversation.jsf.JsfConversationMessager;
import org.apache.myfaces.orchestra.frameworkAdapter.FrameworkAdapter;
import org.apache.myfaces.orchestra.frameworkAdapter._FrameworkAdapterUtils;
import org.apache.myfaces.orchestra.lib.OrchestraException;

public class JsfFrameworkAdapter
extends FrameworkAdapter {
    private final Log log = LogFactory.getLog(JsfFrameworkAdapter.class);

    public JsfFrameworkAdapter(String conversationMessagerClass) {
        ConversationMessager cm = _FrameworkAdapterUtils.createConversationMessager(conversationMessagerClass, JsfConversationMessager.class);
        this.setConversationMessager(cm);
    }

    public void beginRequest() {
        this.log.debug((Object)"Beginning request");
        FrameworkAdapter.setCurrentInstance(this);
    }

    public void endRequest() {
        this.log.debug((Object)"Ending request");
        FrameworkAdapter.setCurrentInstance(null);
    }

    protected ConversationMessager createDefaultConversationMessager() {
        return new JsfConversationMessager();
    }

    protected FacesContext getFacesContext() {
        FacesContext fc = FacesContext.getCurrentInstance();
        if (fc == null) {
            throw new OrchestraException("Missing FacesContext");
        }
        return fc;
    }

    public String getInitParameter(String key) {
        FacesContext context = this.getFacesContext();
        return context.getExternalContext().getInitParameter(key);
    }

    public Object getRequestParameterAttribute(String key) {
        FacesContext context = this.getFacesContext();
        return context.getExternalContext().getRequestParameterMap().get(key);
    }

    public boolean containsRequestParameterAttribute(String key) {
        FacesContext context = this.getFacesContext();
        return context.getExternalContext().getRequestParameterMap().containsKey(key);
    }

    public Object getRequestAttribute(String key) {
        FacesContext context = this.getFacesContext();
        return context.getExternalContext().getRequestMap().get(key);
    }

    public void setRequestAttribute(String key, Object value) {
        FacesContext context = this.getFacesContext();
        context.getExternalContext().getRequestMap().put(key, value);
    }

    public boolean containsRequestAttribute(String key) {
        FacesContext context = this.getFacesContext();
        return context.getExternalContext().getRequestMap().containsKey(key);
    }

    public Object getSessionAttribute(String key) {
        FacesContext context = this.getFacesContext();
        return context.getExternalContext().getSessionMap().get(key);
    }

    public void setSessionAttribute(String key, Object value) {
        FacesContext context = this.getFacesContext();
        context.getExternalContext().getSessionMap().put(key, value);
    }

    public boolean containsSessionAttribute(String key) {
        FacesContext context = this.getFacesContext();
        return context.getExternalContext().getSessionMap().containsKey(key);
    }

    protected String getRequestContextPath() {
        FacesContext context = this.getFacesContext();
        return context.getExternalContext().getRequestContextPath();
    }

    public void redirect(String url) throws IOException {
        StringBuffer redir = new StringBuffer();
        if (url.startsWith("/")) {
            redir.append(this.getRequestContextPath());
        }
        redir.append(url);
        FacesContext context = this.getFacesContext();
        String actionUrl = context.getExternalContext().encodeActionURL(redir.toString());
        context.getExternalContext().redirect(actionUrl);
        context.responseComplete();
    }

    public Object getBean(String name) {
        FacesContext context = this.getFacesContext();
        if (context == null) {
            throw new IllegalStateException("getBean invoked before FacesServlet");
        }
        try {
            return context.getApplication().getVariableResolver().resolveVariable(context, name);
        }
        catch (RuntimeException e) {
            this.log.error((Object)("Failed to resolve variable [" + name + "]"), (Throwable)e);
            throw e;
        }
    }

    public void invokeNavigation(String navigationName) {
        FacesContext context = this.getFacesContext();
        context.getApplication().getNavigationHandler().handleNavigation(context, null, navigationName);
    }

    public String getCurrentViewId() {
        UIViewRoot vr = this.getFacesContext().getViewRoot();
        if (vr == null) {
            return null;
        }
        return vr.getViewId();
    }
}

