/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.validator.core.validation.parameter;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.myfaces.extensions.validator.core.validation.parameter.ParameterKey;
import org.apache.myfaces.extensions.validator.core.validation.parameter.ParameterValue;
import org.apache.myfaces.extensions.validator.core.validation.parameter.ValidationParameter;
import org.apache.myfaces.extensions.validator.core.validation.parameter.ValidationParameterExtractor;
import org.apache.myfaces.extensions.validator.internal.Priority;
import org.apache.myfaces.extensions.validator.internal.ToDo;
import org.apache.myfaces.extensions.validator.internal.UsageCategory;
import org.apache.myfaces.extensions.validator.internal.UsageInformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@UsageInformation(value={UsageCategory.INTERNAL})
public class DefaultValidationParameterExtractor
implements ValidationParameterExtractor {
    protected final Logger logger = Logger.getLogger(this.getClass().getName());

    @Override
    public Map<Object, List<Object>> extract(Annotation annotation) {
        return this.extractById(annotation, null);
    }

    @Override
    public List<Object> extract(Annotation annotation, Object key) {
        return this.extractById(annotation, key, null);
    }

    @Override
    public <T> List<T> extract(Annotation annotation, Object key, Class<T> valueType) {
        return this.extractById(annotation, key, valueType, null);
    }

    @Override
    public <T> T extract(Annotation annotation, Object key, Class<T> valueType, Class valueId) {
        List<T> results = this.extractById(annotation, key, valueType, valueId);
        if (results.iterator().hasNext()) {
            return results.iterator().next();
        }
        return null;
    }

    public <T> List<T> extractById(Annotation annotation, Object key, Class<T> valueType, Class valueId) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object entry : this.extractById(annotation, key, valueId)) {
            if (!valueType.isAssignableFrom(entry.getClass())) continue;
            result.add(entry);
        }
        return result;
    }

    public List<Object> extractById(Annotation annotation, Object key, Class valueId) {
        Map<Object, List<Object>> fullResult = this.extractById(annotation, valueId);
        if (fullResult.containsKey(key)) {
            return fullResult.get(key);
        }
        return new ArrayList<Object>();
    }

    @ToDo(value=Priority.MEDIUM, description="add web.xml parameter for performance tuning to deactivate the scan")
    public Map<Object, List<Object>> extractById(Annotation annotation, Class valueId) {
        HashMap<Object, List<Object>> result = new HashMap<Object, List<Object>>();
        for (Method currentAnnotationAttribute : annotation.annotationType().getDeclaredMethods()) {
            try {
                if (!this.isValidationParameter(currentAnnotationAttribute.getGenericReturnType())) continue;
                Object parameterValue = currentAnnotationAttribute.invoke((Object)annotation, new Object[0]);
                if (parameterValue instanceof Class[]) {
                    for (Class currentParameterValue : (Class[])parameterValue) {
                        this.processParameterValue(annotation, currentParameterValue, result, valueId);
                    }
                    continue;
                }
                if (!(parameterValue instanceof Class)) continue;
                this.processParameterValue(annotation, (Class)parameterValue, result, valueId);
            }
            catch (Exception e) {
                this.logger.log(Level.WARNING, "invalid method", e);
            }
        }
        return result;
    }

    private void processParameterValue(Annotation annotation, Class paramClass, Map<Object, List<Object>> result, Class valueId) throws Exception {
        Object key = null;
        ArrayList<Object> parameterValues = new ArrayList<Object>();
        if (ValidationParameter.class.isAssignableFrom(paramClass)) {
            ArrayList<AccessibleObject> processedFields = new ArrayList<AccessibleObject>();
            ArrayList<AccessibleObject> processedMethods = new ArrayList<AccessibleObject>();
            for (Class currentParamClass = paramClass; currentParamClass != null && !Object.class.getName().equals(currentParamClass.getName()); currentParamClass = currentParamClass.getSuperclass()) {
                for (Field field : currentParamClass.getDeclaredFields()) {
                    if (processedFields.contains(field)) continue;
                    key = this.processFoundField(annotation, field, parameterValues, key, valueId);
                    processedFields.add(field);
                }
                for (AccessibleObject accessibleObject : currentParamClass.getDeclaredMethods()) {
                    if (processedMethods.contains(accessibleObject)) continue;
                    key = this.processFoundMethod(currentParamClass, (Method)accessibleObject, parameterValues, key, valueId);
                    processedMethods.add(accessibleObject);
                }
                for (AnnotatedElement annotatedElement : currentParamClass.getInterfaces()) {
                    if (!ValidationParameter.class.isAssignableFrom((Class<?>)annotatedElement)) continue;
                    for (Method method : ((Class)annotatedElement).getDeclaredMethods()) {
                        if (processedMethods.contains(method)) continue;
                        key = this.processFoundMethod(currentParamClass, method, parameterValues, key, valueId);
                        processedMethods.add(method);
                    }
                    for (AccessibleObject accessibleObject : ((Class)annotatedElement).getDeclaredFields()) {
                        if (processedFields.contains(accessibleObject)) continue;
                        key = this.processFoundField(annotation, (Field)accessibleObject, parameterValues, key, valueId);
                        processedFields.add(accessibleObject);
                    }
                }
            }
        }
        key = this.createDefaultKey(key, paramClass);
        if (parameterValues.isEmpty()) {
            parameterValues.add(key);
        }
        if (result.containsKey(key)) {
            result.get(key).addAll(parameterValues);
        } else {
            result.put(key, parameterValues);
        }
    }

    private Object createDefaultKey(Object key, Class currentClass) {
        if (key == null) {
            for (Class<?> interfaceClass : currentClass.getInterfaces()) {
                if (!ValidationParameter.class.isAssignableFrom(interfaceClass) || interfaceClass.getName().equals(ValidationParameter.class.getName())) continue;
                key = interfaceClass;
                break;
            }
        }
        if (key == null) {
            key = currentClass;
        }
        return key;
    }

    private Object processFoundField(Object instance, Field currentField, List<Object> paramValues, Object key, Class valueId) {
        Object newKey = null;
        if (key == null && currentField.isAnnotationPresent(ParameterKey.class)) {
            try {
                newKey = currentField.get(instance);
            }
            catch (Exception e) {
                this.logger.log(Level.WARNING, "invalid field", e);
            }
        }
        if (currentField.isAnnotationPresent(ParameterValue.class) && (valueId == null || valueId.equals(currentField.getAnnotation(ParameterValue.class).id()))) {
            currentField.setAccessible(true);
            try {
                paramValues.add(currentField.get(instance));
            }
            catch (Exception e) {
                this.logger.log(Level.WARNING, "invalid field", e);
            }
        }
        return newKey != null ? newKey : key;
    }

    private Object processFoundMethod(Class paramClass, Method currentMethod, List<Object> parameterValues, Object key, Class valueId) {
        Object newKey = null;
        if (key == null && currentMethod.isAnnotationPresent(ParameterKey.class)) {
            try {
                if (!Modifier.isAbstract(paramClass.getModifiers()) && !Modifier.isInterface(paramClass.getModifiers())) {
                    newKey = currentMethod.invoke(paramClass.newInstance(), new Object[0]);
                }
            }
            catch (Exception e) {
                this.logger.log(Level.WARNING, "invalid method", e);
            }
        }
        if (currentMethod.isAnnotationPresent(ParameterValue.class) && (valueId == null || valueId.equals(currentMethod.getAnnotation(ParameterValue.class).id()))) {
            currentMethod.setAccessible(true);
            try {
                parameterValues.add(currentMethod.invoke(paramClass.newInstance(), new Object[0]));
            }
            catch (Exception e) {
                if (paramClass.getEnclosingClass() != null) {
                    parameterValues.add(paramClass);
                }
                this.logger.log(Level.WARNING, "invalid method", e);
            }
        }
        return newKey != null ? newKey : key;
    }

    private boolean isValidationParameter(Type genericReturnType) {
        if (genericReturnType instanceof GenericArrayType) {
            if (((GenericArrayType)genericReturnType).getGenericComponentType() instanceof ParameterizedType) {
                return this.analyzeParameterizedType((ParameterizedType)((GenericArrayType)genericReturnType).getGenericComponentType());
            }
        } else if (genericReturnType instanceof ParameterizedType) {
            return this.analyzeParameterizedType((ParameterizedType)genericReturnType);
        }
        return false;
    }

    private boolean analyzeParameterizedType(ParameterizedType parameterizedType) {
        for (Type type : parameterizedType.getActualTypeArguments()) {
            if (!(type instanceof WildcardType)) continue;
            for (Type upperBounds : ((WildcardType)type).getUpperBounds()) {
                if (!(upperBounds instanceof Class) || !ValidationParameter.class.isAssignableFrom((Class)upperBounds)) continue;
                return true;
            }
        }
        return false;
    }
}

