/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.validator.beanval;

import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.faces.context.FacesContext;
import javax.validation.MessageInterpolator;
import javax.validation.ValidatorFactory;
import org.apache.myfaces.extensions.validator.beanval.ExtValBeanValidationModuleConfiguration;
import org.apache.myfaces.extensions.validator.beanval.annotation.BeanValidation;
import org.apache.myfaces.extensions.validator.beanval.annotation.ModelValidation;
import org.apache.myfaces.extensions.validator.beanval.storage.ModelValidationEntry;
import org.apache.myfaces.extensions.validator.beanval.storage.ModelValidationStorage;
import org.apache.myfaces.extensions.validator.beanval.util.BeanValidationUtils;
import org.apache.myfaces.extensions.validator.beanval.validation.message.interpolator.DefaultMessageInterpolator;
import org.apache.myfaces.extensions.validator.beanval.validation.message.interpolator.ExtValMessageInterpolatorAdapter;
import org.apache.myfaces.extensions.validator.beanval.validation.strategy.BeanValidationVirtualValidationStrategy;
import org.apache.myfaces.extensions.validator.core.JsfProjectStage;
import org.apache.myfaces.extensions.validator.core.storage.GroupStorage;
import org.apache.myfaces.extensions.validator.core.validation.message.resolver.MessageResolver;
import org.apache.myfaces.extensions.validator.core.validation.strategy.ValidationStrategy;
import org.apache.myfaces.extensions.validator.internal.UsageCategory;
import org.apache.myfaces.extensions.validator.internal.UsageInformation;
import org.apache.myfaces.extensions.validator.util.ExtValUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@UsageInformation(value={UsageCategory.API})
public class ExtValBeanValidationContext
implements GroupStorage,
ModelValidationStorage {
    protected final Logger logger = Logger.getLogger(this.getClass().getName());
    private static final String KEY = ExtValBeanValidationContext.class.getName() + ":KEY";
    protected ValidatorFactory validatorFactory;
    protected MessageInterpolator defaultMessageInterpolator;
    protected MessageResolver messageResolver;
    protected GroupStorage groupStorage;
    protected ModelValidationStorage modelValidationStorage;
    protected boolean developmentMode = false;

    protected ExtValBeanValidationContext() {
        this.initGroupStorage();
        this.initModelValidationStorage();
        this.initMessageResolver();
        this.initMessageInterpolator();
        if (JsfProjectStage.is((JsfProjectStage)JsfProjectStage.Development)) {
            this.developmentMode = true;
        }
    }

    public static ExtValBeanValidationContext getCurrentInstance() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Map requestMap = facesContext.getExternalContext().getRequestMap();
        ExtValBeanValidationContext currentContext = (ExtValBeanValidationContext)requestMap.get(KEY);
        if (currentContext == null) {
            currentContext = ExtValBeanValidationModuleConfiguration.get().customExtValBeanValidationContext();
            if (currentContext == null) {
                currentContext = new ExtValBeanValidationContext();
            }
            requestMap.put(KEY, currentContext);
        }
        return currentContext;
    }

    public ValidatorFactory getValidatorFactory() {
        if (this.validatorFactory != null) {
            return this.validatorFactory;
        }
        this.validatorFactory = ExtValBeanValidationModuleConfiguration.get().customValidatorFactory();
        if (this.validatorFactory == null) {
            if (this.developmentMode) {
                this.logger.warning("fallback to the default bv validator factory");
            }
            this.validatorFactory = BeanValidationUtils.getDefaultValidatorFactory();
        }
        return this.validatorFactory;
    }

    public MessageInterpolator getMessageInterpolator() {
        if (this.messageResolver != null) {
            return new ExtValMessageInterpolatorAdapter(this.defaultMessageInterpolator, this.messageResolver);
        }
        return this.defaultMessageInterpolator;
    }

    public void addGroup(Class groupClass, String viewId, String clientId) {
        this.groupStorage.addGroup(groupClass, viewId, clientId);
    }

    public void restrictGroup(Class groupClass, String viewId, String clientId) {
        this.groupStorage.restrictGroup(groupClass, viewId, clientId);
    }

    public Class[] getGroups(String viewId, String clientId) {
        return this.groupStorage.getGroups(viewId, clientId);
    }

    public void resetGroups(String viewId) {
        this.groupStorage.resetGroups(viewId);
    }

    public void lockGroups(String viewId) {
        this.groupStorage.lockGroups(viewId);
    }

    public void unlockGroups(String viewId) {
        this.groupStorage.unlockGroups(viewId);
    }

    @Override
    public void addModelValidationEntry(ModelValidationEntry modelValidationEntry) {
        this.modelValidationStorage.addModelValidationEntry(modelValidationEntry);
    }

    @Override
    public List<ModelValidationEntry> getModelValidationEntriesToValidate() {
        return this.modelValidationStorage.getModelValidationEntriesToValidate();
    }

    protected void initGroupStorage() {
        this.groupStorage = (GroupStorage)ExtValUtils.getStorage(GroupStorage.class, (String)BeanValidation.class.getName());
    }

    protected void initModelValidationStorage() {
        this.modelValidationStorage = (ModelValidationStorage)ExtValUtils.getStorage(ModelValidationStorage.class, (String)ModelValidation.class.getName());
    }

    protected void initMessageInterpolator() {
        Object foundBean = ExtValUtils.getELHelper().getBean(MessageInterpolator.class.getName().replace(".", "_"));
        this.defaultMessageInterpolator = foundBean instanceof MessageInterpolator ? (MessageInterpolator)foundBean : new DefaultMessageInterpolator(BeanValidationUtils.getDefaultValidatorFactory().getMessageInterpolator());
    }

    protected void initMessageResolver() {
        this.messageResolver = ExtValUtils.getMessageResolverForValidationStrategy((ValidationStrategy)this.getBeanValidationStrategy());
    }

    private ValidationStrategy getBeanValidationStrategy() {
        return new BeanValidationVirtualValidationStrategy(null, null);
    }
}

