/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.application.viewstate;

import jakarta.faces.FacesWrapper;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import jakarta.faces.lifecycle.ClientWindow;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.myfaces.application.viewstate.KeyFactoryRandom;
import org.apache.myfaces.application.viewstate.KeyFactorySecureRandom;
import org.apache.myfaces.application.viewstate.SerializedViewCollection;
import org.apache.myfaces.application.viewstate.SerializedViewKey;
import org.apache.myfaces.application.viewstate.SessionViewStorageFactory;
import org.apache.myfaces.application.viewstate.SessionViewStorageFactoryImpl;
import org.apache.myfaces.application.viewstate.StateCache;
import org.apache.myfaces.application.viewstate.StateTokenProcessor;
import org.apache.myfaces.application.viewstate.StateTokenProcessorServerSide;
import org.apache.myfaces.config.webparameters.MyfacesConfig;
import org.apache.myfaces.util.MyFacesObjectInputStream;
import org.apache.myfaces.util.token.CsrfSessionTokenFactory;
import org.apache.myfaces.util.token.CsrfSessionTokenFactoryRandom;
import org.apache.myfaces.util.token.CsrfSessionTokenFactorySecureRandom;
import org.apache.myfaces.view.ViewScopeProxyMap;

class StateCacheServerSide
extends StateCache<Object, Object> {
    private static final Logger log = Logger.getLogger(StateCacheServerSide.class.getName());
    public static final String SERIALIZED_VIEW_SESSION_ATTR = StateCacheServerSide.class.getName() + ".SERIALIZED_VIEW";
    public static final String RESTORED_SERIALIZED_VIEW_REQUEST_ATTR = StateCacheServerSide.class.getName() + ".RESTORED_SERIALIZED_VIEW";
    public static final String RESTORED_SERIALIZED_VIEW_ID_REQUEST_ATTR = StateCacheServerSide.class.getName() + ".RESTORED_SERIALIZED_VIEW_ID";
    public static final String RESTORED_SERIALIZED_VIEW_KEY_REQUEST_ATTR = StateCacheServerSide.class.getName() + ".RESTORED_SERIALIZED_VIEW_KEY";
    public static final String RESTORED_VIEW_KEY_REQUEST_ATTR = StateCacheServerSide.class.getName() + ".RESTORED_VIEW_KEY";
    public static final int UNCOMPRESSED_FLAG = 0;
    public static final int COMPRESSED_FLAG = 1;
    private final boolean useFlashScopePurgeViewsInSession;
    private final int numberOfSequentialViewsInSession;
    private final boolean serializeStateInSession;
    private final boolean compressStateInSession;
    private final SessionViewStorageFactory sessionViewStorageFactory;
    private final CsrfSessionTokenFactory csrfSessionTokenFactory;
    private final StateTokenProcessor stateTokenProcessor;

    public StateCacheServerSide() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        MyfacesConfig config = MyfacesConfig.getCurrentInstance(facesContext);
        this.useFlashScopePurgeViewsInSession = !config.isFlashScopeDisabled() && config.isUseFlashScopePurgeViewsInSession();
        this.numberOfSequentialViewsInSession = config.getNumberOfSequentialViewsInSession();
        this.serializeStateInSession = config.isSerializeStateInSession();
        this.compressStateInSession = config.isCompressStateInSession();
        String randomMode = config.getRandomKeyInViewStateSessionToken();
        if ("secureRandom".equals(randomMode)) {
            this.sessionViewStorageFactory = new SessionViewStorageFactoryImpl(new KeyFactorySecureRandom(facesContext));
        } else if ("random".equals(randomMode)) {
            this.sessionViewStorageFactory = new SessionViewStorageFactoryImpl(new KeyFactoryRandom(facesContext));
        } else {
            if (randomMode != null && !randomMode.isEmpty()) {
                log.warning("org.apache.myfaces.RANDOM_KEY_IN_VIEW_STATE_SESSION_TOKEN \"" + randomMode + "\" is not supported (anymore). Fallback to \"secureRandom\"");
            }
            this.sessionViewStorageFactory = new SessionViewStorageFactoryImpl(new KeyFactorySecureRandom(facesContext));
        }
        String csrfRandomMode = config.getRandomKeyInCsrfSessionToken();
        this.csrfSessionTokenFactory = "random".equals(csrfRandomMode) ? new CsrfSessionTokenFactoryRandom(facesContext) : new CsrfSessionTokenFactorySecureRandom(facesContext);
        this.stateTokenProcessor = new StateTokenProcessorServerSide();
    }

    protected Object getServerStateId(FacesContext facesContext, Object state) {
        if (state != null) {
            return this.sessionViewStorageFactory.getKeyFactory().decode((String)state);
        }
        return null;
    }

    protected void saveSerializedViewInSession(FacesContext context, Object serializedView) {
        Map sessionMap = context.getExternalContext().getSessionMap();
        SerializedViewCollection viewCollection = (SerializedViewCollection)sessionMap.get(SERIALIZED_VIEW_SESSION_ATTR);
        if (viewCollection == null) {
            viewCollection = this.sessionViewStorageFactory.createSerializedViewCollection(context);
            sessionMap.put(SERIALIZED_VIEW_SESSION_ATTR, viewCollection);
        }
        Map attributeMap = context.getAttributes();
        SerializedViewKey key = null;
        if (this.numberOfSequentialViewsInSession > 0 && (key = (SerializedViewKey)attributeMap.get(RESTORED_VIEW_KEY_REQUEST_ATTR)) == null) {
            ClientWindow clientWindow = context.getExternalContext().getClientWindow();
            if (clientWindow != null) {
                key = viewCollection.getLastWindowKey(context, clientWindow.getId());
            } else if (this.useFlashScopePurgeViewsInSession && Boolean.TRUE.equals(context.getExternalContext().getRequestMap().get("oam.Flash.REDIRECT.PREVIOUSREQUEST"))) {
                key = (SerializedViewKey)context.getExternalContext().getFlash().get((Object)RESTORED_VIEW_KEY_REQUEST_ATTR);
            }
        }
        SerializedViewKey nextKey = this.sessionViewStorageFactory.createSerializedViewKey(context, context.getViewRoot().getViewId(), this.getNextViewSequence(context));
        ViewScopeProxyMap viewScopeProxyMap = null;
        Object viewMap = context.getViewRoot().getViewMap(false);
        if (viewMap != null) {
            while (viewMap != null) {
                if (viewMap instanceof ViewScopeProxyMap) {
                    viewScopeProxyMap = (ViewScopeProxyMap)viewMap;
                    break;
                }
                if (!(viewMap instanceof FacesWrapper)) continue;
                viewMap = ((FacesWrapper)viewMap).getWrapped();
            }
        }
        if (viewScopeProxyMap != null) {
            viewCollection.put(context, this.serializeView(context, serializedView), nextKey, key, viewScopeProxyMap.getViewScopeId());
        } else {
            viewCollection.put(context, this.serializeView(context, serializedView), nextKey, key);
        }
        ClientWindow clientWindow = context.getExternalContext().getClientWindow();
        if (clientWindow != null) {
            viewCollection.putLastWindowKey(context, clientWindow.getId(), nextKey);
        }
        sessionMap.put(SERIALIZED_VIEW_SESSION_ATTR, viewCollection);
    }

    protected Object getSerializedViewFromSession(FacesContext context, String viewId, Object sequence) {
        ExternalContext externalContext = context.getExternalContext();
        Map attributeMap = context.getAttributes();
        Object serializedView = null;
        if (attributeMap.containsKey(RESTORED_SERIALIZED_VIEW_REQUEST_ATTR)) {
            serializedView = attributeMap.get(RESTORED_SERIALIZED_VIEW_REQUEST_ATTR);
        } else {
            Object state;
            SerializedViewCollection viewCollection = (SerializedViewCollection)externalContext.getSessionMap().get(SERIALIZED_VIEW_SESSION_ATTR);
            if (viewCollection != null && sequence != null && (state = viewCollection.get(this.sessionViewStorageFactory.createSerializedViewKey(context, viewId, sequence))) != null) {
                serializedView = this.deserializeView(state);
            }
            attributeMap.put(RESTORED_SERIALIZED_VIEW_REQUEST_ATTR, serializedView);
            if (this.numberOfSequentialViewsInSession > 0) {
                SerializedViewKey key = this.sessionViewStorageFactory.createSerializedViewKey(context, viewId, sequence);
                attributeMap.put(RESTORED_VIEW_KEY_REQUEST_ATTR, key);
                if (this.useFlashScopePurgeViewsInSession) {
                    externalContext.getFlash().put((Object)RESTORED_VIEW_KEY_REQUEST_ATTR, (Object)key);
                    externalContext.getFlash().keep(RESTORED_VIEW_KEY_REQUEST_ATTR);
                }
            }
            if (context.getPartialViewContext().isAjaxRequest() || context.getPartialViewContext().isPartialRequest()) {
                attributeMap.put(RESTORED_SERIALIZED_VIEW_KEY_REQUEST_ATTR, sequence);
                attributeMap.put(RESTORED_SERIALIZED_VIEW_ID_REQUEST_ATTR, viewId);
            } else {
                this.nextViewSequence(context);
            }
        }
        return serializedView;
    }

    protected Object getNextViewSequence(FacesContext context) {
        Object sequence = context.getAttributes().get("jsf_sequence");
        if (sequence == null) {
            if (context.getPartialViewContext().isAjaxRequest() || context.getPartialViewContext().isPartialRequest()) {
                String restoredViewId = (String)context.getAttributes().get(RESTORED_SERIALIZED_VIEW_ID_REQUEST_ATTR);
                Object restoredKey = context.getAttributes().get(RESTORED_SERIALIZED_VIEW_KEY_REQUEST_ATTR);
                if (restoredViewId != null && restoredKey != null && restoredViewId.equals(context.getViewRoot().getViewId())) {
                    sequence = restoredKey;
                }
            }
            if (sequence == null) {
                sequence = this.nextViewSequence(context);
            }
            context.getAttributes().put("jsf_sequence", sequence);
        }
        return sequence;
    }

    protected Object nextViewSequence(FacesContext facescontext) {
        Object sequence = this.sessionViewStorageFactory.getKeyFactory().generateKey(facescontext);
        facescontext.getAttributes().put("jsf_sequence", sequence);
        return sequence;
    }

    protected Object serializeView(FacesContext context, Object serializedView) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Entering serializeView");
        }
        if (this.serializeStateInSession) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Processing serializeView - serialize state in session");
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
            try {
                OutputStream os = baos;
                if (this.compressStateInSession) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.finest("Processing serializeView - serialize compressed");
                    }
                    ((OutputStream)os).write(1);
                    os = new GZIPOutputStream(os, 1024);
                } else {
                    if (log.isLoggable(Level.FINEST)) {
                        log.finest("Processing serializeView - serialize uncompressed");
                    }
                    ((OutputStream)os).write(0);
                }
                try (ObjectOutputStream out = new ObjectOutputStream(os);){
                    out.writeObject(serializedView);
                }
                baos.close();
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Exiting serializeView - serialized. Bytes : " + baos.size());
                }
                return baos.toByteArray();
            }
            catch (IOException e) {
                log.log(Level.SEVERE, "Exiting serializeView - Could not serialize state: " + e.getMessage(), e);
                return null;
            }
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Exiting serializeView - do not serialize state in session.");
        }
        return serializedView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object deserializeView(Object state) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Entering deserializeView");
        }
        if (state instanceof byte[]) {
            Object object;
            block13: {
                ByteArrayInputStream bais;
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Processing deserializeView - deserializing serialized state. Bytes : " + ((byte[])state).length);
                }
                InputStream is = bais = new ByteArrayInputStream((byte[])state);
                if (((InputStream)is).read() == 1) {
                    is = new GZIPInputStream(is);
                }
                MyFacesObjectInputStream ois = new MyFacesObjectInputStream(is);
                try {
                    object = ois.readObject();
                    if (ois == null) break block13;
                }
                catch (Throwable throwable) {
                    try {
                        if (ois != null) {
                            ois.close();
                            ois = null;
                        }
                        throw throwable;
                    }
                    catch (IOException | ClassNotFoundException e) {
                        log.log(Level.SEVERE, "Exiting deserializeView - Could not deserialize state: " + e.getMessage(), e);
                        return null;
                    }
                }
                ois.close();
                ois = null;
            }
            return object;
        }
        if (state instanceof Object[]) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Exiting deserializeView - state not serialized.");
            }
            return state;
        }
        if (state == null) {
            log.severe("Exiting deserializeView - this method should not be called with a null-state.");
            return null;
        }
        log.severe("Exiting deserializeView - this method should not be called with a state of type : " + String.valueOf(state.getClass()));
        return null;
    }

    @Override
    public Object saveSerializedView(FacesContext facesContext, Object serializedView) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Processing saveSerializedView - server-side state saving - save state");
        }
        this.saveSerializedViewInSession(facesContext, serializedView);
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Exiting saveSerializedView - server-side state saving - saved state");
        }
        return this.encodeSerializedState(facesContext, serializedView);
    }

    @Override
    public Object restoreSerializedView(FacesContext facesContext, String viewId, Object viewState) {
        Object serverStateId;
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Restoring view from session");
        }
        return (serverStateId = this.getServerStateId(facesContext, viewState)) == null ? null : this.getSerializedViewFromSession(facesContext, viewId, serverStateId);
    }

    @Override
    public Object encodeSerializedState(FacesContext facesContext, Object serializedView) {
        return this.sessionViewStorageFactory.getKeyFactory().encode(this.getNextViewSequence(facesContext));
    }

    @Override
    public boolean isWriteStateAfterRenderViewRequired(FacesContext facesContext) {
        return false;
    }

    @Override
    public String createCryptographicallyStrongTokenFromSession(FacesContext context) {
        return this.csrfSessionTokenFactory.createToken(context);
    }

    @Override
    public StateTokenProcessor getStateTokenProcessor(FacesContext context) {
        return this.stateTokenProcessor;
    }

    protected SessionViewStorageFactory getSessionViewStorageFactory() {
        return this.sessionViewStorageFactory;
    }
}

