/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.cdi.view;

import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.faces.context.FacesContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.myfaces.cdi.util.CDIUtils;
import org.apache.myfaces.cdi.util.ContextualInstanceInfo;
import org.apache.myfaces.cdi.view.ViewScopeContext;
import org.apache.myfaces.cdi.view.ViewScopeContextualStorage;
import org.apache.myfaces.cdi.view.ViewScopeContextualStorageHolder;

public class ViewScopeCDIMap
implements Map<String, Object> {
    private String viewScopeId;
    private ViewScopeContextualStorage storage;

    public ViewScopeCDIMap(String viewScopeId) {
        this.viewScopeId = viewScopeId;
    }

    private ViewScopeContextualStorage getStorage() {
        if (this.storage != null && !this.storage.isActivated()) {
            this.storage = null;
        }
        if (this.storage == null) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            BeanManager beanManager = CDIUtils.getBeanManager(facesContext);
            ViewScopeContextualStorageHolder bean = CDIUtils.get(beanManager, ViewScopeContextualStorageHolder.class);
            this.storage = (ViewScopeContextualStorage)bean.getContextualStorage(this.viewScopeId);
        }
        return this.storage;
    }

    private Map<Object, ContextualInstanceInfo<?>> getCreationalContextInstances() {
        return this.getStorage().getStorage();
    }

    public String getViewScopeId() {
        return this.viewScopeId;
    }

    @Override
    public int size() {
        return this.getCreationalContextInstances().size();
    }

    @Override
    public boolean isEmpty() {
        return this.getCreationalContextInstances().isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getCreationalContextInstances().containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        if (value != null) {
            for (Map.Entry<Object, ContextualInstanceInfo<?>> entry : this.getCreationalContextInstances().entrySet()) {
                if (entry.getValue() == null || !value.equals(entry.getValue().getContextualInstance())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Object get(Object key) {
        ContextualInstanceInfo<?> info = this.getCreationalContextInstances().get(key);
        return info == null ? null : info.getContextualInstance();
    }

    @Override
    public Object put(String key, Object value) {
        ContextualInstanceInfo<Object> info = new ContextualInstanceInfo<Object>();
        info.setContextualInstance(value);
        return this.getCreationalContextInstances().put(key, info);
    }

    @Override
    public Object remove(Object key) {
        ContextualInstanceInfo<?> info = this.getCreationalContextInstances().remove(key);
        return info == null ? null : info.getContextualInstance();
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> m) {
        for (Map.Entry<? extends String, ? extends Object> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ViewScopeContext.destroyAll(facesContext, this.viewScopeId);
    }

    @Override
    public Set<String> keySet() {
        return this.getCreationalContextInstances().keySet().stream().map(e -> (String)e).collect(Collectors.toSet());
    }

    @Override
    public Collection<Object> values() {
        ArrayList<Object> values = new ArrayList<Object>(this.getCreationalContextInstances().size());
        for (Map.Entry<Object, ContextualInstanceInfo<?>> entry : this.getCreationalContextInstances().entrySet()) {
            ContextualInstanceInfo<?> info = entry.getValue();
            if (info == null) continue;
            values.add(info.getContextualInstance());
        }
        return values;
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        HashSet<Map.Entry<String, Object>> values = new HashSet<Map.Entry<String, Object>>();
        for (Map.Entry<Object, ContextualInstanceInfo<?>> entry : this.getCreationalContextInstances().entrySet()) {
            ContextualInstanceInfo<?> info = entry.getValue();
            if (info == null) continue;
            values.add(new EntryWrapper(entry.getKey()));
        }
        return values;
    }

    private class EntryWrapper<String, Object>
    implements Map.Entry<String, Object> {
        private final Object key;

        public EntryWrapper(Object key) {
            this.key = key;
        }

        @Override
        public String getKey() {
            return (String)this.key;
        }

        @Override
        public Object getValue() {
            ContextualInstanceInfo<?> info = ViewScopeCDIMap.this.getCreationalContextInstances().get(this.key);
            return info == null ? null : (Object)info.getContextualInstance();
        }

        @Override
        public Object setValue(Object value) {
            ContextualInstanceInfo<Object> info = ViewScopeCDIMap.this.getCreationalContextInstances().get(this.key);
            Object oldValue = null;
            if (info != null) {
                info.setContextualInstance(value);
            } else {
                info = new ContextualInstanceInfo();
                info.setContextualInstance(value);
                ViewScopeCDIMap.this.getCreationalContextInstances().put(this.key, info);
            }
            return oldValue;
        }
    }
}

