/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared.resource;

import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import java.util.Map;
import org.apache.myfaces.shared.application.FacesServletMapping;
import org.apache.myfaces.shared.application.FacesServletMappingUtils;
import org.apache.myfaces.shared.resource.ContractResourceLoader;
import org.apache.myfaces.shared.resource.ResourceHandlerSupport;
import org.apache.myfaces.shared.resource.ResourceLoader;
import org.apache.myfaces.shared.util.WebConfigParamUtils;

public class BaseResourceHandlerSupport
extends ResourceHandlerSupport {
    public static final String RESOURCE_MAX_TIME_EXPIRES = "org.apache.myfaces.RESOURCE_MAX_TIME_EXPIRES";
    private static final String CACHED_SERVLET_MAPPING = BaseResourceHandlerSupport.class.getName() + ".CACHED_SERVLET_MAPPING";
    private static final ResourceLoader[] EMPTY_RESOURCE_LOADERS = new ResourceLoader[0];
    private static final ContractResourceLoader[] EMPTY_CONTRACT_RESOURCE_LOADERS = new ContractResourceLoader[0];
    private Long _startupTime = System.currentTimeMillis();
    private Long _maxTimeExpires;

    @Override
    public ResourceLoader[] getResourceLoaders() {
        return EMPTY_RESOURCE_LOADERS;
    }

    @Override
    public ContractResourceLoader[] getContractResourceLoaders() {
        return EMPTY_CONTRACT_RESOURCE_LOADERS;
    }

    @Override
    public ResourceLoader[] getViewResourceLoaders() {
        return EMPTY_RESOURCE_LOADERS;
    }

    @Override
    public String calculateResourceBasePath(FacesContext facesContext) {
        FacesServletMapping mapping = this.getFacesServletMapping(facesContext);
        ExternalContext externalContext = facesContext.getExternalContext();
        if (mapping != null) {
            String resourceBasePath = null;
            if (mapping.isExtensionMapping()) {
                resourceBasePath = externalContext.getRequestServletPath();
                int stripPoint = resourceBasePath.lastIndexOf(46);
                if (stripPoint > 0) {
                    resourceBasePath = resourceBasePath.substring(0, stripPoint);
                }
            } else {
                resourceBasePath = externalContext.getRequestPathInfo();
            }
            return resourceBasePath;
        }
        return externalContext.getRequestPathInfo();
    }

    @Override
    public boolean isExtensionMapping() {
        FacesServletMapping mapping = this.getFacesServletMapping(FacesContext.getCurrentInstance());
        return mapping != null && mapping.isExtensionMapping();
    }

    @Override
    public String getMapping() {
        FacesServletMapping mapping = this.getFacesServletMapping(FacesContext.getCurrentInstance());
        if (mapping != null) {
            if (mapping.isExtensionMapping()) {
                return mapping.getExtension();
            }
            return mapping.getPrefix();
        }
        return "";
    }

    protected FacesServletMapping getFacesServletMapping(FacesContext context) {
        Map<Object, Object> attributes = context.getAttributes();
        FacesServletMapping mapping = (FacesServletMapping)attributes.get(CACHED_SERVLET_MAPPING);
        if (mapping == null) {
            ExternalContext externalContext = context.getExternalContext();
            mapping = FacesServletMappingUtils.calculateFacesServletMapping(context, externalContext.getRequestServletPath(), externalContext.getRequestPathInfo(), false);
            attributes.put(CACHED_SERVLET_MAPPING, mapping);
        }
        return mapping;
    }

    @Deprecated
    protected static FacesServletMapping calculateFacesServletMapping(String servletPath, String pathInfo) {
        if (pathInfo != null) {
            return FacesServletMapping.createPrefixMapping(servletPath);
        }
        int slashPos = servletPath.lastIndexOf(47);
        int extensionPos = servletPath.lastIndexOf(46);
        if (extensionPos > -1 && extensionPos > slashPos) {
            String extension = servletPath.substring(extensionPos);
            return FacesServletMapping.createExtensionMapping(extension);
        }
        return FacesServletMapping.createPrefixMapping(servletPath);
    }

    @Override
    public long getStartupTime() {
        return this._startupTime;
    }

    @Override
    public long getMaxTimeExpires() {
        if (this._maxTimeExpires == null) {
            this._maxTimeExpires = WebConfigParamUtils.getLongInitParameter(FacesContext.getCurrentInstance().getExternalContext(), RESOURCE_MAX_TIME_EXPIRES, 604800000L);
        }
        return this._maxTimeExpires;
    }
}

