/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.application;

import javax.faces.application.Application;
import javax.faces.application.ApplicationFactory;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.application.ApplicationImpl;

public class ApplicationFactoryImpl
extends ApplicationFactory {
    private static final Log log = LogFactory.getLog(ApplicationFactoryImpl.class);
    private Application _application;
    private boolean _myfacesInstanceAddedToApplicationMap = false;

    public ApplicationFactoryImpl() {
        this.createAndLogNewApplication();
    }

    private void createAndLogNewApplication() {
        this._application = new ApplicationImpl();
        this.putApplicationOnMap();
        if (log.isTraceEnabled()) {
            log.trace((Object)"New ApplicationFactory instance created");
        }
    }

    public void purgeApplication() {
        this.createAndLogNewApplication();
    }

    public Application getApplication() {
        if (this._application != null && !this._myfacesInstanceAddedToApplicationMap) {
            this.putApplicationOnMap();
        }
        return this._application;
    }

    public void setApplication(Application application) {
        if (application == null) {
            throw new NullPointerException("Cannot set a null application in the ApplicationFactory");
        }
        this._application = application;
        this.putApplicationOnMap();
    }

    private void putApplicationOnMap() {
        ExternalContext externalContext;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext != null && (externalContext = facesContext.getExternalContext()) != null) {
            externalContext.getApplicationMap().put("org.apache.myfaces.application.ApplicationImpl", this._application);
            this._myfacesInstanceAddedToApplicationMap = true;
        }
    }
}

