/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.dev;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.poi.hssf.record.AreaFormatRecord;
import org.apache.poi.hssf.record.AreaRecord;
import org.apache.poi.hssf.record.AxisLineFormatRecord;
import org.apache.poi.hssf.record.AxisOptionsRecord;
import org.apache.poi.hssf.record.AxisParentRecord;
import org.apache.poi.hssf.record.AxisRecord;
import org.apache.poi.hssf.record.AxisUsedRecord;
import org.apache.poi.hssf.record.BOFRecord;
import org.apache.poi.hssf.record.BackupRecord;
import org.apache.poi.hssf.record.BarRecord;
import org.apache.poi.hssf.record.BeginRecord;
import org.apache.poi.hssf.record.BlankRecord;
import org.apache.poi.hssf.record.BookBoolRecord;
import org.apache.poi.hssf.record.BoolErrRecord;
import org.apache.poi.hssf.record.BottomMarginRecord;
import org.apache.poi.hssf.record.BoundSheetRecord;
import org.apache.poi.hssf.record.CalcCountRecord;
import org.apache.poi.hssf.record.CalcModeRecord;
import org.apache.poi.hssf.record.CategorySeriesAxisRecord;
import org.apache.poi.hssf.record.ChartFormatRecord;
import org.apache.poi.hssf.record.ChartRecord;
import org.apache.poi.hssf.record.CodepageRecord;
import org.apache.poi.hssf.record.ColumnInfoRecord;
import org.apache.poi.hssf.record.ContinueRecord;
import org.apache.poi.hssf.record.CountryRecord;
import org.apache.poi.hssf.record.DBCellRecord;
import org.apache.poi.hssf.record.DSFRecord;
import org.apache.poi.hssf.record.DatRecord;
import org.apache.poi.hssf.record.DataFormatRecord;
import org.apache.poi.hssf.record.DateWindow1904Record;
import org.apache.poi.hssf.record.DefaultColWidthRecord;
import org.apache.poi.hssf.record.DefaultDataLabelTextPropertiesRecord;
import org.apache.poi.hssf.record.DefaultRowHeightRecord;
import org.apache.poi.hssf.record.DeltaRecord;
import org.apache.poi.hssf.record.DimensionsRecord;
import org.apache.poi.hssf.record.DrawingGroupRecord;
import org.apache.poi.hssf.record.DrawingRecordForBiffViewer;
import org.apache.poi.hssf.record.DrawingSelectionRecord;
import org.apache.poi.hssf.record.EOFRecord;
import org.apache.poi.hssf.record.EndRecord;
import org.apache.poi.hssf.record.ExtSSTRecord;
import org.apache.poi.hssf.record.ExtendedFormatRecord;
import org.apache.poi.hssf.record.ExternSheetRecord;
import org.apache.poi.hssf.record.FnGroupCountRecord;
import org.apache.poi.hssf.record.FontBasisRecord;
import org.apache.poi.hssf.record.FontIndexRecord;
import org.apache.poi.hssf.record.FontRecord;
import org.apache.poi.hssf.record.FooterRecord;
import org.apache.poi.hssf.record.FormatRecord;
import org.apache.poi.hssf.record.FormulaRecord;
import org.apache.poi.hssf.record.FrameRecord;
import org.apache.poi.hssf.record.GridsetRecord;
import org.apache.poi.hssf.record.GutsRecord;
import org.apache.poi.hssf.record.HCenterRecord;
import org.apache.poi.hssf.record.HeaderRecord;
import org.apache.poi.hssf.record.HideObjRecord;
import org.apache.poi.hssf.record.HorizontalPageBreakRecord;
import org.apache.poi.hssf.record.IndexRecord;
import org.apache.poi.hssf.record.InterfaceEndRecord;
import org.apache.poi.hssf.record.InterfaceHdrRecord;
import org.apache.poi.hssf.record.IterationRecord;
import org.apache.poi.hssf.record.LabelRecord;
import org.apache.poi.hssf.record.LabelSSTRecord;
import org.apache.poi.hssf.record.LeftMarginRecord;
import org.apache.poi.hssf.record.LegendRecord;
import org.apache.poi.hssf.record.LineFormatRecord;
import org.apache.poi.hssf.record.LinkedDataRecord;
import org.apache.poi.hssf.record.MMSRecord;
import org.apache.poi.hssf.record.MergeCellsRecord;
import org.apache.poi.hssf.record.MulBlankRecord;
import org.apache.poi.hssf.record.MulRKRecord;
import org.apache.poi.hssf.record.NameRecord;
import org.apache.poi.hssf.record.NumberRecord;
import org.apache.poi.hssf.record.ObjRecord;
import org.apache.poi.hssf.record.ObjectLinkRecord;
import org.apache.poi.hssf.record.PaletteRecord;
import org.apache.poi.hssf.record.PaneRecord;
import org.apache.poi.hssf.record.PasswordRecord;
import org.apache.poi.hssf.record.PasswordRev4Record;
import org.apache.poi.hssf.record.PlotAreaRecord;
import org.apache.poi.hssf.record.PlotGrowthRecord;
import org.apache.poi.hssf.record.PrecisionRecord;
import org.apache.poi.hssf.record.PrintGridlinesRecord;
import org.apache.poi.hssf.record.PrintHeadersRecord;
import org.apache.poi.hssf.record.PrintSetupRecord;
import org.apache.poi.hssf.record.ProtectRecord;
import org.apache.poi.hssf.record.ProtectionRev4Record;
import org.apache.poi.hssf.record.RKRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.hssf.record.RefModeRecord;
import org.apache.poi.hssf.record.RefreshAllRecord;
import org.apache.poi.hssf.record.RightMarginRecord;
import org.apache.poi.hssf.record.RowRecord;
import org.apache.poi.hssf.record.SCLRecord;
import org.apache.poi.hssf.record.SSTRecord;
import org.apache.poi.hssf.record.SaveRecalcRecord;
import org.apache.poi.hssf.record.SelectionRecord;
import org.apache.poi.hssf.record.SeriesIndexRecord;
import org.apache.poi.hssf.record.SeriesListRecord;
import org.apache.poi.hssf.record.SeriesRecord;
import org.apache.poi.hssf.record.SeriesTextRecord;
import org.apache.poi.hssf.record.SeriesToChartGroupRecord;
import org.apache.poi.hssf.record.SharedFormulaRecord;
import org.apache.poi.hssf.record.SheetPropertiesRecord;
import org.apache.poi.hssf.record.StringRecord;
import org.apache.poi.hssf.record.StyleRecord;
import org.apache.poi.hssf.record.SupBookRecord;
import org.apache.poi.hssf.record.TabIdRecord;
import org.apache.poi.hssf.record.TextObjectRecord;
import org.apache.poi.hssf.record.TextRecord;
import org.apache.poi.hssf.record.TickRecord;
import org.apache.poi.hssf.record.TopMarginRecord;
import org.apache.poi.hssf.record.UnitsRecord;
import org.apache.poi.hssf.record.UnknownRecord;
import org.apache.poi.hssf.record.UseSelFSRecord;
import org.apache.poi.hssf.record.VCenterRecord;
import org.apache.poi.hssf.record.ValueRangeRecord;
import org.apache.poi.hssf.record.VerticalPageBreakRecord;
import org.apache.poi.hssf.record.WSBoolRecord;
import org.apache.poi.hssf.record.WindowOneRecord;
import org.apache.poi.hssf.record.WindowProtectRecord;
import org.apache.poi.hssf.record.WindowTwoRecord;
import org.apache.poi.hssf.record.WriteAccessRecord;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndian;

public class BiffViewer {
    String filename;
    private boolean dump;

    public BiffViewer(String[] args) {
        if (args.length > 0) {
            this.filename = args[0];
        } else {
            System.out.println("BIFFVIEWER REQUIRES A FILENAME***");
        }
    }

    public void run() {
        try {
            POIFSFileSystem fs = new POIFSFileSystem(new FileInputStream(this.filename));
            DocumentInputStream stream = fs.createDocumentInputStream("Workbook");
            BiffViewer.createRecords(stream, this.dump);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Record[] createRecords(InputStream in, boolean dump) throws RecordFormatException {
        ArrayList<Record> records = new ArrayList<Record>();
        int loc = 0;
        RecordDetails activeRecord = null;
        try {
            short rectype = 0;
            do {
                rectype = LittleEndian.readShort(in);
                int startloc = loc;
                loc += 2;
                if (rectype == 0) continue;
                short recsize = LittleEndian.readShort(in);
                loc += 2;
                byte[] data = new byte[recsize];
                in.read(data);
                loc += recsize;
                Record record = BiffViewer.createRecord(rectype, recsize, data);
                if (record.getSid() != 60) {
                    records.add(record);
                    if (activeRecord != null) {
                        activeRecord.dump();
                    }
                    activeRecord = new RecordDetails(rectype, recsize, startloc, data, record);
                } else {
                    activeRecord.getRecord().processContinueRecord(data);
                }
                if (!dump) continue;
                BiffViewer.dumpRaw(rectype, recsize, data);
            } while (rectype != 0);
            activeRecord.dump();
        }
        catch (IOException e) {
            throw new RecordFormatException("Error reading bytes");
        }
        Record[] retval = new Record[records.size()];
        retval = records.toArray(retval);
        return retval;
    }

    private static void dumpNormal(Record record, int startloc, short rectype, short recsize) {
        System.out.println("Offset 0x" + Integer.toHexString(startloc) + " (" + startloc + ")");
        System.out.println("recordid = 0x" + Integer.toHexString(rectype) + ", size = " + recsize);
        System.out.println(record.toString());
    }

    private static void dumpContinueRecord(Record last_record, boolean dump, byte[] data) throws IOException {
        if (last_record == null) {
            throw new RecordFormatException("First record is a ContinueRecord??");
        }
        if (dump) {
            System.out.println("-----PRECONTINUED LAST RECORD WOULD SERIALIZE LIKE:");
            byte[] lr = last_record.serialize();
            if (lr != null) {
                HexDump.dump(last_record.serialize(), 0L, System.out, 0);
            }
            System.out.println();
            System.out.println("-----PRECONTINUED----------------------------------");
        }
        last_record.processContinueRecord(data);
        if (dump) {
            System.out.println("-----CONTINUED LAST RECORD WOULD SERIALIZE LIKE:");
            HexDump.dump(last_record.serialize(), 0L, System.out, 0);
            System.out.println();
            System.out.println("-----CONTINUED----------------------------------");
        }
    }

    private static void dumpUnknownRecord(byte[] data) throws IOException {
        System.out.println("-----UNKNOWN----------------------------------");
        if (data.length > 0) {
            HexDump.dump(data, 0L, System.out, 0);
        } else {
            System.out.print("**NO RECORD DATA**");
        }
        System.out.println();
        System.out.println("-----UNKNOWN----------------------------------");
    }

    private static void dumpRaw(short rectype, short recsize, byte[] data) throws IOException {
        System.out.println("============================================");
        System.out.print("rectype = 0x" + Integer.toHexString(rectype));
        System.out.println(", recsize = 0x" + Integer.toHexString(recsize));
        System.out.println("-BEGIN DUMP---------------------------------");
        if (data.length > 0) {
            HexDump.dump(data, 0L, System.out, 0);
        } else {
            System.out.println("**NO RECORD DATA**");
        }
        System.out.println("-END DUMP-----------------------------------");
    }

    private static Record createRecord(short rectype, short size, byte[] data) {
        Record retval = null;
        switch (rectype) {
            case 4098: {
                retval = new ChartRecord(rectype, size, data);
                break;
            }
            case 4116: {
                retval = new ChartFormatRecord(rectype, size, data);
                break;
            }
            case 4099: {
                retval = new SeriesRecord(rectype, size, data);
                break;
            }
            case 4147: {
                retval = new BeginRecord(rectype, size, data);
                break;
            }
            case 4148: {
                retval = new EndRecord(rectype, size, data);
                break;
            }
            case 2057: {
                retval = new BOFRecord(rectype, size, data);
                break;
            }
            case 225: {
                retval = new InterfaceHdrRecord(rectype, size, data);
                break;
            }
            case 193: {
                retval = new MMSRecord(rectype, size, data);
                break;
            }
            case 226: {
                retval = new InterfaceEndRecord(rectype, size, data);
                break;
            }
            case 92: {
                retval = new WriteAccessRecord(rectype, size, data);
                break;
            }
            case 66: {
                retval = new CodepageRecord(rectype, size, data);
                break;
            }
            case 353: {
                retval = new DSFRecord(rectype, size, data);
                break;
            }
            case 317: {
                retval = new TabIdRecord(rectype, size, data);
                break;
            }
            case 156: {
                retval = new FnGroupCountRecord(rectype, size, data);
                break;
            }
            case 25: {
                retval = new WindowProtectRecord(rectype, size, data);
                break;
            }
            case 18: {
                retval = new ProtectRecord(rectype, size, data);
                break;
            }
            case 19: {
                retval = new PasswordRecord(rectype, size, data);
                break;
            }
            case 431: {
                retval = new ProtectionRev4Record(rectype, size, data);
                break;
            }
            case 444: {
                retval = new PasswordRev4Record(rectype, size, data);
                break;
            }
            case 61: {
                retval = new WindowOneRecord(rectype, size, data);
                break;
            }
            case 64: {
                retval = new BackupRecord(rectype, size, data);
                break;
            }
            case 141: {
                retval = new HideObjRecord(rectype, size, data);
                break;
            }
            case 34: {
                retval = new DateWindow1904Record(rectype, size, data);
                break;
            }
            case 14: {
                retval = new PrecisionRecord(rectype, size, data);
                break;
            }
            case 439: {
                retval = new RefreshAllRecord(rectype, size, data);
                break;
            }
            case 218: {
                retval = new BookBoolRecord(rectype, size, data);
                break;
            }
            case 49: {
                retval = new FontRecord(rectype, size, data);
                break;
            }
            case 1054: {
                retval = new FormatRecord(rectype, size, data);
                break;
            }
            case 224: {
                retval = new ExtendedFormatRecord(rectype, size, data);
                break;
            }
            case 659: {
                retval = new StyleRecord(rectype, size, data);
                break;
            }
            case 352: {
                retval = new UseSelFSRecord(rectype, size, data);
                break;
            }
            case 133: {
                retval = new BoundSheetRecord(rectype, size, data);
                break;
            }
            case 140: {
                retval = new CountryRecord(rectype, size, data);
                break;
            }
            case 252: {
                retval = new SSTRecord(rectype, size, data);
                break;
            }
            case 255: {
                retval = new ExtSSTRecord(rectype, size, data);
                break;
            }
            case 10: {
                retval = new EOFRecord(rectype, size, data);
                break;
            }
            case 523: {
                retval = new IndexRecord(rectype, size, data);
                break;
            }
            case 13: {
                retval = new CalcModeRecord(rectype, size, data);
                break;
            }
            case 12: {
                retval = new CalcCountRecord(rectype, size, data);
                break;
            }
            case 15: {
                retval = new RefModeRecord(rectype, size, data);
                break;
            }
            case 17: {
                retval = new IterationRecord(rectype, size, data);
                break;
            }
            case 16: {
                retval = new DeltaRecord(rectype, size, data);
                break;
            }
            case 95: {
                retval = new SaveRecalcRecord(rectype, size, data);
                break;
            }
            case 42: {
                retval = new PrintHeadersRecord(rectype, size, data);
                break;
            }
            case 43: {
                retval = new PrintGridlinesRecord(rectype, size, data);
                break;
            }
            case 130: {
                retval = new GridsetRecord(rectype, size, data);
                break;
            }
            case 235: {
                retval = new DrawingGroupRecord(rectype, size, data);
                break;
            }
            case 236: {
                retval = new DrawingRecordForBiffViewer(rectype, size, data);
                break;
            }
            case 237: {
                retval = new DrawingSelectionRecord(rectype, size, data);
                break;
            }
            case 128: {
                retval = new GutsRecord(rectype, size, data);
                break;
            }
            case 549: {
                retval = new DefaultRowHeightRecord(rectype, size, data);
                break;
            }
            case 129: {
                retval = new WSBoolRecord(rectype, size, data);
                break;
            }
            case 20: {
                retval = new HeaderRecord(rectype, size, data);
                break;
            }
            case 21: {
                retval = new FooterRecord(rectype, size, data);
                break;
            }
            case 131: {
                retval = new HCenterRecord(rectype, size, data);
                break;
            }
            case 132: {
                retval = new VCenterRecord(rectype, size, data);
                break;
            }
            case 161: {
                retval = new PrintSetupRecord(rectype, size, data);
                break;
            }
            case 85: {
                retval = new DefaultColWidthRecord(rectype, size, data);
                break;
            }
            case 512: {
                retval = new DimensionsRecord(rectype, size, data);
                break;
            }
            case 520: {
                retval = new RowRecord(rectype, size, data);
                break;
            }
            case 253: {
                retval = new LabelSSTRecord(rectype, size, data);
                break;
            }
            case 638: {
                retval = new RKRecord(rectype, size, data);
                break;
            }
            case 515: {
                retval = new NumberRecord(rectype, size, data);
                break;
            }
            case 215: {
                retval = new DBCellRecord(rectype, size, data);
                break;
            }
            case 574: {
                retval = new WindowTwoRecord(rectype, size, data);
                break;
            }
            case 29: {
                retval = new SelectionRecord(rectype, size, data);
                break;
            }
            case 60: {
                retval = new ContinueRecord(rectype, size, data);
                break;
            }
            case 516: {
                retval = new LabelRecord(rectype, size, data);
                break;
            }
            case 189: {
                retval = new MulRKRecord(rectype, size, data);
                break;
            }
            case 190: {
                retval = new MulBlankRecord(rectype, size, data);
                break;
            }
            case 513: {
                retval = new BlankRecord(rectype, size, data);
                break;
            }
            case 517: {
                retval = new BoolErrRecord(rectype, size, data);
                break;
            }
            case 125: {
                retval = new ColumnInfoRecord(rectype, size, data);
                break;
            }
            case 229: {
                retval = new MergeCellsRecord(rectype, size, data);
                break;
            }
            case 4122: {
                retval = new AreaRecord(rectype, size, data);
                break;
            }
            case 4102: {
                retval = new DataFormatRecord(rectype, size, data);
                break;
            }
            case 4119: {
                retval = new BarRecord(rectype, size, data);
                break;
            }
            case 4195: {
                retval = new DatRecord(rectype, size, data);
                break;
            }
            case 4196: {
                retval = new PlotGrowthRecord(rectype, size, data);
                break;
            }
            case 4097: {
                retval = new UnitsRecord(rectype, size, data);
                break;
            }
            case 4146: {
                retval = new FrameRecord(rectype, size, data);
                break;
            }
            case 4127: {
                retval = new ValueRangeRecord(rectype, size, data);
                break;
            }
            case 4118: {
                retval = new SeriesListRecord(rectype, size, data);
                break;
            }
            case 4192: {
                retval = new FontBasisRecord(rectype, size, data);
                break;
            }
            case 4134: {
                retval = new FontIndexRecord(rectype, size, data);
                break;
            }
            case 4103: {
                retval = new LineFormatRecord(rectype, size, data);
                break;
            }
            case 4106: {
                retval = new AreaFormatRecord(rectype, size, data);
                break;
            }
            case 4177: {
                retval = new LinkedDataRecord(rectype, size, data);
                break;
            }
            case 6: {
                retval = new FormulaRecord(rectype, size, data);
                break;
            }
            case 4164: {
                retval = new SheetPropertiesRecord(rectype, size, data);
                break;
            }
            case 4132: {
                retval = new DefaultDataLabelTextPropertiesRecord(rectype, size, data);
                break;
            }
            case 4133: {
                retval = new TextRecord(rectype, size, data);
                break;
            }
            case 4161: {
                retval = new AxisParentRecord(rectype, size, data);
                break;
            }
            case 4129: {
                retval = new AxisLineFormatRecord(rectype, size, data);
                break;
            }
            case 430: {
                retval = new SupBookRecord(rectype, size, data);
                break;
            }
            case 23: {
                retval = new ExternSheetRecord(rectype, size, data);
                break;
            }
            case 160: {
                retval = new SCLRecord(rectype, size, data);
                break;
            }
            case 4165: {
                retval = new SeriesToChartGroupRecord(rectype, size, data);
                break;
            }
            case 4166: {
                retval = new AxisUsedRecord(rectype, size, data);
                break;
            }
            case 4125: {
                retval = new AxisRecord(rectype, size, data);
                break;
            }
            case 4128: {
                retval = new CategorySeriesAxisRecord(rectype, size, data);
                break;
            }
            case 4194: {
                retval = new AxisOptionsRecord(rectype, size, data);
                break;
            }
            case 4126: {
                retval = new TickRecord(rectype, size, data);
                break;
            }
            case 4109: {
                retval = new SeriesTextRecord(rectype, size, data);
                break;
            }
            case 4135: {
                retval = new ObjectLinkRecord(rectype, size, data);
                break;
            }
            case 4149: {
                retval = new PlotAreaRecord(rectype, size, data);
                break;
            }
            case 4197: {
                retval = new SeriesIndexRecord(rectype, size, data);
                break;
            }
            case 4117: {
                retval = new LegendRecord(rectype, size, data);
                break;
            }
            case 38: {
                retval = new LeftMarginRecord(rectype, size, data);
                break;
            }
            case 39: {
                retval = new RightMarginRecord(rectype, size, data);
                break;
            }
            case 40: {
                retval = new TopMarginRecord(rectype, size, data);
                break;
            }
            case 41: {
                retval = new BottomMarginRecord(rectype, size, data);
                break;
            }
            case 146: {
                retval = new PaletteRecord(rectype, size, data);
                break;
            }
            case 519: {
                retval = new StringRecord(rectype, size, data);
                break;
            }
            case 24: {
                retval = new NameRecord(rectype, size, data);
                break;
            }
            case 65: {
                retval = new PaneRecord(rectype, size, data);
                break;
            }
            case 1212: {
                retval = new SharedFormulaRecord(rectype, size, data);
                break;
            }
            case 93: {
                retval = new ObjRecord(rectype, size, data);
                break;
            }
            case 438: {
                retval = new TextObjectRecord(rectype, size, data);
                break;
            }
            case 27: {
                retval = new HorizontalPageBreakRecord(rectype, size, data);
                break;
            }
            case 26: {
                retval = new VerticalPageBreakRecord(rectype, size, data);
                break;
            }
            default: {
                retval = new UnknownRecord(rectype, size, data);
            }
        }
        return retval;
    }

    public void setDump(boolean dump) {
        this.dump = dump;
    }

    public static void main(String[] args) {
        try {
            System.setProperty("poi.deserialize.escher", "true");
            BiffViewer viewer = new BiffViewer(args);
            if (args.length > 1 && args[1].equals("on")) {
                viewer.setDump(true);
            }
            if (args.length > 1 && args[1].equals("bfd")) {
                POIFSFileSystem fs = new POIFSFileSystem(new FileInputStream(args[0]));
                DocumentInputStream stream = fs.createDocumentInputStream("Workbook");
                int size = ((InputStream)stream).available();
                byte[] data = new byte[size];
                ((InputStream)stream).read(data);
                HexDump.dump(data, 0L, System.out, 0);
            } else {
                viewer.run();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static class RecordDetails {
        short rectype;
        short recsize;
        int startloc;
        byte[] data;
        Record record;

        public RecordDetails(short rectype, short recsize, int startloc, byte[] data, Record record) {
            this.rectype = rectype;
            this.recsize = recsize;
            this.startloc = startloc;
            this.data = data;
            this.record = record;
        }

        public short getRectype() {
            return this.rectype;
        }

        public short getRecsize() {
            return this.recsize;
        }

        public byte[] getData() {
            return this.data;
        }

        public Record getRecord() {
            return this.record;
        }

        public void dump() throws IOException {
            if (this.record instanceof UnknownRecord) {
                BiffViewer.dumpUnknownRecord(this.data);
            } else {
                BiffViewer.dumpNormal(this.record, this.startloc, this.rectype, this.recsize);
            }
        }
    }
}

