/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.commons.validator;

import java.util.Comparator;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.FacesMessage;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.el.ValueBinding;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.faces.render.Renderer;
import javax.faces.validator.ValidatorException;
import org.apache.myfaces.commons.util.MessageUtils;
import org.apache.myfaces.commons.validator.ValidatorBase;

public abstract class AbstractCompareToValidator
extends ValidatorBase {
    public static final String VALIDATOR_ID = "org.apache.myfaces.commons.validator.CompareTo";
    public static final String COMPARE_TO_MESSAGE_ID = "org.apache.myfaces.commons.validator.CompareTo.INVALID";
    public static final String OPERATOR_EQUALS = "eq";
    public static final String OPERATOR_NOT_EQUALS = "ne";
    public static final String OPERATOR_GREATER_THAN = "gt";
    public static final String OPERATOR_LESS_THAN = "lt";
    public static final String OPERATOR_GREATER_THAN_OR_EQUALS = "ge";
    public static final String OPERATOR_LESS_THAN_OR_EQUALS = "le";
    public static final String OPERATOR_EQUALS_ALT = "==";
    public static final String OPERATOR_NOT_EQUALS_ALT = "!=";
    public static final String OPERATOR_GREATER_THAN_ALT = ">";
    public static final String OPERATOR_LESS_THAN_ALT = "<";
    public static final String OPERATOR_GREATER_THAN_OR_EQUALS_ALT = ">=";
    public static final String OPERATOR_LESS_THAN_OR_EQUALS_ALT = "<=";
    public static final String OPERATOR_EQUALS_ALT2 = "=";

    protected String getOperatorForString(String operatorSpecified) {
        if (OPERATOR_EQUALS.equalsIgnoreCase(operatorSpecified)) {
            return OPERATOR_EQUALS;
        }
        if (OPERATOR_NOT_EQUALS.equalsIgnoreCase(operatorSpecified)) {
            return OPERATOR_NOT_EQUALS;
        }
        if (OPERATOR_GREATER_THAN.equalsIgnoreCase(operatorSpecified)) {
            return OPERATOR_GREATER_THAN;
        }
        if (OPERATOR_LESS_THAN.equalsIgnoreCase(operatorSpecified)) {
            return OPERATOR_LESS_THAN;
        }
        if (OPERATOR_GREATER_THAN_OR_EQUALS.equalsIgnoreCase(operatorSpecified)) {
            return OPERATOR_GREATER_THAN_OR_EQUALS;
        }
        if (OPERATOR_LESS_THAN_OR_EQUALS.equalsIgnoreCase(operatorSpecified)) {
            return OPERATOR_LESS_THAN_OR_EQUALS;
        }
        if (OPERATOR_EQUALS_ALT.equalsIgnoreCase(operatorSpecified)) {
            return OPERATOR_EQUALS;
        }
        if (OPERATOR_NOT_EQUALS_ALT.equalsIgnoreCase(operatorSpecified)) {
            return OPERATOR_NOT_EQUALS;
        }
        if (OPERATOR_GREATER_THAN_ALT.equalsIgnoreCase(operatorSpecified)) {
            return OPERATOR_GREATER_THAN;
        }
        if (OPERATOR_LESS_THAN_ALT.equalsIgnoreCase(operatorSpecified)) {
            return OPERATOR_LESS_THAN;
        }
        if (OPERATOR_GREATER_THAN_OR_EQUALS_ALT.equalsIgnoreCase(operatorSpecified)) {
            return OPERATOR_GREATER_THAN_OR_EQUALS;
        }
        if (OPERATOR_LESS_THAN_OR_EQUALS_ALT.equalsIgnoreCase(operatorSpecified)) {
            return OPERATOR_LESS_THAN_OR_EQUALS;
        }
        if (OPERATOR_EQUALS_ALT2.equalsIgnoreCase(operatorSpecified)) {
            return OPERATOR_EQUALS;
        }
        throw new IllegalStateException("Operator has unknown value of '" + operatorSpecified + "'");
    }

    protected String nameForOperator(String operator) {
        if (OPERATOR_EQUALS.equals(operator)) {
            return "equal to";
        }
        if (OPERATOR_NOT_EQUALS.equals(operator)) {
            return "inequal to";
        }
        if (OPERATOR_GREATER_THAN.equals(operator)) {
            return "greater than";
        }
        if (OPERATOR_LESS_THAN.equals(operator)) {
            return "less than";
        }
        if (OPERATOR_GREATER_THAN_OR_EQUALS.equals(operator)) {
            return "greater than or equal to";
        }
        if (OPERATOR_LESS_THAN_OR_EQUALS.equals(operator)) {
            return "less than or equal to";
        }
        throw new IllegalStateException("Operator has unknown value of '" + operator + "'");
    }

    protected boolean validateOperatorOnComparisonResult(String operator, int result) {
        if (OPERATOR_EQUALS.equals(operator)) {
            return result == 0;
        }
        if (OPERATOR_NOT_EQUALS.equals(operator)) {
            return result != 0;
        }
        if (OPERATOR_GREATER_THAN.equals(operator)) {
            return result > 0;
        }
        if (OPERATOR_LESS_THAN.equals(operator)) {
            return result < 0;
        }
        if (OPERATOR_GREATER_THAN_OR_EQUALS.equals(operator)) {
            return result >= 0;
        }
        if (OPERATOR_LESS_THAN_OR_EQUALS.equals(operator)) {
            return result <= 0;
        }
        throw new IllegalStateException("Operator has unknown value of '" + operator + "'");
    }

    public void validate(FacesContext facesContext, UIComponent uiComponent, Object value) throws ValidatorException {
        block22: {
            Comparator comparator;
            Object foreignValue;
            if (facesContext == null) {
                throw new NullPointerException("facesContext");
            }
            if (uiComponent == null) {
                throw new NullPointerException("uiComponent");
            }
            if (value == null) {
                return;
            }
            String foreignComponentName = this.getFor();
            UIComponent foreignComponent = uiComponent.getParent().findComponent(foreignComponentName);
            if (foreignComponent == null) {
                throw new FacesException("Unable to find component '" + foreignComponentName + "' (calling findComponent on component '" + uiComponent.getId() + "')");
            }
            if (!(foreignComponent instanceof EditableValueHolder)) {
                throw new FacesException("Component '" + foreignComponent.getId() + "' does not implement EditableValueHolder");
            }
            EditableValueHolder foreignEditableValueHolder = (EditableValueHolder)foreignComponent;
            if (foreignEditableValueHolder.isRequired() && foreignEditableValueHolder.getValue() == null) {
                return;
            }
            if (foreignEditableValueHolder.isValid()) {
                foreignValue = foreignEditableValueHolder.getValue();
            } else {
                try {
                    foreignValue = this.getConvertedValueNonValid(facesContext, foreignComponent);
                }
                catch (ConverterException e) {
                    return;
                }
            }
            if (null == foreignValue) {
                return;
            }
            String operator = this.getOperatorForString(this.getOperator());
            String alternateOperatorName = this.getAlternateOperatorName();
            Object[] args = new Object[]{uiComponent.getId(), value.toString(), alternateOperatorName == null ? this.nameForOperator(operator) : alternateOperatorName, foreignComponent.getId(), foreignValue.toString()};
            String message = this.getMessage();
            if (null == message) {
                message = COMPARE_TO_MESSAGE_ID;
            }
            if (null != (comparator = this.createComparator())) {
                if (!this.validateOperatorOnComparisonResult(operator, comparator.compare(value, foreignValue))) {
                    throw new ValidatorException(MessageUtils.getMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)message, (Object[])args));
                }
            } else {
                if (value instanceof Comparable && foreignValue instanceof Comparable) {
                    try {
                        if (!this.validateOperatorOnComparisonResult(operator, ((Comparable)value).compareTo(foreignValue))) {
                            throw new ValidatorException(MessageUtils.getMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)message, (Object[])args));
                        }
                        break block22;
                    }
                    catch (RuntimeException exception) {
                        if (exception instanceof ValidatorException) {
                            throw exception;
                        }
                        throw new ValidatorException(MessageUtils.getMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)(message + ": " + exception.getLocalizedMessage()), (Object[])args));
                    }
                }
                if (value instanceof Comparable) {
                    throw new ClassCastException(this.getClassCastExceptionMessage(foreignComponent.getId(), Comparable.class, foreignValue));
                }
                if (foreignValue instanceof Comparable) {
                    throw new ClassCastException(this.getClassCastExceptionMessage(uiComponent.getId(), Comparable.class, value));
                }
            }
        }
    }

    protected String getClassCastExceptionMessage(String name, Class clazz, Object object) {
        if (null == object) {
            return name + " must be type " + clazz + " but is null";
        }
        return name + " must be type " + clazz + " but is type " + object.getClass();
    }

    protected Comparator createComparator() {
        Object comparator = this.getComparator();
        if (null == comparator) {
            return null;
        }
        if (!(comparator instanceof Comparator)) {
            throw new ClassCastException(this.getClassCastExceptionMessage("comparator", Comparator.class, comparator));
        }
        return (Comparator)comparator;
    }

    public abstract String getFor();

    public abstract void setFor(String var1);

    public abstract String getOperator();

    public abstract void setOperator(String var1);

    public abstract Object getComparator();

    public abstract void setComparator(Object var1);

    public abstract String getAlternateOperatorName();

    public abstract void setAlternateOperatorName(String var1);

    private Renderer getRenderer(FacesContext context, UIComponent foreignComponent) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        String rendererType = foreignComponent.getRendererType();
        if (rendererType == null) {
            return null;
        }
        String renderKitId = context.getViewRoot().getRenderKitId();
        RenderKitFactory rkf = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
        RenderKit renderKit = rkf.getRenderKit(context, renderKitId);
        Renderer renderer = renderKit.getRenderer(foreignComponent.getFamily(), rendererType);
        if (renderer == null) {
            this.getFacesContext().getExternalContext().log("No Renderer found for component " + foreignComponent + " (component-family=" + foreignComponent.getFamily() + ", renderer-type=" + rendererType + ")");
        }
        return renderer;
    }

    private Converter findUIOutputConverter(FacesContext facesContext, UIComponent component) {
        Converter converter = null;
        if (component instanceof ValueHolder) {
            converter = ((ValueHolder)component).getConverter();
        }
        if (converter != null) {
            return converter;
        }
        ValueBinding vb = component.getValueBinding("value");
        if (vb == null) {
            return null;
        }
        Class valueType = vb.getType(facesContext);
        if (valueType == null) {
            return null;
        }
        if (String.class.equals((Object)valueType)) {
            return null;
        }
        if (Object.class.equals((Object)valueType)) {
            return null;
        }
        try {
            return facesContext.getApplication().createConverter(valueType);
        }
        catch (FacesException e) {
            this.getFacesContext().getExternalContext().log("No Converter for type " + valueType.getName() + " found", (Throwable)e);
            return null;
        }
    }

    private Object getConvertedValueNonValid(FacesContext facesContext, UIComponent component) throws ConverterException {
        Converter converter;
        Renderer renderer;
        if (!(component instanceof EditableValueHolder)) {
            return null;
        }
        Object submittedValue = ((EditableValueHolder)component).getSubmittedValue();
        Object componentValueObject = submittedValue == null ? null : ((renderer = this.getRenderer(facesContext, component)) != null ? renderer.getConvertedValue(facesContext, component, submittedValue) : (submittedValue instanceof String ? ((converter = this.findUIOutputConverter(facesContext, component)) != null ? converter.getAsObject(facesContext, component, (String)submittedValue) : submittedValue) : submittedValue));
        return componentValueObject;
    }
}

