/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.security;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.concurrent.Callable;

public final class PrivilegedOperations {
    private PrivilegedOperations() {
        throw new IllegalStateException("No instantiation of class PrivilegedOperations");
    }

    public static ThreadGroup getPrivilegedThreadGroup() {
        if (HasSecurity.withSecurityManager()) {
            return HasSecurity.getPrivilegedThreadGroup();
        }
        return null;
    }

    public static void doPrivileged(Runnable action) {
        if (HasSecurity.isAvailable()) {
            HasSecurity.doPrivileged(action);
        } else {
            action.run();
        }
    }

    public static <T> T doPrivileged(Callable<? extends T> action) throws PrivilegeException {
        if (HasSecurity.isAvailable()) {
            return HasSecurity.doPrivileged(action);
        }
        try {
            return action.call();
        }
        catch (Exception e) {
            throw new PrivilegeException(e);
        }
    }

    public static <T> T doPrivilegedConditional(Callable<? extends T> action) throws PrivilegeException {
        if (HasSecurity.withSecurityManager()) {
            return PrivilegedOperations.doPrivileged(action);
        }
        try {
            return action.call();
        }
        catch (Exception e) {
            throw new PrivilegeException(e);
        }
    }

    private static final class HasSecurity {
        private static final boolean HAS_SECURITY_MANAGER = HasSecurity.haveSecurityManager();
        private static final boolean HAS_ACCESS_CONTROLLER = HasSecurity.haveAccessController();

        private HasSecurity() {
            throw new IllegalStateException("No instantiation of class PrivilegedOperations$HasSecurity");
        }

        private static boolean haveSecurityManager() {
            try {
                Method m = System.class.getDeclaredMethod("getSecurityManager", new Class[0]);
                if (m == null) {
                    return false;
                }
                return m.invoke(null, new Object[0]) != null;
            }
            catch (Throwable t) {
                return false;
            }
        }

        private static boolean haveAccessController() {
            try {
                HasSecurity.class.getClassLoader().loadClass("java.security.AccessController");
                return true;
            }
            catch (Throwable t) {
                return false;
            }
        }

        static boolean withSecurityManager() {
            return HAS_SECURITY_MANAGER;
        }

        static boolean isAvailable() {
            return HAS_ACCESS_CONTROLLER;
        }

        static ThreadGroup getPrivilegedThreadGroup() {
            return System.getSecurityManager().getThreadGroup();
        }

        static void doPrivileged(Runnable action) {
            AccessController.doPrivileged(() -> {
                action.run();
                return null;
            });
        }

        static <T> T doPrivileged(final Callable<? extends T> action) throws PrivilegeException {
            try {
                return AccessController.doPrivileged(new PrivilegedExceptionAction<T>(){

                    @Override
                    public T run() throws Exception {
                        return action.call();
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw new PrivilegeException(e.getCause());
            }
        }
    }

    public static class PrivilegeException
    extends Exception {
        private static final long serialVersionUID = 945792544549913161L;

        PrivilegeException(Throwable cause) {
            super(cause);
        }
    }
}

