/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j;

import com.github.sommeri.less4j.LessSource;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;

public class MultiPathFileSource
extends LessSource {
    private File[] includePaths;
    private String charsetName;
    private File file;

    public MultiPathFileSource(File file, String charsetName, File ... includePaths) {
        this.file = file;
        this.charsetName = charsetName;
        this.includePaths = includePaths;
    }

    public MultiPathFileSource(File file, File ... includePaths) {
        this.file = file;
        this.charsetName = null;
        this.includePaths = includePaths;
    }

    @Override
    public LessSource relativeSource(String filename) throws LessSource.FileNotFound {
        File currentDir;
        File newFile;
        if (this.file != null && (newFile = new File(currentDir = this.file.getParentFile(), filename)).exists()) {
            return new MultiPathFileSource(newFile, this.charsetName, this.includePaths);
        }
        for (int i = 0; i < this.includePaths.length; ++i) {
            File directory = this.includePaths[i];
            File newFile2 = new File(directory, filename);
            if (!newFile2.exists()) continue;
            return new MultiPathFileSource(newFile2, this.charsetName, this.includePaths);
        }
        throw new LessSource.FileNotFound();
    }

    @Override
    public String getContent() throws LessSource.FileNotFound, LessSource.CannotReadFile {
        LessSource.FileSource fileSource = new LessSource.FileSource(this.file, this.charsetName);
        return fileSource.getContent();
    }

    @Override
    public byte[] getBytes() throws LessSource.FileNotFound, LessSource.CannotReadFile {
        LessSource.FileSource fileSource = new LessSource.FileSource(this.file, this.charsetName);
        return fileSource.getBytes();
    }

    @Override
    public String getName() {
        LessSource.FileSource fileSource = new LessSource.FileSource(this.file, this.charsetName);
        return fileSource.getName();
    }

    @Override
    public URI getURI() {
        LessSource.FileSource fileSource = new LessSource.FileSource(this.file, this.charsetName);
        return fileSource.getURI();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.charsetName == null ? 0 : this.charsetName.hashCode());
        File canonicalFile = this.getCanonicalFile();
        result = 31 * result + (canonicalFile == null ? 0 : canonicalFile.hashCode());
        result = 31 * result + Arrays.hashCode(this.includePaths);
        return result;
    }

    private File getCanonicalFile() {
        try {
            return this.getInputFile().getCanonicalFile();
        }
        catch (IOException e) {
            return this.getInputFile().getAbsoluteFile();
        }
    }

    public File getInputFile() {
        return this.file;
    }

    public String toString() {
        return this.getInputFile().toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MultiPathFileSource other = (MultiPathFileSource)obj;
        if (this.charsetName == null ? other.charsetName != null : !this.charsetName.equals(other.charsetName)) {
            return false;
        }
        File canonicalFile = this.getCanonicalFile();
        File othercanonicalFile = other.getCanonicalFile();
        if (canonicalFile == null ? othercanonicalFile != null : !canonicalFile.equals(othercanonicalFile)) {
            return false;
        }
        return Arrays.equals(this.includePaths, other.includePaths);
    }
}

