/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.image;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.ImagingOpException;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.util.Locale;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.stream.Collector;
import org.apache.sis.image.ErrorHandler;
import org.apache.sis.image.ImageAdapter;
import org.apache.sis.image.ImageProcessor;
import org.apache.sis.internal.coverage.j2d.ImageUtilities;
import org.apache.sis.internal.coverage.j2d.TileOpExecutor;
import org.apache.sis.internal.util.Strings;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.collection.Cache;
import org.apache.sis.util.resources.Errors;

abstract class AnnotatedImage
extends ImageAdapter {
    public static final String WARNINGS_SUFFIX = ".warnings";
    private static final Object NULL = Void.TYPE;
    private static final WeakHashMap<RenderedImage, Cache<Object, Object>> CACHE = new WeakHashMap();
    private final Cache<Object, Object> cache;
    protected final Shape areaOfInterest;
    protected final Rectangle boundsOfInterest;
    private volatile ErrorHandler.Report errors;
    private final boolean parallel;
    private final boolean failOnException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AnnotatedImage(RenderedImage renderedImage2, Shape shape, boolean bl, boolean bl2) {
        super(renderedImage2);
        Rectangle rectangle = null;
        if (shape != null) {
            rectangle = shape.getBounds();
            ImageUtilities.clipBounds(renderedImage2, rectangle);
            if (rectangle.isEmpty()) {
                rectangle.x = this.getMinX();
                rectangle.y = this.getMinY();
                rectangle.width = 0;
                rectangle.height = 0;
            }
            if (shape.contains(rectangle)) {
                shape = rectangle;
            }
            if (rectangle.x == this.getMinX() && rectangle.width == this.getWidth() && rectangle.y == this.getMinY() && rectangle.height == this.getHeight()) {
                if (rectangle == shape) {
                    shape = null;
                }
                rectangle = null;
            }
        }
        this.boundsOfInterest = rectangle;
        this.areaOfInterest = shape;
        this.parallel = bl;
        this.failOnException = bl2;
        while (renderedImage2 instanceof ImageAdapter) {
            if (renderedImage2 instanceof AnnotatedImage) {
                this.cache = ((AnnotatedImage)renderedImage2).cache;
                return;
            }
            renderedImage2 = ((ImageAdapter)renderedImage2).source;
        }
        WeakHashMap<RenderedImage, Cache<Object, Object>> weakHashMap = CACHE;
        synchronized (weakHashMap) {
            this.cache = CACHE.computeIfAbsent(renderedImage2, renderedImage -> new Cache(8, 200L, false));
        }
    }

    final RenderedImage unique() {
        if (this.source.getClass() == this.getClass() && this.equalParameters((AnnotatedImage)this.source)) {
            return this.source;
        }
        return ImageProcessor.unique(this);
    }

    private Object getCacheKey(String string) {
        return this.areaOfInterest != null ? new CacheKey(string, this.areaOfInterest) : string;
    }

    protected abstract String getComputedPropertyName();

    @Override
    public String[] getPropertyNames() {
        boolean bl = this.errors != null;
        String[] stringArray = new String[bl ? 2 : 1];
        stringArray[0] = this.getComputedPropertyName();
        if (bl) {
            stringArray[1] = stringArray[0] + WARNINGS_SUFFIX;
        }
        return ArraysExt.concatenate(this.source.getPropertyNames(), stringArray);
    }

    private static boolean isErrorProperty(String string, String string2) {
        return string2 != null && string2.length() == string.length() + WARNINGS_SUFFIX.length() && string2.startsWith(string) && string2.endsWith(WARNINGS_SUFFIX);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Object getProperty(String string) {
        Object object;
        block9: {
            String string2;
            block8: {
                string2 = this.getComputedPropertyName();
                if (!string2.equals(string)) break block8;
                Object object2 = this.getCacheKey(string2);
                object = this.cache.peek(object2);
                if (object != null) break block9;
                boolean bl = false;
                Cache.Handler<Object> handler = this.cache.lock(object2);
                try {
                    object = handler.peek();
                    if (object == null) {
                        try {
                            object = this.computeProperty();
                            if (object == null) {
                                object = NULL;
                            }
                            bl = this.errors == null;
                        }
                        catch (Exception exception) {
                            if (this.failOnException) {
                                throw (ImagingOpException)new ImagingOpException(Errors.format((short)5, string2)).initCause(exception);
                            }
                            ErrorHandler.Report report = this.errors;
                            if (report == null) {
                                this.errors = report = new ErrorHandler.Report();
                            }
                            report.add(null, exception, () -> Errors.getResources((Locale)null).getLogRecord(Level.WARNING, (short)5, string2));
                        }
                    }
                    handler.putAndUnlock(bl ? object : null);
                }
                catch (Throwable throwable) {
                    handler.putAndUnlock(bl ? object : null);
                    throw throwable;
                }
                object = object == NULL ? null : this.cloneProperty(string2, object);
                break block9;
            }
            object = AnnotatedImage.isErrorProperty(string2, string) ? this.errors : this.source.getProperty(string);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void logAndClearError(Class<?> clazz, String string, ErrorHandler errorHandler) {
        ErrorHandler.Report report = this.errors;
        if (report != null) {
            ErrorHandler.Report report2 = report;
            synchronized (report2) {
                LogRecord logRecord = report.getDescription();
                logRecord.setSourceClassName(clazz.getCanonicalName());
                logRecord.setSourceMethodName(string);
                this.errors = null;
            }
            errorHandler.handle(report);
        }
    }

    protected Object computeProperty() throws Exception {
        Collector<? super Raster, ?, ?> collector;
        TileOpExecutor tileOpExecutor;
        if (this.parallel && (tileOpExecutor = new TileOpExecutor(this.source, this.boundsOfInterest)).isMultiTiled() && (collector = this.collector()) != null) {
            if (!this.failOnException) {
                tileOpExecutor.setErrorHandler(report -> {
                    this.errors = report;
                }, AnnotatedImage.class, "getProperty");
            }
            return tileOpExecutor.executeOnReadable(this.source, this.collector());
        }
        return this.computeSequentially();
    }

    protected abstract Object computeSequentially() throws Exception;

    protected Collector<? super Raster, ?, ?> collector() {
        return null;
    }

    protected Object cloneProperty(String string, Object object) {
        return object;
    }

    final Class<AnnotatedImage> appendStringContent(StringBuilder stringBuilder) {
        String string = this.getComputedPropertyName();
        if (this.cache.containsKey(this.getCacheKey(string))) {
            stringBuilder.append("Cached ");
        }
        stringBuilder.append('\"').append(string).append('\"');
        return AnnotatedImage.class;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + Objects.hashCode(this.areaOfInterest) + Boolean.hashCode(this.failOnException);
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object) && this.equalParameters((AnnotatedImage)object);
    }

    private boolean equalParameters(AnnotatedImage annotatedImage) {
        return Objects.equals(this.areaOfInterest, annotatedImage.areaOfInterest) && this.parallel == annotatedImage.parallel && this.failOnException == annotatedImage.failOnException;
    }

    private static final class CacheKey {
        private final String property;
        private final Shape areaOfInterest;

        CacheKey(String string, Shape shape) {
            this.property = string;
            this.areaOfInterest = shape;
        }

        public int hashCode() {
            return this.property.hashCode() + 19 * this.areaOfInterest.hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof CacheKey) {
                CacheKey cacheKey = (CacheKey)object;
                return this.property.equals(cacheKey.property) && this.areaOfInterest.equals(this.areaOfInterest);
            }
            return false;
        }

        public String toString() {
            return Strings.toString(this.getClass(), "property", this.property, "areaOfInterest", this.areaOfInterest);
        }
    }
}

