/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib.tar;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.Date;
import org.hsqldb.lib.tar.RB;
import org.hsqldb.lib.tar.TarMalformatException;

public class PIFGenerator
extends ByteArrayOutputStream {
    OutputStreamWriter writer = new OutputStreamWriter((OutputStream)this, Charset.forName("UTF-8"));
    String name;
    int fakePid = (int)(new Date().getTime() % 100000L);

    public String getName() {
        return this.name;
    }

    protected PIFGenerator() {
    }

    public PIFGenerator(int n) {
        this();
        if (n < 1) {
            throw new IllegalArgumentException("Sequence numbers start at 1");
        }
        this.name = System.getProperty("java.io.tmpdir") + "/GlobalHead." + this.fakePid + "." + n;
    }

    public PIFGenerator(File file) {
        this();
        String string = file.getParentFile() == null ? "." : file.getParentFile().getPath();
        this.name = string + "/PaxHeaders." + this.fakePid + "/" + file.getName();
    }

    public void addRecord(String string, boolean bl) throws TarMalformatException, IOException {
        this.addRecord(string, Boolean.toString(bl));
    }

    public void addRecord(String string, int n) throws TarMalformatException, IOException {
        this.addRecord(string, Integer.toString(n));
    }

    public void addRecord(String string, long l) throws TarMalformatException, IOException {
        this.addRecord(string, Long.toString(l));
    }

    public void addRecord(String string, String string2) throws TarMalformatException, IOException {
        if (string == null || string2 == null || string.length() < 1 || string2.length() < 1) {
            throw new TarMalformatException(RB.zero_write.getString());
        }
        int n = string.length() + string2.length() + 3;
        int n2 = 0;
        if (n < 8) {
            n2 = n + 1;
        } else if (n < 97) {
            n2 = n + 2;
        } else if (n < 996) {
            n2 = n + 3;
        } else if (n < 9995) {
            n2 = n + 4;
        } else if (n < 99994) {
            n2 = n + 5;
        } else {
            throw new TarMalformatException(RB.pif_toobig.getString(99991));
        }
        this.writer.write(Integer.toString(n2));
        this.writer.write(32);
        this.writer.write(string);
        this.writer.write(61);
        this.writer.write(string2);
        this.writer.write(10);
        this.writer.flush();
    }
}

