/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.debugger.streampane;

import java.awt.Font;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.text.StyledDocument;
import org.apache.pdfbox.debugger.PDFDebugger;
import org.apache.pdfbox.debugger.streampane.tooltip.ToolTipController;
import org.apache.pdfbox.debugger.ui.textsearcher.Searcher;

class StreamTextView
implements MouseMotionListener,
AncestorListener {
    private final ToolTipController tTController;
    private JPanel mainPanel;
    private JTextPane textPane;
    private Searcher searcher;

    StreamTextView(StyledDocument document, ToolTipController controller) {
        this.tTController = controller;
        this.initUI(document);
    }

    private void initUI(StyledDocument document) {
        this.mainPanel = new JPanel();
        this.textPane = new JTextPane(document);
        this.textPane.addMouseMotionListener(this);
        this.textPane.setFont(new Font("monospaced", 0, 13));
        this.searcher = new Searcher(this.textPane);
        JScrollPane scrollPane = new JScrollPane(this.textPane);
        BoxLayout boxLayout = new BoxLayout(this.mainPanel, 1);
        this.mainPanel.setLayout(boxLayout);
        this.mainPanel.add(this.searcher.getSearchPanel());
        this.mainPanel.add(scrollPane);
        this.searcher.getSearchPanel().setVisible(false);
        this.mainPanel.addAncestorListener(this);
    }

    JComponent getView() {
        return this.mainPanel;
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.tTController != null) {
            int offset = this.textPane.viewToModel(mouseEvent.getPoint());
            this.textPane.setToolTipText(this.tTController.getToolTip(offset, this.textPane));
        }
    }

    @Override
    public void ancestorAdded(AncestorEvent ancestorEvent) {
        if (ancestorEvent.getAncestor().equals(this.mainPanel)) {
            PDFDebugger debugger = (PDFDebugger)SwingUtilities.getRoot(this.mainPanel);
            debugger.getFindMenu().setEnabled(true);
            this.searcher.addMenuListeners(debugger);
        }
    }

    @Override
    public void ancestorRemoved(AncestorEvent ancestorEvent) {
        if (ancestorEvent.getAncestor().equals(this.mainPanel)) {
            PDFDebugger debugger = (PDFDebugger)SwingUtilities.getRoot(this.mainPanel);
            debugger.getFindMenu().setEnabled(false);
            this.searcher.removeMenuListeners(debugger);
        }
    }

    @Override
    public void ancestorMoved(AncestorEvent ancestorEvent) {
    }
}

