/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage;

import java.util.Optional;
import java.util.OptionalLong;
import org.apache.sis.feature.DefaultFeatureType;
import org.apache.sis.internal.storage.AbstractResource;
import org.apache.sis.internal.storage.MetadataBuilder;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.FeatureSet;
import org.apache.sis.storage.event.StoreListeners;
import org.opengis.util.GenericName;

public abstract class AbstractFeatureSet
extends AbstractResource
implements FeatureSet {
    protected AbstractFeatureSet(StoreListeners storeListeners) {
        super(storeListeners);
    }

    @Override
    public Optional<GenericName> getIdentifier() throws DataStoreException {
        DefaultFeatureType defaultFeatureType = this.getType();
        return defaultFeatureType != null ? Optional.of(defaultFeatureType.getName()) : Optional.empty();
    }

    protected OptionalLong getFeatureCount() {
        return OptionalLong.empty();
    }

    @Override
    protected void createMetadata(MetadataBuilder metadataBuilder) throws DataStoreException {
        super.createMetadata(metadataBuilder);
        metadataBuilder.addFeatureType(this.getType(), this.getFeatureCount().orElse(-1L));
    }
}

