/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.util.DataEntry;
import org.apache.solr.common.util.DataInputInputStream;
import org.apache.solr.common.util.FastInputStream;
import org.apache.solr.common.util.JavaBinCodec;
import org.apache.solr.common.util.Utf8CharSequence;

public class FastJavaBinDecoder
implements DataEntry.FastDecoder {
    private StreamCodec codec;
    private EntryImpl rootEntry = new EntryImpl();
    private InputStream stream;
    private static final DataEntry.EntryListener emptylistener = e -> {};
    static final boolean LOWER_5_BITS = true;
    static final boolean UPPER_3_BITS = false;
    private static final Tag[] lower5BitTags = new Tag[32];
    static final DataEntry.EntryListener ENTRY_LISTENER;

    @Override
    public FastJavaBinDecoder withInputStream(InputStream is) {
        this.stream = is;
        return this;
    }

    @Override
    public Object decode(DataEntry.EntryListener listener) throws IOException {
        this.rootEntry.entryListener = listener == null ? emptylistener : listener;
        this.codec = new StreamCodec(this.stream);
        this.codec.start();
        EntryImpl entry = this.codec.beginRead(this.rootEntry);
        listener.entry(entry);
        if (entry.tag.type.isContainer && entry.entryListener != null) {
            entry.tag.stream(entry, this.codec);
        }
        return entry.ctx;
    }

    private static void addObj(DataEntry e) {
        if (e.type().isContainer) {
            Cloneable ctx;
            Cloneable cloneable = ctx = e.type() == DataEntry.Type.KEYVAL_ITER ? new LinkedHashMap(FastJavaBinDecoder.getSize(e)) : new ArrayList(FastJavaBinDecoder.getSize(e));
            if (e.ctx() != null) {
                if (e.isKeyValEntry()) {
                    ((Map)e.ctx()).put(e.name(), ctx);
                } else {
                    ((Collection)e.ctx()).add(ctx);
                }
            }
            e.listenContainer(ctx, FastJavaBinDecoder.getEntryListener());
        } else {
            Object val = e.val();
            if (val instanceof Utf8CharSequence) {
                val = ((Utf8CharSequence)val).clone();
            }
            if (e.ctx() != null) {
                if (e.isKeyValEntry()) {
                    ((Map)e.ctx()).put(e.name(), val);
                } else {
                    ((Collection)e.ctx()).add(val);
                }
            }
        }
    }

    private static int getSize(DataEntry e) {
        int sz = e.length();
        if (sz == -1) {
            sz = e.type() == DataEntry.Type.KEYVAL_ITER ? 16 : 10;
        }
        return sz;
    }

    public static DataEntry.EntryListener getEntryListener() {
        return ENTRY_LISTENER;
    }

    static {
        for (Tag tag : Tag.values()) {
            if (!tag.isLower5Bits) continue;
            FastJavaBinDecoder.lower5BitTags[tag.code] = tag;
        }
        ENTRY_LISTENER = FastJavaBinDecoder::addObj;
    }

    public static enum Tag {
        _NULL(0, true, DataEntry.Type.NULL),
        _BOOL_TRUE(1, true, DataEntry.Type.BOOL){

            @Override
            public void lazyRead(EntryImpl entry, StreamCodec streamCodec) {
                entry.boolVal = true;
            }

            @Override
            public Object readObject(StreamCodec codec, EntryImpl entry) {
                return Boolean.TRUE;
            }
        }
        ,
        _BOOL_FALSE(2, true, DataEntry.Type.BOOL){

            @Override
            public void lazyRead(EntryImpl entry, StreamCodec streamCodec) {
                entry.boolVal = false;
            }

            @Override
            public Object readObject(StreamCodec codec, EntryImpl entry) {
                return Boolean.FALSE;
            }
        }
        ,
        _BYTE(3, true, DataEntry.Type.INT){

            @Override
            public void lazyRead(EntryImpl entry, StreamCodec streamCodec) throws IOException {
                entry.numericVal = streamCodec.dis.readByte();
                entry.consumedFully = true;
            }

            @Override
            public Object readObject(StreamCodec codec, EntryImpl entry) {
                return (byte)entry.numericVal;
            }
        }
        ,
        _SHORT(4, true, DataEntry.Type.INT){

            @Override
            public void lazyRead(EntryImpl entry, StreamCodec streamCodec) throws IOException {
                entry.numericVal = streamCodec.dis.readShort();
                entry.consumedFully = true;
            }

            @Override
            public Object readObject(StreamCodec codec, EntryImpl entry) {
                return (short)entry.numericVal;
            }
        }
        ,
        _DOUBLE(5, true, DataEntry.Type.DOUBLE){

            @Override
            public void lazyRead(EntryImpl entry, StreamCodec streamCodec) throws IOException {
                entry.doubleVal = streamCodec.dis.readDouble();
                entry.consumedFully = true;
            }

            @Override
            public Object readObject(StreamCodec codec, EntryImpl entry) {
                return entry.doubleVal;
            }
        }
        ,
        _INT(6, true, DataEntry.Type.INT){

            @Override
            public void lazyRead(EntryImpl entry, StreamCodec streamCodec) throws IOException {
                entry.numericVal = streamCodec.dis.readInt();
            }

            @Override
            public Object readObject(StreamCodec codec, EntryImpl entry) {
                return (int)entry.numericVal;
            }
        }
        ,
        _LONG(7, true, DataEntry.Type.LONG){

            @Override
            public void lazyRead(EntryImpl entry, StreamCodec streamCodec) throws IOException {
                entry.numericVal = streamCodec.dis.readLong();
            }

            @Override
            public Object readObject(StreamCodec codec, EntryImpl entry) {
                return entry.numericVal;
            }
        }
        ,
        _FLOAT(8, true, DataEntry.Type.FLOAT){

            @Override
            public void lazyRead(EntryImpl entry, StreamCodec streamCodec) throws IOException {
                entry.doubleVal = streamCodec.dis.readFloat();
            }

            @Override
            public Object readObject(StreamCodec codec, EntryImpl entry) {
                return Float.valueOf((float)entry.doubleVal);
            }
        }
        ,
        _DATE(9, true, DataEntry.Type.DATE){

            @Override
            public void lazyRead(EntryImpl entry, StreamCodec streamCodec) throws IOException {
                entry.numericVal = streamCodec.dis.readLong();
            }

            @Override
            public Object readObject(StreamCodec codec, EntryImpl entry) {
                return new Date(entry.numericVal);
            }
        }
        ,
        _MAP(10, true, DataEntry.Type.KEYVAL_ITER){

            @Override
            public void lazyRead(EntryImpl entry, StreamCodec codec) throws IOException {
                entry.size = Tag.readObjSz(codec, entry.tag);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stream(EntryImpl entry, StreamCodec codec) throws IOException {
                try {
                    for (int i = 0; i < entry.size; ++i) {
                        CharSequence key = codec.readObjKey(codec.getTag());
                        Tag.callbackMapEntryListener(entry, key, codec, i);
                    }
                }
                finally {
                    entry.callEnd();
                }
            }

            @Override
            public Object readObject(StreamCodec codec, EntryImpl entry) throws IOException {
                return codec.readMap(codec.dis, entry.size);
            }
        }
        ,
        _SOLRDOC(11, true, DataEntry.Type.KEYVAL_ITER){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stream(EntryImpl entry, StreamCodec codec) throws IOException {
                try {
                    codec.getTag();
                    entry.size = codec.readSize(codec.dis);
                    for (int i = 0; i < entry.size; ++i) {
                        Tag tag = codec.getTag();
                        if (tag == _SOLRDOC) {
                            EntryImpl e = entry.getChildAndReset();
                            e.tag = tag;
                            e.idx = i;
                            Tag.callbackIterListener(entry, e, codec);
                            continue;
                        }
                        CharSequence key = codec.readObjKey(tag);
                        Tag.callbackMapEntryListener(entry, key, codec, i);
                    }
                }
                finally {
                    entry.callEnd();
                }
            }

            @Override
            public Object readObject(StreamCodec codec, EntryImpl entry) throws IOException {
                return codec.readSolrDocument(codec.dis);
            }
        }
        ,
        _SOLRDOCLST(12, true, DataEntry.Type.ENTRY_ITER){

            @Override
            public void lazyRead(EntryImpl entry, StreamCodec codec) throws IOException {
                entry.metadata = codec.readVal(codec.dis);
                codec.getTag();
                entry.size = codec.readSize(codec.dis);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stream(EntryImpl entry, StreamCodec codec) throws IOException {
                try {
                    for (int i = 0; i < entry.size; ++i) {
                        EntryImpl newEntry = codec.beginRead(entry);
                        newEntry.idx = i;
                        Tag.callbackIterListener(entry, newEntry, codec);
                    }
                }
                finally {
                    entry.callEnd();
                }
            }

            @Override
            public Object readObject(StreamCodec codec, EntryImpl entry) throws IOException {
                SolrDocumentList solrDocs = new SolrDocumentList();
                if (entry.metadata != null) {
                    List list = (List)entry.metadata;
                    solrDocs.setNumFound((Long)list.get(0));
                    solrDocs.setStart((Long)list.get(1));
                    solrDocs.setMaxScore((Float)list.get(2));
                    if (list.size() > 3) {
                        solrDocs.setNumFoundExact((Boolean)list.get(3));
                    }
                }
                List l = codec.readArray(codec.dis, entry.size);
                solrDocs.addAll(l);
                return solrDocs;
            }
        }
        ,
        _BYTEARR(13, true, DataEntry.Type.BYTEARR){

            @Override
            public void lazyRead(EntryImpl entry, StreamCodec codec) throws IOException {
                entry.size = JavaBinCodec.readVInt(codec.dis);
            }

            @Override
            public Object readObject(StreamCodec codec, EntryImpl entry) throws IOException {
                ByteBuffer buf = codec.readByteBuffer(codec.dis, entry.size);
                entry.size = buf.limit() - buf.position();
                return buf;
            }

            @Override
            public void skip(EntryImpl entry, StreamCodec codec) throws IOException {
                codec.skip(entry.size);
            }
        }
        ,
        _ITERATOR(14, true, DataEntry.Type.ENTRY_ITER){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stream(EntryImpl entry, StreamCodec codec) throws IOException {
                try {
                    long idx = 0L;
                    while (true) {
                        EntryImpl newEntry = codec.beginRead(entry);
                        ++idx;
                        newEntry.idx = newEntry.idx;
                        if (newEntry.tag == _END) {
                            break;
                        }
                        ++idx;
                        newEntry.idx = newEntry.idx;
                        Tag.callbackIterListener(entry, newEntry, codec);
                    }
                }
                finally {
                    entry.callEnd();
                }
            }

            @Override
            public Object readObject(StreamCodec codec, EntryImpl entry) throws IOException {
                return codec.readIterator(codec.dis);
            }
        }
        ,
        _END(15, true, null),
        _SOLRINPUTDOC(16, true, DataEntry.Type.JAVA_OBJ){

            @Override
            public void lazyRead(EntryImpl entry, StreamCodec codec) throws IOException {
                entry.objVal = this.readObject(codec, entry);
                entry.consumedFully = true;
            }
        }
        ,
        _MAP_ENTRY_ITER(17, true, DataEntry.Type.KEYVAL_ITER){

            @Override
            public void stream(EntryImpl entry, StreamCodec codec) throws IOException {
                Tag tag;
                long idx = 0L;
                while ((tag = codec.getTag()) != _END) {
                    CharSequence key = codec.readObjKey(tag);
                    Tag.callbackMapEntryListener(entry, key, codec, idx++);
                }
            }

            @Override
            public Object readObject(StreamCodec codec, EntryImpl entry) throws IOException {
                return codec.readMapIter(codec.dis);
            }
        }
        ,
        _ENUM_FIELD_VALUE(18, true, DataEntry.Type.JAVA_OBJ){

            @Override
            public void lazyRead(EntryImpl entry, StreamCodec codec) throws IOException {
                entry.objVal = codec.readEnumFieldValue(codec.dis);
                entry.consumedFully = true;
            }
        }
        ,
        _MAP_ENTRY(19, true, DataEntry.Type.JAVA_OBJ){

            @Override
            public void lazyRead(EntryImpl entry, StreamCodec codec) throws IOException {
                entry.objVal = codec.readMapEntry(codec.dis);
                entry.consumedFully = true;
            }
        }
        ,
        _TAG_AND_LEN(32, false, null),
        _STR(32, false, DataEntry.Type.STR){

            @Override
            public void lazyRead(EntryImpl entry, StreamCodec codec) throws IOException {
                entry.size = Tag.readObjSz(codec, this);
            }

            @Override
            public Object readObject(StreamCodec codec, EntryImpl entry) throws IOException {
                return codec.readUtf8(codec.dis);
            }

            @Override
            public void skip(EntryImpl entry, StreamCodec codec) throws IOException {
                codec.skip(entry.size);
            }
        }
        ,
        _SINT(64, false, DataEntry.Type.INT){

            @Override
            public void lazyRead(EntryImpl entry, StreamCodec codec) throws IOException {
                entry.numericVal = codec.readSmallInt(codec.dis);
            }

            @Override
            public Object readObject(StreamCodec codec, EntryImpl entry) {
                return (int)entry.numericVal;
            }
        }
        ,
        _SLONG(96, false, DataEntry.Type.LONG){

            @Override
            public void lazyRead(EntryImpl entry, StreamCodec codec) throws IOException {
                entry.numericVal = codec.readSmallLong(codec.dis);
            }

            @Override
            public Object readObject(StreamCodec codec, EntryImpl entry) {
                return entry.numericVal;
            }
        }
        ,
        _ARR(-128, false, DataEntry.Type.ENTRY_ITER){

            @Override
            public void lazyRead(EntryImpl entry, StreamCodec codec) throws IOException {
                entry.size = Tag.readObjSz(codec, this);
            }

            @Override
            public void stream(EntryImpl entry, StreamCodec codec) throws IOException {
                for (int i = 0; i < entry.size; ++i) {
                    EntryImpl newEntry = codec.beginRead(entry);
                    newEntry.idx = i;
                    Tag.callbackIterListener(entry, newEntry, codec);
                }
            }

            @Override
            public Object readObject(StreamCodec codec, EntryImpl entry) throws IOException {
                return codec.readArray(codec.dis);
            }
        }
        ,
        _ORDERED_MAP(-96, false, DataEntry.Type.KEYVAL_ITER){

            @Override
            public void lazyRead(EntryImpl entry, StreamCodec codec) throws IOException {
                entry.size = Tag.readObjSz(codec, entry.tag);
            }

            @Override
            public void stream(EntryImpl entry, StreamCodec codec) throws IOException {
                _MAP.stream(entry, codec);
            }

            @Override
            public Object readObject(StreamCodec codec, EntryImpl entry) throws IOException {
                return codec.readOrderedMap(codec.dis);
            }
        }
        ,
        _NAMED_LST(-64, false, DataEntry.Type.KEYVAL_ITER){

            @Override
            public void lazyRead(EntryImpl entry, StreamCodec codec) throws IOException {
                entry.size = Tag.readObjSz(codec, entry.tag);
            }

            @Override
            public void stream(EntryImpl entry, StreamCodec codec) throws IOException {
                _MAP.stream(entry, codec);
            }

            @Override
            public Object readObject(StreamCodec codec, EntryImpl entry) throws IOException {
                return codec.readNamedList(codec.dis);
            }
        }
        ,
        _EXTERN_STRING(-32, false, DataEntry.Type.STR){

            @Override
            public Object readObject(StreamCodec codec, EntryImpl entry) throws IOException {
                return codec.readExternString(codec.dis);
            }
        };

        final int code;
        final boolean isLower5Bits;
        final DataEntry.Type type;

        private static int readObjSz(StreamCodec codec, Tag tag) throws IOException {
            return tag.isLower5Bits ? StreamCodec.readVInt(codec.dis) : codec.readSize(codec.dis);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void callbackMapEntryListener(EntryImpl entry, CharSequence key, StreamCodec codec, long idx) throws IOException {
            EntryImpl newEntry = codec.beginRead(entry);
            newEntry.name = key;
            newEntry.mapEntry = true;
            newEntry.idx = idx;
            try {
                if (entry.entryListener != null) {
                    entry.entryListener.entry(newEntry);
                }
            }
            finally {
                Tag.postCallback(codec, newEntry);
            }
        }

        private static void callbackIterListener(EntryImpl parent, EntryImpl newEntry, StreamCodec codec) throws IOException {
            try {
                newEntry.mapEntry = false;
                if (parent.entryListener != null) {
                    parent.entryListener.entry(newEntry);
                }
            }
            finally {
                Tag.postCallback(codec, newEntry);
            }
        }

        private static void postCallback(StreamCodec codec, EntryImpl newEntry) throws IOException {
            if (!newEntry.consumedFully) {
                if (newEntry.tag.type.isContainer) {
                    if (newEntry.entryListener == null) {
                        newEntry.entryListener = emptylistener;
                    }
                    newEntry.tag.stream(newEntry, codec);
                } else {
                    newEntry.tag.skip(newEntry, codec);
                }
            }
        }

        private Tag(int code, boolean isLower5Bits, DataEntry.Type type) {
            this.code = code;
            this.isLower5Bits = isLower5Bits;
            this.type = type;
        }

        public void stream(EntryImpl currentEntry, StreamCodec codec) throws IOException {
        }

        public void lazyRead(EntryImpl entry, StreamCodec codec) throws IOException {
        }

        public Object readObject(StreamCodec codec, EntryImpl entry) throws IOException {
            throw new RuntimeException("Unsupported object : " + this.name());
        }

        public void skip(EntryImpl entry, StreamCodec codec) throws IOException {
            if (entry.tag.type == DataEntry.Type.KEYVAL_ITER || entry.tag.type == DataEntry.Type.ENTRY_ITER) {
                entry.entryListener = null;
                this.stream(entry, codec);
            } else if (!entry.tag.type.isPrimitive) {
                this.readObject(codec, entry);
            }
        }
    }

    public class EntryImpl
    implements DataEntry {
        int size = -1;
        Tag tag;
        Object metadata;
        EntryImpl parent;
        EntryImpl child;
        long numericVal;
        double doubleVal;
        Object objVal;
        public Object ctx;
        boolean boolVal;
        boolean mapEntry;
        long idx;
        DataEntry.EntryListener entryListener;
        boolean consumedFully = false;
        int depth = 0;
        CharSequence name;

        EntryImpl getChildAndReset() {
            if (this.child == null) {
                this.child = new EntryImpl();
                this.child.parent = this;
                this.child.depth = this.depth + 1;
            }
            this.child.reset();
            return this.child;
        }

        @Override
        public long index() {
            return this.idx;
        }

        @Override
        public int length() {
            return this.size;
        }

        public Tag getTag() {
            return this.tag;
        }

        @Override
        public boolean boolVal() {
            return this.boolVal;
        }

        @Override
        public boolean isKeyValEntry() {
            return this.mapEntry;
        }

        @Override
        public CharSequence name() {
            return this.name;
        }

        @Override
        public int depth() {
            return this.depth;
        }

        @Override
        public DataEntry parent() {
            return this.parent;
        }

        @Override
        public Object metadata() {
            return this.metadata;
        }

        @Override
        public Object ctx() {
            return this.parent == null ? null : this.parent.ctx;
        }

        @Override
        public DataEntry.Type type() {
            return this.tag.type;
        }

        @Override
        public int intVal() {
            return (int)this.numericVal;
        }

        @Override
        public long longVal() {
            return this.numericVal;
        }

        @Override
        public float floatVal() {
            if (this.tag.type == DataEntry.Type.FLOAT) {
                return (float)this.doubleVal;
            }
            return ((Number)this.val()).floatValue();
        }

        @Override
        public double doubleVal() {
            return this.doubleVal;
        }

        @Override
        public Object val() {
            if (this.objVal != null) {
                return this.objVal;
            }
            try {
                Object object = this.objVal = this.tag.readObject(FastJavaBinDecoder.this.codec, this);
                return object;
            }
            catch (IOException e) {
                throw new RuntimeException("Error with stream", e);
            }
            finally {
                this.consumedFully = true;
            }
        }

        @Override
        public void listenContainer(Object ctx, DataEntry.EntryListener listener) {
            this.entryListener = listener;
            this.ctx = ctx;
        }

        void reset() {
            this.doubleVal = 0.0;
            this.numericVal = 0L;
            this.objVal = null;
            this.ctx = null;
            this.entryListener = null;
            this.size = -1;
            this.tag = null;
            this.consumedFully = false;
            this.metadata = null;
            this.name = null;
            this.idx = -1L;
        }

        public void callEnd() {
            if (this.entryListener != null) {
                this.entryListener.end(this);
            }
        }
    }

    static class StreamCodec
    extends JavaBinCodec {
        final FastInputStream dis;

        StreamCodec(InputStream is) {
            this.dis = FastInputStream.wrap(is);
        }

        public void skip(int sz) throws IOException {
            while (sz > 0) {
                int read = this.dis.read(this.bytes, 0, Math.min(this.bytes.length, sz));
                sz -= read;
            }
        }

        void start() throws IOException {
            this._init(this.dis);
        }

        Tag getTag() throws IOException {
            this.tagByte = this.dis.readByte();
            switch (this.tagByte >>> 5) {
                case 1: {
                    return Tag._STR;
                }
                case 2: {
                    return Tag._SINT;
                }
                case 3: {
                    return Tag._SLONG;
                }
                case 0x7FFFFFC: {
                    return Tag._ARR;
                }
                case 0x7FFFFFD: {
                    return Tag._ORDERED_MAP;
                }
                case 0x7FFFFFE: {
                    return Tag._NAMED_LST;
                }
                case 0x7FFFFFF: {
                    return Tag._EXTERN_STRING;
                }
            }
            Tag t = lower5BitTags[this.tagByte];
            if (t == null) {
                throw new RuntimeException("Invalid type " + this.tagByte);
            }
            return t;
        }

        public ByteBuffer readByteBuffer(DataInputInputStream dis, int sz) throws IOException {
            ByteBuffer result = dis.readDirectByteBuffer(sz);
            if (result != null) {
                return result;
            }
            byte[] arr = new byte[StreamCodec.readVInt(dis)];
            dis.readFully(arr);
            return ByteBuffer.wrap(arr);
        }

        public CharSequence readObjKey(Tag ktag) throws IOException {
            CharSequence key = null;
            if (ktag.type == DataEntry.Type.STR) {
                key = ktag == Tag._EXTERN_STRING ? this.readExternString(this.dis) : this.readStr(this.dis);
            } else if (ktag.type != DataEntry.Type.NULL) {
                throw new RuntimeException("Key must be String");
            }
            return key;
        }

        public EntryImpl beginRead(EntryImpl parent) throws IOException {
            EntryImpl entry = parent.getChildAndReset();
            entry.tag = this.getTag();
            entry.tag.lazyRead(entry, this);
            if (entry.tag.type.isPrimitive) {
                entry.consumedFully = true;
            }
            return entry;
        }
    }
}

