/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.firefox;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.firefox.FirefoxBinary;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.firefox.GeckoDriverService;
import org.openqa.selenium.firefox.XpiDriverService;
import org.openqa.selenium.html5.LocalStorage;
import org.openqa.selenium.html5.SessionStorage;
import org.openqa.selenium.html5.WebStorage;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.FileDetector;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.html5.RemoteWebStorage;
import org.openqa.selenium.remote.service.DriverCommandExecutor;
import org.openqa.selenium.remote.service.DriverService;

public class FirefoxDriver
extends RemoteWebDriver
implements WebStorage {
    public static final String BINARY = "firefox_binary";
    public static final String PROFILE = "firefox_profile";
    public static final String MARIONETTE = "marionette";
    protected FirefoxBinary binary;
    private RemoteWebStorage webStorage = new RemoteWebStorage(this.getExecuteMethod());

    public FirefoxDriver() {
        this(new FirefoxOptions());
    }

    @Deprecated
    public FirefoxDriver(Capabilities desiredCapabilities) {
        this(new FirefoxOptions(Objects.requireNonNull(desiredCapabilities, "No capabilities seen")));
    }

    @Deprecated
    public FirefoxDriver(GeckoDriverService service, Capabilities desiredCapabilities) {
        this(Objects.requireNonNull(service, "No geckodriver service provided"), new FirefoxOptions(desiredCapabilities));
    }

    public FirefoxDriver(FirefoxOptions options) {
        super(FirefoxDriver.toExecutor(options), FirefoxDriver.dropCapabilities((Capabilities)options));
    }

    public FirefoxDriver(GeckoDriverService service) {
        super((CommandExecutor)new DriverCommandExecutor((DriverService)service), (Capabilities)new FirefoxOptions());
    }

    public FirefoxDriver(XpiDriverService service) {
        super((CommandExecutor)new DriverCommandExecutor((DriverService)service), (Capabilities)new FirefoxOptions());
    }

    public FirefoxDriver(GeckoDriverService service, FirefoxOptions options) {
        super((CommandExecutor)new DriverCommandExecutor((DriverService)service), FirefoxDriver.dropCapabilities((Capabilities)options));
    }

    public FirefoxDriver(XpiDriverService service, FirefoxOptions options) {
        super((CommandExecutor)new DriverCommandExecutor((DriverService)service), FirefoxDriver.dropCapabilities((Capabilities)options));
    }

    private static CommandExecutor toExecutor(FirefoxOptions options) {
        DriverService.Builder builder;
        Objects.requireNonNull(options, "No options to construct executor from");
        if (!Boolean.parseBoolean(System.getProperty("webdriver.firefox.marionette", "true")) || options.isLegacy()) {
            FirefoxProfile profile = options.getProfile();
            if (profile == null) {
                profile = new FirefoxProfile();
                options.setCapability(PROFILE, profile);
            }
            builder = XpiDriverService.builder().withBinary(options.getBinary()).withProfile(profile);
        } else {
            builder = new GeckoDriverService.Builder().usingFirefoxBinary(options.getBinary());
        }
        return new DriverCommandExecutor(builder.build());
    }

    public void setFileDetector(FileDetector detector) {
        throw new WebDriverException("Setting the file detector only works on remote webdriver instances obtained via RemoteWebDriver");
    }

    public LocalStorage getLocalStorage() {
        return this.webStorage.getLocalStorage();
    }

    public SessionStorage getSessionStorage() {
        return this.webStorage.getSessionStorage();
    }

    private static boolean isLegacy(Capabilities desiredCapabilities) {
        Boolean forceMarionette = FirefoxDriver.forceMarionetteFromSystemProperty();
        if (forceMarionette != null) {
            return forceMarionette == false;
        }
        Object marionette = desiredCapabilities.getCapability(MARIONETTE);
        return marionette instanceof Boolean && (Boolean)marionette == false;
    }

    private static Boolean forceMarionetteFromSystemProperty() {
        String useMarionette = System.getProperty("webdriver.firefox.marionette");
        if (useMarionette == null) {
            return null;
        }
        return Boolean.valueOf(useMarionette);
    }

    private static Capabilities dropCapabilities(Capabilities capabilities) {
        MutableCapabilities caps;
        if (capabilities == null) {
            return new ImmutableCapabilities();
        }
        if (FirefoxDriver.isLegacy(capabilities)) {
            HashSet toRemove = Sets.newHashSet((Object[])new String[]{BINARY, PROFILE});
            caps = new MutableCapabilities(Maps.filterKeys((Map)capabilities.asMap(), key -> !toRemove.contains(key)));
        } else {
            caps = new MutableCapabilities(capabilities);
        }
        Proxy proxy = Proxy.extractFrom((Capabilities)capabilities);
        if (proxy != null) {
            caps.setCapability("proxy", (Object)proxy);
        }
        return caps;
    }

    public static final class SystemProperty {
        public static final String BROWSER_BINARY = "webdriver.firefox.bin";
        public static final String BROWSER_LOGFILE = "webdriver.firefox.logfile";
        public static final String BROWSER_LIBRARY_PATH = "webdriver.firefox.library.path";
        public static final String BROWSER_PROFILE = "webdriver.firefox.profile";
        public static final String DRIVER_XPI_PROPERTY = "webdriver.firefox.driver";
        public static final String DRIVER_USE_MARIONETTE = "webdriver.firefox.marionette";
    }
}

