/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.coverage;

import javax.measure.Unit;
import org.apache.sis.measure.MeasurementRange;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.measure.Range;

final class ConvertedRange
extends MeasurementRange<Double> {
    private static final long serialVersionUID = -1416908614729956928L;
    private final double altMinimum;
    private final double altMaximum;

    ConvertedRange(double[] dArray, boolean bl, boolean bl2, Unit<?> unit) {
        super(Double.class, dArray[0], bl, dArray[1], bl2, unit);
        this.altMinimum = dArray[2];
        this.altMaximum = dArray[3];
    }

    private ConvertedRange(NumberRange<Double> numberRange, ConvertedRange convertedRange, NumberRange<Double> numberRange2) {
        super(numberRange, convertedRange.unit());
        boolean bl = !this.isMinIncluded();
        this.altMinimum = Math.min(convertedRange.getMinDouble(bl), numberRange2.getMinDouble(bl));
        bl = !this.isMaxIncluded();
        this.altMaximum = Math.max(convertedRange.getMaxDouble(bl), numberRange2.getMaxDouble(bl));
    }

    @Override
    public Range<Double> union(Range<Double> range) {
        ConvertedRange convertedRange = super.union(range);
        if (convertedRange != this && convertedRange != range && convertedRange instanceof NumberRange && range instanceof NumberRange) {
            convertedRange = new ConvertedRange(convertedRange, this, (NumberRange)range);
        }
        return convertedRange;
    }

    @Override
    public double getMinDouble(boolean bl) {
        return bl == this.isMinIncluded() ? this.getMinDouble() : this.altMinimum;
    }

    @Override
    public double getMaxDouble(boolean bl) {
        return bl == this.isMaxIncluded() ? this.getMaxDouble() : this.altMaximum;
    }
}

