/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.extent;

import java.util.Date;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.geoapi.temporal.Instant;
import org.apache.sis.internal.geoapi.temporal.Period;
import org.apache.sis.internal.metadata.ReferencingServices;
import org.apache.sis.internal.util.TemporalUtilities;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.apache.sis.metadata.iso.extent.DefaultSpatialTemporalExtent;
import org.apache.sis.xml.NilObject;
import org.apache.sis.xml.NilReason;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.extent.SpatialTemporalExtent;
import org.opengis.metadata.extent.TemporalExtent;
import org.opengis.referencing.operation.TransformException;
import org.opengis.temporal.TemporalPrimitive;

@XmlType(name="EX_TemporalExtent_Type")
@XmlRootElement(name="EX_TemporalExtent")
@XmlSeeAlso(value={DefaultSpatialTemporalExtent.class})
public class DefaultTemporalExtent
extends ISOMetadata
implements TemporalExtent {
    private static final long serialVersionUID = -6149873501105795242L;
    private TemporalPrimitive extent;

    public DefaultTemporalExtent() {
    }

    public DefaultTemporalExtent(TemporalExtent temporalExtent) {
        super(temporalExtent);
        if (temporalExtent != null) {
            this.extent = temporalExtent.getExtent();
        }
    }

    public static DefaultTemporalExtent castOrCopy(TemporalExtent temporalExtent) {
        if (temporalExtent instanceof SpatialTemporalExtent) {
            return DefaultSpatialTemporalExtent.castOrCopy((SpatialTemporalExtent)temporalExtent);
        }
        if (temporalExtent == null || temporalExtent instanceof DefaultTemporalExtent) {
            return (DefaultTemporalExtent)temporalExtent;
        }
        return new DefaultTemporalExtent(temporalExtent);
    }

    @XmlElement(name="extent", required=true)
    public TemporalPrimitive getExtent() {
        return this.extent;
    }

    public void setExtent(TemporalPrimitive temporalPrimitive) {
        this.checkWritePermission(this.extent);
        this.extent = temporalPrimitive;
    }

    static Date getTime(TemporalPrimitive temporalPrimitive, boolean bl) {
        Instant instant;
        if (temporalPrimitive instanceof Instant) {
            instant = (Instant)temporalPrimitive;
        } else if (temporalPrimitive instanceof Period) {
            instant = bl ? ((Period)temporalPrimitive).getBeginning() : ((Period)temporalPrimitive).getEnding();
        } else {
            return null;
        }
        return instant.getDate();
    }

    public Date getStartTime() {
        return DefaultTemporalExtent.getTime(this.extent, true);
    }

    public Date getEndTime() {
        return DefaultTemporalExtent.getTime(this.extent, false);
    }

    public void setBounds(Date date, Date date2) throws UnsupportedOperationException {
        Object object = null;
        if (date != null || date2 != null) {
            object = date2 == null || date2.equals(date) ? TemporalUtilities.createInstant(date) : (date == null ? TemporalUtilities.createInstant(date2) : TemporalUtilities.createPeriod(date, date2));
        }
        this.setExtent((TemporalPrimitive)object);
    }

    public void setBounds(Envelope envelope) throws TransformException {
        this.checkWritePermission(this.extent);
        ReferencingServices.getInstance().setBounds(envelope, this);
    }

    public void intersect(TemporalExtent temporalExtent) {
        this.checkWritePermission(this.extent);
        TemporalPrimitive temporalPrimitive = temporalExtent.getExtent();
        if (temporalPrimitive != null && !(this.extent instanceof NilObject)) {
            if (this.extent == null || temporalPrimitive instanceof NilObject) {
                this.extent = temporalPrimitive;
            } else {
                Date date = DefaultTemporalExtent.getTime(this.extent, true);
                Date date2 = DefaultTemporalExtent.getTime(this.extent, false);
                Date date3 = DefaultTemporalExtent.getTime(temporalPrimitive, true);
                Date date4 = DefaultTemporalExtent.getTime(temporalPrimitive, false);
                boolean bl = false;
                if (date3 != null && (date == null || date3.after(date))) {
                    date = date3;
                    bl = true;
                }
                if (date4 != null && (date2 == null || date4.before(date2))) {
                    date2 = date4;
                    bl = true;
                }
                if (bl) {
                    if (date != null && date2 != null && date.after(date2)) {
                        this.extent = NilReason.MISSING.createNilObject(TemporalPrimitive.class);
                    } else {
                        this.setBounds(date, date2);
                    }
                }
            }
        }
    }
}

