/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations;

import java.util.List;
import org.elasticsearch.cache.recycler.CacheRecycler;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.search.aggregations.Aggregation;

public abstract class InternalAggregation
implements Aggregation,
ToXContent,
Streamable {
    protected String name;

    protected InternalAggregation() {
    }

    protected InternalAggregation(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public abstract Type type();

    public abstract InternalAggregation reduce(ReduceContext var1);

    public static final class CommonFields {
        public static final XContentBuilderString BUCKETS = new XContentBuilderString("buckets");
        public static final XContentBuilderString VALUE = new XContentBuilderString("value");
        public static final XContentBuilderString VALUE_AS_STRING = new XContentBuilderString("value_as_string");
        public static final XContentBuilderString DOC_COUNT = new XContentBuilderString("doc_count");
        public static final XContentBuilderString KEY = new XContentBuilderString("key");
        public static final XContentBuilderString KEY_AS_STRING = new XContentBuilderString("key_as_string");
        public static final XContentBuilderString FROM = new XContentBuilderString("from");
        public static final XContentBuilderString FROM_AS_STRING = new XContentBuilderString("from_as_string");
        public static final XContentBuilderString TO = new XContentBuilderString("to");
        public static final XContentBuilderString TO_AS_STRING = new XContentBuilderString("to_as_string");
    }

    protected static class ReduceContext {
        private final List<InternalAggregation> aggregations;
        private final CacheRecycler cacheRecycler;

        public ReduceContext(List<InternalAggregation> aggregations, CacheRecycler cacheRecycler) {
            this.aggregations = aggregations;
            this.cacheRecycler = cacheRecycler;
        }

        public List<InternalAggregation> aggregations() {
            return this.aggregations;
        }

        public CacheRecycler cacheRecycler() {
            return this.cacheRecycler;
        }
    }

    public static class Type {
        private String name;
        private BytesReference stream;

        public Type(String name) {
            this(name, new BytesArray(name));
        }

        public Type(String name, String stream) {
            this(name, new BytesArray(stream));
        }

        public Type(String name, BytesReference stream) {
            this.name = name;
            this.stream = stream;
        }

        public String name() {
            return this.name;
        }

        public BytesReference stream() {
            return this.stream;
        }
    }
}

