/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.impl;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.http.client.HttpClient;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.BinaryResponseParser;
import org.apache.solr.client.solrj.impl.HttpClientUtil;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.request.IsUpdateRequest;
import org.apache.solr.client.solrj.request.RequestWriter;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SolrjNamedThreadFactory;

public class LBHttpSolrClient
extends SolrClient {
    private static Set<Integer> RETRY_CODES = new HashSet<Integer>(4);
    private final Map<String, ServerWrapper> aliveServers = new LinkedHashMap<String, ServerWrapper>();
    protected final Map<String, ServerWrapper> zombieServers = new ConcurrentHashMap<String, ServerWrapper>();
    private volatile ServerWrapper[] aliveServerList = new ServerWrapper[0];
    private ScheduledExecutorService aliveCheckExecutor;
    private final HttpClient httpClient;
    private final boolean clientIsInternal;
    private final AtomicInteger counter = new AtomicInteger(-1);
    private static final SolrQuery solrQuery;
    private volatile ResponseParser parser;
    private volatile RequestWriter requestWriter;
    private Set<String> queryParams = new HashSet<String>();
    private int interval = 60000;
    private static final int CHECK_INTERVAL = 60000;
    private static final int NONSTANDARD_PING_LIMIT = 5;

    public LBHttpSolrClient(String ... solrServerUrls) throws MalformedURLException {
        this((HttpClient)null, solrServerUrls);
    }

    public LBHttpSolrClient(HttpClient httpClient, String ... solrServerUrl) {
        this(httpClient, new BinaryResponseParser(), solrServerUrl);
    }

    public LBHttpSolrClient(HttpClient httpClient, ResponseParser parser, String ... solrServerUrl) {
        this.clientIsInternal = httpClient == null;
        this.parser = parser;
        if (httpClient == null) {
            ModifiableSolrParams params = new ModifiableSolrParams();
            if (solrServerUrl.length > 1) {
                params.set("retry", false);
            } else {
                params.set("retry", true);
            }
            this.httpClient = HttpClientUtil.createClient(params);
        } else {
            this.httpClient = httpClient;
        }
        for (String s : solrServerUrl) {
            ServerWrapper wrapper = new ServerWrapper(this.makeSolrClient(s));
            this.aliveServers.put(wrapper.getKey(), wrapper);
        }
        this.updateAliveList();
    }

    public Set<String> getQueryParams() {
        return this.queryParams;
    }

    public void setQueryParams(Set<String> queryParams) {
        this.queryParams = queryParams;
    }

    public void addQueryParams(String queryOnlyParam) {
        this.queryParams.add(queryOnlyParam);
    }

    public static String normalize(String server) {
        if (server.endsWith("/")) {
            server = server.substring(0, server.length() - 1);
        }
        return server;
    }

    protected HttpSolrClient makeSolrClient(String server) {
        HttpSolrClient client = new HttpSolrClient(server, this.httpClient, this.parser);
        if (this.requestWriter != null) {
            client.setRequestWriter(this.requestWriter);
        }
        if (this.queryParams != null) {
            client.setQueryParams(this.queryParams);
        }
        return client;
    }

    public Rsp request(Req req) throws SolrServerException, IOException {
        Rsp rsp = new Rsp();
        Exception ex = null;
        boolean isUpdate = req.request instanceof IsUpdateRequest;
        ArrayList<ServerWrapper> skipped = null;
        long timeAllowedNano = this.getTimeAllowedInNanos(req.getRequest());
        long timeOutTime = System.nanoTime() + timeAllowedNano;
        for (String serverStr : req.getServers()) {
            if (this.isTimeExceeded(timeAllowedNano, timeOutTime)) break;
            ServerWrapper wrapper = this.zombieServers.get(serverStr = LBHttpSolrClient.normalize(serverStr));
            if (wrapper != null) {
                int numDeadServersToTry = req.getNumDeadServersToTry();
                if (numDeadServersToTry <= 0) continue;
                if (skipped == null) {
                    skipped = new ArrayList<ServerWrapper>(numDeadServersToTry);
                    skipped.add(wrapper);
                    continue;
                }
                if (skipped.size() >= numDeadServersToTry) continue;
                skipped.add(wrapper);
                continue;
            }
            rsp.server = serverStr;
            HttpSolrClient client = this.makeSolrClient(serverStr);
            ex = this.doRequest(client, req, rsp, isUpdate, false, null);
            if (ex != null) continue;
            return rsp;
        }
        if (skipped != null) {
            for (ServerWrapper wrapper : skipped) {
                if (this.isTimeExceeded(timeAllowedNano, timeOutTime)) break;
                ex = this.doRequest(wrapper.client, req, rsp, isUpdate, true, wrapper.getKey());
                if (ex != null) continue;
                return rsp;
            }
        }
        if (ex == null) {
            throw new SolrServerException("No live SolrServers available to handle this request");
        }
        throw new SolrServerException("No live SolrServers available to handle this request:" + this.zombieServers.keySet(), ex);
    }

    protected Exception addZombie(HttpSolrClient server, Exception e) {
        ServerWrapper wrapper = new ServerWrapper(server);
        wrapper.lastUsed = System.currentTimeMillis();
        wrapper.standard = false;
        this.zombieServers.put(wrapper.getKey(), wrapper);
        this.startAliveCheckExecutor();
        return e;
    }

    protected Exception doRequest(HttpSolrClient client, Req req, Rsp rsp, boolean isUpdate, boolean isZombie, String zombieKey) throws SolrServerException, IOException {
        Exception ex = null;
        try {
            rsp.rsp = client.request(req.getRequest(), (String)null);
            if (isZombie) {
                this.zombieServers.remove(zombieKey);
            }
        }
        catch (SolrException e) {
            if (!isUpdate && RETRY_CODES.contains(e.code())) {
                ex = !isZombie ? this.addZombie(client, e) : e;
            }
            if (isZombie) {
                this.zombieServers.remove(zombieKey);
            }
            throw e;
        }
        catch (SocketException e) {
            if (!isUpdate || e instanceof ConnectException) {
                ex = !isZombie ? this.addZombie(client, e) : e;
            }
            throw e;
        }
        catch (SocketTimeoutException e) {
            if (!isUpdate) {
                ex = !isZombie ? this.addZombie(client, e) : e;
            }
            throw e;
        }
        catch (SolrServerException e) {
            Throwable rootCause = e.getRootCause();
            if (!isUpdate && rootCause instanceof IOException) {
                ex = !isZombie ? this.addZombie(client, e) : e;
            }
            if (isUpdate && rootCause instanceof ConnectException) {
                ex = !isZombie ? this.addZombie(client, e) : e;
            }
            throw e;
        }
        catch (Exception e) {
            throw new SolrServerException(e);
        }
        return ex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAliveList() {
        Map<String, ServerWrapper> map = this.aliveServers;
        synchronized (map) {
            this.aliveServerList = this.aliveServers.values().toArray(new ServerWrapper[this.aliveServers.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServerWrapper removeFromAlive(String key) {
        Map<String, ServerWrapper> map = this.aliveServers;
        synchronized (map) {
            ServerWrapper wrapper = this.aliveServers.remove(key);
            if (wrapper != null) {
                this.updateAliveList();
            }
            return wrapper;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToAlive(ServerWrapper wrapper) {
        Map<String, ServerWrapper> map = this.aliveServers;
        synchronized (map) {
            ServerWrapper prev = this.aliveServers.put(wrapper.getKey(), wrapper);
            this.updateAliveList();
        }
    }

    public void addSolrServer(String server) throws MalformedURLException {
        HttpSolrClient client = this.makeSolrClient(server);
        this.addToAlive(new ServerWrapper(client));
    }

    public String removeSolrServer(String server) {
        try {
            server = new URL(server).toExternalForm();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        if (server.endsWith("/")) {
            server = server.substring(0, server.length() - 1);
        }
        this.removeFromAlive(server);
        this.zombieServers.remove(server);
        return null;
    }

    public void setConnectionTimeout(int timeout) {
        HttpClientUtil.setConnectionTimeout(this.httpClient, timeout);
    }

    public void setSoTimeout(int timeout) {
        HttpClientUtil.setSoTimeout(this.httpClient, timeout);
    }

    @Override
    public void close() {
        this.shutdown();
    }

    @Override
    @Deprecated
    public void shutdown() {
        if (this.aliveCheckExecutor != null) {
            this.aliveCheckExecutor.shutdownNow();
        }
        if (this.clientIsInternal) {
            HttpClientUtil.close(this.httpClient);
        }
    }

    @Override
    public NamedList<Object> request(SolrRequest request, String collection) throws SolrServerException, IOException {
        SolrServerException ex = null;
        ServerWrapper[] serverList = this.aliveServerList;
        int maxTries = serverList.length;
        HashMap<String, ServerWrapper> justFailed = null;
        long timeAllowedNano = this.getTimeAllowedInNanos(request);
        long timeOutTime = System.nanoTime() + timeAllowedNano;
        for (int attempts = 0; attempts < maxTries && !this.isTimeExceeded(timeAllowedNano, timeOutTime); ++attempts) {
            int count = this.counter.incrementAndGet() & Integer.MAX_VALUE;
            ServerWrapper wrapper = serverList[count % serverList.length];
            wrapper.lastUsed = System.currentTimeMillis();
            try {
                return wrapper.client.request(request, collection);
            }
            catch (SolrException e) {
                throw e;
            }
            catch (SolrServerException e) {
                if (e.getRootCause() instanceof IOException) {
                    ex = e;
                    this.moveAliveToDead(wrapper);
                    if (justFailed == null) {
                        justFailed = new HashMap<String, ServerWrapper>();
                    }
                    justFailed.put(wrapper.getKey(), wrapper);
                    continue;
                }
                throw e;
            }
            catch (Exception e) {
                throw new SolrServerException(e);
            }
        }
        for (ServerWrapper wrapper : this.zombieServers.values()) {
            if (this.isTimeExceeded(timeAllowedNano, timeOutTime)) break;
            if (!wrapper.standard || justFailed != null && justFailed.containsKey(wrapper.getKey())) continue;
            try {
                NamedList<Object> rsp = wrapper.client.request(request, collection);
                this.zombieServers.remove(wrapper.getKey());
                this.addToAlive(wrapper);
                return rsp;
            }
            catch (SolrException e) {
                throw e;
            }
            catch (SolrServerException e) {
                if (e.getRootCause() instanceof IOException) {
                    ex = e;
                    continue;
                }
                throw e;
            }
            catch (Exception e) {
                throw new SolrServerException(e);
            }
        }
        if (ex == null) {
            throw new SolrServerException("No live SolrServers available to handle this request");
        }
        throw new SolrServerException("No live SolrServers available to handle this request", ex);
    }

    private long getTimeAllowedInNanos(SolrRequest req) {
        SolrParams reqParams = req.getParams();
        return reqParams == null ? -1L : TimeUnit.NANOSECONDS.convert(reqParams.getInt("timeAllowed", -1), TimeUnit.MILLISECONDS);
    }

    private boolean isTimeExceeded(long timeAllowedNano, long timeOutTime) {
        return timeAllowedNano > 0L && System.nanoTime() > timeOutTime;
    }

    private void checkAZombieServer(ServerWrapper zombieServer) {
        block4: {
            long currTime = System.currentTimeMillis();
            try {
                ServerWrapper wrapper;
                zombieServer.lastChecked = currTime;
                QueryResponse resp = zombieServer.client.query(solrQuery);
                if (resp.getStatus() == 0 && (wrapper = this.zombieServers.remove(zombieServer.getKey())) != null) {
                    wrapper.failedPings = 0;
                    if (wrapper.standard) {
                        this.addToAlive(wrapper);
                    }
                }
            }
            catch (Exception e) {
                ++zombieServer.failedPings;
                if (zombieServer.standard || zombieServer.failedPings < 5) break block4;
                this.zombieServers.remove(zombieServer.getKey());
            }
        }
    }

    private void moveAliveToDead(ServerWrapper wrapper) {
        if ((wrapper = this.removeFromAlive(wrapper.getKey())) == null) {
            return;
        }
        this.zombieServers.put(wrapper.getKey(), wrapper);
        this.startAliveCheckExecutor();
    }

    public void setAliveCheckInterval(int interval) {
        if (interval <= 0) {
            throw new IllegalArgumentException("Alive check interval must be positive, specified value = " + interval);
        }
        this.interval = interval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startAliveCheckExecutor() {
        if (this.aliveCheckExecutor == null) {
            LBHttpSolrClient lBHttpSolrClient = this;
            synchronized (lBHttpSolrClient) {
                if (this.aliveCheckExecutor == null) {
                    this.aliveCheckExecutor = Executors.newSingleThreadScheduledExecutor(new SolrjNamedThreadFactory("aliveCheckExecutor"));
                    this.aliveCheckExecutor.scheduleAtFixedRate(LBHttpSolrClient.getAliveCheckRunner(new WeakReference<LBHttpSolrClient>(this)), this.interval, this.interval, TimeUnit.MILLISECONDS);
                }
            }
        }
    }

    private static Runnable getAliveCheckRunner(final WeakReference<LBHttpSolrClient> lbRef) {
        return new Runnable(){

            @Override
            public void run() {
                LBHttpSolrClient lb = (LBHttpSolrClient)lbRef.get();
                if (lb != null && lb.zombieServers != null) {
                    for (ServerWrapper zombieServer : lb.zombieServers.values()) {
                        lb.checkAZombieServer(zombieServer);
                    }
                }
            }
        };
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public ResponseParser getParser() {
        return this.parser;
    }

    public void setParser(ResponseParser parser) {
        this.parser = parser;
    }

    public void setRequestWriter(RequestWriter requestWriter) {
        this.requestWriter = requestWriter;
    }

    public RequestWriter getRequestWriter() {
        return this.requestWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.aliveCheckExecutor != null) {
                this.aliveCheckExecutor.shutdownNow();
            }
        }
        finally {
            super.finalize();
        }
    }

    static {
        RETRY_CODES.add(404);
        RETRY_CODES.add(403);
        RETRY_CODES.add(503);
        RETRY_CODES.add(500);
        solrQuery = new SolrQuery("*:*");
        solrQuery.setRows(0);
        solrQuery.setSort("_docid_", SolrQuery.ORDER.asc);
        solrQuery.setDistrib(false);
    }

    public static class Rsp {
        protected String server;
        protected NamedList<Object> rsp;

        public NamedList<Object> getResponse() {
            return this.rsp;
        }

        public String getServer() {
            return this.server;
        }
    }

    public static class Req {
        protected SolrRequest request;
        protected List<String> servers;
        protected int numDeadServersToTry;

        public Req(SolrRequest request, List<String> servers) {
            this.request = request;
            this.servers = servers;
            this.numDeadServersToTry = servers.size();
        }

        public SolrRequest getRequest() {
            return this.request;
        }

        public List<String> getServers() {
            return this.servers;
        }

        public int getNumDeadServersToTry() {
            return this.numDeadServersToTry;
        }

        public void setNumDeadServersToTry(int numDeadServersToTry) {
            this.numDeadServersToTry = numDeadServersToTry;
        }
    }

    protected static class ServerWrapper {
        final HttpSolrClient client;
        long lastUsed;
        long lastChecked;
        boolean standard = true;
        int failedPings = 0;

        public ServerWrapper(HttpSolrClient client) {
            this.client = client;
        }

        public String toString() {
            return this.client.getBaseURL();
        }

        public String getKey() {
            return this.client.getBaseURL();
        }

        public int hashCode() {
            return this.getKey().hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ServerWrapper)) {
                return false;
            }
            return this.getKey().equals(((ServerWrapper)obj).getKey());
        }
    }
}

