/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.properties;

import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.fo.properties.Property;
import org.apache.fop.fo.properties.PropertyCache;
import org.apache.fop.fo.properties.PropertyMaker;

public final class EnumProperty
extends Property {
    private static final PropertyCache cache = new PropertyCache(EnumProperty.class);
    private final int value;
    private final String text;

    private EnumProperty(int explicitValue, String text) {
        this.value = explicitValue;
        this.text = text;
    }

    public static EnumProperty getInstance(int explicitValue, String text) {
        return (EnumProperty)cache.fetch(new EnumProperty(explicitValue, text));
    }

    public int getEnum() {
        return this.value;
    }

    public Object getObject() {
        return this.text;
    }

    public boolean equals(Object obj) {
        if (obj instanceof EnumProperty) {
            EnumProperty ep = (EnumProperty)obj;
            return ep.value == this.value && (ep.text == this.text || ep.text != null && ep.text.equals(this.text));
        }
        return false;
    }

    public int hashCode() {
        return this.value + this.text.hashCode();
    }

    public static class Maker
    extends PropertyMaker {
        public Maker(int propId) {
            super(propId);
        }

        public Property checkEnumValues(String value) {
            return super.checkEnumValues(value);
        }

        public Property convertProperty(Property p, PropertyList propertyList, FObj fo) throws PropertyException {
            if (p instanceof EnumProperty) {
                return p;
            }
            return super.convertProperty(p, propertyList, fo);
        }
    }
}

