/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.boxes.apple;

import com.coremedia.iso.IsoTypeReader;
import com.coremedia.iso.Utf8;
import com.googlecode.mp4parser.RequiresParseDetailAspect;
import com.googlecode.mp4parser.boxes.apple.AppleDataBox;
import java.nio.ByteBuffer;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class AppleRecordingYearBox
extends AppleDataBox {
    DateFormat df;
    Date date = new Date();
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    public AppleRecordingYearBox() {
        super("\u00a9day", 1);
        this.df = new SimpleDateFormat("yyyy-MM-dd'T'kk:mm:ssZ");
        this.df.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    public Date getDate() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return this.date;
    }

    public void setDate(Date date) {
        Date date2 = date;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)date2);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        this.date = date;
    }

    protected byte[] writeData() {
        return Utf8.convert(AppleRecordingYearBox.rfc822toIso8601Date(this.df.format(this.date)));
    }

    protected void parseData(ByteBuffer data) {
        String dateString = IsoTypeReader.readString(data, data.remaining());
        try {
            this.date = this.df.parse(AppleRecordingYearBox.iso8601toRfc822Date(dateString));
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    protected static String iso8601toRfc822Date(String iso8601) {
        iso8601 = iso8601.replaceAll("Z$", "+0000");
        iso8601 = iso8601.replaceAll("([0-9][0-9]):([0-9][0-9])$", "$1$2");
        return iso8601;
    }

    protected static String rfc822toIso8601Date(String rfc622) {
        rfc622 = rfc622.replaceAll("\\+0000$", "Z");
        return rfc622;
    }

    protected int getDataLength() {
        return Utf8.convert(AppleRecordingYearBox.rfc822toIso8601Date(this.df.format(this.date))).length;
    }

    static {
        AppleRecordingYearBox.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AppleRecordingYearBox.java", AppleRecordingYearBox.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getDate", "com.googlecode.mp4parser.boxes.apple.AppleRecordingYearBox", "", "", "", "java.util.Date"), 27);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setDate", "com.googlecode.mp4parser.boxes.apple.AppleRecordingYearBox", "java.util.Date", "date", "", "void"), 31);
    }
}

