/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.tests;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.manifoldcf.agents.system.AgentsDaemon;
import org.apache.manifoldcf.core.interfaces.Configuration;
import org.apache.manifoldcf.core.interfaces.ConfigurationNode;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.ThreadContextFactory;
import org.apache.manifoldcf.crawler.interfaces.IJobDescription;
import org.apache.manifoldcf.crawler.interfaces.IJobManager;
import org.apache.manifoldcf.crawler.interfaces.JobManagerFactory;
import org.apache.manifoldcf.crawler.interfaces.JobStatus;
import org.apache.manifoldcf.crawler.system.ManifoldCF;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.webapp.WebAppContext;

public class ManifoldCFInstance {
    protected final boolean webapps;
    protected final boolean singleWar;
    protected final int testPort;
    protected final String processID;
    protected DaemonThread daemonThread = null;
    protected Server server = null;

    public ManifoldCFInstance() {
        this("", 8346, false, true);
    }

    public ManifoldCFInstance(String processID) {
        this(processID, 8346, false, true);
    }

    public ManifoldCFInstance(boolean singleWar) {
        this("", 8346, singleWar, true);
    }

    public ManifoldCFInstance(String processID, boolean singleWar) {
        this(processID, 8346, singleWar, true);
    }

    public ManifoldCFInstance(boolean singleWar, boolean webapps) {
        this("", 8346, singleWar, webapps);
    }

    public ManifoldCFInstance(String processID, boolean singleWar, boolean webapps) {
        this(processID, 8346, singleWar, webapps);
    }

    public ManifoldCFInstance(String processID, int testPort) {
        this(processID, testPort, false, true);
    }

    public ManifoldCFInstance(String processID, int testPort, boolean singleWar) {
        this(processID, testPort, singleWar, true);
    }

    public ManifoldCFInstance(String processID, int testPort, boolean singleWar, boolean webapps) {
        this.processID = processID;
        this.webapps = webapps;
        this.testPort = testPort;
        this.singleWar = singleWar;
    }

    public void waitJobInactiveNative(IJobManager jobManager, Long jobID, long maxTime) throws ManifoldCFException, InterruptedException {
        long startTime = System.currentTimeMillis();
        block5: while (System.currentTimeMillis() < startTime + maxTime) {
            JobStatus status = jobManager.getStatus(jobID);
            if (status == null) {
                throw new ManifoldCFException("No such job: '" + jobID + "'");
            }
            int statusValue = status.getStatus();
            switch (statusValue) {
                case 0: {
                    throw new ManifoldCFException("Job was never started.");
                }
                case 5: {
                    break;
                }
                case 9: {
                    throw new ManifoldCFException("Job reports error status: " + status.getErrorText());
                }
                default: {
                    ManifoldCF.sleep((long)1000L);
                    continue block5;
                }
            }
            return;
        }
        throw new ManifoldCFException("ManifoldCF did not terminate in the allotted time of " + new Long(maxTime).toString() + " milliseconds");
    }

    public void waitJobDeletedNative(IJobManager jobManager, Long jobID, long maxTime) throws ManifoldCFException, InterruptedException {
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() < startTime + maxTime) {
            JobStatus status = jobManager.getStatus(jobID);
            if (status == null) {
                return;
            }
            ManifoldCF.sleep((long)1000L);
        }
        throw new ManifoldCFException("ManifoldCF did not delete in the allotted time of " + new Long(maxTime).toString() + " milliseconds");
    }

    public void waitJobRunningNative(IJobManager jobManager, Long jobID, long maxTime) throws ManifoldCFException, InterruptedException {
        long startTime = System.currentTimeMillis();
        block6: while (System.currentTimeMillis() < startTime + maxTime) {
            JobStatus status = jobManager.getStatus(jobID);
            if (status == null) {
                throw new ManifoldCFException("No such job: '" + jobID + "'");
            }
            int statusValue = status.getStatus();
            switch (statusValue) {
                case 0: {
                    throw new ManifoldCFException("Job was never started.");
                }
                case 5: {
                    throw new ManifoldCFException("Job ended on its own!");
                }
                case 9: {
                    throw new ManifoldCFException("Job reports error status: " + status.getErrorText());
                }
                case 1: {
                    break;
                }
                default: {
                    ManifoldCF.sleep((long)1000L);
                    continue block6;
                }
            }
            return;
        }
        throw new ManifoldCFException("ManifoldCF did not start in the allotted time of " + new Long(maxTime).toString() + " milliseconds");
    }

    public void loginAPI(String userID, String password) throws Exception {
        Configuration requestObject = new Configuration();
        ConfigurationNode cn = new ConfigurationNode("userID");
        cn.setValue(userID);
        requestObject.addChild(requestObject.getChildCount(), cn);
        cn = new ConfigurationNode("password");
        cn.setValue(password);
        requestObject.addChild(requestObject.getChildCount(), cn);
        this.performAPIPostOperationViaNodes("LOGIN", 200, requestObject);
    }

    public void startJobAPI(String jobIDString) throws Exception {
        Configuration requestObject = new Configuration();
        Configuration result = this.performAPIPutOperationViaNodes("start/" + jobIDString, 201, requestObject);
        int i = 0;
        while (i < result.getChildCount()) {
            ConfigurationNode resultNode;
            if (!(resultNode = result.findChild(i++)).getType().equals("error")) continue;
            throw new Exception(resultNode.getValue());
        }
    }

    public void deleteJobAPI(String jobIDString) throws Exception {
        Configuration result = this.performAPIDeleteOperationViaNodes("jobs/" + jobIDString, 200);
        int i = 0;
        while (i < result.getChildCount()) {
            ConfigurationNode resultNode;
            if (!(resultNode = result.findChild(i++)).getType().equals("error")) continue;
            throw new Exception(resultNode.getValue());
        }
    }

    public String getJobStatusAPI(String jobIDString) throws Exception {
        Configuration result = this.performAPIGetOperationViaNodes("jobstatusesnocounts/" + jobIDString, 200);
        String status = null;
        int i = 0;
        while (i < result.getChildCount()) {
            ConfigurationNode resultNode;
            if ((resultNode = result.findChild(i++)).getType().equals("error")) {
                throw new Exception(resultNode.getValue());
            }
            if (!resultNode.getType().equals("jobstatus")) continue;
            int j = 0;
            while (j < resultNode.getChildCount()) {
                ConfigurationNode childNode;
                if (!(childNode = resultNode.findChild(j++)).getType().equals("status")) continue;
                status = childNode.getValue();
            }
        }
        return status;
    }

    public long getJobDocumentsProcessedAPI(String jobIDString) throws Exception {
        Configuration result = this.performAPIGetOperationViaNodes("jobstatuses/" + jobIDString, 200);
        String documentsProcessed = null;
        int i = 0;
        while (i < result.getChildCount()) {
            ConfigurationNode resultNode;
            if ((resultNode = result.findChild(i++)).getType().equals("error")) {
                throw new Exception(resultNode.getValue());
            }
            if (!resultNode.getType().equals("jobstatus")) continue;
            int j = 0;
            while (j < resultNode.getChildCount()) {
                ConfigurationNode childNode;
                if (!(childNode = resultNode.findChild(j++)).getType().equals("documents_processed")) continue;
                documentsProcessed = childNode.getValue();
            }
        }
        if (documentsProcessed == null) {
            throw new Exception("Expected a documents_processed field, didn't find it");
        }
        return new Long(documentsProcessed);
    }

    public void waitJobInactiveAPI(String jobIDString, long maxTime) throws Exception {
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() < startTime + maxTime) {
            String status = this.getJobStatusAPI(jobIDString);
            if (status == null) {
                throw new Exception("No such job: '" + jobIDString + "'");
            }
            if (status.equals("not yet run")) {
                throw new Exception("Job was never started.");
            }
            if (status.equals("done")) {
                return;
            }
            if (status.equals("error")) {
                throw new Exception("Job reports error.");
            }
            ManifoldCF.sleep((long)1000L);
        }
        throw new ManifoldCFException("ManifoldCF did not terminate in the allotted time of " + new Long(maxTime).toString() + " milliseconds");
    }

    public void waitJobDeletedAPI(String jobIDString, long maxTime) throws Exception {
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() < startTime + maxTime) {
            String status = this.getJobStatusAPI(jobIDString);
            if (status == null) {
                return;
            }
            ManifoldCF.sleep((long)1000L);
        }
        throw new ManifoldCFException("ManifoldCF did not delete in the allotted time of " + new Long(maxTime).toString() + " milliseconds");
    }

    public String makeAPIURL(String command) throws Exception {
        if (this.webapps) {
            if (this.singleWar) {
                return "http://localhost:" + Integer.toString(this.testPort) + "/mcf/api/json/" + command;
            }
            return "http://localhost:" + Integer.toString(this.testPort) + "/mcf-api-service/json/" + command;
        }
        throw new Exception("No API servlet running");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String convertToString(HttpResponse httpResponse) throws IOException {
        HttpEntity entity = httpResponse.getEntity();
        if (entity != null) {
            try (InputStream is = entity.getContent();){
                Charset charSet;
                try {
                    ContentType ct = ContentType.get((HttpEntity)entity);
                    charSet = ct == null ? StandardCharsets.UTF_8 : ct.getCharset();
                }
                catch (ParseException e) {
                    charSet = StandardCharsets.UTF_8;
                }
                char[] buffer = new char[65536];
                InputStreamReader r = new InputStreamReader(is, charSet);
                StringWriter w = new StringWriter();
                try {
                    int amt;
                    while ((amt = r.read(buffer)) != -1) {
                        ((Writer)w).write(buffer, 0, amt);
                    }
                }
                finally {
                    ((Writer)w).flush();
                }
                String string = ((Object)w).toString();
                return string;
            }
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String performAPIGetOperation(String apiURL, int expectedResponse) throws Exception {
        CloseableHttpClient client = HttpClients.createDefault();
        HttpGet method = new HttpGet(apiURL);
        try {
            HttpResponse response = client.execute((HttpUriRequest)method);
            int responseCode = response.getStatusLine().getStatusCode();
            String responseString = ManifoldCFInstance.convertToString(response);
            if (responseCode != expectedResponse) {
                throw new Exception("API http error; expected " + Integer.toString(expectedResponse) + ", saw " + Integer.toString(responseCode) + ": " + responseString);
            }
            String string = responseString;
            return string;
        }
        finally {
            method.abort();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String performAPIDeleteOperation(String apiURL, int expectedResponse) throws Exception {
        CloseableHttpClient client = HttpClients.createDefault();
        HttpDelete method = new HttpDelete(apiURL);
        try {
            HttpResponse response = client.execute((HttpUriRequest)method);
            int responseCode = response.getStatusLine().getStatusCode();
            String responseString = ManifoldCFInstance.convertToString(response);
            if (responseCode != expectedResponse) {
                throw new Exception("API http error; expected " + Integer.toString(expectedResponse) + ", saw " + Integer.toString(responseCode) + ": " + responseString);
            }
            String string = responseString;
            return string;
        }
        finally {
            method.abort();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String performAPIPutOperation(String apiURL, int expectedResponse, String input) throws Exception {
        CloseableHttpClient client = HttpClients.createDefault();
        HttpPut method = new HttpPut(apiURL);
        try {
            method.setEntity((HttpEntity)new StringEntity(input, ContentType.create((String)"text/plain", (Charset)StandardCharsets.UTF_8)));
            HttpResponse response = client.execute((HttpUriRequest)method);
            int responseCode = response.getStatusLine().getStatusCode();
            String responseString = ManifoldCFInstance.convertToString(response);
            if (responseCode != expectedResponse) {
                throw new Exception("API http error; expected " + Integer.toString(expectedResponse) + ", saw " + Integer.toString(responseCode) + ": " + responseString);
            }
            String string = responseString;
            return string;
        }
        finally {
            method.abort();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String performAPIPostOperation(String apiURL, int expectedResponse, String input) throws Exception {
        CloseableHttpClient client = HttpClients.createDefault();
        HttpPost method = new HttpPost(apiURL);
        try {
            method.setEntity((HttpEntity)new StringEntity(input, ContentType.create((String)"text/plain", (Charset)StandardCharsets.UTF_8)));
            HttpResponse response = client.execute((HttpUriRequest)method);
            int responseCode = response.getStatusLine().getStatusCode();
            String responseString = ManifoldCFInstance.convertToString(response);
            if (responseCode != expectedResponse) {
                throw new Exception("API http error; expected " + Integer.toString(expectedResponse) + ", saw " + Integer.toString(responseCode) + ": " + responseString);
            }
            String string = responseString;
            return string;
        }
        finally {
            method.abort();
        }
    }

    public Configuration performAPIGetOperationViaNodes(String command, int expectedResponse) throws Exception {
        String result = this.performAPIGetOperation(this.makeAPIURL(command), expectedResponse);
        Configuration cfg = new Configuration();
        cfg.fromJSON(result);
        return cfg;
    }

    public Configuration performAPIDeleteOperationViaNodes(String command, int expectedResponse) throws Exception {
        String result = this.performAPIDeleteOperation(this.makeAPIURL(command), expectedResponse);
        Configuration cfg = new Configuration();
        cfg.fromJSON(result);
        return cfg;
    }

    public Configuration performAPIPutOperationViaNodes(String command, int expectedResponse, Configuration argument) throws Exception {
        String argumentJson = argument != null ? argument.toJSON() : null;
        String result = this.performAPIPutOperation(this.makeAPIURL(command), expectedResponse, argumentJson);
        Configuration cfg = new Configuration();
        cfg.fromJSON(result);
        return cfg;
    }

    public Configuration performAPIPostOperationViaNodes(String command, int expectedResponse, Configuration argument) throws Exception {
        String argumentJson = argument != null ? argument.toJSON() : null;
        String result = this.performAPIPostOperation(this.makeAPIURL(command), expectedResponse, argumentJson);
        Configuration cfg = new Configuration();
        cfg.fromJSON(result);
        return cfg;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void start() throws Exception {
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        if (this.webapps) {
            this.server = new Server(this.testPort);
            this.server.setStopAtShutdown(true);
            this.server.setHandler((Handler)contexts);
        }
        if (this.singleWar) {
            if (!this.webapps) throw new Exception("Can't run singleWar without webapps");
            String combinedWarPath = "../../framework/build/war-proprietary/mcf-combined-service.war";
            if (System.getProperty("combinedWarPath") != null) {
                combinedWarPath = System.getProperty("combinedWarPath");
            }
            WebAppContext lcfCombined = new WebAppContext(combinedWarPath, "/mcf");
            lcfCombined.setParentLoaderPriority(true);
            contexts.addHandler((Handler)lcfCombined);
            this.server.start();
            return;
        } else {
            if (this.webapps) {
                String crawlerWarPath = "../../framework/build/war-proprietary/mcf-crawler-ui.war";
                String authorityserviceWarPath = "../../framework/build/war-proprietary/mcf-authority-service.war";
                String apiWarPath = "../../framework/build/war-proprietary/mcf-api-service.war";
                if (System.getProperty("crawlerWarPath") != null) {
                    crawlerWarPath = System.getProperty("crawlerWarPath");
                }
                if (System.getProperty("authorityserviceWarPath") != null) {
                    authorityserviceWarPath = System.getProperty("authorityserviceWarPath");
                }
                if (System.getProperty("apiWarPath") != null) {
                    apiWarPath = System.getProperty("apiWarPath");
                }
                WebAppContext lcfCrawlerUI = new WebAppContext(crawlerWarPath, "/mcf-crawler-ui");
                lcfCrawlerUI.setParentLoaderPriority(true);
                contexts.addHandler((Handler)lcfCrawlerUI);
                WebAppContext lcfAuthorityService = new WebAppContext(authorityserviceWarPath, "/mcf-authority-service");
                lcfAuthorityService.setParentLoaderPriority(true);
                contexts.addHandler((Handler)lcfAuthorityService);
                WebAppContext lcfApi = new WebAppContext(apiWarPath, "/mcf-api-service");
                lcfApi.setParentLoaderPriority(true);
                contexts.addHandler((Handler)lcfApi);
                this.server.start();
            }
            IThreadContext tc = ThreadContextFactory.make();
            AgentsDaemon.clearAgentsShutdownSignal((IThreadContext)tc);
            this.daemonThread = new DaemonThread(this.processID);
            this.daemonThread.start();
        }
    }

    public void stop() throws Exception {
        block16: {
            Exception currentException = null;
            IThreadContext tc = ThreadContextFactory.make();
            if (this.daemonThread != null || this.singleWar) {
                JobStatus status;
                IJobDescription desc;
                IJobManager jobManager = JobManagerFactory.make((IThreadContext)tc);
                IJobDescription[] jobs = jobManager.getAllJobs();
                int i = 0;
                while (i < jobs.length) {
                    desc = jobs[i++];
                    try {
                        jobManager.manualAbort(desc.getID());
                    }
                    catch (ManifoldCFException e) {}
                }
                i = 0;
                block10: while (i < jobs.length) {
                    desc = jobs[i++];
                    while ((status = jobManager.getStatus(desc.getID(), false)) != null) {
                        int statusValue = status.getStatus();
                        switch (statusValue) {
                            case 0: 
                            case 5: 
                            case 9: {
                                continue block10;
                            }
                            default: {
                                ManifoldCF.sleep((long)10000L);
                                break;
                            }
                        }
                    }
                }
                i = 0;
                while (i < jobs.length) {
                    desc = jobs[i++];
                    try {
                        jobManager.deleteJob(desc.getID());
                    }
                    catch (ManifoldCFException e) {}
                }
                i = 0;
                while (i < jobs.length) {
                    desc = jobs[i++];
                    while ((status = jobManager.getStatus(desc.getID(), false)) != null) {
                        ManifoldCF.sleep((long)10000L);
                    }
                }
                try {
                    this.stopNoCleanup();
                }
                catch (Exception e) {
                    if (currentException != null) break block16;
                    currentException = e;
                }
            }
        }
    }

    public void stopNoCleanup() throws Exception {
        if (this.daemonThread != null) {
            Exception currentException = null;
            while (true) {
                this.daemonThread.interrupt();
                if (!this.daemonThread.isAlive()) break;
                Thread.sleep(1000L);
            }
            Exception e = this.daemonThread.getDaemonException();
            if (e != null || !(e instanceof InterruptedException)) {
                currentException = e;
            }
            if (currentException != null) {
                throw currentException;
            }
        }
    }

    public void unload() throws Exception {
        if (this.server != null) {
            this.server.stop();
            this.server.join();
            this.server = null;
        }
    }

    protected static class DaemonThread
    extends Thread {
        protected final String processID;
        protected Exception daemonException = null;

        public DaemonThread(String processID) {
            this.processID = processID;
            this.setName("Daemon thread");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            IThreadContext tc = ThreadContextFactory.make();
            AgentsDaemon ad = new AgentsDaemon(this.processID);
            try {
                ad.runAgents(tc);
            }
            catch (ManifoldCFException e) {
                this.daemonException = e;
            }
            finally {
                try {
                    ad.stopAgents(tc);
                }
                catch (ManifoldCFException e) {
                    this.daemonException = e;
                }
            }
        }

        public Exception getDaemonException() {
            return this.daemonException;
        }
    }
}

